/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.mame;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.tibennetwork.iarcade.mame.Machine;
import org.tibennetwork.iarcade.mame.MachineDoesntExistException;
import org.tibennetwork.iarcade.mame.MachineHasNoSoftwareListException;
import org.tibennetwork.iarcade.mame.MameExecutionException;
import org.tibennetwork.iarcade.mame.MameRuntime;
import org.tibennetwork.iarcade.mame.MediaDevice;
import org.tibennetwork.iarcade.mame.Software;
import org.tibennetwork.iarcade.mame.SoftwareList;
import org.tibennetwork.iarcade.mame.SoftwareNotFoundInSoftwareListsException;

public class SoftwareRepository {
    private MameRuntime mame;

    public SoftwareRepository(MameRuntime mame) {
        this.mame = mame;
    }

    public Software findByMachineAndByName(Machine machine, String softwareName) throws IOException, InterruptedException, MachineDoesntExistException, MachineHasNoSoftwareListException, SoftwareNotFoundInSoftwareListsException {
        SoftwareListsXmlContainer slxc = this.getSoftwareLists(machine);
        for (SoftwareList sl : slxc.getSoftwareLists()) {
            for (Software s : sl.getSoftwares()) {
                if (!s.getName().equals(softwareName)) continue;
                s.setMachine(machine);
                s.setSoftwareList(sl);
                if (s.isAClone()) {
                    s.setOriginal(this.findByMachineAndByName(machine, s.getCloneof()));
                }
                return s;
            }
        }
        throw new SoftwareNotFoundInSoftwareListsException(String.format("The software '%s' has not been found on '%s'  software lists", softwareName, machine.getDescription()));
    }

    public Software findByMachineAndAndByMediaTypeAndByName(Machine machine, MediaDevice mediaDevice, String softwareName) throws IOException, InterruptedException, MachineDoesntExistException, MachineHasNoSoftwareListException, SoftwareNotFoundInSoftwareListsException {
        SoftwareListsXmlContainer slxc = this.getSoftwareLists(machine);
        for (SoftwareList sl : slxc.getSoftwareLists()) {
            for (Software s : sl.getSoftwares()) {
                if (!s.getName().equals(softwareName) || !s.getMediaInterface().equals(mediaDevice.getMediaInterface())) continue;
                s.setMachine(machine);
                s.setSoftwareList(sl);
                if (s.isAClone()) {
                    s.setOriginal(this.findByMachineAndAndByMediaTypeAndByName(machine, mediaDevice, s.getCloneof()));
                }
                return s;
            }
        }
        throw new SoftwareNotFoundInSoftwareListsException(String.format("The software '%s' has not been found on '%s'  software lists", softwareName, machine.getDescription()));
    }

    private SoftwareListsXmlContainer getSoftwareLists(Machine m) throws MachineDoesntExistException, MachineHasNoSoftwareListException, IOException, InterruptedException {
        SoftwareListsXmlContainer slxc;
        String[] mameCommandLine = new String[]{"-listsoftware", m.getName()};
        InputStream is = null;
        try {
            is = this.mame.executeAndReturnStdoutAsInputStream(mameCommandLine);
        }
        catch (MameExecutionException e) {
            throw new MachineDoesntExistException(String.format("The machine '%s' doesn't exist or is not supported by the provided Mame version", m.getName()));
        }
        try {
            slxc = JAXB.unmarshal(is, SoftwareListsXmlContainer.class);
        }
        catch (DataBindingException e) {
            throw new MachineHasNoSoftwareListException("Can't extract software list data from Mame runtime. It usually occurs by a misconfigured hashpath parameter");
        }
        if (slxc.getSoftwareLists().isEmpty()) {
            throw new MachineHasNoSoftwareListException(String.format("The machine '%s' has no software lists", m.getDescription()));
        }
        return slxc;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class SoftwareListsXmlContainer {
        @XmlElement(name="softwarelist")
        private List<SoftwareList> softwareLists;

        SoftwareListsXmlContainer() {
        }

        public List<SoftwareList> getSoftwareLists() {
            return this.softwareLists;
        }
    }
}

