//////////////////////////////////////////////////////////////////////////////
// Cosmic Monsters Emulator - Version 1.0                                   //
// Project Started on: 06/03/98. This Version Compiled on:07/01/98 1:51 AM  //
// Programmed by Rafael Pereira Rigues (phobos40@hotmail.com)               //
// Based on Code by Michael Strutt - Thank's Michael!!!                     //
//                                                                          //
// Special Thanks to:                                                       //
// Shawn Hargreaves (Allegro library)                                       //
// DJ Delorie (DJGPP)                                                       //
// Tony, from the AMOAD Emulators (big thank's to you!!!)                   //
//////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <allegro.h>
#include "Z80.h"

// Declare's ////////////////////////////////////////////////////////////////

DECLARE_COLOR_DEPTH_LIST (COLOR_DEPTH_8);
DECLARE_GFX_DRIVER_LIST (GFX_DRIVER_MODEX);

// Definicao de funcoes /////////////////////////////////////////////////////

void main(int argc, char *argv[]);
byte LoadRoms();
byte LoadRom(char *pszFilename, word wOffset, word wLength);
void Nmi(void);
void Error(char *pszText);
void Help();

// Variaveis Globais ////////////////////////////////////////////////////////

byte bGame;
reg z80reg;
byte *pbROM;
byte *pbRAM;
byte bShiftValue = 0;
byte bBitmap = 0;
byte bBitmapPrevious = 0;
DATAFILE *audio;

// Checa as NMI's (Non Maskable Interrupts) /////////////////////////////////

void Nmi()
{
	IFlag=1;
}
END_OF_FUNCTION(Nmi);

// Funcao Main... ///////////////////////////////////////////////////////////

void main(int argc, char *argv[])
{
 clrscr();
 printf("ͻ\n");
 printf(" AMOAD XIII - Cosmic Monsters Emulator - Version 1.0 (07/02/1998) \n");
 printf(" Programmed by Rafael Pereira Rigues (phobos40@hotmail.com)       \n");
 printf(" Based on Code by Michael Strutt                                  \n");
 printf("ͼ\n\n");
 printf("Press ENTER to continue \n");

 if (!getch())
  getch();

 allegro_init();
 install_keyboard();
 install_sound(DIGI_AUTODETECT,MIDI_NONE,0);
 install_timer();
 initialise_joystick();

 pbRAM=(byte *)malloc(0x2000);
 if(!pbRAM) Error("Could not allocate memory for RAM");

 if(!LoadRoms()) Error("Could not load ROM images");

 audio=load_datafile("Audio.dat");
 if(!audio) Error("Could not load audio data");

 LOCK_VARIABLE(IFlag);
 LOCK_FUNCTION(Nmi);
 install_int(Nmi,8);

 set_gfx_mode(GFX_MODEX,256,256,0,0);

 ResetZ80(&z80reg);
 Z80(z80reg);

 free(pbRAM);
 free(pbROM);
}

// Funcoes usadas pelo programa /////////////////////////////////////////////

byte LoadRoms()
{
 pbROM=(byte *)malloc(0x5000);
 if(!pbROM) return(0);

 if (!LoadRom("cosmicmo.1", 0x0000, 0x0400)) return(0);
 if (!LoadRom("cosmicmo.2", 0x0400, 0x0400)) return(0);
 if (!LoadRom("cosmicmo.3", 0x0800, 0x0400)) return(0);
 if (!LoadRom("cosmicmo.4", 0x0C00, 0x0400)) return(0);
 if (!LoadRom("cosmicmo.5", 0x4000, 0x0400)) return(0);
 if (!LoadRom("cosmicmo.6", 0x4400, 0x0400)) return(0);
 if (!LoadRom("cosmicmo.7", 0x4800, 0x0400)) return(0);
 return(1);
}

byte LoadRom(char *pszFilename, word wOffset, word wLength)
{
 FILE *fp;

 fp=fopen(pszFilename,"rb");
 if(!fp) return(0);

 fread(pbROM+wOffset,wLength,1,fp);

 fclose(fp);
 return(1);
}

void Error(char *pszText)
{
 printf("error: %s\n",pszText);
 exit(1);
}

void M_WRMEM(word A,byte V)
{
 int b, c, x, y;

 if(A<0x2000 || A>0x3fff) return;	// invalid memory address (W)
 pbRAM[A-0x2000]=V;			// valid work or video RAM
 if(A>0x23ff)
 {					// video RAM
  x=(A-0x2400)>>5;
  y=(A-0x2400)&0x1f;
  c=15;
  for(b=0;b<8;b++)
  {
   if(V&0x01) putpixel(screen,x,256-((y<<3)+b),c); else putpixel(screen,x,256-((y<<3)+b),0);
   V=V>>1;
  }
 }
}

byte M_RDMEM(word A)
{
 if(A>0x4fff) return(0); 			// invalid memory address (R)
 if(A<0x2000 || A>0x3fff) return(pbROM[A]);	// reading ROM
 return(pbRAM[A-0x2000]);			// reading RAM
}

byte DoIn(byte Port)
{
 word wValue;
 byte bValue;

 switch(Port)
 {
  case 1: bValue=0x81;
          poll_joystick();
          if(key[KEY_ESC]) CPURunning=0;
	  if(key[KEY_1]) bValue|=0x04;
	  if(key[KEY_2]) bValue|=0x02;
	  if(key[KEY_3]) bValue&=~0x01;
	  if( key[KEY_LEFT] || joy_left) bValue|=0x20;
	  if( key[KEY_RIGHT] || joy_right) bValue|=0x40;
	  if( key[KEY_CONTROL] || joy_b1) bValue|=0x10;
	  return(bValue);

  case 2: bValue=0;
          poll_joystick();
          if(key[KEY_T]) bValue=0x04;
	  if(key[KEY_P]) bValue=0x08;
	  if(bGame!=1) {
			if( key[KEY_LEFT] || joy_left) bValue|=0x20;
			if( key[KEY_RIGHT] || joy_right) bValue|=0x40;
			if( key[KEY_CONTROL] || joy_b1) bValue|=0x10;
		       }
	  return(bValue);

  case 3: wValue=(bBitmap<<8)|bBitmapPrevious;
	  wValue=wValue<<bShiftValue;
	  bValue=(byte)(wValue>>8);
	  return(bValue);

  default: return(0x00);
 }
}

void DoOut(byte Port,byte Value)
{
 static byte bSound1 = 0;
 static byte bSound2 = 0;

 switch(Port)
 {
  case 2: bShiftValue=Value; break;

  case 3: if(Value&0x01 && ~bSound1&0x01) play_sample(audio[0].dat,128,128,1000,1);
	  if(~Value&0x01 && bSound1&0x01) stop_sample(audio[0].dat);
	  if(Value&0x02 && ~bSound1&0x02) play_sample(audio[1].dat,100,128,1000,0);
	  if(~Value&0x02 && bSound1&0x02) stop_sample(audio[1].dat);
	  if(Value&0x04 && ~bSound1&0x04) play_sample(audio[2].dat,128,128,1000,0);
	  if(~Value&0x04 && bSound1&0x04) stop_sample(audio[2].dat);
	  if(Value&0x08 && ~bSound1&0x08) play_sample(audio[3].dat,100,128,1000,0);
	  if(~Value&0x08 && bSound1&0x08) stop_sample(audio[3].dat);
	  bSound1=Value; break;

  case 4: bBitmapPrevious=bBitmap;
	  bBitmap=Value; break;

  case 5: if(Value&0x01 && ~bSound2&0x01) play_sample(audio[4].dat,255,128,1000,0);
	  if(Value&0x02 && ~bSound2&0x02) play_sample(audio[5].dat,255,128,1000,0);
	  if(Value&0x04 && ~bSound2&0x04) play_sample(audio[6].dat,255,128,1000,0);
	  if(Value&0x08 && ~bSound2&0x08) play_sample(audio[7].dat,255,128,1000,0);
	  if(Value&0x10 && ~bSound2&0x10) play_sample(audio[8].dat,128,128,1000,0);
	  if(~Value&0x10 && bSound2&0x10) stop_sample(audio[8].dat);
	  bSound2=Value; break;
 }
}

void Patch(reg *R)
{
}

word Interrupt()
{
 static byte bNMI = 0;

 if(bNMI++&0x01) return(0x0010);
 return(0x0008);
}
