/***************************************************************************
  vidhrdw.c
  The Pac Man driver uses the Pengo functions except for the color prom
  conversion.
***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"

#define VIDEO_RAM_SIZE 0x400

static struct rectangle spritevisiblearea =
{
	0, 28*8-1,
	2*8, 34*8-1
};

void pacman_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom)
{
	int i;
	for (i = 0;i < 16;i++)
	{
		int bit0,bit1,bit2;
		bit0 = (color_prom[i] >> 0) & 0x01;
		bit1 = (color_prom[i] >> 1) & 0x01;
		bit2 = (color_prom[i] >> 2) & 0x01;
		palette[3*i] = 0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2;
		bit0 = (color_prom[i] >> 3) & 0x01;
		bit1 = (color_prom[i] >> 4) & 0x01;
		bit2 = (color_prom[i] >> 5) & 0x01;
		palette[3*i + 1] = 0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2;
		bit0 = 0;
		bit1 = (color_prom[i] >> 6) & 0x01;
		bit2 = (color_prom[i] >> 7) & 0x01;
		palette[3*i + 2] = 0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2;
	}
	for (i = 0;i < 4 * 32;i++)
		colortable[i] = color_prom[i + 16];
}

void pacman_vh_screenrefresh(struct osd_bitmap *bitmap)
{
	int i,offs;
	for (offs = 0;offs < VIDEO_RAM_SIZE;offs++)
	{
		if (dirtybuffer[offs])
		{
			int sx,sy,mx,my;
			dirtybuffer[offs] = 0;
			mx = offs / 32;
			my = offs % 32;
			if (mx <= 1)
			{
				sx = 29 - my;
				sy = mx + 34;
			}
			else if (mx >= 30)
			{
				sx = 29 - my;
				sy = mx - 30;
			}
			else
			{
				sx = 29 - mx;
				sy = my + 2;
			}
			drawgfx(tmpbitmap,Machine->gfx[0],
					videoram[offs],
					colorram[offs],
					0,0,8*sx,8*sy,
					&Machine->drv->visible_area,TRANSPARENCY_NONE,0);
		}
	}

	copybitmap(bitmap,tmpbitmap,0,0,0,0,&Machine->drv->visible_area,TRANSPARENCY_NONE,0);
	for (i = 6;i > 2;i--)
	{
		drawgfx(bitmap,Machine->gfx[1],
				spriteram[2*i] >> 2,spriteram[2*i + 1],
				spriteram[2*i] & 2,spriteram[2*i] & 1,
				239 - spriteram_2[2*i],272 - spriteram_2[2*i + 1],
				&spritevisiblearea,TRANSPARENCY_COLOR,Machine->background_pen);
	}
	for (i = 2;i > 0;i--)
	{
		drawgfx(bitmap,Machine->gfx[1],
				spriteram[2*i] >> 2,spriteram[2*i + 1],
				spriteram[2*i] & 2,spriteram[2*i] & 1,
				238 - spriteram_2[2*i],272 - spriteram_2[2*i + 1],
				&spritevisiblearea,TRANSPARENCY_COLOR,Machine->background_pen);
	}
}
