// Original source code written by Michael Strutt (mstrutt@pixie.co.za)
// AMOAD Conversion by Tony Docherty (tony.docherty@almac.co.uk)
// Compiled using DJGPP & Allegro Libray
// z80 emulation by Marat Fayzullin

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <..\allegro\allegro.h>
#include "..\z80\Z80.h"

void main();
byte LoadRom(char *pszFilename, word wOffset, word wLength);
void Nmi(void);
void Error(char *pszText);
void NoRoms();
void NoSam();

reg z80reg;
byte *pbROM;
byte *pbRAM;
byte bShiftValue = 0;
byte bBitmap = 0;
byte bBitmapPrevious = 0;
byte bKey = 0;
DATAFILE *audio;

void Nmi()
{
  IFlag=1;
}
END_OF_FUNCTION(Nmi);

void main()
{
  textcolor(WHITE);
  clrscr();
  clreol(); printf("\n");
  clreol(); printf("                                   AMOAD PART VI\n");
  clreol(); printf("\n");
  textcolor(RED);
  clreol(); printf("                                  SPACE ATTACK II\n\n\n");
  textcolor(LIGHTGREEN);
  clreol(); printf("                                            \n");
  clreol(); printf("                                          \n");
  clreol(); printf("                                  \n");
  clreol(); printf("                                    \n");
  clreol(); printf("                              \n");
  clreol(); printf("                                  \n");
  clreol(); printf("                                            \n");
  clreol(); printf("                                      \n\n\n\n");
  textcolor(WHITE);
  clreol(); printf("  Please do not distribute the source code, executable, or diskette image with\n");
  clreol(); printf("   ROM images. Doing so may harm further emulator development and may lead to\n");
  clreol(); printf("   legal action being taken by the lawful copyright holder of the ROM images.\n\n");
  clreol(); printf("             If you do not agree with these conditions press ESC now.\n\n");
  textcolor(LIGHTGREEN);
  clreol(); printf("                         Press any other key to continue\n");
  bKey=getch();
  if (bKey==27) {textcolor(LIGHTGRAY); clrscr(); exit(1);}

  allegro_init();
  install_keyboard();
  install_sound(DIGI_AUTODETECT,MIDI_NONE,0);
  install_timer();
  initialise_joystick(); // by Tony

  pbRAM=(byte *)malloc(0x2000);
  if(!pbRAM) Error("Could not allocate memory for RAM");

  pbROM=(byte *)malloc(0x5000);
  if(!pbROM) Error("Could not allocate memory for ROM");
  // Load Space Invaders Roms
  if(!LoadRom("spaceatt.h",0x0000,0x0800)) NoRoms();
  if(!LoadRom("spaceatt.g",0x0800,0x0800)) NoRoms();
  if(!LoadRom("spaceatt.f",0x1000,0x0800)) NoRoms();
  if(!LoadRom("spaceatt.e",0x1800,0x0800)) NoRoms();

  // Load Space Invaders Samples
  audio=load_datafile("spaceatt.sam");
  if(!audio) NoSam();

  LOCK_VARIABLE(IFlag);
  LOCK_FUNCTION(Nmi);
  install_int(Nmi,8);

  set_gfx_mode(GFX_MODEX,256,256,0,0);

  ResetZ80(&z80reg);
  Z80(z80reg);

  free(pbRAM);
  free(pbROM);
}

byte LoadRom(char *pszFilename, word wOffset, word wLength)
{
  FILE *fp;
  fp=fopen(pszFilename,"rb");
  if(!fp) return(0);
  fread(pbROM+wOffset,wLength,1,fp);
  fclose(fp);
  return(1);
}

void Error(char *pszText)
{
  printf("error: %s\n",pszText);
  exit(1);
}

void NoRoms(char *pszText)
{
  textcolor(LIGHTGRAY);
  clrscr();
  printf("The following ROM images require to be copied onto this floppy disk:\n");
  printf("\n");
  printf("SPACEATT.E\n");
  printf("SPACEATT.F\n");
  printf("SPACEATT.G\n");
  printf("SPACEATT.H\n\n");
  exit(1);
}

void NoSam()
{
  textcolor(LIGHTGRAY);
  clrscr();
  printf("The following Sample files require to be copied onto this floppy disk:\n\n");
  printf("INVADERS.SAM\n\n");
  exit(1);
}


void M_WRMEM(word A,byte V)
{
  int b, c, x, y;

  if(A<0x2000 || A>0x3fff) return;        // invalid memory address (W)
  pbRAM[A-0x2000]=V;                      // valid work or video RAM
  if(A>0x23ff)                            // video RAM
  {
    x=(A-0x2400)>>5;
    y=(A-0x2400)&0x1f;
    c=15;
    if(y<8) c=2;
    if(y>23 && y<28) c=4;
    for(b=0;b<8;b++)
    {
      if(V&0x01) putpixel(screen,x,256-((y<<3)+b),c); else putpixel(screen,x,256-((y<<3)+b),0); V=V>>1;
    }
  }
}

byte M_RDMEM(word A)
{
  if(A>0x4fff) return(0);                         // invalid memory address (R)
  if(A<0x2000 || A>0x3fff) return(pbROM[A]);      // reading ROM
  return(pbRAM[A-0x2000]);                        // reading RAM
}

byte DoIn(byte Port)
{
  word wValue;
  byte bValue;

  switch(Port)
  {
    case 1:
      bValue=0x81;
      poll_joystick(); // by Tony
      if(key[KEY_ESC]) CPURunning=0;
      if(key[KEY_1]) bValue|=0x04;
      if(key[KEY_2]) bValue|=0x02;
      if(key[KEY_3]) bValue&=~0x01;
      if(key[KEY_LEFT]) bValue|=0x20;
      if(key[KEY_RIGHT]) bValue|=0x40;
      if(key[KEY_CONTROL]) bValue|=0x10;
      if(joy_left) bValue|=0x20;
      if(joy_right) bValue|=0x40;
      if(joy_b1) bValue|=0x10;
      return(bValue);
    case 2:
      bValue=0;
      poll_joystick(); // by Tony
      if(key[KEY_T]) bValue=0x04;
      if(key[KEY_P]) bValue=0x08;
      if(key[KEY_LEFT]) bValue|=0x20;
      if(key[KEY_RIGHT]) bValue|=0x40;
      if(key[KEY_CONTROL]) bValue|=0x10;
      if(joy_left) bValue|=0x20;
      if(joy_right) bValue|=0x40;
      if(joy_b1) bValue|=0x10;
      return(bValue);
    case 3:
      wValue=(bBitmap<<8)|bBitmapPrevious;
      wValue=wValue<<bShiftValue;
      bValue=(byte)(wValue>>8);
      return(bValue);
    default:
      return(0x00);
  }
}

void DoOut(byte Port,byte Value)
{
  static byte bSound1 = 0;
  static byte bSound2 = 0;
  switch(Port)
  {
    case 2:
      bShiftValue=Value;
      break;
    case 3:
      if(Value&0x01 && ~bSound1&0x01) play_sample(audio[0].dat,128,128,1000,1);
      if(~Value&0x01 && bSound1&0x01) stop_sample(audio[0].dat);
      if(Value&0x02 && ~bSound1&0x02) play_sample(audio[1].dat,100,128,1000,0);
      if(~Value&0x02 && bSound1&0x02) stop_sample(audio[1].dat);
      if(Value&0x04 && ~bSound1&0x04) play_sample(audio[2].dat,128,128,1000,0);
      if(~Value&0x04 && bSound1&0x04) stop_sample(audio[2].dat);
      if(Value&0x08 && ~bSound1&0x08) play_sample(audio[3].dat,100,128,1000,0);
      if(~Value&0x08 && bSound1&0x08) stop_sample(audio[3].dat);
      bSound1=Value;
      break;
    case 4:
      bBitmapPrevious=bBitmap;
      bBitmap=Value;
      break;
    case 5:
      if(Value&0x01 && ~bSound2&0x01) play_sample(audio[4].dat,255,128,1000,0);
      if(Value&0x02 && ~bSound2&0x02) play_sample(audio[5].dat,255,128,1000,0);
      if(Value&0x04 && ~bSound2&0x04) play_sample(audio[6].dat,255,128,1000,0);
      if(Value&0x08 && ~bSound2&0x08) play_sample(audio[7].dat,255,128,1000,0);
      if(Value&0x10 && ~bSound2&0x10) play_sample(audio[8].dat,128,128,1000,0);
      if(~Value&0x10 && bSound2&0x10) stop_sample(audio[8].dat);
      bSound2=Value;
      break;
  }
}

void Patch(reg *R)
{
}

word Interrupt()
{
  static byte bNMI = 0;
  if(bNMI++&0x01) return(0x0010);
  return(0x0008);
}
