/******************************************************************************

	M2X

	(C) Phil Bennett 2008

******************************************************************************/

#include "M2x.h"
#include "log.h"
#include "core.h"

#define MAX_LOADSTRING			100
#define WINDOW_STYLE			WS_OVERLAPPEDWINDOW
#define DEFAULT_WINDOW_WIDTH	300
#define DEFAULT_WINDOW_HEIGHT	300

// Global Variables:

static HINSTANCE hInst;
static TCHAR szTitle[MAX_LOADSTRING];
static TCHAR szWindowClass[MAX_LOADSTRING];

static HWND hWnd;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);


int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_M2X, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
		return FALSE;

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_M2X));

	// TODO: Move to state loop
//	#ifdef _DEBUG
		InitErrorLog(hWnd);
//	#endif

	// Main application loop
	while (TRUE)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
				break;

			// Translate the message and dispatch it to WindowProc()
			if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}

		Core.RunEmulator();
	}
	return (int)msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_M2X));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_M2X);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	hInst = hInstance; // Store instance handle in our global variable

	hWnd = CreateWindow(szWindowClass, szTitle, WINDOW_STYLE,
		CW_USEDEFAULT, CW_USEDEFAULT, DEFAULT_WINDOW_WIDTH, DEFAULT_WINDOW_HEIGHT, NULL, NULL, hInstance, NULL);

	if (!hWnd)
		return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
			case IDM_LOADGAME:
				Core.SetState(EMULATOR_INITIALISE);
				break;
			case IDM_RESET:
				// Shouldn't happen but just in case
				if (Core.GetState() != EMULATOR_UNLOADED)
					Core.SetState(EMULATOR_RESET);
				break;
			case IDM_ABOUT:
				DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
				break;
			case IDM_EXIT:
				DestroyWindow(hWnd);
				break;
			default:
				return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
		// TODO: Should be handled elsewhere maybe
	case WM_KEYDOWN:
		switch (wParam)
		{
			case VK_F3:
				if (Core.GetState() != EMULATOR_UNLOADED)
					Core.SetState(EMULATOR_RESET);
				break;
		}
		break;
	case WM_PAINT:
		// TODO
		hdc = BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		Core.SetState(EMULATOR_SHUTDOWN);
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}


/*
 * Miscellaneous functions that probably don't belong here
 */
void ErrorBox(char *fmt, ...)
{
	va_list args;
	char buf[256];
	TCHAR *error_text;

	va_start(args, fmt);
	vsnprintf(buf, 256, fmt, args);
	va_end(args);

	error_text = CharToWString(buf);

	MessageBox(NULL, error_text, TEXT("ERROR"), MB_ICONERROR);
	delete error_text;
}

void SystemBeep(void)
{
	MessageBeep(MB_OK);
}

void ResizeAppWindow(int width, int height)
{
	RECT Client;
	RECT Area;

	// Get current dimensions
	GetWindowRect(hWnd, &Client);

	// Adjust for window size
	SetRect(&Area, 0, 0, width, height);
	AdjustWindowRectEx(&Area, WINDOW_STYLE, true, 0);
	int window_width = Area.right - Area.left;
	int window_height = Area.bottom - Area.top;

	// We don't take account of the task bar.
	RECT WorkArea;

	SystemParametersInfo(SPI_GETWORKAREA, 0, &WorkArea, 0);

	int screen_width = WorkArea.right - WorkArea.left;
	int screen_height = WorkArea.bottom - WorkArea.top;

	// Adjust position of the window for better visibility
	Client.left = (screen_width - window_width) / 2;
	Client.top = (screen_height - window_height) / 2;

	SetWindowPos(hWnd, 0, Client.left, Client.top, window_width, window_height, 0);
}

void ChangeAppSubTitle(LPCTSTR lpSubTitle)
{
	TCHAR newtitle[128];
	wcscpy(newtitle, szTitle);
	wcscat(newtitle, TEXT(": "));

	wcscat(newtitle, lpSubTitle);
	SetWindowText(hWnd, newtitle);
//	HWND hWnd, // handle to window or control
//	LPCTSTR lpString // address of string
}


void GetMousePosition(int &x, int &y)
{
	POINT pt;
	RECT Client;
	GetWindowRect(hWnd, &Client);

	GetCursorPos(&pt);

	if (pt.x >= Client.left && pt.x <= Client.right)
	{
		// Within the window
		x = pt.x - Client.left;
	}
	else
	{
		if (pt.x <= Client.left)
			x = 0;
		else
			x = Client.right;
	}

	y = 0;
}

HWND GetAppHWnd()
{
	return hWnd;
}


void EnableResetMenuItem(bool bEnable)
{
	EnableMenuItem(GetMenu(hWnd), IDM_RESET, bEnable ? MF_ENABLED : MF_GRAYED);
}

WCHAR *CharToWString(const char *utf8string)
{
	int char_count;
	WCHAR *result;

	char_count = MultiByteToWideChar(CP_UTF8, 0, utf8string, -1, NULL, 0);
	result = (WCHAR *)malloc(char_count * sizeof(*result));

	if (result != NULL)
		MultiByteToWideChar(CP_UTF8, 0, utf8string, -1, result, char_count);

	return result;
}

char *WStringToChar(const WCHAR *wstring)
{
	int char_count;
	char *result;

	char_count = WideCharToMultiByte(CP_UTF8, 0, wstring, -1, NULL, 0, NULL, NULL);
	result = (char *)malloc(char_count * sizeof(*result));

	if (result != NULL)
		WideCharToMultiByte(CP_UTF8, 0, wstring, -1, result, char_count, NULL, NULL);

	return result;
}
