#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef char INT8;
typedef unsigned char UINT8;
typedef short INT16;
typedef unsigned short UINT16;
typedef int INT32;
typedef unsigned int UINT32;

#define AA		(inst & 2)
#define LI		((inst >> 2) & 0xffffff)
#define SEXLI	((LI << 2) | (((LI << 2) & (1 << 25)) ? 0xfc000000 : 0))
#define BD		((inst >> 2) & 0x3fff)


#define SEX16(x)	(INT32)(INT16)(x)

enum IForm
{
	I,
	B,
	SC,
	D,
	DS,
	X,
	XL,
	XFX,
	XFL,
	XS,
	XO,
	A,
	M,
	MD,
	MDs,
	INVALID
};

UINT32 Read32BE(bool *eof, FILE *file)
{
	UINT32 dword;

	dword = (fgetc(file) << 24) |
			(fgetc(file) << 16) |
			(fgetc(file) << 8)  |
			(fgetc(file) << 0);

	*eof = feof(file);

	return dword;
}

int main(int argc, char *argv[])
{
	FILE *file_i;
	FILE *file_o;
	bool eof = false;

	if (argc < 2)
	{
		printf("No file supplied");
		exit(1);
	}

	file_i = fopen(argv[1], "rb");

	if (file_i == NULL)
	{
		printf("Couldn't open %s", argv[1]);
		exit(1);
	}

	file_o = fopen("output.txt", "wb");

	if (file_o == NULL)
	{
		printf("Couldn't open output");
		exit(1);
	}

	for (int pos = 0; pos < (2048*1024); pos+=4)
	{
		UINT32 inst = Read32BE(&eof, file_i);
		enum IForm form = INVALID;
		char buf[64];
		const char *op;

		UINT32 addr;

		switch ((inst >> 26) & 0x3f)
		{
			case 14:
			{
				op = "addi";
				form = D;
				break;
			}
			case 12:
			{
				op = "addic";
				form = D;
				break;
			}
			case 13:
			{
				op = "addic.";
				form = D;
				break;
			}
			case 15:
			{
				op = "addis";
				form = D;
				break;
			}
			case 28:
			{
				op = "andi.";
				form = D;
				break;
			}
			case 29:
			{
				op = "andis.";
				form = D;
				break;
			}
			case 34:
			{
				op = "lbz";
				form = D;
				break;
			}
			case 35:
			{
				op = "lbzu";
				form = D;
				break;
			}
			case 50:
			{
				op = "lfd";
				form = D;
				break;
			}
			case 51:
			{
				op = "lfdu";
				form = D;
				break;
			}
			case 48:
			{
				op = "lfs";
				form = D;
				break;
			}
			case 49:
			{
				op = "lfsu";
				form = D;
				break;
			}
			case 42:
			{
				op = "lha";
				form = D;
				break;
			}
			case 43:
			{
				op = "lhau";
				form = D;
				break;
			}
			case 40:
			{
				op = "lhz";
				form = D;
				break;
			}
			case 41:
			{
				op = "lhzu";
				form = D;
				break;
			}
			case 46:
			{
				op = "lmw";
				form = D;
				break;
			}
			case 32:
			{
				op = "lwz";
				form = D;
				break;
			}
			case 33:
			{
				op = "lwzu";
				form = D;
				break;
			}
			case 7:
			{
				op = "mulli";
				form = D;
				break;
			}
			case 24:
			{
				op = "ori";
				form = D;
				break;
			}
			case 25:
			{
				op = "oris";
				form = D;
				break;
			}
			case 38:
			{
				op = "stb";
				form = D;
				break;
			}
			case 39:
			{
				op = "stbu";
				form = D;
				break;
			}
			case 54:
			{
				op = "stfd";
				form = D;
				break;
			}
			case 55:
			{
				op = "stfdu";
				form = D;
				break;
			}
			case 52:
			{
				op = "stfs";
				form = D;
				break;
			}
			case 53:
			{
				op = "stfsu";
				form = D;
				break;
			}
			case 44:
			{
				op = "sth";
				form = D;
				break;
			}
			case 45:
			{
				op = "sthu";
				form = D;
				break;
			}
			case 47:
			{
				op = "stmw";
				form = D;
				break;
			}
			case 36:
			{
				op = "stw";
				form = D;
				break;
			}
			case 37:
			{
				op = "stwu";
				form = D;
				break;
			}
			case 8:
			{
				op = "subfic";
				form = D;
				break;
			}
			case 3:
			{
				op = "twi";
				form = D;
				break;
			}
			case 26:
			{
				op = "xori";
				form = D;
				break;
			}
			case 27:
			{
				op = "xoris";
				form = D;
				break;
			}
			case 18:
			{
				static const char *bx_ops[] = { "b", "bl", "ba", "bla" };
				op = bx_ops[inst & 3];
				form = I;
				break;
			}
			case 16:
			{
				static const char *bcx_ops[] = { "bc", "bcl", "bca", "bcla" };
				op = bcx_ops[inst & 3];
				form = B;
				break;
			}
			case 17:
			{
				op = "sc";
				form = SC;
				break;
			}
			default:
				op = "?????";
		}

		sprintf(buf, "%.08x:    %s", pos, op);

		int i;
		int j = strlen(buf);

		for (i = j; i < 24; ++i)
			buf[i] = ' ';

		char *buf_ptr = &buf[24];

		switch (form)
		{
			case I:		sprintf(buf_ptr, "%.8x\n", pos + (AA ? 0 : SEXLI)); break;
			case B:		sprintf(buf_ptr, "%.8x\n", pos + (AA ? 0 : SEX16(BD))); break;
			case SC:	sprintf(buf_ptr, "\n"); break;
			case D:		sprintf(buf_ptr, "r%d, r%d, %.04x\n", ((inst >> 21) & 0x1f), ((inst >> 16) & 0x1f), inst & 0xffff); break;
			default:	sprintf(buf_ptr, "\n"); break;
		}

		fprintf(file_o, buf);
	}

}
