/******************************************************************************

    debugman

    Emulated CPU debugging support

******************************************************************************/

#include "m2x.h"
#include "log.h"
#include "cpuexec.h"
#include "core.h"
#include "debugman.h"

enum
{
	DEBUGGER_RUNNING,
	DEBUGGER_WAITING,
	DEBUGGER_STEP,
} DebuggerState;

// HACK
extern UINT8 *RAM;

const char *GetTaskName(UINT32 taskptr)
{
	static char buf[32];

	if (taskptr == 0xc0000000)
		return "????";
	UINT32 nameptr = READ32_BE(RAM, taskptr + 0x10) - 0x40000000;

	int i = 0;
	while (i < 32)
	{
		buf[i] = RAM[nameptr + i];
		if (buf[i++] == 0)
			break;
	}
	return buf;
}

const char *ToName(UINT32 loc)
{
	static char buf[32];

	loc -= 0x40000000;

	int i = 0;
	while (i < 32)
	{
		buf[i] = RAM[loc + i];
		if (buf[i++] == 0)
			break;
	}
	return buf;
}

float READFLOAT(UINT8 *ptr, UINT32 addr)
{
	UINT32 hex = READ32_BE(ptr, addr);
	return *(float*)&hex;
}

void DebugManager::DebugStep(CPU *cpu)
{
	static int trace = 0;
	UINT32 pc = cpu->GetPC();

	return;

//	if (trace)
//		LOGERROR("%x\n", pc);

	if (pc == 0x400c1394)
//	if (pc == 0x400b9ef4)
	{
		LOGERROR("\n****M_DRAW****\n");
		LOGERROR("POD (R3):       %x\n", cpu->GetReg(3));
		LOGERROR("Closedata (R4): %x\n\n", cpu->GetReg(4));
		trace = 1;

		for (int i = 0; i < 32; ++i)
		{
			LOGERROR("r[%d] = %x;\n", i, cpu->GetReg(i));
		}

		UINT32 podptr = cpu->GetReg(3);
		if (podptr != NULL)
		{
//			FILE *f = fopen("tmp\\ramsave.bin","wb");
//			fwrite(RAM, 1, 16384*1024, f);
//			fclose(f);

			podptr -= 0x40000000;
			LOGERROR("POD Info:\n");
			LOGERROR("flags:     %8x\n",   READ32_BE(RAM, podptr + 0));
			LOGERROR("pnext:     %8x\n",   READ32_BE(RAM, podptr + 4));
			LOGERROR("pcase:     %8x\n",   READ32_BE(RAM, podptr + 8));
			LOGERROR("ptexture:  %8x\n",   READ32_BE(RAM, podptr + 12));
			LOGERROR("pgeometry: %8x\n",   READ32_BE(RAM, podptr + 16));
			LOGERROR("pmatrix:   %8x\n",   READ32_BE(RAM, podptr + 20));
			LOGERROR("plights:   %8x\n",   READ32_BE(RAM, podptr + 24));
			LOGERROR("puserdata: %8x\n",   READ32_BE(RAM, podptr + 28));
			LOGERROR("pmaterial: %8x\n\n", READ32_BE(RAM, podptr + 32));

			UINT32 geo = READ32_BE(RAM, podptr + 16) - 0x40000000;

			LOGERROR("POD Geometry:\n");
			LOGERROR("xmin:      %f\n",     READFLOAT(RAM, geo + 0));
			LOGERROR("ymin:      %f\n",     READFLOAT(RAM, geo + 4));
			LOGERROR("zmin:      %f\n",     READFLOAT(RAM, geo + 8));
			LOGERROR("xext:      %f\n",     READFLOAT(RAM, geo + 12));
			LOGERROR("yext:      %f\n",     READFLOAT(RAM, geo + 16));
			LOGERROR("zext:      %f\n",     READFLOAT(RAM, geo + 20));
			LOGERROR("pvtx:      %.8x\n",   READ32_BE(RAM, geo + 24));
			LOGERROR("pshared    %.8x\n",   READ32_BE(RAM, geo + 28));
			LOGERROR("vtxcnt:    %d\n",     READ32_BE(RAM, geo + 32) >> 16);
			LOGERROR("sharedcnt: %d\n",     READ32_BE(RAM, geo + 34) >> 16);
			LOGERROR("pindex:    %.8x\n",   READ32_BE(RAM, geo + 36));
			LOGERROR("puv:       %.8x\n\n", READ32_BE(RAM, geo + 40));
			LOGERROR("paaedge:   %.8x\n\n", READ32_BE(RAM, geo + 44));
		}
	}

	if (pc == 0x400bb894)
	{
		trace = 1;
	}

	if (pc == 0x400c1784)
	{
		LOGERROR("Vertices drawn (R15): %d\n\n", cpu->GetReg(15));
	}

	if (pc == 0x400ba25c)
	{
		LOGERROR("Vertices drawn (R21): %x\n\n", cpu->GetReg(21));

		// SHITE
//		FILE *f = fopen("tmp\\drawn.bin","wb");
//		fwrite(RAM, 1, 16384*1024, f);
//		fclose(f);
	}

#if 0
	if (pc == 0x407e256c)
		CLOGERROR(RED, "BDA VIDEO CALLING\n");
	if (pc == 0x407e2334)
		CLOGERROR(RED, "What Function\n");

	if (trace > 0)
	{
	//	LOGERROR("%x\n", pc);
		trace--;
	}

	// Heat of 11
	UINT32 activetaskptr = 0x2cc08;
	// POLYS
//	UINT32 activetaskptr = 0x2ba30;
	UINT32 taskptr = READ32_BE(RAM, activetaskptr) - 0x40000000;

#if 0
	if (pc == 0x400224a8) // SuperAllocSignalInternal
	{
		CLOGERROR(GREEN, "SuperAllocSignal: Mask:%x, Task %x (%s)\n", cpu->GetReg(3), taskptr, GetTaskName(taskptr));
	}
	else if (pc == 0x40022504)
	{
		CLOGERROR(GREEN, "Alloced list: %x\n", cpu->GetReg(3));
	}
	else if (pc == 0x40022520)
	{
		CLOGERROR(GREEN, "New Allocated list: %x\n", cpu->GetReg(31));
	}
	else if (pc == 0x40022550)
	{
		UINT32 asigs = READ32_BE(RAM, 0x30+taskptr) - 0x40000000;
		CLOGERROR(GREEN, "\t: Return %x\n", cpu->GetReg(3));
		CLOGERROR(GREEN, "\t: Alloced Sigs %x\n", asigs);
	}
#endif

#if 1

	if (pc == 0x40022628) // SuperSignal
	{
		UINT32 to = cpu->GetReg(3)-0x40000000;
		CLOGERROR(CYAN, "SuperSignal: %x from %x (%s) ", cpu->GetReg(4), taskptr, GetTaskName(taskptr));
		CLOGERROR(CYAN, "to %x (%s)\n", to, GetTaskName(to));
		if ((to == 0xfe5a08) && cpu->GetReg(4) == 0x100)
		{
			trace = 50000;
		}
	}


	if (pc == 0x4002257c) // SuperFreeSignal
	{

		CLOGERROR(RED, "SuperFreeSignal:  mask:%x, Task %x (%s)\n", cpu->GetReg(3), taskptr, GetTaskName(taskptr));
	}


	if (pc == 0x40012cc8) // CreateTask
	{

		CLOGERROR(RED, "CreateTask: %s, Task %x (%s)\n", ToName(cpu->GetReg(4)), taskptr, GetTaskName(taskptr));
	}

	if (pc == 0x40012dc4) // CreateModulethread
	{

		CLOGERROR(RED, "CreateModuleThread: %s, Task %x (%s)\n", ToName(cpu->GetReg(4)), taskptr, GetTaskName(taskptr));
	}

	if (pc == 0x40012cc8) // CreateThread
	{

		CLOGERROR(RED, "CreateThread: %x (%s), Task %x (%s)\n", cpu->GetReg(3), ToName(cpu->GetReg(4)), taskptr, GetTaskName(taskptr));
	}
#endif

	//if (pc == 0x400223fc)
	if (pc == 0x4002172c)
	{
		CLOGERROR(CYAN, "SuperWait: mask:%x, Task %x (%s)\n", cpu->GetReg(3), taskptr, GetTaskName(taskptr));
	}
	//else if (pc == 0x4002245c)
	else if (pc == 0x4002178c)
	{
		CLOGERROR(CYAN, "\tWaiting...\n");
	}
	//else if (pc == 0x400224a4)
	else if (pc == 0x400217d4)
	{
		CLOGERROR(CYAN, "\tLeaving Wait %x (%s)\n", taskptr, GetTaskName(taskptr));
	}
#endif
}
