#pragma once

#include "M2x.h"
#include <vector>

typedef int FileHandle;
class vector;

#define FILE_READ			(1 << 0)
#define FILE_WRITE			(1 << 1)
#define FILE_OPEN_EXISTING	(1 << 2)
#define FILE_OPEN_ALWAYS	(1 << 3)
#define FILE_MEMMAPPED		(1 << 4)

typedef enum _FileStatus_
{
	FILE_ERROR = 0,
	FILE_OK = 1,
} FileStatus;

typedef enum _FilePos_
{
	FILE_POS_BEGIN,
	FILE_POS_CURRENT,
	FILE_POS_END,
} FilePos;

struct FileInfo
{
	friend class FileManager;
private:
	FileHandle	handle;
	char		name[256];
	HANDLE		sys_handle;
	int			flags;
public:
	FileInfo() { };
	~FileInfo();
};

class FileManager
{
private:
	std::vector<FileInfo> file_list;

	bool FileManager::Validate(FileHandle handle, int &pos);
public:

	FileStatus Open(const char *path, const char *file, int flags, FileHandle &handle);
	FileStatus Close(FileHandle &handle);
	FileStatus Read(FileHandle handle, void *buffer, int bytes);
	FileStatus Write(FileHandle handle, void *buffer, int bytes);
	FileStatus Delete(const char *path, const char *file);
	FileStatus SetPos(FileHandle handle, int offset, FilePos pos);
	FileStatus GetFileSize(FileHandle handle, UINT64 &size);
	FileStatus FileExists(const char *name);

	FileStatus CreateFolder(const char *name);

	FileManager();
	~FileManager();
};
