#pragma once
#include "M2x.h"

enum ErrorLogColour
{
	RED = FOREGROUND_RED,
	GREEN = FOREGROUND_GREEN,
	BLUE = FOREGROUND_BLUE,
	CYAN = FOREGROUND_GREEN | FOREGROUND_BLUE,
	WHITE = FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE,
};
#if 1
#define LOGERROR(format, ...)		PrintErrorLog(WHITE, format, __VA_ARGS__)
#define CLOGERROR(col, format, ...)	PrintErrorLog(col, format, __VA_ARGS__)
#else
#define LOGERROR(format, ...)
#define CLOGERROR(col, format, ...)

#define UARTLOGERROR(format, ...)		PrintErrorLog(WHITE, format, __VA_ARGS__)
#endif

void InitErrorLog(HWND hWnd);
void PrintErrorLog(ErrorLogColour color, char *fmt, ...);
void CloseErrorLog();

//#define DEBUG_BREAK	__debugbreak()
#define DEBUG_BREAK		LOGERROR("DEBUGBREAK AT %s %d\n", __FILE__, __LINE__);
