#pragma once
#include "M2x.h"

#define READ8(x, a)				(x[(a)])
#define READ16_LE(x, a)			((x[(a) + 1] << 8) | (x[(a) + 0]))
#define READ16_BE(x, a)			((x[(a) + 0] << 8) | (x[(a) + 1]))

#define WRITE16_BE(x, a, d)		do { \
								x[(a) + 0] = ((d) >> 8) & 0xff;	\
								x[(a) + 1] = ((d) & 0xff); } while(0)

#define READ32_LE(x, a)			((x[(a) + 3] << 24) | (x[(a) + 2] << 16) | (x[(a) + 1] << 8) | x[(a) + 0])
#define READ32_BE(x, a)			((x[(a) + 0] << 24) | (x[(a) + 1] << 16) | (x[(a) + 2] << 8) | x[(a) + 3])

#define WRITE32_BE(x, a, d)		do { \
								x[(a) + 0] = ((d) >> 24) & 0xff;	\
								x[(a) + 1] = ((d) >> 16) & 0xff;	\
								x[(a) + 2] = ((d) >> 8) & 0xff;		\
								x[(a) + 3] = ((d) & 0xff); } while(0)

#define ADDRESS_MAP( name )				memory_map name[] = {
#define MAP_RANGE(start, end, r, w)		{ 0, start, end, r, w },
#define ADDRESS_MAP_END					{ 0xff } };

#define READ32_HANDLER(NAME)	UINT32 NAME(UINT32 offset, UINT32 mask)
#define WRITE32_HANDLER(NAME)	void NAME(UINT32 offset, UINT32 data, UINT32 mask)
