#pragma once

#include "core.h"

class YMZ280B
{
private:
#define CHANNELS	8

	union
	{
		struct
		{
			struct
			{
				UINT8 pitch1;
				UINT8 pitch2;
				UINT8 level;
				UINT8 pan;
			} ctrl_regs[CHANNELS];

			struct
			{
				UINT8 start_addr;
				UINT8 loop_start;
				UINT8 loop_end;
				UINT8 end_addr;
			} addr_h_regs[CHANNELS];

			struct
			{
				UINT8 start_addr;
				UINT8 loop_start;
				UINT8 loop_end;
				UINT8 end_addr;
			} addr_m_regs[CHANNELS];

			struct
			{
				UINT8 start_addr;
				UINT8 loop_start;
				UINT8 loop_end;
				UINT8 end_addr;
			} addr_l_regs[CHANNELS];
		};
		UINT8 addr[0x80];
	} fn_regs;

	UINT8 ch_reg;
	UINT8 dspen_reg;
	UINT8 dspdata_reg;
	UINT8 ramaddr_h_reg;
	UINT8 ramaddr_m_reg;
	UINT8 ramaddr_l_reg;
	UINT8 ramdata_reg;
	UINT8 irq_reg;
	UINT8 misc_reg;

	UINT8 status;

	UINT8 reg_addr;

	void UpdateStream();

	UINT8 (*ReadExternalRAM)(int offset);
	void (*WriteExternalRAM)(int offset, UINT8 data);

public:
	YMZ280B();
	void Reset();
	void SetExternalReadHandler(UINT8 (*callback)(int));
	void SetExternalWriteHandler(void (*callback)(int, UINT8));
	UINT8 Read(int offset);
	void Write(int offset, UINT8 data);
};
