#pragma once

#define TRUNC(x)	((float)(int)(x))
#define FCLAMP(x)	do { if (x > 255.0f) x = 255.0f; else if (x < 0.0f) x = 0.0f; } while(0)
#define ROUND(x)	(float)(x < 0 ? ceil((x) - 0.5) : floor((x) + 0.5))

#define PPC_BIT(x)	(31 - (x))

typedef struct _VTX_
{
	float	x;
	float	y;
	float	r, g, b, a;
	float	rw;
	float	uw, vw;
} VTX;

typedef struct _slope_
{
	float slope;
	float dDx;
} slope;

struct slope_calc_data
{
	float y23;
	float y31;
	float y12;
	float x23;
	float x31;
	float x12;
	float xstep_long;
	float iAria;
};

enum _scan_
{
	LR, RL
};


void InitTriangleEngine();

READ32_HANDLER( te_r );
WRITE32_HANDLER( te_w );

#define IP_MASK			0x01fffffc

#define X_FBCLIP		(int)((DB.FBClip >> 16) & 0x3ff)
#define Y_FBCLIP		(int)(DB.FBClip & 0x3ff)

#define X_WINCLIPMIN	(int)((DB.XWinClip >> 16) & 0x3ff)
#define X_WINCLIPMAX	(int)(DB.XWinClip & 0x3ff)
#define Y_WINCLIPMIN	(int)((DB.YWinClip >> 16) & 0x3ff)
#define Y_WINCLIPMAX	(int)(DB.YWinClip & 0x3ff)

#define Z_XOFFSET		((DB.ZOffset >> 16) & 0xfff)
#define Z_YOFFSET		(DB.ZOffset & 0xfff)
#define Z_XCLIP			((DB.ZClip >> 16) & 0x3ff)
#define Z_YCLIP			(DB.ZClip & 0x3ff)

#define VTX_FLAG_SHAD	(1 << (31 - 15))
#define VTX_FLAG_TEXT	(1 << (31 - 14))
#define VTX_FLAG_PRSP	(1 << (31 - 13))
#define VTX_FLAG_NEW	(1 << (31 - 12))
#define VTX_FLAG_RM		(1 << (31 - 11))


/* TEMasterMode */
#define TEMASTER_MODE_DDITH_SHIFT		PPC_BIT(26)
#define TEMASTER_MODE_DDITH_MASK		(1 << TEMASTER_MODE_DDITH_SHIFT)
#define TEMASTER_MODE_DZBUF_SHIFT		PPC_BIT(27)
#define TEMASTER_MODE_DZBUF_MASK		(1 << TEMASTER_MODE_DZBUF_SHIFT)
#define TEMASTER_MODE_DBLEND_SHIFT		PPC_BIT(28)
#define TEMASTER_MODE_DBLEND_MASK		(1 << TEMASTER_MODE_DBLEND_SHIFT)
#define TEMASTER_MODE_DSHADE_SHIFT		PPC_BIT(29)
#define TEMASTER_MODE_DSHADE_MASK		(1 << TEMASTER_MODE_DSHADE_SHIFT)
#define TEMASTER_MODE_DTEXT_SHIFT		PPC_BIT(30)
#define TEMASTER_MODE_DTEXT_MASK		(1 << TEMASTER_MODE_DTEXT_SHIFT)
#define TEMASTER_MODE_RESET_SHIFT		PPC_BIT(31)
#define TEMASTER_MODE_RESET_MASK		(1 << TEMASTER_MODE_RESET_SHIFT)


/* TEICntl */
#define TEICNTL_STRT_SHIFT				PPC_BIT(26)
#define TEICNTL_STRT_MASK				(1 << TEICNTL_STRT_SHIFT)
#define TEICNTL_RSTRT_SHIFT				PPC_BIT(27)
#define TEICNTL_RSTRT_MASK				(1 << TEICNTL_RSTRT_SHIFT)
#define TEICNTL_STPI_SHIFT				PPC_BIT(28)
#define TEICNTL_STPI_MASK				(1 << TEICNTL_STPI_SHIFT)
#define TEICNTL_STPL_SHIFT				PPC_BIT(29)
#define TEICNTL_STPL_MASK				(1 << TEICNTL_STPL_SHIFT)
#define TEICNTL_STEP_SHIFT				PPC_BIT(30)
#define TEICNTL_STEP_MASK				(1 << TEICNTL_STEP_SHIFT)
#define TEICNTL_INT_SHIFT				PPC_BIT(31)
#define TEICNTL_INT_MASK				(1 << TEICNTL_INT_SHIFT)


/* IntStat */
#if 0
#define INTSTAT_ALUSTATINT_SHIFT
#define INTSTAT_ZFUNCSTATINT_SHIFT
#define INTSTAT_ANYRENDINT_SHIFT
#define INTSTAT_SUPERINT_SHIFT
#define INTSTAT_UIINSTRINT_SHIFT
#define INTSTAT_SPINSTRINT_SHIFT
#define INTSTAT_WINCLIPINT_SHIFT
#define INTSTAT_LISTENDINT_SHIFT
#define INTSTAT_IMINSTRINT_SHIFT
#define INTSTAT_DFINSTRINT_SHIFT
#define INTSTAT_DFINSTRVECT_MASK	(0xff << INSTAT_DFINSTRINT_SHIFT)
#endif
/* SuperGenControl */
#define SUPERGENCTL_ZWR16BEN_SHIFT		PPC_BIT(29)
#define SUPERGENCTL_ZWR16BEN_MASK		(1 << SUPERGENCTL_ZWR16BEN_SHIFT)
#define SUPERGENCTL_DESTWR16BEN_SHIFT	PPC_BIT(30)
#define SUPERGENCTL_DESTWR16BEN_MASK	(1 << SUPERGENCTL_DESTWR16BEN_SHIFT)
#define SUPERGENCTL_DESTOUTEN_SHIFT		PPC_BIT(31)
#define SUPERGENCTL_DESTOUTEN_MASK		(1 << SUPERGENCTL_DESTOUTEN_SHIFT)

/* UserGenControl */
#define USERGENCTL_ZBUFEN_SHIFT			PPC_BIT(21)
#define USERGENCTL_ZBUFEN_MASK			(1 << USERGENCTL_ZBUFEN_SHIFT)
#define USERGENCTL_ZOUTEN_SHIFT			PPC_BIT(22)
#define USERGENCTL_ZOUTEN_MASK			(1 << USERGENCTL_ZOUTEN_SHIFT)
#define USERGENCTL_WCLIPINEN_SHIFT		PPC_BIT(23)
#define USERGENCTL_WCLIPINEN_MASK		(1 << USERGENCTL_WCLIPINEN_SHIFT)
#define USERGENCTL_WCLIPOUTEN_SHIFT		PPC_BIT(24)
#define USERGENCTL_WCLIPOUTEN_MASK		(1 << USERGENCTL_WCLIPOUTEN_SHIFT)
#define USERGENCTL_BLENDEN_SHIFT		PPC_BIT(25)
#define USERGENCTL_BLENDEN_MASK			(1 << USERGENCTL_BLENDEN_SHIFT)
#define USERGENCTL_SRCINEN_SHIFT		PPC_BIT(26)
#define USERGENCTL_SRCINEN_MASK			(1 << USERGENCTL_SRCINEN_SHIFT)
#define USERGENCTL_DITHEREN_SHIFT		PPC_BIT(27)
#define USERGENCTL_DITHEREN_MASK		(1 << USERGENCTL_DITHEREN_SHIFT)
#define USERGENCTL_DESTOUT_SHIFT		PPC_BIT(31)
#define USERGENCTL_DESTOUT_MASK			(15 << USERGENCTL_DESTOUT_SHIFT)

/* DiscardControl */
#define DISCARDCTL_ZCLIPDISEN_SHIFT		PPC_BIT(28)
#define DISCARDCTL_ZCLIPDISEN_MASK		(1 << DISCARDCTL_ZCLIPDISEN_SHIFT)
#define DISCARDCTL_SSBDISEN_SHIFT		PPC_BIT(29)
#define DISCARDCTL_SSBDISEN_MASK		(1 << DISCARDCTL_SSBDISEN_SHIFT)
#define DISCARDCTL_RGBDISEN_SHIFT		PPC_BIT(30)
#define DISCARDCTL_RGBDISEN_MASK		(1 << DISCARDCTL_RGBDISEN_SHIFT)
#define DISCARDCTL_ADISEN_SHIFT			PPC_BIT(31)
#define DISCARDCTL_ADISEN_MASK			(1 << DISCARDCTL_ADISEN_SHIFT)

/* Status */
#define STATUS_FBCLIP_SHIFT				PPC_BIT(16)
#define STATUS_FBCLIP_MASK				(1 << STATUS_FBCLIP_SHIFT)
#define STATUS_WINCLIP_SHIFT			PPC_BIT(17)
#define STATUS_WINCLIP_MASK				(1 << STATUS_WINCLIP_SHIFT)
#define STATUS_ZCLIP_SHIFT				PPC_BIT(18)
#define STATUS_ZCLIP_MASK				(1 << STATUS_ZCLIP_SHIFT)

/* TxtLdCntl */
#define TXTLDCNTL_SRCBITOFFS_SHIFT		PPC_BIT(31)
#define TXTLDCNTL_SRCBITOFFS_MASK		(7 << TXTLDCNTL_SRCBITOFFS_SHIFT)
#define TXTLDCNTL_LDMODE_SHIFT			PPC_BIT(23)
#define TXTLDCNTL_LDMODE_MASK			(3 << TXTLDCNTL_LDMODE_SHIFT)

#define TXTLDCNTL_LDMODE_TEXLOAD		0
#define TXTLDCNTL_LDMODE_MMDMA			1
#define TXTLDCNTL_LDMODE_PIPLOAD		2
#define TXTLDCNTL_LDMODE_RESERVED		3

#define TXTLDCNTL_COMPRESSED_SHIFT		PPC_BIT(21)
#define TXTLDCNTL_COMPRESSED_MASK		(1 << TXTLDCNTL_COMPRESSED_SHIFT)
#define TXTLDCNTL_MMDMAMODE_SHIFT		PPC_BIT(20)
#define TXTLDCNTL_MMDMAMODE_MASK		(1 << TXTLDCNTL_MMDMAMODE_SHIFT)

/* TxtTABCntl */
#define TXTTABCNTL_CASEL_SHIFT			PPC_BIT(31)
#define TXTTABCNTL_CASEL_MASK			(7 << TXTTABCNTL_CASEL_SHIFT)
#define TXTTABCNTL_CBSEL_SHIFT			PPC_BIT(28)
#define TXTTABCNTL_CBSEL_MASK			(7 << TXTTABCNTL_CBSEL_SHIFT)
#define TXTTABCNTL_CTSEL_SHIFT			PPC_BIT(25)
#define TXTTABCNTL_CTSEL_MASK			(7 << TXTTABCNTL_CTSEL_SHIFT)

#define TXTTABCNTL_LERP_AITER			0
#define TXTTABCNTL_LERP_CITER			1
#define TXTTABCNTL_LERP_AT				2
#define TXTTABCNTL_LERP_CT				3
#define TXTTABCNTL_LERP_ACONST			4
#define TXTTABCNTL_LERP_CCONST			5

#define TXTTABCNTL_COSEL_SHIFT			PPC_BIT(22)
#define TXTTABCNTL_COSEL_MASK			(3 << TXTTABCNTL_COSEL_SHIFT)
#define TXTTABCNTL_COSEL_CITER			0
#define TXTTABCNTL_COSEL_CT				1
#define TXTTABCNTL_COSEL_BLENDOUTPUT	2
#define TXTTABCNTL_COSEL_RESERVED		3

#define TXTTABCNTL_AASEL_SHIFT			PPC_BIT(20)
#define TXTTABCNTL_AASEL_MASK			(3 << TXTTABCNTL_AASEL_SHIFT)
#define TXTTABCNTL_ABSEL_SHIFT			PPC_BIT(18)
#define TXTTABCNTL_ABSEL_MASK			(3 << TXTTABCNTL_ABSEL_SHIFT)
#define TXTTABCNTL_AOSEL_SHIFT			PPC_BIT(16)
#define TXTTABCNTL_AOSEL_MASK			(3 << TXTTABCNTL_AOSEL_SHIFT)
#define TXTTABCNTL_AOSEL_AITER			0
#define TXTTABCNTL_AOSEL_AT				1
#define TXTTABCNTL_AOSEL_BLENDOUTPUT	2
#define TXTTABCNTL_AOSEL_RESERVED		3

#define TXTTABCNTL_BLENDOP_SHIFT		PPC_BIT(14)
#define TXTTABCNTL_BLENDOP_MASK			(1 << TXTTABCNTL_BLENDOP_SHIFT)
#define TXTTABCNTL_BLENDOP_LERP			0
#define TXTTABCNTL_BLENDOP_MULTIPLY		1

/* SrcCntl */
#define SRCCNTL_32BPP_SHIFT				PPC_BIT(31)
#define SRCCNTL_32BPP_MASK				(1 << SRCCNTL_32BPP_SHIFT)
#define SRCCNTL_MSBREP_SHIFT			PPC_BIT(30)
#define SRCCNTL_MSBREP_MASK				(1 << SRCCNTL_MSBREP_SHIFT)

#define SRCOFFS_XOFFS_SHIFT				PPC_BIT(15)
#define SRCOFFS_XOFFS_MASK				(0xfff << SRCOFFS_XOFFS_SHIFT)
#define SRCOFFS_YOFFS_SHIFT				PPC_BIT(31)
#define SRCOFFS_YOFFS_MASK				(0xfff << SRCOFFS_YOFFS_SHIFT)

/* DestCntl */
#define DESTCNTL_32BPP_SHIFT			PPC_BIT(31)
#define DESTCNTL_32BPP_MASK				(1 << DESTCNTL_32BPP_SHIFT)

/* TxtAddrCntl */
#define TXTADDRCNTL_LODMAX_SHIFT		PPC_BIT(31)
#define TXTADDRCNTL_LODMAX_MASK			(15 << TXTADDRCNTL_LODMAX_SHIFT)
#define TXTADDRCNTL_R12FLTSEL_SHIFT		PPC_BIT(27)
#define TXTADDRCNTL_R12FLTSEL_MASK		(7 << TXTADDRCNTL_R12FLTSEL_SHIFT)
#define TXTADDRCNTL_R3FLTSEL_SHIFT		PPC_BIT(24)
#define TXTADDRCNTL_R3FLTSEL_MASK		(7 << TXTADDRCNTL_R3FLTSEL_SHIFT)
#define TXTADDRCNTL_R45FLTSEL_SHIFT		PPC_BIT(21)
#define TXTADDRCNTL_R45FLTSEL_MASK		(7 << TXTADDRCNTL_R45FLTSEL_SHIFT)

#define TXTADDRCNTL_FILTER_POINT		0
#define TXTADDRCNTL_FILTER_LINEAR		1
#define TXTADDRCNTL_FILTER_BILINEAR		2
#define TXTADDRCNTL_FILTER_QUASITRI		3

#define TXTADDRCNTL_LOOKUPEN_SHIFT		PPC_BIT(18)
#define TXTADDRCNTL_LOOKUPEN_MASK		(1 << TXTADDRCNTL_LOOKUPEN_SHIFT)


/* SourceMultCntl */
#define SRCMULTCNTL_SRCINSEL_SHIFT		PPC_BIT(25)
#define SRCMULTCNTL_SRCINSEL_MASK		(3 << SRCMULTCNTL_SRCINSEL_SHIFT)
#define SRCMULTCNTL_SRCCOEFSEL_SHIFT	PPC_BIT(27)
#define SRCMULTCNTL_SRCCOEFSEL_MASK		(3 << SRCMULTCNTL_SRCCOEFSEL_SHIFT)
#define SRCMULTCNTL_SRCCONSTCNTL_SHIFT	PPC_BIT(29)
#define SRCMULTCNTL_SRCCONSTCNTL_MASK	(3 << SRCMULTCNTL_SRCCONSTCNTL_SHIFT)
#define SRCMULTCNTL_SRCCOEFCMP_SHIFT	PPC_BIT(30)
#define SRCMULTCNTL_SRCCOEFCMP_MASK		(1 << SRCMULTCNTL_SRCCOEFCMP_SHIFT)
#define SRCMULTCNTL_SRCRJUST_SHIFT		PPC_BIT(31)
#define SRCMULTCNTL_SRCRJUST_MASK		(1 << SRCMULTCNTL_SRCRJUST_SHIFT)

/* TextureMultCntl */
#define TXTMULTCNTL_TXTINSEL_SHIFT		PPC_BIT(25)
#define TXTMULTCNTL_TXTINSEL_MASK		(3 << TXTMULTCNTL_TXTINSEL_SHIFT)
#define TXTMULTCNTL_TXTCOEFSEL_SHIFT	PPC_BIT(27)
#define TXTMULTCNTL_TXTCOEFSEL_MASK		(3 << TXTMULTCNTL_TXTCOEFSEL_SHIFT)
#define TXTMULTCNTL_TXTCONSTCNTL_SHIFT	PPC_BIT(29)
#define TXTMULTCNTL_TXTCONSTCNTL_MASK	(3 << TXTMULTCNTL_TXTCONSTCNTL_SHIFT)
#define TXTMULTCNTL_TXTCOEFCMP_SHIFT	PPC_BIT(30)
#define TXTMULTCNTL_TXTCOEFCMP_MASK		(1 << TXTMULTCNTL_TXTCOEFCMP_SHIFT)
#define TXTMULTCNTL_TXTRJUST_SHIFT		PPC_BIT(31)
#define TXTMULTCNTL_TXTRJUST_MASK		(1 << TXTMULTCNTL_TXTRJUST_SHIFT)

#define ALUCNTL_ALUSEL_SHIFT			PPC_BIT(28)
#define ALUCNTL_ALUSEL_MASK				(5 << ALUCNTL_ALUSEL_SHIFT)
#define ALUCNTL_FINALDIVIDE_SHIFT		PPC_BIT(31)
#define ALUCNTL_FINALDIVIDE_MASK		(7 << ALUCNTL_FINALDIVIDE_SHIFT)

#define DSTACNTL_ADESTCONSTCNTL_SHIFT	PPC_BIT(29)
#define DSTACNTL_ADESTCONSTCNTL_MASK	(3 << DSTACNTL_ADESTCONSTCNTL_SHIFT)
#define DSTACNTL_ADESTSEL_SHIFT			PPC_BIT(31)
#define DSTACNTL_ADESTSEL_MASK			(3 << DSTACNTL_ADESTSEL_SHIFT)

#define DESTALPHACONST_CONST0_SHIFT		PPC_BIT(15)
#define DESTALPHACONST_CONST0_MASK		(8 << DESTALPHACONST_CONST0_SHIFT)
#define DESTALPHACONST_CONST1_SHIFT		PPC_BIT(31)
#define DESTALPHACONST_CONST1_MASK		(8 << DESTALPHACONST_CONST1_SHIFT)

#define SSBDSBCNTL_DSBCONST_SHIFT		PPC_BIT(29)
#define SSBDSBCNTL_DSBCONST_MASK		(1 << SSBDSBCNTL_DSBCONST_SHIFT)
#define SSBDSBCNTL_DSBSEL_SHIFT			PPC_BIT(31)
#define SSBDSBCNTL_DSBSEL_MASK			(1 << SSBDSBCNTL_DSBSEL_SHIFT)


/* CS Source Selects */
#define SRC_SRC_SELECT				0
#define SRC_CONST_SELECT			1
#define SRC_COMP_SELECT				2
#define SRC_ALPHASRC_SELECT			3

#define TALPHA_ATI					0
#define TALPHA_ONE					1
#define TALPHA_ZERO					2

#define TXTR_CTI_SELECT				0
#define TXTR_CONST_SELECT			1
#define TXTR_COMP_SELECT			2
#define TXTR_ALPHATXT_SELECT		3

#define TXCOEF_ATI_SELECT			0
#define TXCOEF_ASRC_SELECT			1
#define TXCOEF_CONST_SELECT			2
#define TXCOEF_CSRC_SELECT			3

#define SRCCOEF_ATI_SELECT			0
#define SRCCOEF_ASRC_SELECT			1
#define SRCCOEF_CONST_SELECT		2
#define SRCCOEF_CTI_SELECT			3

#define TEXTYPE_CDEPTH_SHIFT		(0)
#define TEXTYPE_LDEPTH_SHIFT		(0)
#define TEXTYPE_CDEPTH_MASK			(15)
#define TEXTYPE_LDEPTH_MASK			(15)

#define TEXTYPE_ADEPTH_SHIFT		(0)
#define TEXTYPE_ADEPTH_MASK			(15 << TEXTYPE_ADEPTH_SHIFT)

#define TEXTYPE_TRANSPARENT_SHIFT	(8)
#define TEXTYPE_TRANSPARENT_MASK	(1 << TEXTYPE_TRANSPARENT_SHIFT)

#define TEXTYPE_SSBON_SHIFT			(9)
#define TEXTYPE_SSBON_MASK			(1 << TEXTYPE_SSBON_SHIFT)

#define TEXTYPE_COLORINDEX_ON_SHIFT	(10)
#define TEXTYPE_COLORINDEX_ON_MASK	(1 << TEXTYPE_COLORINDEX_ON_SHIFT)

#define TEXTYPE_ALPHAON_SHIFT		(11)
#define TEXTYPE_ALPHAON_MASK		(1 << TEXTYPE_ALPHAON_SHIFT)

#define TEXTYPE_LITERAL_SHIFT		(12)
#define TEXTYPE_LITERAL_MASK		(1 << TEXTYPE_LITERAL_SHIFT)

/* TxtPIPCntl */
#define TXTPIPCNTL_SSBSEL_SHIFT		PPC_BIT(17)
#define TXTPIPCNTL_SSBSEL_MASK		(7 << TXTPIPCNTL_SSBSEL_SHIFT)

#define TXTPIPCNTL_ALPHASEL_SHIFT	PPC_BIT(20)
#define TXTPIPCNTL_ALPHASEL_MASK	(7 << TXTPIPCNTL_ALPHASEL_SHIFT)

#define TXTPIPCNTL_COLORSEL_SHIFT	PPC_BIT(23)
#define TXTPIPCNTL_COLORSEL_MASK	(7 << TXTPIPCNTL_COLORSEL_SHIFT)

#define TXTPIPCNTL_IDXOFFSET_SHIFT	PPC_BIT(31)
#define TXTPIPCNTL_IDXOFFSET_MASK	(255 << TXTPIPCNTL_IDXOFFSET_SHIFT)

#define PIPSEL_CONSTANT				0
#define PIPSEL_TRAM					1
#define PIPSEL_PIP					2

/* Vertex */
#define VERTEX_STATE_TSORT_SHIFT	(0)
#define VERTEX_STATE_TSORT_MASK		(7 << VERTEX_STATE_TSORT_SHIFT)

#define VERTEX_STATE_VCNT_SHIFT		(3)
#define VERTEX_STATE_VCNT_MASK		(3 << VERTEX_STATE_VCNT_SHIFT)
