#include "d3d9.h"
#include "stdio.h"

#include "M2x.h"
#include "video.h"


bool Video::Initialise(int width, int height)
{
	HWND hWnd = GetAppHWnd();
	D3DPRESENT_PARAMETERS D3Dpp;

#if 0
	if ( FAILED( hr = DirectInput8Create( GetModuleHandle(NULL), DIRECTINPUT_VERSION, 
										IID_IDirectInput8, (VOID**)&pDirectInput8, NULL ) ) )
		return hr;
#endif

	ZeroMemory(&D3Dpp, sizeof(D3Dpp));
	D3Dpp.BackBufferWidth = width;
	D3Dpp.BackBufferHeight = height;
	D3Dpp.BackBufferCount = 1;
	D3Dpp.BackBufferFormat = D3DFMT_X8R8G8B8;
	D3Dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	D3Dpp.hDeviceWindow = hWnd;
	D3Dpp.Windowed = TRUE;
	D3Dpp.EnableAutoDepthStencil = TRUE;
	D3Dpp.AutoDepthStencilFormat = D3DFMT_D16;
	D3Dpp.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
	D3Dpp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

	pD3D9 = Direct3DCreate9(D3D_SDK_VERSION);

	if ( FAILED(pD3D9->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &D3Dpp, &pD3D9Dev) ))
		return FALSE;

	CUSTOMVERTEX vertices[4] =
	{
		{ 0.0f - 0.5f,   0.0f - 0.5f,   1.0f, 1.0f, 0xffffffff, 0.0f, 0.0f },
		{ width - 0.5f, 0.0f - 0.5f,   1.0f, 1.0f, 0xffffffff, 1.0f, 0.0f },
		{ width - 0.5f, height - 0.5f, 1.0f, 1.0f, 0xffffffff, 1.0f, 1.0f },
		{ 0.0f - 0.5f,   height - 0.5f, 1.0f, 1.0f, 0xffffffff, 0.0f, 1.0f },
	};

	if ( FAILED( pD3D9Dev->CreateVertexBuffer( 4 * sizeof(CUSTOMVERTEX),
												0, D3DFVF_CUSTOMVERTEX,
												D3DPOOL_DEFAULT, &g_pVB, NULL ) ) )
	{
		return FALSE;
	}

	// Now we fill the vertex buffer. To do this, we need to Lock() the VB to
	// gain access to the vertices. This mechanism is required becuase vertex
	// buffers may be in device memory.
	VOID* pVertices;

	if (FAILED(g_pVB->Lock( 0, sizeof(vertices), (void**)&pVertices, 0)))
		return FALSE;

	memcpy( pVertices, vertices, sizeof(vertices) );
	g_pVB->Unlock();

	pD3D9Dev->CreateTexture(width, height, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_MANAGED, &PresentTexture, NULL);

	pD3D9Dev->SetRenderState(D3DRS_LIGHTING, FALSE);
	pD3D9Dev->SetRenderState(D3DRS_ZENABLE, TRUE);
	pD3D9Dev->SetVertexShader(NULL);
	pD3D9Dev->SetFVF( D3DFVF_CUSTOMVERTEX );

	pD3D9Dev->SetTexture (0, PresentTexture);
	pD3D9Dev->SetStreamSource( 0, g_pVB, 0, sizeof(CUSTOMVERTEX) );

	ActiveBuffer = new BufferInfo;
	ActiveBuffer->Width = width;
	ActiveBuffer->Height = height;
	ActiveBuffer->BytesPP = 4; // TODO

	return TRUE;
}

BufferInfo *Video::GetBufferInfo()
{
	D3DLOCKED_RECT Rect;
	PresentTexture->LockRect(0, &Rect, NULL, 0);

	ActiveBuffer->Pitch = Rect.Pitch;
	ActiveBuffer->Buffer = Rect.pBits;

	return ActiveBuffer;
}

void Video::ReleaseBuffer()
{
	PresentTexture->UnlockRect(0);
}

void Video::D3DRender()
{
	pD3D9Dev->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 0), 1.0f, 0);
	pD3D9Dev->Clear(0, NULL, D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 0, 0), 1.0f, 0);

	if ( SUCCEEDED( pD3D9Dev->BeginScene() ) )
	{
		pD3D9Dev->DrawPrimitive( D3DPT_TRIANGLEFAN, 0, 2 );
		pD3D9Dev->EndScene();
	}
	pD3D9Dev->Present(NULL, NULL, NULL, NULL);
}


UINT32 RGB1555(UINT16 x)
{
	UINT8 r = (x >> 0) & 0x1f;
	UINT8 g = (x >> 5) & 0x1f;
	UINT8 b = (x >> 10) & 0x1f;

	r = (r << 3) | (r >> 2);
	g = (g << 3) | (g >> 2);
	b = (b << 3) | (b >> 2);

	return (r << 16) | (g << 8) | (b << 0);
}

UINT32 BGR1555(UINT16 x)
{
	UINT8 r = (x >> 0) & 0x1f;
	UINT8 g = (x >> 5) & 0x1f;
	UINT8 b = (x >> 10) & 0x1f;

	r = (r << 3) | (r >> 2);
	g = (g << 3) | (g >> 2);
	b = (b << 3) | (b >> 2);

	return (b << 16) | (g << 8) | (r << 0);
}

void WriteBMP(UINT8 *buffer, int w, int h, int bytespp)
{
	FILE *bmp = fopen("out.bmp","wb");

	if (bmp == NULL)
		return;

	struct bmpinfo info;

	info.header = 0x4d42;
	info.filesize = 54 + (w * h * 4);
	info.pixoffsetet = 54;
	info.headerbytes = 40;
	info.px_width = w;
	info.px_height = -h;
	info.planes = 1;
	info.bpp = 32;
	info.bi_type = 0;
	info.rawsize = w * h * 3;
	info.hres = 0;
	info.vres = 0;
	info.numcols = 0;
	info.numimpcols = 0;

	fwrite(&info, sizeof(info), 1, bmp);

	if (bytespp == 2)
	{
		for (int y = 0; y < h; ++y)
		{
			for (int x = 0; x < w; ++x)
			{
				UINT16 srcpix = READ16_BE(buffer, (y * w + x) * 2);
				UINT32 dstpix = BGR1555(srcpix);
				fwrite(&dstpix, 4, 1, bmp);
			}
		}
	}
	else if (bytespp == 4)
	{
		for (int y = 0; y < h; ++y)
		{
			for (int x = 0; x < w; ++x)
			{
				UINT32 srcpix = READ32_BE(buffer, (y * w + x) * 4);
				fwrite(&srcpix, 4, 1, bmp);
			}
		}
	}

	fclose(bmp);
}
