#pragma once
#include "d3d9.h"

typedef struct
{
	INT32	Height;
	INT32	Width;
	INT32	Pitch;
	INT32	BytesPP;
	void *Buffer;
} BufferInfo;

class Video
{
private:
	struct CUSTOMVERTEX
	{
		FLOAT x, y, z, rhw;
		D3DCOLOR c;
		FLOAT u, v;
	};

	//Custom vertex format
#define D3DFVF_CUSTOMVERTEX		(D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1)

	IDirect3D9			*pD3D9;
	IDirect3DDevice9	*pD3D9Dev;

	LPDIRECT3DVERTEXBUFFER9 g_pVB;
	IDirect3DTexture9 *PresentTexture;

	BufferInfo *ActiveBuffer;

public:
	bool Initialise(int width, int height);
	void VideoUpdateRender();
	void D3DRender();
	BufferInfo *GetBufferInfo();
	void ReleaseBuffer();
};

#pragma pack(push, bitmap_data, 1)
struct bmpinfo
{
	UINT16	header;
	UINT32	filesize;
	UINT16	reserved1;
	UINT16	reserved2;
	UINT32	pixoffsetet;
	UINT32	headerbytes;
	INT32	px_width;
	INT32	px_height;
	UINT16	planes;
	UINT16	bpp;
	UINT32	bi_type;
	UINT32	rawsize;
	UINT32	hres;
	UINT32	vres;
	UINT32	numcols;
	UINT32	numimpcols;
};
#pragma pack(pop, bitmap_data, 1)

void WriteBMP(UINT8 *buffer, int w, int h, int bytespp);

#define VIDEO_UPDATE( NAME )	void NAME##_video_update(BufferInfo *BInfo)

typedef void (*VideoUpdateCB)(BufferInfo *BInfo);

UINT32 RGB1555(UINT16 x);
UINT32 BGR1555(UINT16 x);

#define BITMAP_ADDR16(y, x)		*((UINT16*)BInfo->Buffer + (y * BInfo->Pitch / BInfo->BytesPP) + x)
#define BITMAP_ADDR32(y, x)		*((UINT32*)BInfo->Buffer + (y * BInfo->Pitch / BInfo->BytesPP) + x)
