#pragma once

class EEPROM
{
private:
#define CMD_BUF_SIZE	32

	enum
	{
		READ,
		EWEN,
		ERASE,
		WRITE,
		ERAL,
		WRAL,
		EWDS,
	};

	enum eState
	{
		INSTRUCTION,
		INSTRUCTION_MATCHED,
		ADDRESS,
		GOT_ADDRESS,
		DATA,
		GOT_DATA,
		READ_DATA,
		STATUS,
		INVALID,
	} state;
	
	UINT32 cs;
	UINT32 di;
	UINT32 ck;
	UINT32 dO;

	bool write_enable;

	UINT32 bits_to_shift;
	UINT32 org;
	UINT32 status_delay;

	UINT32 address_in;
	UINT32 data_in;
	UINT32 size;
	UINT8 *data;
	UINT32 cmd_ptr;
	char cmd_buf[CMD_BUF_SIZE];

	bool inst_valid;
	bool cmd_matched;
	UINT32 matching_cmd;
	FileHandle file_handle;

	void ProcessData(UINT32 di);
	void ClockDataOut();
	void SetState(enum eState newstate);

	void UpdateCmdPtr()
	{
		cmd_ptr = (cmd_ptr + 1) % CMD_BUF_SIZE;
	}

public:
	void SetCS(UINT32 state);
	void SetDI(UINT32 state);
	void SetCK(UINT32 state);

	UINT32 GetDO();

	EEPROM(UINT32 size);
	~EEPROM();
	bool InitialiseEEPROM(const char *eeprom_file);
};
