/******************************************************************************

    log

    Error logging

******************************************************************************/

#include "M2x.h"
#include "log.h"
#include "stdio.h"
#include <string>
#include <comdef.h>

static HWND hEdit;

void InitErrorLog(HWND hWndParent)
{
	AllocConsole();

#if 0

	// TODO: At some point, use an edit box

	hEdit = CreateWindowEx(WS_EX_CLIENTEDGE, L"EDIT", L"Log",
		WS_POPUP | WS_VISIBLE | WS_CAPTION |
		ES_MULTILINE | ES_AUTOVSCROLL | ES_AUTOHSCROLL | ES_READONLY,
		255, 255, 100, 100, hWndParent, NULL, GetModuleHandle(NULL), NULL);

	if (hEdit == NULL)
		MessageBox(hWndParent, L"Could not create edit box.", L"Error", MB_OK | MB_ICONERROR);

	ShowWindow(hEdit, SW_SHOWNORMAL);
	UpdateWindow(hEdit);

#endif

}

void PrintErrorLog(ErrorLogColour col, char *fmt, ...)
{
	char buf[256];
	va_list args;
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);

	va_start(args, fmt);
	vsnprintf_s(buf, 256, 256, fmt, args);
	va_end(args);

	SetConsoleTextAttribute(hConsole, col);

	int lenA = lstrlenA(buf);
	int lenW;
	BSTR unicodestr;

	lenW = ::MultiByteToWideChar(CP_ACP, 0, buf, lenA, 0, 0);
	if (lenW > 0)
	{
		// Check whether conversion was successful
		unicodestr = ::SysAllocStringLen(0, lenW);
		MultiByteToWideChar(CP_ACP, 0, buf, lenA, unicodestr, lenW);

		WriteConsole(hConsole, unicodestr, lenW, NULL, NULL);
		SysFreeString(unicodestr);
	}
	else
	{
		// ERROR
	}
}

void CloseErrorLog()
{
	FreeConsole();
}
