/******************************************************************************

    romload

    ROM loading and verification

******************************************************************************/

#include "M2x.h"
#include "core.h"
#include "romload.h"


UINT32 ComputeCRC32(void *buffer, UINT32 size)
{
	return 0;
}

/*
	Load and validate a ROM file
*/
bool LoadROMFile(const ROMFile file_desc, void **buffer)
{
	FileHandle tmp;
	UINT8 *buf;
	char filepath[32];
	UINT64 size;

	sprintf(filepath, "roms\\%s", Core.GetActiveSetName());

	if (Core.FileMan->Open(filepath, file_desc.name, FILE_READ | FILE_OPEN_EXISTING, tmp) != FILE_OK)
	{
		ErrorBox("Could not open %s", file_desc.name);
		return false;
	}

	/* Verify the size */
	Core.FileMan->GetFileSize(tmp, size);

	if (file_desc.size != size)
	{
		ErrorBox("%s: Incorrect size\n(Found %d, expected %d)", file_desc.name, (UINT32)size, (UINT32)file_desc.size);
		return false;
	}

	/* Now read the file contents */
	buf = new UINT8[file_desc.size];
	
	if (Core.FileMan->Read(tmp, buf, file_desc.size) != FILE_OK)
	{
		ErrorBox("%s: Read error", file_desc.name);
		return false;
	}

	/* Validate the CRC-32 */
#if 0
	UINT32 crc32 = ComputeCRC32(buf, file_desc.size);

	if (crc32 != file_desc.crc32)
	{
		ErrorBox("%s: Incorrect CRC-32\n(Found 0x%.8x, expected 0x%.8x)", file_desc.name, crc32, file_desc.crc32);
		return false;
	}
#endif

	/* Validate the SHA-1 */
#pragma message(__FILE__": Add SHA-1?")

	Core.FileMan->Close(tmp);

	*(UINT8 **)(buffer) = buf;
	return true;
}