/******************************************************************************

    ymz280b.c

    YMZ280B 8-channel PCM/ADPCM decoder emulation

******************************************************************************/

#include "core.h"
#include "log.h"
#include "ymz280b.h"

YMZ280B::YMZ280B() : ReadExternalRAM(NULL), WriteExternalRAM(NULL)
{
	Reset();
}

void YMZ280B::Reset()
{
	memset(fn_regs.addr, 0, sizeof(fn_regs.addr));

	ch_reg = 0;
	dspen_reg = 0;
	dspdata_reg = 0;
	ramaddr_h_reg = 0;
	ramaddr_m_reg = 0;
	ramaddr_l_reg = 0;
	ramdata_reg = 0;
	irq_reg = 0;
	misc_reg = 0;

	status = 0;

	reg_addr = 0;
}

void YMZ280B::SetExternalReadHandler(UINT8 (*callback)(int))
{
	ReadExternalRAM = callback;
}

void YMZ280B::SetExternalWriteHandler(void (*callback)(int, UINT8))
{
	WriteExternalRAM = callback;
}

void YMZ280B::UpdateStream()
{

}

UINT8 YMZ280B::Read(int offset)
{
	if (offset == 0)
	{
		if (ReadExternalRAM)
		{
			UINT32 addr = (ramaddr_h_reg << 16) | (ramaddr_m_reg << 8) | ramaddr_l_reg;
			return ReadExternalRAM(addr);
		}
		else
			return 0xff;
	}
	else
	{
		UpdateStream();
		return status;
	}
}

void YMZ280B::Write(int offset, UINT8 data)
{
	if (offset == 0)
	{
		reg_addr = data;
	}
	else
	{
		UpdateStream();

		if (reg_addr < 0x80)
			fn_regs.addr[reg_addr] = data;
		else
		{
			switch (reg_addr)
			{
				case 0x80: ch_reg = data;			break;
				case 0x81: dspen_reg = data & 1;	break;
				case 0x82: dspdata_reg = data;		break;
				case 0x84: ramaddr_h_reg = data;	break;
				case 0x85: ramaddr_m_reg = data;	break;
				case 0x86: ramaddr_l_reg = data;	break;
				case 0x87:
				{
					ramdata_reg = data;
					if (WriteExternalRAM)
					{
						UINT32 addr = (ramaddr_h_reg << 16) | (ramaddr_h_reg << 8) | ramaddr_l_reg;
						WriteExternalRAM(addr, ramdata_reg);
					}
					break;
				}
				case 0xe0:	irq_reg = data;			break;
				case 0xff:	misc_reg = data;		break;
			}
		}
	}
}