#pragma once

#include "romload.h"

typedef struct _m2_game_info_
{
	const char	*setname;
	const char	*title;
	const char	*version;
	const char	*year;
	ROMFile		bios;
	ROMFile		ymz;
	ROMFile		eeprom;
	ROMFile		nvram;
	ROMFile		cd;
	int			flags;
} m2_game_info;

#define GAME_HAS_YMZ280B		(1 << 0)
#define GAME_HAS_TIMEKEEPER		(1 << 1)
#define GAME_HAS_8MB			(1 << 2)

// Main
extern UINT8 *RAM;
extern UINT32 RAM_SIZE_BYTES;
extern UINT32 RAM_SIZE_MASK;

void SetBDAInterrupt(int id);
void ClearBDAInterrupt(int id);
void SetCDEInterrupt(int id);

void ClearCDEStatus(int id);

// Atapi
