/******************************************************************************

    Timer

    Handling of emulation timing

******************************************************************************/

#include "timer.h"
#include "core.h"


Timer::Timer(emu_time time, UINT32 in_flags, bool active, void (*cb)()) :
			period(time),
			prev(NULL),
			next(NULL),
			callback(cb)
{
	if (active)
		flags = in_flags |= TIMER_ACTIVE;

	expiry_time = Core.GetEmulationTime() + time;
}

void ClearTimerList(Timer **list)
{
	while (*list)
	{
		Timer *temp = *list;
		*list = temp->next;
		delete temp;
	}
}

void InsertTimer(Timer **list, emu_time period, UINT32 flags, bool active, void (*callback)())
{
	Timer *new_timer = new Timer(period, flags, active, callback);
	Timer *last;

	/* Adding as the head? */
	if (*list == NULL)
	{
		*list = new_timer;
		return;
	}

	for (Timer *temp = *list; temp; temp = temp->next)
	{
		last = temp;
		if (new_timer->expiry_time <= temp->expiry_time)
		{
			/* Replacing the head? */
			if (temp->prev == NULL)
			{
				*list = new_timer;
				temp->prev = new_timer;
				new_timer->next = temp;
			}
			else
			{
				new_timer->prev = temp->prev;
				new_timer->next = temp;
				temp->prev->next = new_timer;
			}
			return;
		}
	}

	/* Replacing the tail? */
	if (last->next == NULL)
	{
		last->next= new_timer;
		new_timer->prev = last;
	}
}

void RemoveTimer(Timer **list, Timer *timer)
{
	assert (timer != NULL);

	/* Deleting the head? */
	if (timer->prev == NULL)
	{
		*list = timer->next;

		if (timer->next)
			timer->next->prev = NULL;
	}
	else
	{
		timer->prev->next = timer->next;

		if (timer->next)
			timer->next->prev = timer->next;
	}

	delete timer;
	return;
}

