#pragma once
#include "M2x.h"

typedef double emu_time;

struct time_class
{
	/*
	int val;

	time_class &operator+(const time_class a, const time_class b)
	{
		time_class c;
		c->val = 33;
		return c;
	}
*/
};

#define TIMER_CALLBACK(name)	void name()

#define TIMER_ACTIVE		(1 << 0)
#define TIMER_PERIODIC		(1 << 1)
#define TIMER_ONESHOT		(1 << 2)

#define TIME_IN_NSEC(val)	((double)(val) / 1.0e9)
#define TIME_IN_USEC(val)	((double)(val) / 1.0e6)
#define TIME_IN_MSEC(val)	((double)(val) / 1.0e3)
#define TIME_IN_SEC(val)	((double)(val))

#define TIME_IN_HZ(val)		(1.0 / (double)(val))

struct Timer
{
	emu_time period;
	emu_time expiry_time;
	UINT32 flags;
	void (*callback)();
	struct Timer *prev;
	struct Timer *next;

	Timer(emu_time time, UINT32 flags, bool active, void (*cb)());
	Timer(){}
};

void InsertTimer(Timer **list, emu_time period, UINT32 flags, bool active, void (*callback)());
void RemoveTimer(Timer **list, Timer *timer);
void UpdateTimers(Timer **list, emu_time delta);
void ClearTimerList(Timer **list);
