unit cpu;

interface

  procedure CpuReset;
  function CpuRun : integer;


implementation

  uses Def, Decoder, Srcdst;

  type Proc1 = procedure;


  procedure CpuReset;
  begin
    procptr := nil;
    RTT_flag := false;
    WAIT_flag := false;
    STEP_flag := false;
    RESET_flag := true;
    HALT_flag := false;
    HALT_i := false;
    EVNT_i := false;
    VIRQ_C0 := false;
    VIRQ_C4 := false;
    VIRQ_C8 := false;
{ reset vector }
    ptrw(@reg[R7])^ := $F600;
    psw := $00E0;
  end {CpuReset};


{ execute a single instruction, returns the number of clock cycles }
  function CpuRun : integer;
  var
    vector: word;
  begin
    CpuRun := 1;
    if RESET_flag then
    begin
      CpuRun := 8;
      RESET_flag := false;
    end {if};

{ pending hardware interrupt? }
    if HALT_flag or HALT_i or EVNT_i or VIRQ_C0 or VIRQ_C4 or VIRQ_C8 then
      WAIT_flag := false;
    if STEP_flag or ((psw and H_bit) <> 0) then
    begin
      HALT_flag := false;
      HALT_i := false;
    end {if};
    STEP_flag := false;
    if WAIT_flag then exit;

{ handle the interrupts }
    if HALT_flag then
    begin
      vector := $0004;
      HALT_flag := false;
    end
    else if HALT_i then
    begin
      vector := $E002;
      HALT_i := false;
    end
    else if EVNT_i and ((psw and I_bit) = 0) then
    begin
      vector := $0040;
      EVNT_i := false;
    end
    else if VIRQ_C0 and ((psw and I_bit) = 0) then
    begin
      vector := $00C0;
      VIRQ_C0 := false;
    end
    else if VIRQ_C4 and ((psw and I_bit) = 0) then
    begin
      vector := $00C4;
      VIRQ_C4 := false;
    end
    else if VIRQ_C8 and ((psw and I_bit) = 0) then
    begin
      vector := $00C8;
      VIRQ_C8 := false;
    end
    else

{ execute the instruction }
    begin
      opt := WORDSIZE;
      GetLoc ($17);
      code := ptrw(SrcPtr)^;		{ instruction pointed to by the PC }
      vector := Make_DC0;
      ptrw(@reg[R7])^ := ptrw(@reg[R7])^ and $FFFE;
{ complete an optional I/O device write }
      if procptr <> nil then
      begin
        Proc1(procptr);
        procptr := nil;
      end {if};
{ trace mode? }
      if ((psw and T_bit) <> 0) and (vector = 0) and not RTT_flag then
	vector := $000C;
    end {if};

{ execute an optional trap }
    if vector <> 0 then
    begin
      opt := WORDSIZE;
      GetLoc ($26);				{ SP <- SP-2 }
      loc := loc and $FFFE;
      ptrw(DstPtr)^ := psw;			{ (SP) <- PSW }
      GetLoc ($26);				{ SP <- SP-2 }
      ptrw(DstPtr)^ := ptrw(@reg[R7])^;		{ (SP) <- PC }
      loc := vector and $FFFE;
      ptrw(@reg[R7])^ := ptrw(SrcPtr)^ and $FFFE; { PC <- (vector) }
      Inc (loc, 2);
      psw := ptrw(SrcPtr)^;			{ PSW <- (vector+2) }
    end {if};

    RTT_flag := false;
  end {CpuRun};

end.
