{ System controller KA1835VG5 }

unit SysCon;

interface

  var sysreg1, sysreg2: word;	{ RG1, RG2 }

  procedure SysConInit;
  procedure SysConClose;
  function WrRam (address: word) : boolean;
  function RdRam (address: word) : boolean;
  function RdRom (address: word) : boolean;

implementation

uses Def;

const split: array [0..7] of word = ( $E000, $4000, $8000, $2000, 0, 0, 0, 0 );

procedure SysConInit;
begin
  sysreg1 := 0;
  sysreg2 := 0;
end {SysConInit};


procedure SysConClose;
begin
end {SysConClose};


function WrRam (address: word) : boolean;
begin
  WrRam :=
	(address < split[(sysreg1 shr 9) and 3])
	or
	( (address >= $E800) and (address < $EC00) );
end {WrRam};


function RdRam (address: word) : boolean;
var
  i: word;
begin
  i := (sysreg1 shr 11) and 7;
  RdRam :=
	( integer(cardinal(address)) < integer(cardinal(split[i and 3])) )
	or
	( (address >= $E800) and (address < $EC00) );
end {RdRam};


function RdRom (address: word) : boolean;
begin
  RdRom := ((sysreg2 and $2000) = 0) and
  (
	( (address >= split[(sysreg1 shr 11) and 7]) and (address < $E000) )
	or
	( ((sysreg2 and $0200) <> 0) and
		(address >= $E000) and (address < $E800) )
	or
	( (address >= $EC00) and (address < $FE00) )
  );
end {RdRom};


end.
