/* CCoreAlt.c */
/* Frontend to the Cray EL92 Emulator Core */
/* This version is meant for simple compiling, until some extra makefiles are put up */
/* To compile CrayCore with Digital mars, use the command 'dmc ccorealt.c' */
/* Should be similarly simple for most other compilers */
/* Version .1 */

/* History: */
/* .1: First version put online, displays register contents, takes input in Octal */


/* Copyright (c) 2004 Clinton Dalrymple
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */



/* This code makes certain presumptions, namely that a Char is 8 bits, and Doubles 64 bits */
/* This should work out for most platforms */


/* This program, will most likely run POORLY on a 32-bit system, and then there is */
/* the added question of performance on a system without fully usable native vector ability */


/* Interrupts have not yet been implemented, and will take a while before they are done */


/* The Version intended to be emulated is a CRAY EL-92, Model 100 */
/* This machine had 1 CPU, 32MW Memory, 64-bit Words, 6GB Disks, and no Hippi */
/* It also had a 110 Volt AC power, it was intended to be a 'Deskside Cray' */
/* The Cpu ran at 33Mhz, and so did the memory */
/* There was no Virtual Memory, or at least not as most people know it. */
/* Also, Division abilities in hardware are rather... lacking. */

/* Paralell support may be in the future, the Long, Distant future */
/* For now, I am not even going to consider adding any form of multiple CPU support */


#include <stdio.h>
#include "CCore.h"
#include "CpuExec.c"

/* On a more C99 compliant compiler, uncommenting 'inline' should give a boost, should need to add 'inline' in CpuExecute.c */
/* inline */  void CpuExecute(void);

/* For Testing */
int opcode, wantquit;

/* The reason opcode is not sent as an arg is that in the future, I believe I will send cycles to be executed as an arg, */
/* and wish to avoid pointless recoding, where I can. */

int main()
{
	while(!wantquit)
	{
		printf("\n\nScalar:");
		printf("\nS0: %d S1: %d S2: %d S3: %d S4: %d S5: %d S6: %d S7: %d", S0, S1, S2, S3, S4, S5, S6, S7);
		printf("\n\nScalar Support:");
		printf("\nT0: %d T1: %d T2: %d T3: %d T4: %d T5: %d T6: %d T7: %d", T0, T1, T2, T3, T4, T5, T6, T7);
		printf("\nT8: %d T9: %d T10: %d T11: %d T12: %d T13: %d T14: %d T15: %d", T8, T9, T10, T11, T12, T13, T14, T15);
		printf("\nT16: %d T17: %d T18: %d T19: %d T20: %d T21: %d T22: %d T23: %d", T16, T17, T18, T19, T20, T21, T22, T23);
		printf("\nT24: %d T25: %d T26: %d T27: %d T28: %d T29: %d T30: %d T31: %d", T24, T25, T26, T27, T28, T29, T30, T31);
		printf("\nT32: %d T33: %d T34: %d T35: %d T36: %d T37: %d T38: %d T39: %d", T32, T33, T34, T35, T36, T37, T38, T39);
		printf("\nT40: %d T41: %d T42: %d T43: %d T44: %d T45: %d T46: %d T47: %d", T40, T41, T42, T43, T44, T45, T46, T47);
		printf("\nT48: %d T49: %d T50: %d T51: %d T52: %d T53: %d T54: %d T55: %d", T48, T49, T50, T51, T52, T53, T54, T55);
		printf("\nT56: %d T57: %d T58: %d T59: %d T60: %d T61: %d T62: %d T63: %d", T56, T57, T58, T59, T60, T61, T62, T63);
		printf("\n\nAddress:");
		printf("\nA0: %d A1: %d A2: %d A3: %d A4: %d A5: %d A6: %d A7: %d", A0, A1, A2, A3, A4, A5, A6, A7);
		printf("\n\nAddress Support:");
		printf("\nB0: %d B1: %d B2: %d B3: %d B4: %d B5: %d B6: %d B7: %d", B0, B1, B2, B3, B4, B5, B6, B7);
		printf("\nB8: %d B9: %d B10: %d B11: %d B12: %d B13: %d B14: %d B15: %d", B8, B9, B10, B11, B12, B13, B14, B15);
		printf("\nB16: %d B17: %d B18: %d B19: %d B20: %d B21: %d B22: %d B23: %d", B16, B17, B18, B19, B20, B21, B22, B23);
		printf("\nB24: %d B25: %d B26: %d B27: %d B28: %d B29: %d B30: %d B31: %d", B24, B25, B26, B27, B28, B29, B30, B31);
		printf("\nB32: %d B33: %d B34: %d B35: %d B36: %d B37: %d B38: %d B39: %d", B32, B33, B34, B35, B36, B37, B38, B39);
		printf("\nB40: %d B41: %d B42: %d B43: %d B44: %d B45: %d B46: %d B47: %d", B40, B41, B42, B43, B44, B45, B46, B47);
		printf("\nB48: %d B49: %d B50: %d B51: %d B52: %d B53: %d B54: %d B55: %d", B48, B49, B50, B51, B52, B53, B54, B55);
		printf("\nB56: %d B57: %d B58: %d B59: %d B60: %d B61: %d B62: %d B63: %d", B56, B57, B58, B59, B60, B61, B62, B63);
		printf("\n\nSupport Registers:");
		printf("\nBA: %d CA: %d CE: %d CI: %d CL: %d CLN: %d EA: %d F: %d II: %d", BA, CA, CE, CI, CL, CLN, EA, F, II);
		printf("\nLA: %d MC: %d P: %d PC: %d RT: %d SR %d VL: %d VM: %d XA: %d", LA, MC, P, PC, RT, SR, VL, VM, XA);
		printf("\n\nShared Scalar//Address:");
		printf("\nST0: %d ST1: %d ST2: %d ST3: %d ST4: %d ST5: %d ST6: %d ST7: %d", ST0, ST1, ST2, ST3, ST4, ST5, ST6, ST7);
		printf("\nSB0: %d SB1: %d SB2: %d SB3: %d SB4: %d SB5: %d SB6: %d SB7: %d", SB0, SB1, SB2, SB3, SB4, SB5, SB6, SB7);
		printf("\n\nSemaphores:");
		printf("\nSM0: %d SM1: %d SM2: %d SM3: %d SM4: %d SM5: %d SM6: %d SM7: %d", SM0, SM1, SM2, SM3, SM4, SM5, SM6, SM7);
		printf("\nSM8: %d SM9: %d SM10: %d SM11: %d SM12: %d SM13: %d SM14: %d SM15: %d", SM8, SM9, SM10, SM11, SM12, SM13, SM14, SM15);
		printf("\nSM16: %d SM17: %d SM18: %d SM19: %d SM20: %d SM21: %d SM22: %d SM23: %d", SM16, SM17, SM18, SM19, SM20, SM21, SM22, SM23);
		printf("\nSM24: %d SM25: %d SM26: %d SM27: %d SM28: %d SM29: %d SM30: %d SM31: %d", SM24, SM25, SM26, SM27, SM28, SM29, SM30, SM31);
		printf("\nOpcode: ");
		scanf("%o", &opcode);
		fflush(stdin);
		CpuExecute();
	}
	return 0;
}
