/* CCore.h */
/* Version .1 */


/* Copyright (c) 2004 Clinton Dalrymple
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */


/* Defines */
/* Define CWORD for 64-bit integers, this will make the code more easily portable */
/* CHWORD needs to be a 32-bit integer, I am using this define to make porting easier, */
/* as I do plan to have this running on 64-bit platforms some day. */
/* NAT stands for Natural Size of Integer, on x86, this is 32 bit */
#define CWORD __int64
#define CHWORD int

/* Seclare the Memory, should add up to 32MW */
/* Note that this is still 256 MB of memory, and should be taken into consideration */
/* 16, 8, or even 4 MW configurations could be used early on, as it is unlikely that this */
/* emulator will be running Unicos for a long time, if ever, I find it more likely that if */
/* this emulator is finished, I will end up having to port NetBSD to it, as Cray seems */
/* unlikely to do any form of hobbyist licence, even though others such as DEC have done so */

/* Memory is disabled in this version */
/* extern unsigned CWORD *memory;
memory = (unsigned CWORD *)malloc(33554432); */

/* Declare the Instruction Buffers */
/* These need to be 32-word */
/* According to one source, there should be only four of these */
/* Not sure on names, so... */

/* Instruction buffers are disabled in this version */
/* extern unsigned CWORD *IB0;
extern unsigned CWORD *IB1;
extern unsigned CWORD *IB2;
extern unsigned CWORD *IB3;
extern unsigned CWORD *IB4;
extern unsigned CWORD *IB5;
extern unsigned CWORD *IB6;
extern unsigned CWORD *IB7;
IB0 = (unsigned CWORD *)malloc(32);
IB1 = (unsigned CWORD *)malloc(32);
IB2 = (unsigned CWORD *)malloc(32);
IB3 = (unsigned CWORD *)malloc(32);
IB3 = (unsigned CWORD *)malloc(32);
IB4 = (unsigned CWORD *)malloc(32);
IB5 = (unsigned CWORD *)malloc(32);
IB6 = (unsigned CWORD *)malloc(32);
IB7 = (unsigned CWORD *)malloc(32); */


/* TODO: Set up MC, P, SR, VL special size registers properly */

/* Registers */
/* Not entirely sure on names, were guessed from looking at the block diagram at Cray Cyber */
/* Currently to be found at: http://static.cray-cyber.org/Others/crayymp_blockdia.jpg */


/* Declare the Vector Registers */
/* These will most likely be Incredibly Slow on x86 computers */
/* A good line of thought for later use would be to possibly use MMX/SSE to give */
/* as much of a boost as possible, even a 1% boost is still a boost */
/* These need to be 64 bit, with 64 elements */
/* Not sure if these work right on platforms where double != 64 bits */
double V0[64];
double V1[64];
double V2[64];
double V3[64];
double V4[64];
double V5[64];
double V6[64];
double V7[64];

/* Extra Support Registers and junk */
unsigned CHWORD BA; /* Base Address */
unsigned CHWORD CA; /* Channel Address */
unsigned CHWORD CE; /* Channel Error */
unsigned CHWORD CI; /* Channel Interrupt */
unsigned CHWORD CL; /* Channel Limit register */
CHWORD CLN;
unsigned CHWORD EA; /* Exchange Address */
CWORD F; /* Flag register */
unsigned CHWORD II; /* Interrupt Interval Register, 32 bits */
unsigned CHWORD LA; /* Limit Address */
unsigned int MC; /* Master Clear register, may be just 1 bit */
unsigned int P; /* Program Register, supposed to be 24 bits */
unsigned CHWORD PC; /* Program Counter */
unsigned CWORD RT; /* Real Time clock */
CWORD SR; /* Status Register, may be just 1 bit (not entirely sure, though) */
unsigned int VL; /* Vector Length , supposed to be 7 bit, hopefully works as an int */
unsigned CWORD VM; /* Vector Mask */
unsigned char XA; /* Exchange Address */


/* Declare the Scalar Registers */
/* these are 64 bit */
/* Not sure which data type is best yet, I am starting to consider doubles, for testing */
CWORD S0;
CWORD S1;
CWORD S2;
CWORD S3;
CWORD S4;
CWORD S5;
CWORD S6;
CWORD S7;

/* Declare the Intermediate Scalar Support Registers */
/* There are 64 of these, 64 bits each */
/* May or may not be this many in the particular CPU I with to emulate */
/* This is the Tjk, often referred to in Octal */
CWORD T0;
CWORD T1;
CWORD T2;
CWORD T3;
CWORD T4;
CWORD T5;
CWORD T6;
CWORD T7;
CWORD T8;
CWORD T9;
CWORD T10;
CWORD T11;
CWORD T12;
CWORD T13;
CWORD T14;
CWORD T15;
CWORD T16;
CWORD T17;
CWORD T18;
CWORD T19;
CWORD T20;
CWORD T21;
CWORD T22;
CWORD T23;
CWORD T24;
CWORD T25;
CWORD T26;
CWORD T27;
CWORD T28;
CWORD T29;
CWORD T30;
CWORD T31;
CWORD T32;
CWORD T33;
CWORD T34;
CWORD T35;
CWORD T36;
CWORD T37;
CWORD T38;
CWORD T39;
CWORD T40;
CWORD T41;
CWORD T42;
CWORD T43;
CWORD T44;
CWORD T45;
CWORD T46;
CWORD T47;
CWORD T48;
CWORD T49;
CWORD T50;
CWORD T51;
CWORD T52;
CWORD T53;
CWORD T54;
CWORD T55;
CWORD T56;
CWORD T57;
CWORD T58;
CWORD T59;
CWORD T60;
CWORD T61;
CWORD T62;
CWORD T63;

/* Declare the Address Registers */
/* These are 32-bit */
/* Made these signed, not entirely sure if correct */
CHWORD A0;
CHWORD A1;
CHWORD A2;
CHWORD A3;
CHWORD A4;
CHWORD A5;
CHWORD A6;
CHWORD A7;

/* Address Temporary Registers, should be 64 of these */
/* I am currently making these 32 bit, signed, on the premise that they are copies of */
/* the 'regular' Address Registers */
/* These are sometimes referred to as the Bjk, using octal, thus B77 == B63 */
CHWORD B0;
CHWORD B1;
CHWORD B2;
CHWORD B3;
CHWORD B4;
CHWORD B5;
CHWORD B6;
CHWORD B7;
CHWORD B8;
CHWORD B9;
CHWORD B10;
CHWORD B11;
CHWORD B12;
CHWORD B13;
CHWORD B14;
CHWORD B15;
CHWORD B16;
CHWORD B17;
CHWORD B18;
CHWORD B19;
CHWORD B20;
CHWORD B21;
CHWORD B22;
CHWORD B23;
CHWORD B24;
CHWORD B25;
CHWORD B26;
CHWORD B27;
CHWORD B28;
CHWORD B29;
CHWORD B30;
CHWORD B31;
CHWORD B32;
CHWORD B33;
CHWORD B34;
CHWORD B35;
CHWORD B36;
CHWORD B37;
CHWORD B38;
CHWORD B39;
CHWORD B40;
CHWORD B41;
CHWORD B42;
CHWORD B43;
CHWORD B44;
CHWORD B45;
CHWORD B46;
CHWORD B47;
CHWORD B48;
CHWORD B49;
CHWORD B50;
CHWORD B51;
CHWORD B52;
CHWORD B53;
CHWORD B54;
CHWORD B55;
CHWORD B56;
CHWORD B57;
CHWORD B58;
CHWORD B59;
CHWORD B60;
CHWORD B61;
CHWORD B62;
CHWORD B63;


/* Shared Address Registers */
CHWORD SB0;
CHWORD SB1;
CHWORD SB2;
CHWORD SB3;
CHWORD SB4;
CHWORD SB5;
CHWORD SB6;
CHWORD SB7;

/* Semaphore Registers */
CHWORD SM0;
CHWORD SM1;
CHWORD SM2;
CHWORD SM3;
CHWORD SM4;
CHWORD SM5;
CHWORD SM6;
CHWORD SM7;
CHWORD SM8;
CHWORD SM9;
CHWORD SM10;
CHWORD SM11;
CHWORD SM12;
CHWORD SM13;
CHWORD SM14;
CHWORD SM15;
CHWORD SM16;
CHWORD SM17;
CHWORD SM18;
CHWORD SM19;
CHWORD SM20;
CHWORD SM21;
CHWORD SM22;
CHWORD SM23;
CHWORD SM24;
CHWORD SM25;
CHWORD SM26;
CHWORD SM27;
CHWORD SM28;
CHWORD SM29;
CHWORD SM30;
CHWORD SM31;

/* Shared Scalar Registers */
CWORD ST0;
CWORD ST1;
CWORD ST2;
CWORD ST3;
CWORD ST4;
CWORD ST5;
CWORD ST6;
CWORD ST7;
