#include <stdio.h>
#include "CCore.h"


/* Copyright (c) 2004 Clinton Dalrymple
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */


/* FOR TESTING */
extern int opcode, wantquit;

/* On instruction types: */
/* 000-004: Special */
/* 005-017: Branch */
/* 02x, 030-033: A Register */
/* 034-037: B/T Memory */
/* 040-043, 071-077: S Register */
/* 044-061: Scalar Integer */
/* 062-070: Scalar Floating Point */
/* 10x-13x: Scalar Memory */
/* 140-177: Vector */


/* Moving Values from A<->B, or S<->T only takes 1 clock cycle */
/* Much more data on instruction timings needs to be found */
/* I despirately hope it is not still protected information */


/* Notes on Monitor Mode: no Monitor Mode support of any kind is yet implemented. */
/* All opcodes are ran whether in Monitor Mode or not. */



/* More info on the x0 thing: */
/* Written by Dik T. Winter, on Comp.Arch, on 24-10-1991, in thread */
/* "Supercomputer Information Anyone?" */
/* But if you use standard compilers with a bit of assembler you can only use
   a small subset of the T and B registers.  And the T and B register sets do
   not allow indexing.  And A0 and S0 can not be used the same way as the others.
   On the other hand, if you do not need the V (vector) registers for vector
   operations you can use them for scratch, and they *do* allow indexing.
   So you have in effect 8 array's of 64 elements as registers. */


/* inline int CpuExecute(int cycles) */
/* inline */ extern void CpuExecute(void)
{
	/* NAT cycle_count = cycles; */
	/* while (cycle_count > 0) */
	{
		/* Opcode Table */
		/* Note that these are ordered more by type than numerical value */
		/* These are in Octal. */
		/* There are many errors here in opcode names, once again, much more research needed */
		/* switch (memory[PC++]) */
		switch(opcode)
		{
		case 000000:
			/* CAL ERR */
			/* Error Exit */
			/* FOR TESTING: */
			wantquit=1;
			break;
		case 001000:
			/* CAL PASS */
			/* Pass instruction */
			break;
		case 001101:
			/* CAL CL,Aj,Ak */
			/* CAL CL A0,A1 */
			/* Sets CL register for channel specified by Aj, to address specified by Ak */
			break;
		case 001102:
			break;
		case 001103:
			break;
		case 001104:
			break;
		case 001105:
			break;
		case 001106:
			break;
		case 001107:
			break;
		case 001111:
			break;
		case 001112:
			break;
		case 001113:
			break;
		case 001114:
			break;
		case 001115:
			break;
		case 001116:
			break;
		case 001117:
			break;
		case 001121:
			break;
		case 001122:
			break;
		case 001123:
			break;
		case 001124:
			break;
		case 001125:
			break;
		case 001126:
			break;
		case 001127:
			break;
		case 001131:
			break;
		case 001132:
			break;
		case 001133:
			break;
		case 001134:
			break;
		case 001135:
			break;
		case 001136:
			break;
		case 001137:
			break;
		case 001141:
			break;
		case 001142:
			break;
		case 001143:
			break;
		case 001144:
			break;
		case 001145:
			break;
		case 001146:
			break;
		case 001147:
			break;
		case 001151:
			break;
		case 001152:
			break;
		case 001153:
			break;
		case 001154:
			break;
		case 001155:
			break;
		case 001156:
			break;
		case 001157:
			break;
		case 001161:
			break;
		case 001162:
			break;
		case 001163:
			break;
		case 001164:
			break;
		case 001165:
			break;
		case 001166:
			break;
		case 001167:
			break;
		case 001171:
			break;
		case 001172:
			break;
		case 001173:
			break;
		case 001174:
			break;
		case 001175:
			break;
		case 001176:
			break;
		case 001177:
			break;
		case 001200:
			/* CAL CI, A0 */
			/* CAL CI, Aj */
			/* Clears interrupt flag and error flag for channel specified by Aj */
			break;
		case 001210:
			/* CAL CI, A1 */
			break;
		case 001220:
			/* CAL CI, A2 */
			break;
		case 001230:
			/* CAL CI, A3 */
			break;
		case 001240:
			/* CAL CI, A4 */
			break;
		case 001250:
			/* CAL CI, A5 */
			break;
		case 001260:
			/* CAL CI, A6 */
			break;
		case 001270:
			/* CAL CI, A7 */
			break;
		case 001201:
			/* CAL MC, A0 */
			/* CAL MC, Aj */
			/* Opcode 0012j1 */
			/* Clears interrupt and error flags for channel indicated by Aj. */
			/* If Aj represents an output channel, sets device master clear. */
			/* If Aj represents an input channel, clears device ready-held */
			break;
		case 001211:
			/* CAL MC, A1 */
			break;
		case 001221:
			/* CAL MC, A2 */
			break;
		case 001231:
			/* CAL MC, A3 */
			break;
		case 001241:
			/* CAL MC, A4 */
			break;
		case 001251:
			/* CAL MC, A5 */
			break;
		case 001261:
			/* CAL MC, A6 */
			break;
		case 001271:
			/* CAL MC, A7 */
			break;
		case 001300:
			/* CAL XA, A0 */
			/* CAL XA, Aj */
			/* Enters XA register with Aj*/
			XA = A0;
			break;
		case 001310:
			/* CAL XA, A1 */
			XA = A1;
			break;
		case 001320:
			/* CAL XA, A2 */
			XA = A2;
			break;
		case 001330:
			/* CAL XA, A3 */
			XA = A3;
			break;
		case 001340:
			/* CAL XA, A4 */
			XA = A4;
			break;
		case 001350:
			/* CAL XA, A5 */
			XA = A5;
			break;
		case 001360:
			/* CAL XA, A6 */
			XA = A6;
			break;
		case 001370:
			/* CAL XA, A7 */
			XA = A7;
			break;
		case 001400:
			/* CAL RT, S0 */
			/* CAL RT, Sj */
			/* Transmits Sj to RTC */
			/* RTC bits 0-63 are forced to 0's if j=0 */
			RT = 0;
			break;
		case 001410:
			/* CAL RT, S1 */
			RT = S1;
			break;
		case 001420:
			/* CAL RT, S2 */
			RT = S2;
			break;
		case 001430:
			/* CAL RT, S3 */
			RT = S3;
			break;
		case 001440:
			/* CAL RT, S4 */
			RT = S4;
			break;
		case 001450:
			/* CAL RT, S5 */
			RT = S5;
			break;
		case 001460:
			/* CAL RT, S6 */
			RT = S6;
			break;
		case 001470:
			/* CAL RT, S7 */
			RT = S7;
			break;
		case 001401:
			/* CAL SIPI */
			/* Sets interprocessor interrupt request of CPU 0 */
			break;
		case 001402:
			/* CAL CIPI */
			/* Clears Interprocessor Interrupt */
			break;
		case 001403:
			/* CAL */
			/* Clears CLN register */
			break;
		case 001413:
			/* CAL CLN A1 */
			/* Puts A1 into CLN */
			break;
		case 001423:
			/* CAL CLN A2 */
			break;
		case 001433:
			/* CAL CLN A3 */
			break;
		case 001443:
			/* CAL CLN A4 */
			break;
		case 001453:
			/* CAL CLN A5 */
			break;
		case 001463:
			/* CAL CLN A6 */
			break;
		case 001473:
			/* CAL CLN A7 */
			break;
		case 001404:
			/* CAL PCI S0 */
			/* CAL PCI Sj */
			/* Loads Interrupt Interval (II) register with Sj */
			II = S0;
			break;
		case 001414:
			/* CAL PCI S1 */
			II = S1;
			break;
		case 001424:
			/* CAL PCI S2 */
			II = S2;
			break;
		case 001434:
			/* CAL PCI S3 */
			II = S3;
			break;
		case 001444:
			/* CAL PCI S4 */
			II = S4;
			break;
		case 001454:
			/* CAL PCI S5 */
			II = S5;
			break;
		case 001464:
			/* CAL PCI S6 */
			II = S6;
			break;
		case 001474:
			/* CAL PCI S7 */
			II = S7;
			break;
		case 001405:
			/* CAL CCI */
			/* Clear Clock Interrupt */
			break;
		case 001406:
			/* CAL ECI */
			/* Enables programmable clock interrupt */
			break;
		case 001407:
			/* CAL DCI */
			/* Disables programmable clock interrupt */
			break;
		case 001500:
			/* Clears all performance monitor counters */
			break;
		case 001501:
			/* Disables port A error correction */
			break;
		case 001511:
			/* Disables port B error correction */
			break;
		case 001521:
			/* Disables port D error correction */
			break;
		case 001531:
			/* Enables T register data to be routed through port D error correction, */
			/* instead of port B */
			break;
		case 001541:
			/* Enables replacement of check byte with data on Ports C and D writes, */
			/* and replacement of data with check bytes on Ports A, B, and D reads */
			break;
		case 001551:
			/* Enables replacement of check byte with Vk data on port C during execution of 1771jk */
		case 002000:
			/* CAL VL 1 */
			/* Enters 1 into VL */
			VL = 1;
			break;
		case 002001:
			/* CAL VL A1 */
			/* CAL VL Ak */
			/* Transmits Ak to VL */
			VL = A1;
			break;
		case 002002:
			/* CAL VL A2 */
			VL = A2;
			break;
		case 002003:
			/* CAL VL A3 */
			VL = A3;
			break;
		case 002004:
			/* CAL VL A4 */
			VL = A4;
			break;
		case 002005:
			/* CAL VL A5 */
			VL = A5;
			break;
		case 002006:
			/* CAL VL A6 */
			VL = A6;
			break;
		case 002007:
			/* CAL VL A7 */
			VL = A7;
			break;
		case 002100:
			/* CAL EFI */
			/* Enables interrupt on floating point error */
			break;
		case 002200:
			/* CAL DFI */
			/* Disables interrupt on floating point error */
			break;
		case 002300:
			/* CAL ERI */
			/* Enables interrupt on operand range error */
			break;
		case 002400:
			/* CAL DRI */
			/* Disables interrupt on operand range error */
			break;
		case 002500:
			/* CAL DBM */
			/* Disables bidirectional memory transfers */
			break;
		case 002600:
			/* CAL EBM */
			/* Enables bidirectional memory transfers */
			break;
		case 002700:
			/* CAL CMR */
			/* Completes memory references */
			break;
		case 003000:
			/* CAL VM 0 */
			/* Enters 0 into VM */
			VM = 0;
			break;
		case 003010:
			/* CAL VM S0 */
			/* CAL VM Si */
			/* 0030j0 */
			/* If register A0 or S0 is in the h, j, or k field, the value of the register */
			/* is ignored, instead, a special operand is issued */
			/* Transmits Sj to VM register */
			VM = S1;
			break;
		case 003020:
			/* CAL VM S1 */
			VM = S2;
			break;
		case 003030:
			/* CAL VM S2 */
			VM = S3;
			break;
		case 003040:
			/* CAL VM S3 */
			VM = S4;
			break;
		case 003050:
			/* CAL VM S4 */
			VM = S5;
			break;
		case 003060:
			/* CAL VM S5 */
			VM = S6;
			break;
		case 003070:
			/* CAL VM S6 */
			VM = S7;
			break;
		case 004000:
			/* CAL EX */
			/* Normal Exit */
			/* FOR TESTING: */
			wantquit = 1;
			break;
		case 023000:
			/* CAL Ai Sj */
			/* Transmits Sj to Ai */
			A0 = S0;
			break;
		case 023010:
			A0 = S1;
			break;
		case 023020:
			A0 = S2;
			break;
		case 023030:
			A0 = S3;
			break;
		case 023040:
			A0 = S4;
			break;
		case 023050:
			A0 = S5;
			break;
		case 023060:
			A0 = S6;
			break;
		case 023070:
			A0 = S7;
			break;
		case 023100:
			A1 = S0;
			break;
		case 023110:
			/* CAL A1 S1 */
			A1 = S1;
			break;
		case 023120:
			A1 = S2;
			break;
		case 023130:
			A1 = S3;
			break;
		case 023140:
			A1 = S4;
			break;
		case 023150:
			A1 = S5;
			break;
		case 023160:
			A1 = S6;
			break;
		case 023170:
			A1 = S7;
			break;
		case 023200:
			A2 = S0;
			break;
		case 023210:
			/* CAL A2 S1 */
			A2 = S1;
			break;
		case 023220:
			A2 = S2;
			break;
		case 023230:
			A2 = S3;
			break;
		case 023240:
			A2 = S4;
			break;
		case 023250:
			A2 = S5;
			break;
		case 023260:
			A2 = S6;
			break;
		case 023270:
			A2 = S7;
			break;
		case 023300:
			A3 = S0;
			break;
		case 023310:
			A3 = S1;
			break;
		case 023320:
			A3 = S2;
			break;
		case 023330:
			A3 = S3;
			break;
		case 023340:
			A3 = S4;
			break;
		case 023350:
			A3 = S5;
			break;
		case 023360:
			A3 = S6;
			break;
		case 023370:
			A3 = S7;
			break;
		case 023400:
			A4 = S0;
			break;
		case 023410:
			A4 = S1;
			break;
		case 023420:
			A4 = S2;
			break;
		case 023430:
			A4 = S3;
			break;
		case 023440:
			A4 = S4;
			break;
		case 023450:
			A4 = S5;
			break;
		case 023460:
			A4 = S6;
			break;
		case 023470:
			A4 = S7;
			break;
		case 023500:
			A5 = S0;
			break;
		case 023510:
			A5 = S1;
			break;
		case 023520:
			A5 = S2;
			break;
		case 023530:
			A5 = S3;
			break;
		case 023540:
			A5 = S4;
			break;
		case 023550:
			A5 = S5;
			break;
		case 023560:
			A5 = S6;
			break;
		case 023570:
			A5 = S7;
			break;
		case 023600:
			A6 = S0;
			break;
		case 023610:
			A6 = S1;
			break;
		case 023620:
			A6 = S2;
			break;
		case 023630:
			A6 = S3;
			break;
		case 023640:
			A6 = S4;
			break;
		case 023650:
			A6 = S5;
			break;
		case 023660:
			A6 = S6;
			break;
		case 023670:
			A6 = S7;
			break;
		case 023700:
			A7 = S0;
			break;
		case 023710:
			A7 = S1;
			break;
		case 023720:
			A7 = S2;
			break;
		case 023730:
			A7 = S3;
			break;
		case 023740:
			A7 = S4;
			break;
		case 023750:
			A7 = S5;
			break;
		case 023760:
			A7 = S6;
			break;
		case 023770:
			A7 = S7;
			break;
		case 023001:
			/* CAL A0 VL */
			/* CAL Ai Vl */
			/* Transmits VL to Ai */
			A0 = VL;
			break;
		case 023101:
			/* CAL A1 VL */
			A1 = VL;
			break;
		case 023201:
			/* CAL A2 VL */
			A2 = VL;
			break;
		case 023301:
			/* CAL A3 VL */
			A3 = VL;
			break;
		case 023401:
			/* CAL A4 VL */
			A4 = VL;
			break;
		case 023501:
			/* CAL A5 VL */
			A5 = VL;
			break;
		case 023601:
			/* CAL A6 VL */
			A6 = VL;
			break;
		case 023701:
			/* CAL A7 VL */
			A7 = VL;
			break;
		case 024000:
			/* CAL B00 A0 */
			/* CAL Bjk Ai */
			/* Transmits Bjk to Ai */
			A0 = B0;
			break;
		case 024001:
			/* CAL B01 A0 */
			A0 = B1;
			break;
		case 024002:
			/* CAL B02 A0 */
			A0 = B2;
			break;
		case 024003:
			/* CAL B03 A0 */
			A0 = B3;
			break;
		case 024004:
			/* CAL B04 A0 */
			A0 = B4;
			break;
		case 024005:
			/* CAL B05 A0 */
			A0 = B5;
			break;
		case 024006:
			/* CAL B06 A0 */
			A0 = B6;
			break;
		case 024007:
			/* CAL B07 A0 */
			A0 = B7;
			break;
		case 024010:
			/* CAL B08 A0 */
			A0 = B8;
			break;
		case 024011:
			/* CAL B09 A0 */
			A0 = B9;
			break;
		case 024012:
			/* CAL B10 A0 */
			A0 = B10;
			break;
		case 024013:
			/* CAL B11 A0 */
			A0 = B11;
			break;
		case 024014:
			/* CAL B12 A0 */
			A0 = B12;
			break;
		case 024015:
			/* CAL B13 A0 */
			A0 = B13;
			break;
		case 024016:
			/* CAL B14 A0 */
			A0 = B14;
			break;
		case 024017:
			/* CAL B15 A0 */
			A0 = B15;
			break;
		case 024020:
			/* CAL B16 A0 */
			A0 = B16;
			break;
		case 024021:
			/* CAL B17 A0 */
			A0 = B17;
			break;
		case 024022:
			A0 = B18;
			break;
		case 024023:
			A0 = B19;
			break;
		case 024024:
			A0 = B20;
			break;
		case 024025:
			A0 = B21;
			break;
		case 024026:
			A0 = B22;
			break;
		case 024027:
			A0 = B23;
			break;
		case 024030:
			A0 = B24;
			break;
		case 024031:
			A0 = B25;
			break;
		case 024032:
			A0 = B26;
			break;
		case 024033:
			A0 = B27;
			break;
		case 024034:
			A0 = B28;
			break;
		case 024035:
			A0 = B29;
			break;
		case 024036:
			A0 = B30;
			break;
		case 024037:
			A0 = B31;
			break;
		case 024040:
			A0 = B32;
			break;
		case 024041:
			A0 = B33;
			break;
		case 024042:
			A0 = B34;
			break;
		case 024043:
			A0 = B35;
			break;
		case 024044:
			A0 = B36;
			break;
		case 024045:
			A0 = B37;
			break;
		case 024046:
			A0 = B38;
			break;
		case 024047:
			A0 = B39;
			break;
		case 024050:
			A0 = B40;
			break;
		case 024051:
			A0 = B41;
			break;
		case 024052:
			A0 = B42;
			break;
		case 024053:
			A0 = B43;
			break;
		case 024054:
			A0 = B44;
			break;
		case 024055:
			A0 = B45;
			break;
		case 024056:
			A0 = B46;
			break;
		case 024057:
			A0 = B47;
			break;
		case 024060:
			A0 = B48;
			break;
		case 024061:
			A0 = B49;
			break;
		case 024062:
			A0 = B50;
			break;
		case 024063:
			A0 = B51;
			break;
		case 024064:
			A0 = B52;
			break;
		case 024065:
			A0 = B53;
			break;
		case 024066:
			A0 = B54;
			break;
		case 024067:
			A0 = B55;
			break;
		case 024070:
			A0 = B56;
			break;
		case 024071:
			A0 = B57;
			break;
		case 024072:
			A0 = B58;
			break;
		case 024073:
			A0 = B59;
			break;
		case 024074:
			A0 = B61;
			break;
		case 024075:
			A0 = B61;
			break;
		case 024076:
			A0 = 62;
			break;
		case 024077:
			/* CAL B63 A0 */
			A0 = B63;
			break;
		case 024100:
			A1 = B0;
			break;
		case 024101:
			A1 = B1;
			break;
		case 024102:
			A1 = B2;
			break;
		case 024103:
			A1 = B3;
			break;
		case 024104:
			A1 = B4;
			break;
		case 024105:
			A1 = B5;
			break;
		case 024106:
			A1 = B6;
			break;
		case 024107:
			A1 = B7;
			break;
		case 024110:
			A1 = B8;
			break;
		case 024111:
			A1 = B9;
			break;
		case 024112:
			A1 = B10;
			break;
		case 024113:
			A1 = B11;
			break;
		case 024114:
			A1 = B12;
			break;
		case 024115:
			A1 = B13;
			break;
		case 024116:
			A1 = B14;
			break;
		case 024117:
			A1 = B15;
			break;
		case 024120:
			A1 = B16;
			break;
		case 024121:
			A1 = B17;
			break;
		case 024122:
			A1 = B18;
			break;
		case 024123:
			A1 = B19;
			break;
		case 024124:
			A1 = B20;
			break;
		case 024125:
			A1 = B21;
			break;
		case 024126:
			A1 = B22;
			break;
		case 024127:
			A1 = B23;
			break;
		case 024130:
			A1 = B24;
			break;
		case 024131:
			A1 = B25;
			break;
		case 024132:
			A1 = B26;
			break;
		case 024133:
			A1 = B27;
			break;
		case 024134:
			A1 = B28;
			break;
		case 024135:
			A1 = B29;
			break;
		case 024136:
			A1 = B30;
			break;
		case 024137:
			A1 = B31;
			break;
		case 024140:
			A1 = B32;
			break;
		case 024141:
			A1 = B33;
			break;
		case 024142:
			A1 = B34;
			break;
		case 024143:
			A1 = B35;
			break;
		case 024144:
			A1 = B36;
			break;
		case 024145:
			A1 = B37;
			break;
		case 024146:
			A1 = B38;
			break;
		case 024147:
			A1 = B39;
			break;
		case 024150:
			A1 = B40;
			break;
		case 024151:
			A1 = B41;
			break;
		case 024152:
			A1 = B42;
			break;
		case 024153:
			A1 = B43;
			break;
		case 024154:
			A1 = B44;
			break;
		case 024155:
			A1 = B45;
			break;
		case 024156:
			A1 = B46;
			break;
		case 024157:
			A1 = B47;
			break;
		case 024160:
			A1 = B48;
			break;
		case 024161:
			A1 = B49;
			break;
		case 024162:
			A1 = B50;
			break;
		case 024163:
			A1 = B51;
			break;
		case 024164:
			A1 = B52;
			break;
		case 024165:
			A1 = B53;
			break;
		case 024166:
			A1 = B54;
			break;
		case 024167:
			A1 = B55;
			break;
		case 024170:
			A1 = B56;
			break;
		case 024171:
			A1 = B57;
			break;
		case 024172:
			A1 = B58;
			break;
		case 024173:
			A1 = B59;
			break;
		case 024174:
			A1 = B60;
			break;
		case 024175:
			A1 = B61;
			break;
		case 024176:
			A1 = B62;
			break;
		case 024177:
			/* CAL B63 A1 */
			A1 = B63;
			break;
		case 024200:
			A2 = B0;
			break;
		case 024201:
			A2 = B1;
			break;
		case 024202:
			A2 = B2;
			break;
		case 024203:
			A2 = B3;
			break;
		case 024204:
			A2 = B4;
			break;
		case 024205:
			A2 = B5;
			break;
		case 024206:
			A2 = B6;
			break;
		case 024207:
			A2 = B7;
			break;
		case 024210:
			A2 = B8;
			break;
		case 024211:
			A2 = B9;
			break;
		case 024212:
			A2 = B10;
			break;
		case 024213:
			A2 = B11;
			break;
		case 024214:
			A2 = B12;
			break;
		case 024215:
			A2 = B13;
			break;
		case 024216:
			A2 = B14;
			break;
		case 024217:
			A2 = B15;
			break;
		case 024220:
			A2 = B16;
			break;
		case 024221:
			A2 = B17;
			break;
		case 024222:
			A2 = B18;
			break;
		case 024223:
			A2 = B19;
			break;
		case 024224:
			A2 = B20;
			break;
		case 024225:
			A2 = B21;
			break;
		case 024226:
			A2 = B22;
			break;
		case 024227:
			A2 = B23;
			break;
		case 024230:
			A2 = B24;
			break;
		case 024231:
			A2 = B25;
			break;
		case 024232:
			A2 = B26;
			break;
		case 024233:
			A2 = B27;
			break;
		case 024234:
			A2 = B28;
			break;
		case 024235:
			A2 = B29;
			break;
		case 024236:
			A2 = B30;
			break;
		case 024237:
			A2 = B31;
			break;
		case 024240:
			A2 = B32;
			break;
		case 024241:
			A2 = B33;
			break;
		case 024242:
			A2 = B34;
			break;
		case 024243:
			A2 = B35;
			break;
		case 024244:
			A2 = B36;
			break;
		case 024245:
			A2 = B37;
			break;
		case 024246:
			A2 = B38;
			break;
		case 024247:
			A2 = B39;
			break;
		case 024250:
			A2 = B40;
			break;
		case 024251:
			A2 = B41;
			break;
		case 024252:
			A2 = B42;
			break;
		case 024253:
			A2 = B43;
			break;
		case 024254:
			A2 = B44;
			break;
		case 024255:
			A2 = B45;
			break;
		case 024256:
			A2 = B46;
			break;
		case 024257:
			A2 = B47;
			break;
		case 024260:
			A2 = B48;
			break;
		case 024261:
			A2 = B49;
			break;
		case 024262:
			A2 = B50;
			break;
		case 024263:
			A2 = B51;
			break;
		case 024264:
			A2 = B52;
			break;
		case 024265:
			A2 = B53;
			break;
		case 024266:
			A2 = B54;
			break;
		case 024267:
			A2 = B55;
			break;
		case 024270:
			A2 = B56;
			break;
		case 024271:
			A2 = B57;
			break;
		case 024272:
			A2 = B58;
			break;
		case 024273:
			A2 = B59;
			break;
		case 024274:
			A2 = B60;
			break;
		case 024275:
			A2 = B61;
			break;
		case 024276:
			A2 = B62;
			break;
		case 024277:
			/* CAL B63 A2 */
			A2 = B63;
			break;
		case 024300:
			A3 = B0;
			break;
		case 024301:
			A3 = B1;
			break;
		case 024302:
			A3 = B2;
			break;
		case 024303:
			A3 = B3;
			break;
		case 024304:
			A3 = B4;
			break;
		case 024305:
			A3 = B5;
			break;
		case 024306:
			A3 = B6;
			break;
		case 024307:
			A3 = B7;
			break;
		case 024310:
			A3 = B8;
			break;
		case 024311:
			A3 = B9;
			break;
		case 024312:
			A3 = B10;
			break;
		case 024313:
			A3 = B11;
			break;
		case 024314:
			A3 = B12;
			break;
		case 024315:
			A3 = B13;
			break;
		case 024316:
			A3 = B14;
			break;
		case 024317:
			A3 = B15;
			break;
		case 024320:
			A3 = B16;
			break;
		case 024321:
			A3 = B17;
			break;
		case 024322:
			A3 = B18;
			break;
		case 024323:
			A3 = B19;
			break;
		case 024324:
			A3 = B20;
			break;
		case 024325:
			A3 = B21;
			break;
		case 024326:
			A3 = B22;
			break;
		case 024327:
			A3 = B23;
			break;
		case 024330:
			A3 = B24;
			break;
		case 024331:
			A3 = B25;
			break;
		case 024332:
			A3 = B26;
			break;
		case 024333:
			A3 = B27;
			break;
		case 024334:
			A3 = B28;
			break;
		case 024335:
			A3 = B29;
			break;
		case 024336:
			A3 = B30;
			break;
		case 024337:
			A3 = B31;
			break;
		case 024340:
			A3 = B32;
			break;
		case 024341:
			A3 = B33;
			break;
		case 024342:
			A3 = B34;
			break;
		case 024343:
			A3 = B35;
			break;
		case 024344:
			A3 = B36;
			break;
		case 024345:
			A3 = B37;
			break;
		case 024346:
			A3 = B38;
			break;
		case 024347:
			A3 = B39;
			break;
		case 024350:
			A3 = B40;
			break;
		case 024351:
			A3 = B41;
			break;
		case 024352:
			A3 = B42;
			break;
		case 024353:
			A3 = B43;
			break;
		case 024354:
			A3 = B44;
			break;
		case 024355:
			A3 = B45;
			break;
		case 024356:
			A3 = B46;
			break;
		case 024357:
			A3 = B47;
			break;
		case 024360:
			A3 = B48;
			break;
		case 024361:
			A3 = B49;
			break;
		case 024362:
			A3 = B50;
			break;
		case 024363:
			A3 = B51;
			break;
		case 024364:
			A3 = B52;
			break;
		case 024365:
			A3 = B53;
			break;
		case 024366:
			A3 = B54;
			break;
		case 024367:
			A3 = B55;
			break;
		case 024370:
			A3 = B56;
			break;
		case 024371:
			A3 = B57;
			break;
		case 024372:
			A3 = B58;
			break;
		case 024373:
			A3 = B59;
			break;
		case 024374:
			A3 = B60;
			break;
		case 024375:
			A3 = B61;
			break;
		case 024376:
			A3 = B62;
			break;
		case 024377:
			/* CAL B63 A3 */
			A3 = B63;
			break;
		case 024400:
			A4 = B0;
			break;
		case 024401:
			A4 = B1;
			break;
		case 024402:
			A4 = B2;
			break;
		case 024403:
			A4 = B3;
			break;
		case 024404:
			A4 = B4;
			break;
		case 024405:
			A4 = B5;
			break;
		case 024406:
			A4 = B6;
			break;
		case 024407:
			A4 = B7;
			break;
		case 024410:
			A4 = B8;
			break;
		case 024411:
			A4 = B9;
			break;
		case 024412:
			A4 = B10;
			break;
		case 024413:
			A4 = B11;
			break;
		case 024414:
			A4 = B12;
			break;
		case 024415:
			A4 = B13;
			break;
		case 024416:
			A4 = B14;
			break;
		case 024417:
			A4 = B15;
			break;
		case 024420:
			A4 = B16;
			break;
		case 024421:
			A4 = B17;
			break;
		case 024422:
			A4 = B18;
			break;
		case 024423:
			A4 = B19;
			break;
		case 024424:
			A4 = B20;
			break;
		case 024425:
			A4 = B21;
			break;
		case 024426:
			A4 = B22;
			break;
		case 024427:
			A4 = B23;
			break;
		case 024430:
			A4 = B24;
			break;
		case 024431:
			A4 = B25;
			break;
		case 024432:
			A4 = B26;
			break;
		case 024433:
			A4 = B27;
			break;
		case 024434:
			A4 = B28;
			break;
		case 024435:
			A4 = B29;
			break;
		case 024436:
			A4 = B30;
			break;
		case 024437:
			A4 = B31;
			break;
		case 024440:
			A4 = B32;
			break;
		case 024441:
			A4 = B33;
			break;
		case 024442:
			A4 = B34;
			break;
		case 024443:
			A4 = B35;
			break;
		case 024444:
			A4 = B36;
			break;
		case 024445:
			A4 = B37;
			break;
		case 024446:
			A4 = B38;
			break;
		case 024447:
			A4 = B39;
			break;
		case 024450:
			A4 = B40;
			break;
		case 024451:
			A4 = B41;
			break;
		case 024452:
			A4 = B42;
			break;
		case 024453:
			A4 = B43;
			break;
		case 024454:
			A4 = B44;
			break;
		case 024455:
			A4 = B45;
			break;
		case 024456:
			A4 = B46;
			break;
		case 024457:
			A4 = B47;
			break;
		case 024460:
			A4 = B48;
			break;
		case 024461:
			A4 = B49;
			break;
		case 024462:
			A4 = B50;
			break;
		case 024463:
			A4 = B51;
			break;
		case 024464:
			A4 = B52;
			break;
		case 024465:
			A4 = B53;
			break;
		case 024466:
			A4 = B54;
			break;
		case 024467:
			A4 = B55;
			break;
		case 024470:
			A4 = B56;
			break;
		case 024471:
			A4 = B57;
			break;
		case 024472:
			A4 = B58;
			break;
		case 024473:
			A4 = B59;
			break;
		case 024474:
			A4 = B60;
			break;
		case 024475:
			A4 = B61;
			break;
		case 024476:
			A4 = B62;
			break;
		case 024477:
			/* CAL B63 A4 */
			A4 = B63;
			break;
		case 024500:
			A5 = B0;
			break;
		case 024501:
			A5 = B1;
			break;
		case 024502:
			A5 = B2;
			break;
		case 024503:
			A5 = B3;
			break;
		case 024504:
			A5 = B4;
			break;
		case 024505:
			A5 = B5;
			break;
		case 024506:
			A5 = B6;
			break;
		case 024507:
			A5 = B7;
			break;
		case 024510:
			A5 = B8;
			break;
		case 024511:
			A5 = B9;
			break;
		case 024512:
			A5 = B10;
			break;
		case 024513:
			A5 = B11;
			break;
		case 024514:
			A5 = B12;
			break;
		case 024515:
			A5 = B13;
			break;
		case 024516:
			A5 = B14;
			break;
		case 024517:
			A5 = B15;
			break;
		case 024520:
			A5 = B16;
			break;
		case 024521:
			A5 = B17;
			break;
		case 024522:
			A5 = B18;
			break;
		case 024523:
			A5 = B19;
			break;
		case 024524:
			A5 = B20;
			break;
		case 024525:
			A5 = B21;
			break;
		case 024526:
			A5 = B22;
			break;
		case 024527:
			A5 = B23;
			break;
		case 024530:
			A5 = B24;
			break;
		case 024531:
			A5 = B25;
			break;
		case 024532:
			A5 = B26;
			break;
		case 024533:
			A5 = B27;
			break;
		case 024534:
			A5 = B28;
			break;
		case 024535:
			A5 = B29;
			break;
		case 024536:
			A5 = B30;
			break;
		case 024537:
			A5 = B31;
			break;
		case 024540:
			A5 = B32;
			break;
		case 024541:
			A5 = B33;
			break;
		case 024542:
			A5 = B34;
			break;
		case 024543:
			A5 = B35;
			break;
		case 024544:
			A5 = B36;
			break;
		case 024545:
			A5 = B37;
			break;
		case 024546:
			A5 = B38;
			break;
		case 024547:
			A5 = B39;
			break;
		case 024550:
			A5 = B40;
			break;
		case 024551:
			A5 = B41;
			break;
		case 024552:
			A5 = B42;
			break;
		case 024553:
			A5 = B43;
			break;
		case 024554:
			A5 = B44;
			break;
		case 024555:
			A5 = B45;
			break;
		case 024556:
			A5 = B46;
			break;
		case 024557:
			A5 = B47;
			break;
		case 024560:
			A5 = B48;
			break;
		case 024561:
			A5 = B49;
			break;
		case 024562:
			A5 = B50;
			break;
		case 024563:
			A5 = B51;
			break;
		case 024564:
			A5 = B52;
			break;
		case 024565:
			A5 = B53;
			break;
		case 024566:
			A5 = B54;
			break;
		case 024567:
			A5 = B55;
			break;
		case 024570:
			A5 = B56;
			break;
		case 024571:
			A5 = B57;
			break;
		case 024572:
			A5 = B58;
			break;
		case 024573:
			A5 = B59;
			break;
		case 024574:
			A5 = B60;
			break;
		case 024575:
			A5 = B61;
			break;
		case 024576:
			A5 = B62;
			break;
		case 024577:
			/* CAL B63 A5 */
			A5 = B63;
			break;
		case 024600:
			A6 = B0;
			break;
		case 024601:
			A6 = B1;
			break;
		case 024602:
			A6 = B2;
			break;
		case 024603:
			A6 = B3;
			break;
		case 024604:
			A6 = B4;
			break;
		case 024605:
			A6 = B5;
			break;
		case 024606:
			A6 = B6;
			break;
		case 024607:
			A6 = B7;
			break;
		case 024610:
			A6 = B8;
			break;
		case 024611:
			A6 = B9;
			break;
		case 024612:
			A6 = B10;
			break;
		case 024613:
			A6 = B11;
			break;
		case 024614:
			A6 = B12;
			break;
		case 024615:
			A6 = B13;
			break;
		case 024616:
			A6 = B14;
			break;
		case 024617:
			A6 = B15;
			break;
		case 024620:
			A6 = B16;
			break;
		case 024621:
			A6 = B17;
			break;
		case 024622:
			A6 = B18;
			break;
		case 024623:
			A6 = B19;
			break;
		case 024624:
			A6 = B20;
			break;
		case 024625:
			A6 = B21;
			break;
		case 024626:
			A6 = B22;
			break;
		case 024627:
			A6 = B23;
			break;
		case 024630:
			A6 = B24;
			break;
		case 024631:
			A6 = B25;
			break;
		case 024632:
			A6 = B26;
			break;
		case 024633:
			A6 = B27;
			break;
		case 024634:
			A6 = B28;
			break;
		case 024635:
			A6 = B29;
			break;
		case 024636:
			A6 = B30;
			break;
		case 024637:
			A6 = B31;
			break;
		case 024640:
			A6 = B32;
			break;
		case 024641:
			A6 = B33;
			break;
		case 024642:
			A6 = B34;
			break;
		case 024643:
			A6 = B35;
			break;
		case 024644:
			A6 = B36;
			break;
		case 024645:
			A6 = B37;
			break;
		case 024646:
			A6 = B38;
			break;
		case 024647:
			A6 = B39;
			break;
		case 024650:
			A6 = B40;
			break;
		case 024651:
			A6 = B41;
			break;
		case 024652:
			A6 = B42;
			break;
		case 024653:
			A6 = B43;
			break;
		case 024654:
			A6 = B44;
			break;
		case 024655:
			A6 = B45;
			break;
		case 024656:
			A6 = B46;
			break;
		case 024657:
			A6 = B47;
			break;
		case 024660:
			A6 = B48;
			break;
		case 024661:
			A6 = B49;
			break;
		case 024662:
			A6 = B50;
			break;
		case 024663:
			A6 = B51;
			break;
		case 024664:
			A6 = B52;
			break;
		case 024665:
			A6 = B53;
			break;
		case 024666:
			A6 = B54;
			break;
		case 024667:
			A6 = B55;
			break;
		case 024670:
			A6 = B56;
			break;
		case 024671:
			A6 = B57;
			break;
		case 024672:
			A6 = B58;
			break;
		case 024673:
			A6 = B59;
			break;
		case 024674:
			A6 = B60;
			break;
		case 024675:
			A6 = B61;
			break;
		case 024676:
			A6 = B62;
			break;
		case 024677:
			/* CAL B63 A6 */
			A6 = B63;
			break;
		case 024700:
			A7 = B0;
			break;
		case 024701:
			A7 = B1;
			break;
		case 024702:
			A7 = B2;
			break;
		case 024703:
			A7 = B3;
			break;
		case 024704:
			A7 = B4;
			break;
		case 024705:
			A7 = B5;
			break;
		case 024706:
			A7 = B6;
			break;
		case 024707:
			A7 = B7;
			break;
		case 024710:
			A7 = B8;
			break;
		case 024711:
			A7 = B9;
			break;
		case 024712:
			A7 = B10;
			break;
		case 024713:
			A7 = B11;
			break;
		case 024714:
			A7 = B12;
			break;
		case 024715:
			A7 = B13;
			break;
		case 024716:
			A7 = B14;
			break;
		case 024717:
			A7 = B15;
			break;
		case 024720:
			A7 = B16;
			break;
		case 024721:
			A7 = B17;
			break;
		case 024722:
			A7 = B18;
			break;
		case 024723:
			A7 = B19;
			break;
		case 024724:
			A7 = B20;
			break;
		case 024725:
			A7 = B21;
			break;
		case 024726:
			A7 = B22;
			break;
		case 024727:
			A7 = B23;
			break;
		case 024730:
			A7 = B24;
			break;
		case 024731:
			A7 = B25;
			break;
		case 024732:
			A7 = B26;
			break;
		case 024733:
			A7 = B27;
			break;
		case 024734:
			A7 = B28;
			break;
		case 024735:
			A7 = B29;
			break;
		case 024736:
			A7 = B30;
			break;
		case 024737:
			A7 = B31;
			break;
		case 024740:
			A7 = B32;
			break;
		case 024741:
			A7 = B33;
			break;
		case 024742:
			A7 = B34;
			break;
		case 024743:
			A7 = B35;
			break;
		case 024744:
			A7 = B36;
			break;
		case 024745:
			A7 = B37;
			break;
		case 024746:
			A7 = B38;
			break;
		case 024747:
			A7 = B39;
			break;
		case 024750:
			A7 = B40;
			break;
		case 024751:
			A7 = B41;
			break;
		case 024752:
			A7 = B42;
			break;
		case 024753:
			A7 = B43;
			break;
		case 024754:
			A7 = B44;
			break;
		case 024755:
			A7 = B45;
			break;
		case 024756:
			A7 = B46;
			break;
		case 024757:
			A7 = B47;
			break;
		case 024760:
			A7 = B48;
			break;
		case 024761:
			A7 = B49;
			break;
		case 024762:
			A7 = B50;
			break;
		case 024763:
			A7 = B51;
			break;
		case 024764:
			A7 = B52;
			break;
		case 024765:
			A7 = B53;
			break;
		case 024766:
			A7 = B54;
			break;
		case 024767:
			A7 = B55;
			break;
		case 024770:
			A7 = B56;
			break;
		case 024771:
			A7 = B57;
			break;
		case 024772:
			A7 = B58;
			break;
		case 024773:
			A7 = B59;
			break;
		case 024774:
			A7 = B60;
			break;
		case 024775:
			A7 = B61;
			break;
		case 024776:
			A7 = B62;
			break;
		case 024777:
			/* CAL B63 A7 */
			A7 = B63;
			break;
		/* DO THIS */
		case 025000:
			/* CAL A0 B00 */
			/* CAL Ai Bjk */
			/* Transmits Ai to Bjk */
			B0 = A0;
			break;
		case 025001:
			/* CAL B01 A0 */
			B1 = A0;
			break;
		case 025002:
			B2 = A0;
			break;
		case 025003:
			B3 = A0;
			break;
		case 025004:
			B4 = A0;
			break;
		case 025005:
			B5 = A0;
			break;
		case 025006:
			B6 = A0;
			break;
		case 025007:
			B7 = A0;
			break;
		case 025010:
			B8 = A0;
			break;
		case 025011:
			B9 = A0;
			break;
		case 025012:
			/* CAL B10 A0 */
			B10 = A0;
			break;
		case 025013:
			B11 = A0;
			break;
		case 025014:
			B12 = A0;
			break;
		case 025015:
			B13 = A0;
			break;
		case 025016:
			B14 = A0;
			break;
		case 025017:
			B15 = A0;
			break;
		case 025020:
			B16 = A0;
			break;
		case 025021:
			B17 = A0;
			break;
		case 025022:
			B18 = A0;
			break;
		case 025023:
			B19 = A0;
			break;
		case 025024:
			B20 = A0;
			break;
		case 025025:
			B21 = A0;
			break;
		case 025026:
			B22 = A0;
			break;
		case 025027:
			B23 = A0;
			break;
		case 025030:
			B24 = A0;
			break;
		case 025031:
			B25 = A0;
			break;
		case 025032:
			B26 = A0;
			break;
		case 025033:
			B27 = A0;
			break;
		case 025034:
			B28 = A0;
			break;
		case 025035:
			B29 = A0;
			break;
		case 025036:
			B30 = A0;
			break;
		case 025037:
			B31 = A0;
			break;
		case 025040:
			B32 = A0;
			break;
		case 025041:
			B33 = A0;
			break;
		case 025042:
			B34 = A0;
			break;
		case 025043:
			B35 = A0;
			break;
		case 025044:
			B36 = A0;
			break;
		case 025045:
			B37 = A0;
			break;
		case 025046:
			B38 = A0;
			break;
		case 025047:
			B39 = A0;
			break;
		case 025050:
			B40 = A0;
			break;
		case 025051:
			B41 = A0;
			break;
		case 025052:
			B42 = A0;
			break;
		case 025053:
			B43 = A0;
			break;
		case 025054:
			B44 = A0;
			break;
		case 025055:
			B45 = A0;
			break;
		case 025056:
			B46 = A0;
			break;
		case 025057:
			B47 = A0;
			break;
		case 025060:
			B48 = A0;
			break;
		case 025061:
			B49 = A0;
			break;
		case 025062:
			B50 = A0;
			break;
		case 025063:
			B51 = A0;
			break;
		case 025064:
			B52 = A0;
			break;
		case 025065:
			B53 = A0;
			break;
		case 025066:
			B54 = A0;
			break;
		case 025067:
			B55 = A0;
			break;
		case 025070:
			B56 = A0;
			break;
		case 025071:
			B57 = A0;
			break;
		case 025072:
			B58 = A0;
			break;
		case 025073:
			B59 = A0;
			break;
		case 025074:
			B60 = A0;
			break;
		case 025075:
			B61 = A0;
			break;
		case 025076:
			B62 = A0;
			break;
		case 025077:
			B63 = A0;
			break;
		case 025100:
			B0 = A1;
			break;
		case 025101:
			B1 = A1;
			break;
		case 025102:
			B2 = A1;
			break;
		case 025103:
			B3 = A1;
			break;
		case 025104:
			B4 = A1;
			break;
		case 025105:
			B5 = A1;
			break;
		case 025106:
			B6 = A1;
			break;
		case 025107:
			/* CAL B07 A1 */
			B7 = A1;
			break;
		case 025110:
			B8 = A1;
			break;
		case 025111:
			B9 = A1;
			break;
		case 025112:
			B10 = A1;
			break;
		case 025113:
			B11 = A1;
			break;
		case 025114:
			B12 = A1;
			break;
		case 025115:
			B13 = A1;
			break;
		case 025116:
			B14 = A1;
			break;
		case 025117:
			B15 = A1;
			break;
		case 025120:
			B16 = A1;
			break;
		case 025121:
			B17 = A1;
			break;
		case 025122:
			B18 = A1;
			break;
		case 025123:
			B19 = A1;
			break;
		case 025124:
			B20 = A1;
			break;
		case 025125:
			B21 = A1;
			break;
		case 025126:
			B22 = A1;
			break;
		case 025127:
			B23 = A1;
			break;
		case 025130:
			B24 = A1;
			break;
		case 025131:
			B25 = A1;
			break;
		case 025132:
			B26 = A1;
			break;
		case 025133:
			B27 = A1;
			break;
		case 025134:
			B28 = A1;
			break;
		case 025135:
			B29 = A1;
			break;
		case 025136:
			B30 = A1;
			break;
		case 025137:
			B31 = A1;
			break;
		case 025140:
			B32 = A1;
			break;
		case 025141:
			B33 = A1;
			break;
		case 025142:
			B34 = A1;
			break;
		case 025143:
			B35 = A1;
			break;
		case 025144:
			B36 = A1;
			break;
		case 025145:
			B37 = A1;
			break;
		case 025146:
			B38 = A1;
			break;
		case 025147:
			B39 = A1;
			break;
		case 025150:
			B40 = A1;
			break;
		case 025151:
			B41 = A1;
			break;
		case 025152:
			B42 = A1;
			break;
		case 025153:
			B43 = A1;
			break;
		case 025154:
			B44 = A1;
			break;
		case 025155:
			B45 = A1;
			break;
		case 025156:
			B46 = A1;
			break;
		case 025157:
			B47 = A1;
			break;
		case 025160:
			B48 = A1;
			break;
		case 025161:
			B49 = A1;
			break;
		case 025162:
			B50 = A1;
			break;
		case 025163:
			B51 = A1;
			break;
		case 025164:
			B52 = A1;
			break;
		case 025165:
			B53 = A1;
			break;
		case 025166:
			B54 = A1;
			break;
		case 025167:
			B55 = A1;
			break;
		case 025170:
			B56 = A1;
			break;
		case 025171:
			B57 = A1;
			break;
		case 025172:
			B58 = A1;
			break;
		case 025173:
			B59 = A1;
			break;
		case 025174:
			B60 = A1;
			break;
		case 025175:
			B61 = A1;
			break;
		case 025176:
			B62 = A1;
			break;
		case 025177:
			B63 = A1;
			break;
		case 025200:
			B0 = A2;
			break;
		case 025201:
			B1 = A2;
			break;
		case 025202:
			B2 = A2;
			break;
		case 025203:
			B3 = A2;
			break;
		case 025204:
			B4 = A2;
			break;
		case 025205:
			B5 = A2;
			break;
		case 025206:
			B6 = A2;
			break;
		case 025207:
			B7 = A2;
			break;
		case 025210:
			B8 = A2;
			break;
		case 025211:
			B9 = A2;
			break;
		case 025212:
			B10 = A2;
			break;
		case 025213:
			B11 = A2;
			break;
		case 025214:
			B12 = A2;
			break;
		case 025215:
			B13 = A2;
			break;
		case 025216:
			B14 = A2;
			break;
		case 025217:
			B15 = A2;
			break;
		case 025220:
			B16 = A2;
			break;
		case 025221:
			B17 = A2;
			break;
		case 025222:
			B18 = A2;
			break;
		case 025223:
			B19 = A2;
			break;
		case 025224:
			B20 = A2;
			break;
		case 025225:
			B21 = A2;
			break;
		case 025226:
			B22 = A2;
			break;
		case 025227:
			B23 = A2;
			break;
		case 025230:
			B24 = A2;
			break;
		case 025231:
			B25 = A2;
			break;
		case 025232:
			B26 = A2;
			break;
		case 025233:
			B27 = A2;
			break;
		case 025234:
			B28 = A2;
			break;
		case 025235:
			B29 = A2;
			break;
		case 025236:
			B30 = A2;
			break;
		case 025237:
			B31 = A2;
			break;
		case 025240:
			B32 = A2;
			break;
		case 025241:
			B33 = A2;
			break;
		case 025242:
			B34 = A2;
			break;
		case 025243:
			B35 = A2;
			break;
		case 025244:
			B36 = A2;
			break;
		case 025245:
			B37 = A2;
			break;
		case 025246:
			B38 = A2;
			break;
		case 025247:
			B39 = A2;
			break;
		case 025250:
			B40 = A2;
			break;
		case 025251:
			B41 = A2;
			break;
		case 025252:
			B42 = A2;
			break;
		case 025253:
			B43 = A2;
			break;
		case 025254:
			B44 = A2;
			break;
		case 025255:
			B45 = A2;
			break;
		case 025256:
			B46 = A2;
			break;
		case 025257:
			B47 = A2;
			break;
		case 025260:
			B48 = A2;
			break;
		case 025261:
			B49 = A2;
			break;
		case 025262:
			B50 = A2;
			break;
		case 025263:
			B51 = A2;
			break;
		case 025264:
			B52 = A2;
			break;
		case 025265:
			B53 = A2;
			break;
		case 025266:
			B54 = A2;
			break;
		case 025267:
			B55 = A2;
			break;
		case 025270:
			B56 = A2;
			break;
		case 025271:
			B57 = A2;
			break;
		case 025272:
			B58 = A2;
			break;
		case 025273:
			B59 = A2;
			break;
		case 025274:
			B60 = A2;
			break;
		case 025275:
			B61 = A2;
			break;
		case 025276:
			B62 = A2;
			break;
		case 025277:
			B63 = A2;
			break;
		case 025300:
			B0 = A3;
			break;
		case 025301:
			B1 = A3;
			break;
		case 025302:
			B2 = A3;
			break;
		case 025303:
			B3 = A3;
			break;
		case 025304:
			B4 = A3;
			break;
		case 025305:
			B5 = A3;
			break;
		case 025306:
			B6 = A3;
			break;
		case 025307:
			B7 = A3;
			break;
		case 025310:
			B8 = A3;
			break;
		case 025311:
			B9 = A3;
			break;
		case 025312:
			B10 = A3;
			break;
		case 025313:
			B11 = A3;
			break;
		case 025314:
			B12 = A3;
			break;
		case 025315:
			B13 = A3;
			break;
		case 025316:
			B14 = A3;
			break;
		case 025317:
			B15 = A3;
			break;
		case 025320:
			B16 = A3;
			break;
		case 025321:
			B17 = A3;
			break;
		case 025322:
			B18 = A3;
			break;
		case 025323:
			B19 = A3;
			break;
		case 025324:
			B20 = A3;
			break;
		case 025325:
			B21 = A3;
			break;
		case 025326:
			B22 = A3;
			break;
		case 025327:
			B23 = A3;
			break;
		case 025330:
			B24 = A3;
			break;
		case 025331:
			B25 = A3;
			break;
		case 025332:
			B26 = A3;
			break;
		case 025333:
			B27 = A3;
			break;
		case 025334:
			B28 = A3;
			break;
		case 025335:
			B29 = A3;
			break;
		case 025336:
			B30 = A3;
			break;
		case 025337:
			B31 = A3;
			break;
		case 025340:
			B32 = A3;
			break;
		case 025341:
			B33 = A3;
			break;
		case 025342:
			B34 = A3;
			break;
		case 025343:
			B35 = A3;
			break;
		case 025344:
			B36 = A3;
			break;
		case 025345:
			B37 = A3;
			break;
		case 025346:
			B38 = A3;
			break;
		case 025347:
			B39 = A3;
			break;
		case 025350:
			B40 = A3;
			break;
		case 025351:
			B41 = A3;
			break;
		case 025352:
			B42 = A3;
			break;
		case 025353:
			B43 = A3;
			break;
		case 025354:
			B44 = A3;
			break;
		case 025355:
			B45 = A3;
			break;
		case 025356:
			B46 = A3;
			break;
		case 025357:
			B47 = A3;
			break;
		case 025360:
			B48 = A3;
			break;
		case 025361:
			B49 = A3;
			break;
		case 025362:
			B50 = A3;
			break;
		case 025363:
			B51 = A3;
			break;
		case 025364:
			B52 = A3;
			break;
		case 025365:
			B53 = A3;
			break;
		case 025366:
			B54 = A3;
			break;
		case 025367:
			B55 = A3;
			break;
		case 025370:
			B56 = A3;
			break;
		case 025371:
			B57 = A3;
			break;
		case 025372:
			B58 = A3;
			break;
		case 025373:
			B59 = A3;
			break;
		case 025374:
			B60 = A3;
			break;
		case 025375:
			B61 = A3;
			break;
		case 025376:
			B62 = A3;
			break;
		case 025377:
			B63 = A3;
			break;
		case 025400:
			B0 = A4;
			break;
		case 025401:
			B1 = A4;
			break;
		case 025402:
			B2 = A4;
			break;
		case 025403:
			B3 = A4;
			break;
		case 025404:
			B4 = A4;
			break;
		case 025405:
			B5 = A4;
			break;
		case 025406:
			B6 = A4;
			break;
		case 025407:
			B7 = A4;
			break;
		case 025410:
			B8 = A4;
			break;
		case 025411:
			B9 = A4;
			break;
		case 025412:
			B10 = A4;
			break;
		case 025413:
			B11 = A4;
			break;
		case 025414:
			B12 = A4;
			break;
		case 025415:
			B13 = A4;
			break;
		case 025416:
			B14 = A4;
			break;
		case 025417:
			B15 = A4;
			break;
		case 025420:
			B16 = A4;
			break;
		case 025421:
			B17 = A4;
			break;
		case 025422:
			B18 = A4;
			break;
		case 025423:
			B19 = A4;
			break;
		case 025424:
			B20 = A4;
			break;
		case 025425:
			B21 =A4;
			break;
		case 025426:
			B22 =A4;
			break;
		case 025427:
			B23 = A4;
			break;
		case 025430:
			B24 = A4;
			break;
		case 025431:
			B25 = A4;
			break;
		case 025432:
			B26 = A4;
			break;
		case 025433:
			B27 = A4;
			break;
		case 025434:
			B28 = A4;
			break;
		case 025435:
			B29 = A4;
			break;
		case 025436:
			B30 = A4;
			break;
		case 025437:
			B31 = A4;
			break;
		case 025440:
			B32 = A4;
			break;
		case 025441:
			B33 = A4;
			break;
		case 025442:
			B34 = A4;
			break;
		case 025443:
			B35 = A4;
			break;
		case 025444:
			B36 = A4;
			break;
		case 025445:
			B37 = A4;
			break;
		case 025446:
			B38 = A4;
			break;
		case 025447:
			B39 = A4;
			break;
		case 025450:
			B40 = A4;
			break;
		case 025451:
			B41 = A4;
			break;
		case 025452:
			B42 = A4;
			break;
		case 025453:
			B43 = A4;
			break;
		case 025454:
			B44 = A4;
			break;
		case 025455:
			B45 = A4;
			break;
		case 025456:
			B46 = A4;
			break;
		case 025457:
			B47 = A4;
			break;
		case 025460:
			B48 = A4;
			break;
		case 025461:
			B49 = A4;
			break;
		case 025462:
			B50 = A4;
			break;
		case 025463:
			B51 = A4;
			break;
		case 025464:
			B52 = A4;
			break;
		case 025465:
			B53 = A4;
			break;
		case 025466:
			B54 = A4;
			break;
		case 025467:
			B55 = A4;
			break;
		case 025470:
			B56 = A4;
			break;
		case 025471:
			B57 = A4;
			break;
		case 025472:
			B58 = A4;
			break;
		case 025473:
			B59 = A4;
			break;
		case 025474:
			B60 = A4;
			break;
		case 025475:
			B61 = A4;
			break;
		case 025476:
			B62 = A4;
			break;
		case 025477:
			B63 = A4;
			break;
		case 025500:
			B0 = A5;
			break;
		case 025501:
			B1 = A5;
			break;
		case 025502:
			B2 = A5;
			break;
		case 025503:
			B3 = A5;
			break;
		case 025504:
			B4 = A5;
			break;
		case 025505:
			B5 = A5;
			break;
		case 025506:
			B6 = A5;
			break;
		case 025507:
			B7 = A5;
			break;
		case 025510:
			B8 = A5;
			break;
		case 025511:
			B9 = A5;
			break;
		case 025512:
			B10 = A5;
			break;
		case 025513:
			B11 = A5;
			break;
		case 025514:
			B12 = A5;
			break;
		case 025515:
			B13 = A5;
			break;
		case 025516:
			B14 = A5;
			break;
		case 025517:
			B15 = A5;
			break;
		case 025520:
			B16 = A5;
			break;
		case 025521:
			B17 = A5;
			break;
		case 025522:
			B18 = A5;
			break;
		case 025523:
			B19 = A5;
			break;
		case 025524:
			B20 = A5;
			break;
		case 025525:
			B21 = A5;
			break;
		case 025526:
			B22 = A5;
			break;
		case 025527:
			B23 = A5;
			break;
		case 025530:
			B24 = A5;
			break;
		case 025531:
			B25 = A5;
			break;
		case 025532:
			B26 = A5;
			break;
		case 025533:
			B27 = A5;
			break;
		case 025534:
			B28 = A5;
			break;
		case 025535:
			B29 = A5;
			break;
		case 025536:
			B30 = A5;
			break;
		case 025537:
			B31 = A5;
			break;
		case 025540:
			B32 = A5;
			break;
		case 025541:
			B33 = A5;
			break;
		case 025542:
			B34 = A5;
			break;
		case 025543:
			B35 = A5;
			break;
		case 025544:
			B36 = A5;
			break;
		case 025545:
			B37 = A5;
			break;
		case 025546:
			B38 = A5;
			break;
		case 025547:
			B39 = A5;
			break;
		case 025550:
			B40 = A5;
			break;
		case 025551:
			B41 = A5;
			break;
		case 025552:
			B42 = A5;
			break;
		case 025553:
			B43 = A5;
			break;
		case 025554:
			B44 = A5;
			break;
		case 025555:
			B45 = A5;
			break;
		case 025556:
			B46 = A5;
			break;
		case 025557:
			B47 = A5;
			break;
		case 025560:
			B48 = A5;
			break;
		case 025561:
			B49 = A5;
			break;
		case 025562:
			B50 = A5;
			break;
		case 025563:
			B51 = A5;
			break;
		case 025564:
			B52 = A5;
			break;
		case 025565:
			B53 = A5;
			break;
		case 025566:
			B54 = A5;
			break;
		case 025567:
			B55 = A5;
			break;
		case 025570:
			B56 = A5;
			break;
		case 025571:
			B57 = A5;
			break;
		case 025572:
			B58 = A5;
			break;
		case 025573:
			B59 = A5;
			break;
		case 025574:
			B60 = A5;
			break;
		case 025575:
			B61 = A5;
			break;
		case 025576:
			B62 = A5;
			break;
		case 025577:
			B63 = A5;
			break;
		case 025600:
			B0 = A6;
			break;
		case 025601:
			B1 = A6;
			break;
		case 025602:
			B2 = A6;
			break;
		case 025603:
			B3 = A6;
			break;
		case 025604:
			B4 = A6;
			break;
		case 025605:
			B5 = A6;
			break;
		case 025606:
			B6 = A6;
			break;
		case 025607:
			B7 = A6;
			break;
		case 025610:
			B8 = A6;
			break;
		case 025611:
			B9 = A6;
			break;
		case 025612:
			B10 = A6;
			break;
		case 025613:
			B11 = A6;
			break;
		case 025614:
			B12 = A6;
			break;
		case 025615:
			B13 = A6;
			break;
		case 025616:
			B14 = A6;
			break;
		case 025617:
			B15 = A6;
			break;
		case 025620:
			B16 = A6;
			break;
		case 025621:
			B17 = A6;
			break;
		case 025622:
			B18 = A6;
			break;
		case 025623:
			B19 = A6;
			break;
		case 025624:
			B20 = A6;
			break;
		case 025625:
			B21 = A6;
			break;
		case 025626:
			B22 = A6;
			break;
		case 025627:
			B23 = A6;
			break;
		case 025630:
			B24 = A6;
			break;
		case 025631:
			B25 = A6;
			break;
		case 025632:
			B26 = A6;
			break;
		case 025633:
			B27 = A6;
			break;
		case 025634:
			B28 = A6;
			break;
		case 025635:
			B29 = A6;
			break;
		case 025636:
			B30 = A6;
			break;
		case 025637:
			B31 = A6;
			break;
		case 025640:
			B32 = A6;
			break;
		case 025641:
			B33 = A6;
			break;
		case 025642:
			B34 = A6;
			break;
		case 025643:
			B35 = A6;
			break;
		case 025644:
			B36 = A6;
			break;
		case 025645:
			B37 = A6;
			break;
		case 025646:
			B38 = A6;
			break;
		case 025647:
			B39 = A6;
			break;
		case 025650:
			B40 = A6;
			break;
		case 025651:
			B41 = A6;
			break;
		case 025652:
			B42 = A6;
			break;
		case 025653:
			B43 = A6;
			break;
		case 025654:
			B44 = A6;
			break;
		case 025655:
			B45 = A6;
			break;
		case 025656:
			B46 = A6;
			break;
		case 025657:
			B47 = A6;
			break;
		case 025660:
			B48 = A6;
			break;
		case 025661:
			B49 = A6;
			break;
		case 025662:
			B50 = A6;
			break;
		case 025663:
			B51 = A6;
			break;
		case 025664:
			B52 = A6;
			break;
		case 025665:
			B53 = A6;
			break;
		case 025666:
			B54 = A6;
			break;
		case 025667:
			B55 = A6;
			break;
		case 025670:
			B56 = A6;
			break;
		case 025671:
			B57 = A6;
			break;
		case 025672:
			B58 = A6;
			break;
		case 025673:
			B59 = A6;
			break;
		case 025674:
			B60 = A6;
			break;
		case 025675:
			B61 = A6;
			break;
		case 025676:
			B62 = A6;
			break;
		case 025677:
			B63 = A6;
			break;
		case 025700:
			B0 = A7;
			break;
		case 025701:
			B1 = A7;
			break;
		case 025702:
			B2 = A7;
			break;
		case 025703:
			B3 = A7;
			break;
		case 025704:
			B4 = A7;
			break;
		case 025705:
			B5 = A7;
			break;
		case 025706:
			B6 = A7;
			break;
		case 025707:
			B7 = A7;
			break;
		case 025710:
			B8 = A7;
			break;
		case 025711:
			B9 = A7;
			break;
		case 025712:
			B10 = A7;
			break;
		case 025713:
			B11 = A7;
			break;
		case 025714:
			B12 = A7;
			break;
		case 025715:
			B13 = A7;
			break;
		case 025716:
			B14 = A7;
			break;
		case 025717:
			B15 = A7;
			break;
		case 025720:
			B16 = A7;
			break;
		case 025721:
			B17 = A7;
			break;
		case 025722:
			B18 = A7;
			break;
		case 025723:
			B19 = A7;
			break;
		case 025724:
			B20 = A7;
			break;
		case 025725:
			B21 = A7;
			break;
		case 025726:
			B22 = A7;
			break;
		case 025727:
			B23 = A7;
			break;
		case 025730:
			B24 = A7;
			break;
		case 025731:
			B25 = A7;
			break;
		case 025732:
			B26 = A7;
			break;
		case 025733:
			B27 = A7;
			break;
		case 025734:
			B28 = A7;
			break;
		case 025735:
			B29 = A7;
			break;
		case 025736:
			B30 = A7;
			break;
		case 025737:
			B31 = A7;
			break;
		case 025740:
			B32 = A7;
			break;
		case 025741:
			B33 = A7;
			break;
		case 025742:
			B34 = A7;
			break;
		case 025743:
			B35 = A7;
			break;
		case 025744:
			B36 = A7;
			break;
		case 025745:
			B37 = A7;
			break;
		case 025746:
			B38 = A7;
			break;
		case 025747:
			B39 = A7;
			break;
		case 025750:
			B40 = A7;
			break;
		case 025751:
			B41 = A7;
			break;
		case 025752:
			B42 = A7;
			break;
		case 025753:
			B43 = A7;
			break;
		case 025754:
			B44 = A7;
			break;
		case 025755:
			B45 = A7;
			break;
		case 025756:
			B46 = A7;
			break;
		case 025757:
			B47 = A7;
			break;
		case 025760:
			B48 = A7;
			break;
		case 025761:
			B49 = A7;
			break;
		case 025762:
			B50 = A7;
			break;
		case 025763:
			B51 = A7;
			break;
		case 025764:
			B52 = A7;
			break;
		case 025765:
			B53 = A7;
			break;
		case 025766:
			B54 = A7;
			break;
		case 025767:
			B55 = A7;
			break;
		case 025770:
			B56 = A7;
			break;
		case 025771:
			B57 = A7;
			break;
		case 025772:
			B58 = A7;
			break;
		case 025773:
			B59 = A7;
			break;
		case 025774:
			B60 = A7;
			break;
		case 025775:
			B61 = A7;
			break;
		case 025776:
			B62 = A7;
			break;
		case 025777:
			/* CAL B63 A7 */
			B63 = A7;
			break;
		case 026007:
			/* CAL Ai SBj */
			/* Transmits SBj to Ai */
			A0 = SB0;
			break;
		case 026017:
			A0 = SB1;
			break;
		case 026027:
			A0 = SB2;
			break;
		case 026037:
			A0 = SB3;
			break;
		case 026047:
			A0 = SB4;
			break;
		case 026057:
			A0 = SB5;
			break;
		case 026067:
			A0 = SB6;
			break;
		case 026077:
			A0 = SB7;
			break;
		case 026107:
			A1 = SB0;
			break;
		case 026117:
			A1 = SB1;
			break;
		case 026127:
			A1 = SB2;
			break;
		case 026137:
			A1 = SB3;
			break;
		case 026147:
			A1 = SB4;
			break;
		case 026157:
			A1 = SB5;
			break;
		case 026167:
			A1 = SB6;
			break;
		case 026177:
			A1 = SB7;
			break;
		case 026207:
			A2 = SB0;
			break;
		case 026217:
			A2 = SB1;
			break;
		case 026227:
			A2 = SB2;
			break;
		case 026237:
			A2 = SB3;
			break;
		case 026247:
			A2 = SB4;
			break;
		case 026257:
			A2 = SB5;
			break;
		case 026267:
			A2 = SB6;
			break;
		case 026277:
			A2 = SB7;
			break;
		case 026307:
			A3 = SB0;
			break;
		case 026317:
			A3 = SB1;
			break;
		case 026327:
			A3 = SB2;
			break;
		case 026337:
			A3 = SB3;
			break;
		case 026347:
			A3 = SB4;
			break;
		case 026357:
			A3 = SB5;
			break;
		case 026367:
			A3 = SB6;
			break;
		case 026377:
			A3 = SB7;
			break;
		case 026407:
			A4 = SB0;
			break;
		case 026417:
			A4 = SB1;
			break;
		case 026427:
			A4 = SB2;
			break;
		case 026437:
			A4 = SB3;
			break;
		case 026447:
			A4 = SB4;
			break;
		case 026457:
			A4 = SB5;
			break;
		case 026467:
			A4 = SB6;
			break;
		case 026477:
			A4 = SB7;
			break;
		case 026507:
			A5 = SB0;
			break;
		case 026517:
			A5 = SB1;
			break;
		case 026527:
			A5 = SB2;
			break;
		case 026537:
			A5 = SB3;
			break;
		case 026547:
			A5 = SB4;
			break;
		case 026557:
			A5 = SB5;
			break;
		case 026567:
			A5 = SB6;
			break;
		case 026577:
			A5 = SB7;
			break;
		case 026607:
			A6 = SB0;
			break;
		case 026617:
			A6 = SB1;
			break;
		case 026627:
			A6 = SB2;
			break;
		case 026637:
			A6 = SB3;
			break;
		case 026647:
			A6 = SB4;
			break;
		case 026657:
			A6 = SB5;
			break;
		case 026667:
			A6 = SB6;
			break;
		case 026677:
			A6 = SB7;
			break;
		case 026707:
			A7 = SB0;
			break;
		case 026717:
			A7 = SB1;
			break;
		case 026727:
			A7 = SB2;
			break;
		case 026737:
			A7 = SB3;
			break;
		case 026747:
			A7 = SB4;
			break;
		case 026757:
			A7 = SB5;
			break;
		case 026767:
			A7 = SB6;
			break;
		case 026777:
			A7 = SB7;
			break;
		case 027007:
			/* CAL SBj Ai */
			/* Transmits SBj to Ai */
			SB0 = A0;
			break;
		case 027017:
			SB1 = A0;
			break;
		case 027027:
			SB2 = A0;
			break;
		case 027037:
			SB3 = A0;
			break;
		case 027047:
			SB4 = A0;
			break;
		case 027057:
			SB5 = A0;
			break;
		case 027067:
			SB6 = A0;
			break;
		case 027077:
			SB7 = A0;
			break;
		case 027107:
			SB0 = A1;
			break;
		case 027117:
			SB1 = A1;
			break;
		case 027127:
			SB2 = A1;
			break;
		case 027137:
			SB3 = A1;
			break;
		case 027147:
			SB4 = A1;
			break;
		case 027157:
			SB5 = A1;
			break;
		case 027167:
			SB6 = A1;
			break;
		case 027177:
			SB7 = A1;
			break;
		case 027207:
			SB0 = A2;
			break;
		case 027217:
			SB1 = A2;
			break;
		case 027227:
			SB2 = A2;
			break;
		case 027237:
			SB3 = A2;
			break;
		case 027247:
			SB4 = A2;
			break;
		case 027257:
			SB5 = A2;
			break;
		case 027267:
			SB6 = A2;
			break;
		case 027277:
			SB7 = A2;
			break;
		case 027307:
			SB0 = A3;
			break;
		case 027317:
			SB1 = A3;
			break;
		case 027327:
			SB2 = A3;
			break;
		case 027337:
			SB3 = A3;
			break;
		case 027347:
			SB4 = A3;
			break;
		case 027357:
			SB5 = A3;
			break;
		case 027367:
			SB6 = A3;
			break;
		case 027377:
			SB7 = A3;
			break;
		case 027407:
			SB0 = A4;
			break;
		case 027417:
			SB1 = A4;
			break;
		case 027427:
			SB2 = A4;
			break;
		case 027437:
			SB3 = A4;
			break;
		case 027447:
			SB4 = A4;
			break;
		case 027457:
			SB5 = A4;
			break;
		case 027467:
			SB6 = A4;
			break;
		case 027477:
			SB7 = A4;
			break;
		case 027507:
			SB0 = A5;
			break;
		case 027517:
			SB1 = A5;
			break;
		case 027527:
			SB2 = A5;
			break;
		case 027537:
			SB3 = A5;
			break;
		case 027547:
			SB4 = A5;
			break;
		case 027557:
			SB5 = A5;
			break;
		case 027567:
			SB6 = A5;
			break;
		case 027577:
			SB7 = A5;
			break;
		case 027607:
			SB0 = A6;
			break;
		case 027617:
			SB1 = A6;
			break;
		case 027627:
			SB2 = A6;
			break;
		case 027637:
			SB3 = A6;
			break;
		case 027647:
			SB4 = A6;
			break;
		case 027657:
			SB5 = A6;
			break;
		case 027667:
			SB6 = A6;
			break;
		case 027677:
			SB7 = A6;
			break;
		case 027707:
			SB0 = A7;
			break;
		case 027717:
			SB1 = A7;
			break;
		case 027727:
			SB2 = A7;
			break;
		case 027737:
			SB3 = A7;
			break;
		case 027747:
			SB4 = A7;
			break;
		case 027757:
			SB5 = A7;
			break;
		case 027767:
			SB6 = A7;
			break;
		case 027777:
			SB7 = A7;
			break;
		case 030000:
			/* CAL A0 A0 + 1 */
			/* CAL Ai Aj + 1 */
			/* Integer sum of Aj and 1 to Ai. */
			A0++;
			break;
		case 030010:
			/* CAL A0 A1 + 1 */
			A0 = A1 + 1;
			break;
		case 030020:
			/* CAL A0 A2 + 1 */
			A0 = A2 + 1;
			break;
		case 030030:
			/* CAL A0 A3 + 1 */
			A0 = A3 + 1;
			break;
		case 030040:
			/* CAL A0 A4 + 1 */
			A0 = A4 + 1;
			break;
		case 030050:
			/* CAL A0 A5 + 1 */
			A0 = A5 + 1;
			break;
		case 030060:
			/* CAL A0 A6 + 1 */
			A0 = A6 + 1;
			break;
		case 030070:
			/* CAL A0 A7 + 1 */
			A0 = A7 + 1;
			break;
		case 030100:
			/* CAL A1 A0 + 1 */
			A1 = A0 + 1;
			break;
		case 030110:
			/* CAL A1 A1 + 1 */
			A1++;
			break;
		case 030120:
			/* CAL A1 A2 + 1 */
			A1 = A2 + 1;
			break;
		case 030130:
			/* CAL A1 A3 + 1 */
			A1 = A3 + 1;
			break;
		case 030140:
			/* CAL A1 A4 + 1 */
			A1 = A4 + 1;
			break;
		case 030150:
			/* CAL A1 A5 + 1 */
			A1 = A5 + 1;
			break;
		case 030160:
			/* CAL A1 A6 + 1 */
			A1 = A6 + 1;
			break;
		case 030170:
			/* CAL A1 A7 + 1 */
			A1 = A7 + 1;
			break;
		case 030200:
			/* CAL A2 A0 + 1 */
			A2 = A0 + 1;
			break;
		case 030210:
			/* CAL A2 A1 + 1 */
			A2 = A1 + 1;
			break;
		case 030220:
			/* CAL A2 A2 + 1 */
			A2++;
			break;
		case 030230:
			/* CAL A2 A3 + 1 */
			A2 = A3 + 1;
			break;
		case 030240:
			/* CAL A2 A4 + 1 */
			A2 = A4 + 1;
			break;
		case 030250:
			/* CAL A2 A5 + 1 */
			A2 = A5 + 1;
			break;
		case 030260:
			/* CAL A2 A6 + 1 */
			A2 = A6 + 1;
			break;
		case 030270:
			/* CAL A2 A7 + 1 */
			A2 = A7 + 1;
			break;
		case 030300:
			/* CAL A3 A0 + 1 */
			A3 = A0 + 1;
			break;
		case 030310:
			/* CAL A3 A1 + 1 */
			A3 = A1 + 1;
			break;
		case 030320:
			/* CAL A3 A2 + 1 */
			A3 = A2 + 1;
			break;
		case 030330:
			/* CAL A3 A3 + 1 */
			A3++;
			break;
		case 030340:
			/* CAL A3 A4 + 1 */
			A3 = A4 + 1;
			break;
		case 030350:
			/* CAL A3 A5 + 1 */
			A3 = A5 + 1;
			break;
		case 030360:
			/* CAL A3 A6 + 1 */
			A3 = A6 + 1;
			break;
		case 030370:
			/* CAL A3 A7 + 1 */
			A3 = A7 + 1;
			break;
		case 030400:
			/* CAL A4 A0 + 1 */
			A4 = A0 + 1;
			break;
		case 030410:
			/* CAL A4 A1 + 1 */
			A4 = A1 + 1;
			break;
		case 030420:
			/* CAL A4 A2 + 1 */
			A4 = A2 + 1;
			break;
		case 030430:
			/* CAL A4 A3 + 1 */
			A4 = A3 + 1;
			break;
		case 030440:
			/* CAL A4 A4 + 1 */
			A4++;
			break;
		case 030450:
			/* CAL A4 A5 + 1 */
			A4 = A5 + 1;
			break;
		case 030460:
			/* CAL A4 A6 + 1 */
			A4 = A6 + 1;
			break;
		case 030470:
			/* CAL A4 A7 + 1 */
			A4 = A7 + 1;
			break;
		case 030500:
			/* CAL A5 A0 + 1 */
			A5 = A0 + 1;
			break;
		case 030510:
			/* CAL A5 A1 + 1 */
			A5 = A1 + 1;
			break;
		case 030520:
			/* CAL A5 A2 + 1 */
			A5 = A2 + 1;
			break;
		case 030530:
			/* CAL A5 A3 + 1 */
			A5 = A3 + 1;
			break;
		case 030540:
			/* CAL A5 A4 + 1 */
			A5 = A4 + 1;
			break;
		case 030550:
			/* CAL A5 A5 + 1 */
			A5++;
			break;
		case 030560:
			/* CAL A5 A6 + 1 */
			A5 = A6 + 1;
			break;
		case 030570:
			/* CAL A5 A7 + 1 */
			A5 = A7 + 1;
			break;
		case 030600:
			/* CAL A6 A0 + 1 */
			A6 = A0 + 1;
			break;
		case 030610:
			/* CAL A6 A1 + 1 */
			A6 = A1 + 1;
			break;
		case 030620:
			/* CAL A6 A2 + 1 */
			A6 = A2 + 1;
			break;
		case 030630:
			/* CAL A6 A3 + 1 */
			A6 = A3 + 1;
			break;
		case 030640:
			/* CAL A6 A4 + 1 */
			A6 = A4 + 1;
			break;
		case 030650:
			/* CAL A6 A5 + 1 */
			A6 = A5 + 1;
			break;
		case 030660:
			/* CAL A6 A6 + 1 */
			A6++;
			break;
		case 030670:
			/* CAL A6 A7 + 1 */
			A6 = A7 + 1;
			break;
		case 030700:
			/* CAL A7 A0 + 1 */
			A7 = A0 + 1;
			break;
		case 030710:
			/* CAL A7 A1 + 1 */
			A7 = A1 + 1;
			break;
		case 030720:
			/* CAL A7 A2 + 1 */
			A7 = A2 + 1;
			break;
		case 030730:
			/* CAL A7 A3 + 1 */
			A7 = A3 + 1;
			break;
		case 030740:
			/* CAL A7 A4 + 1 */
			A7 = A4 + 1;
			break;
		case 030750:
			/* CAL A7 A5 + 1 */
			A7 = A5 + 1;
			break;
		case 030760:
			/* CAL A7 A6 + 1 */
			A7 = A6 + 1;
			break;
		case 030770:
			/* CAL A7 A7 + 1 */
			A7++;
			break;
		case 030011:
			/* CAL Ai Aj+Ak */
			/* CAL A0 A1+A1 */
			A0 = A1 + A1;
			break;
		case 030012:
			A0 = A1 + A2;
			break;
		case 030013:
			A0 = A1 + A3;
			break;
		case 030014:
			A0 = A1 + A4;
			break;
		case 030015:
			A0 = A1 + A5;
			break;
		case 030016:
			A0 = A1 + A6;
			break;
		case 030017:
			A0 = A1 + A7;
			break;
		case 030021:
			A0 = A2 + A1;
			break;
		case 030022:
			A0 = A2 + A2;
			break;
		case 030023:
			A0 = A2 + A3;
			break;
		case 030024:
			A0 = A2 + A4;
			break;
		case 030025:
			A0 = A2 + A5;
			break;
		case 030026:
			A0 = A2 + A6;
			break;
		case 030027:
			A0 = A2 + A7;
			break;
		case 030031:
			A0 = A3 + A1;
			break;
		case 030032:
			A0 = A3 + A2;
			break;
		case 030033:
			A0 = A3 + A3;
			break;
		case 030034:
			A0 = A3 + A4;
			break;
		case 030035:
			A0 = A3 + A5;
			break;
		case 030036:
			A0 = A3 + A6;
			break;
		case 030037:
			A0 = A3 + A7;
			break;
		case 030041:
			A0 = A4 + A1;
			break;
		case 030042:
			A0 = A4 + A2;
			break;
		case 030043:
			A0 = A4 + A3;
			break;
		case 030044:
			A0 = A4 + A4;
			break;
		case 030045:
			A0 = A4 + A5;
			break;
		case 030046:
			A0 = A4 + A6;
			break;
		case 030047:
			A0 = A4 + A7;
			break;
		case 030051:
			A0 = A5 + A1;
			break;
		case 030052:
			A0 = A5 + A2;
			break;
		case 030053:
			A0 = A5 + A3;
			break;
		case 030054:
			A0 = A5 + A4;
			break;
		case 030055:
			A0 = A5 + A5;
			break;
		case 030056:
			A0 = A5 + A6;
			break;
		case 030057:
			A0 = A5 + A7;
			break;
		case 030061:
			A0 = A6 + A1;
			break;
		case 030062:
			A0 = A6 + A2;
			break;
		case 030063:
			A0 = A6 + A3;
			break;
		case 030064:
			A0 = A6 + A4;
			break;
		case 030065:
			A0 = A6 + A5;
			break;
		case 030066:
			A0 = A6 + A6;
			break;
		case 030067:
			A0 = A6 + A7;
			break;
		case 030071:
			A0 = A7 + A1;
			break;
		case 030072:
			A0 = A7 + A2;
			break;
		case 030073:
			A0 = A7 + A3;
			break;
		case 030074:
			A0 = A7 + A4;
			break;
		case 030075:
			A0 = A7 + A5;
			break;
		case 030076:
			A0 = A7 + A6;
			break;
		case 030077:
			A0 = A7 + A7;
			break;
		case 030111:
			A1 = A1 + A1;
			break;
		case 030112:
			A1 = A1 + A2;
			break;
		case 030113:
			A1 = A1 + A3;
			break;
		case 030114:
			A1 = A1 + A4;
			break;
		case 030115:
			A1 = A1 + A5;
			break;
		case 030116:
			A1 = A1 + A6;
			break;
		case 030117:
			A1 = A1 + A7;
			break;
		case 030121:
			A1 = A2 + A1;
			break;
		case 030122:
			A1 = A2 + A2;
			break;
		case 030123:
			A1 = A2 + A3;
			break;
		case 030124:
			A1 = A2 + A4;
			break;
		case 030125:
			A1 = A2 + A5;
			break;
		case 030126:
			A1 = A2 + A6;
			break;
		case 030127:
			A1 = A2 + A7;
			break;
		case 030131:
			A1 = A3 + A1;
			break;
		case 030132:
			A1 = A3 + A2;
			break;
		case 030133:
			A1 = A3 + A3;
			break;
		case 030134:
			A1 = A3 + A4;
			break;
		case 030135:
			A1 = A3 + A5;
			break;
		case 030136:
			A1 = A3 + A6;
			break;
		case 030137:
			A1 = A3 + A7;
			break;
		case 030141:
			A1 = A4 + A1;
			break;
		case 030142:
			A1 = A4 + A2;
			break;
		case 030143:
			A1 = A4 + A3;
			break;
		case 030144:
			A1 = A4 + A4;
			break;
		case 030145:
			A1 = A4 + A5;
			break;
		case 030146:
			A1 = A4 + A6;
			break;
		case 030147:
			A1 = A4 + A7;
			break;
		case 030151:
			A1 = A5 + A1;
			break;
		case 030152:
			A1 = A5 + A2;
			break;
		case 030153:
			A1 = A5 + A3;
			break;
		case 030154:
			A1 = A5 + A4;
			break;
		case 030155:
			A1 = A5 + A5;
			break;
		case 030156:
			A1 = A5 + A6;
			break;
		case 030157:
			A1 = A5 + A7;
			break;
		case 030161:
			A1 = A6 + A1;
			break;
		case 030162:
			A1 = A6 + A2;
			break;
		case 030163:
			A1 = A6 + A3;
			break;
		case 030164:
			A1 = A6 + A4;
			break;
		case 030165:
			A1 = A6 + A5;
			break;
		case 030166:
			A1 = A6 + A6;
			break;
		case 030167:
			A1 = A6 + A7;
			break;
		case 030171:
			A1 = A7 + A1;
			break;
		case 030172:
			A1 = A7 + A2;
			break;
		case 030173:
			A1 = A7 + A3;
			break;
		case 030174:
			A1 = A7 + A4;
			break;
		case 030175:
			A1 = A7 + A5;
			break;
		case 030176:
			A1 = A7 + A6;
			break;
		case 030177:
			A1 = A7 + A7;
			break;
		case 030211:
			A2 = A1 + A1;
			break;
		case 030212:
			A2 = A1 + A2;
			break;
		case 030213:
			A2 = A1 + A3;
			break;
		case 030214:
			A2 = A1 + A4;
			break;
		case 030215:
			A2 = A1 + A5;
			break;
		case 030216:
			A2 = A1 + A6;
			break;
		case 030217:
			A2 = A1 + A7;
			break;
		case 030221:
			A2 = A2 + A1;
			break;
		case 030222:
			A2 = A2 + A2;
			break;
		case 030223:
			A2 = A2 + A3;
			break;
		case 030224:
			A2 = A2 + A4;
			break;
		case 030225:
			A2 = A2 + A5;
			break;
		case 030226:
			A2 = A2 + A6;
			break;
		case 030227:
			A2 = A2 + A7;
			break;
		case 030231:
			A2 = A3 + A1;
			break;
		case 030232:
			A2 = A3 + A2;
			break;
		case 030233:
			A2 = A3 + A3;
			break;
		case 030234:
			A2 = A3 + A4;
			break;
		case 030235:
			A2 = A3 + A5;
			break;
		case 030236:
			A2 = A3 + A6;
			break;
		case 030237:
			A2 = A3 + A7;
			break;
		case 030241:
			A2 = A4 + A1;
			break;
		case 030242:
			A2 = A4 + A2;
			break;
		case 030243:
			A2 = A4 + A3;
			break;
		case 030244:
			A2 = A4 + A4;
			break;
		case 030245:
			A2 = A4 + A5;
			break;
		case 030246:
			A2 = A4 + A6;
			break;
		case 030247:
			A2 = A4 + A7;
			break;
		case 030251:
			A2 = A5 + A1;
			break;
		case 030252:
			A2 = A5 + A2;
			break;
		case 030253:
			A2 = A5 + A3;
			break;
		case 030254:
			A2 = A5 + A4;
			break;
		case 030255:
			A2 = A5 + A5;
			break;
		case 030256:
			A2 = A5 + A6;
			break;
		case 030257:
			A2 = A5 + A7;
			break;
		case 030261:
			A2 = A6 + A1;
			break;
		case 030262:
			A2 = A6 + A2;
			break;
		case 030263:
			A2 = A6 + A3;
			break;
		case 030264:
			A2 = A6 + A4;
			break;
		case 030265:
			A2 = A6 + A5;
			break;
		case 030266:
			A2 = A6 + A6;
			break;
		case 030267:
			A2 = A6 + A7;
			break;
		case 030271:
			A2 = A7 + A1;
			break;
		case 030272:
			A2 = A7 + A2;
			break;
		case 030273:
			A2 = A7 + A3;
			break;
		case 030274:
			A2 = A7 + A4;
			break;
		case 030275:
			A2 = A7 + A5;
			break;
		case 030276:
			A2 = A7 + A6;
			break;
		case 030277:
			A2 = A7 + A7;
			break;
		case 030311:
			A3 = A1 + A1;
			break;
		case 030312:
			A3 = A1 + A2;
			break;
		case 030313:
			A3 = A1 + A3;
			break;
		case 030314:
			A3 = A1 + A4;
			break;
		case 030315:
			A3 = A1 + A5;
			break;
		case 030316:
			A3 = A1 + A6;
			break;
		case 030317:
			A3 = A1 + A7;
			break;
		case 030321:
			A3 = A2 + A1;
			break;
		case 030322:
			A3 = A2 + A2;
			break;
		case 030323:
			A3 = A2 + A3;
			break;
		case 030324:
			A3 = A2 + A4;
			break;
		case 030325:
			A3 = A2 + A5;
			break;
		case 030326:
			A3 = A2 + A6;
			break;
		case 030327:
			A3 = A2 + A7;
			break;
		case 030331:
			A3 = A3 + A1;
			break;
		case 030332:
			A3 = A3 + A2;
			break;
		case 030333:
			A3 = A3 + A3;
			break;
		case 030334:
			A3 = A3 + A4;
			break;
		case 030335:
			A3 = A3 + A5;
			break;
		case 030336:
			A3 = A3 + A6;
			break;
		case 030337:
			A3 = A3 + A7;
			break;
		case 030341:
			A3 = A4 + A1;
			break;
		case 030342:
			A3 = A4 + A2;
			break;
		case 030343:
			A3 = A4 + A3;
			break;
		case 030344:
			A3 = A4 + A4;
			break;
		case 030345:
			A3 = A4 + A5;
			break;
		case 030346:
			A3 = A4 + A6;
			break;
		case 030347:
			A3 = A4 + A7;
			break;
		case 030351:
			A3 = A5 + A1;
			break;
		case 030352:
			A3 = A5 + A2;
			break;
		case 030353:
			A3 = A5 + A3;
			break;
		case 030354:
			A3 = A5 + A4;
			break;
		case 030355:
			A3 = A5 + A5;
			break;
		case 030356:
			A3 = A5 + A6;
			break;
		case 030357:
			A3 = A5 + A7;
			break;
		case 030361:
			A3 = A6 + A1;
			break;
		case 030362:
			A3 = A6 + A2;
			break;
		case 030363:
			A3 = A6 + A3;
			break;
		case 030364:
			A3 = A6 + A4;
			break;
		case 030365:
			A3 = A6 + A5;
			break;
		case 030366:
			A3 = A6 + A6;
			break;
		case 030367:
			A3 = A6 + A7;
			break;
		case 030371:
			A3 = A7 + A1;
			break;
		case 030372:
			A3 = A7 + A2;
			break;
		case 030373:
			A3 = A7 + A3;
			break;
		case 030374:
			A3 = A7 + A4;
			break;
		case 030375:
			A3 = A7 + A5;
			break;
		case 030376:
			A3 = A7 + A6;
			break;
		case 030377:
			A3 = A7 + A7;
			break;
		case 030411:
			A4 = A1 + A1;
			break;
		case 030412:
			A4 = A1 + A2;
			break;
		case 030413:
			A4 = A1 + A3;
			break;
		case 030414:
			A4 = A1 + A4;
			break;
		case 030415:
			A4 = A1 + A5;
			break;
		case 030416:
			A4 = A1 + A6;
			break;
		case 030417:
			A4 = A1 + A7;
			break;
		case 030421:
			A4 = A2 + A1;
			break;
		case 030422:
			A4 = A2 + A2;
			break;
		case 030423:
			A4 = A2 + A3;
			break;
		case 030424:
			A4 = A2 + A4;
			break;
		case 030425:
			A4 = A2 + A5;
			break;
		case 030426:
			A4 = A2 + A6;
			break;
		case 030427:
			A4 = A2 + A7;
			break;
		case 030431:
			A4 = A3 + A1;
			break;
		case 030432:
			A4 = A3 + A2;
			break;
		case 030433:
			A4 = A3 + A3;
			break;
		case 030434:
			A4 = A3 + A4;
			break;
		case 030435:
			A4 = A3 + A5;
			break;
		case 030436:
			A4 = A3 + A6;
			break;
		case 030437:
			A4 = A3 + A7;
			break;
		case 030441:
			A4 = A4 + A1;
			break;
		case 030442:
			A4 = A4 + A2;
			break;
		case 030443:
			A4 = A4 + A3;
			break;
		case 030444:
			A4 = A4 + A4;
			break;
		case 030445:
			A4 = A4 + A5;
			break;
		case 030446:
			A4 = A4 + A6;
			break;
		case 030447:
			A4 = A4 + A7;
			break;
		case 030451:
			A4 = A5 + A1;
			break;
		case 030452:
			A4 = A5 + A2;
			break;
		case 030453:
			A4 = A5 + A3;
			break;
		case 030454:
			A4 = A5 + A4;
			break;
		case 030455:
			A4 = A5 + A5;
			break;
		case 030456:
			A4 = A5 + A6;
			break;
		case 030457:
			A4 = A5 + A7;
			break;
		case 030461:
			A4 = A6 + A1;
			break;
		case 030462:
			A4 = A6 + A2;
			break;
		case 030463:
			A4 = A6 + A3;
			break;
		case 030464:
			A4 = A6 + A4;
			break;
		case 030465:
			A4 = A6 + A5;
			break;
		case 030466:
			A4 = A6 + A6;
			break;
		case 030467:
			A4 = A6 + A7;
			break;
		case 030471:
			A4 = A7 + A1;
			break;
		case 030472:
			A4 = A7 + A2;
			break;
		case 030473:
			A4 = A7 + A3;
			break;
		case 030474:
			A4 = A7 + A4;
			break;
		case 030475:
			A4 = A7 + A5;
			break;
		case 030476:
			A4 = A7 + A6;
			break;
		case 030477:
			A4 = A7 + A7;
			break;
		case 030511:
			A5 = A1 + A1;
			break;
		case 030512:
			A5 = A1 + A2;
			break;
		case 030513:
			A5 = A1 + A3;
			break;
		case 030514:
			A5 = A1 + A4;
			break;
		case 030515:
			A5 = A1 + A5;
			break;
		case 030516:
			A5 = A1 + A6;
			break;
		case 030517:
			A5 = A1 + A7;
			break;
		case 030521:
			A5 = A2 + A1;
			break;
		case 030522:
			A5 = A2 + A2;
			break;
		case 030523:
			A5 = A2 + A3;
			break;
		case 030524:
			A5 = A2 + A4;
			break;
		case 030525:
			A5 = A2 + A5;
			break;
		case 030526:
			A5 = A2 + A6;
			break;
		case 030527:
			A5 = A2 + A7;
			break;
		case 030531:
			A5 = A3 + A1;
			break;
		case 030532:
			A5 = A3 + A2;
			break;
		case 030533:
			A5 = A3 + A3;
			break;
		case 030534:
			A5 = A3 + A4;
			break;
		case 030535:
			A5 = A3 + A5;
			break;
		case 030536:
			A5 = A3 + A6;
			break;
		case 030537:
			A5 = A3 + A7;
			break;
		case 030541:
			A5 = A4 + A1;
			break;
		case 030542:
			A5 = A4 + A2;
			break;
		case 030543:
			A5 = A4 + A3;
			break;
		case 030544:
			A5 = A4 + A4;
			break;
		case 030545:
			A5 = A4 + A5;
			break;
		case 030546:
			A5 = A4 + A6;
			break;
		case 030547:
			A5 = A4 + A7;
			break;
		case 030551:
			A5 = A5 + A1;
			break;
		case 030552:
			A5 = A5 + A2;
			break;
		case 030553:
			A5 = A5 + A3;
			break;
		case 030554:
			A5 = A5 + A4;
			break;
		case 030555:
			A5 = A5 + A5;
			break;
		case 030556:
			A5 = A5 + A6;
			break;
		case 030557:
			A5 = A5 + A7;
			break;
		case 030561:
			A5 = A6 + A1;
			break;
		case 030562:
			A5 = A6 + A2;
			break;
		case 030563:
			A5 = A6 + A3;
			break;
		case 030564:
			A5 = A6 + A4;
			break;
		case 030565:
			A5 = A6 + A5;
			break;
		case 030566:
			A5 = A6 + A6;
			break;
		case 030567:
			A5 = A6 + A7;
			break;
		case 030571:
			A5 = A7 + A1;
			break;
		case 030572:
			A5 = A7 + A2;
			break;
		case 030573:
			A5 = A7 + A3;
			break;
		case 030574:
			A5 = A7 + A4;
			break;
		case 030575:
			A5 = A7 + A5;
			break;
		case 030576:
			A5 = A7 + A6;
			break;
		case 030577:
			A5 = A7 + A7;
			break;
		case 030611:
			A6 = A1 + A1;
			break;
		case 030612:
			A6 = A1 + A2;
			break;
		case 030613:
			A6 = A1 + A3;
			break;
		case 030614:
			A6 = A1 + A4;
			break;
		case 030615:
			A6 = A1 + A5;
			break;
		case 030616:
			A6 = A1 + A6;
			break;
		case 030617:
			A6 = A1 + A7;
			break;
		case 030621:
			A6 = A2 + A1;
			break;
		case 030622:
			A6 = A2 + A2;
			break;
		case 030623:
			A6 = A2 + A3;
			break;
		case 030624:
			A6 = A2 + A4;
			break;
		case 030625:
			A6 = A2 + A5;
			break;
		case 030626:
			A6 = A2 + A6;
			break;
		case 030627:
			A6 = A2 + A7;
			break;
		case 030631:
			A6 = A3 + A1;
			break;
		case 030632:
			A6 = A3 + A2;
			break;
		case 030633:
			A6 = A3 + A3;
			break;
		case 030634:
			A6 = A3 + A4;
			break;
		case 030635:
			A6 = A3 + A5;
			break;
		case 030636:
			A6 = A3 + A6;
			break;
		case 030637:
			A6 = A3 + A7;
			break;
		case 030641:
			A6 = A4 + A1;
			break;
		case 030642:
			A6 = A4 + A2;
			break;
		case 030643:
			A6 = A4 + A3;
			break;
		case 030644:
			A6 = A4 + A4;
			break;
		case 030645:
			A6 = A4 + A5;
			break;
		case 030646:
			A6 = A4 + A6;
			break;
		case 030647:
			A6 = A4 + A7;
			break;
		case 030651:
			A6 = A5 + A1;
			break;
		case 030652:
			A6 = A5 + A2;
			break;
		case 030653:
			A6 = A5 + A3;
			break;
		case 030654:
			A6 = A5 + A4;
			break;
		case 030655:
			A6 = A5 + A5;
			break;
		case 030656:
			A6 = A5 + A6;
			break;
		case 030657:
			A6 = A5 + A7;
			break;
		case 030661:
			A6 = A6 + A1;
			break;
		case 030662:
			A6 = A6 + A2;
			break;
		case 030663:
			A6 = A6 + A3;
			break;
		case 030664:
			A6 = A6 + A4;
			break;
		case 030665:
			A6 = A6 + A5;
			break;
		case 030666:
			A6 = A6 + A6;
			break;
		case 030667:
			A6 = A6 + A7;
			break;
		case 030671:
			A6 = A7 + A1;
			break;
		case 030672:
			A6 = A7 + A2;
			break;
		case 030673:
			A6 = A7 + A3;
			break;
		case 030674:
			A6 = A7 + A4;
			break;
		case 030675:
			A6 = A7 + A5;
			break;
		case 030676:
			A6 = A7 + A6;
			break;
		case 030677:
			A6 = A7 + A7;
			break;
		case 030711:
			A7 = A1 + A1;
			break;
		case 030712:
			A7 = A1 + A2;
			break;
		case 030713:
			A7 = A1 + A3;
			break;
		case 030714:
			A7 = A1 + A4;
			break;
		case 030715:
			A7 = A1 + A5;
			break;
		case 030716:
			A7 = A1 + A6;
			break;
		case 030717:
			A7 = A1 + A7;
			break;
		case 030721:
			A7 = A2 + A1;
			break;
		case 030722:
			A7 = A2 + A2;
			break;
		case 030723:
			A7 = A2 + A3;
			break;
		case 030724:
			A7 = A2 + A4;
			break;
		case 030725:
			A7 = A2 + A5;
			break;
		case 030726:
			A7 = A2 + A6;
			break;
		case 030727:
			A7 = A2 + A7;
			break;
		case 030731:
			A7 = A3 + A1;
			break;
		case 030732:
			A7 = A3 + A2;
			break;
		case 030733:
			A7 = A3 + A3;
			break;
		case 030734:
			A7 = A3 + A4;
			break;
		case 030735:
			A7 = A3 + A5;
			break;
		case 030736:
			A7 = A3 + A6;
			break;
		case 030737:
			A7 = A3 + A7;
			break;
		case 030741:
			A7 = A4 + A1;
			break;
		case 030742:
			A7 = A4 + A2;
			break;
		case 030743:
			A7 = A4 + A3;
			break;
		case 030744:
			A7 = A4 + A4;
			break;
		case 030745:
			A7 = A4 + A5;
			break;
		case 030746:
			A7 = A4 + A6;
			break;
		case 030747:
			A7 = A4 + A7;
			break;
		case 030751:
			A7 = A5 + A1;
			break;
		case 030752:
			A7 = A5 + A2;
			break;
		case 030753:
			A7 = A5 + A3;
			break;
		case 030754:
			A7 = A5 + A4;
			break;
		case 030755:
			A7 = A5 + A5;
			break;
		case 030756:
			A7 = A5 + A6;
			break;
		case 030757:
			A7 = A5 + A7;
			break;
		case 030761:
			A7 = A6 + A1;
			break;
		case 030762:
			A7 = A6 + A2;
			break;
		case 030763:
			A7 = A6 + A3;
			break;
		case 030764:
			A7 = A6 + A4;
			break;
		case 030765:
			A7 = A6 + A5;
			break;
		case 030766:
			A7 = A6 + A6;
			break;
		case 030767:
			A7 = A6 + A7;
			break;
		case 030771:
			A7 = A7 + A1;
			break;
		case 030772:
			A7 = A7 + A2;
			break;
		case 030773:
			A7 = A7 + A3;
			break;
		case 030774:
			A7 = A7 + A4;
			break;
		case 030775:
			A7 = A7 + A5;
			break;
		case 030776:
			A7 = A7 + A6;
			break;
		case 030777:
			A7 = A7 + A7;
			break;
		case 030001:
			/* CAL A0 A1 */
			/* CAL Ai Ak */
			/* Transmits Ak to Ai */
			A1 = A0;
			break;
		case 030002:
			/* CAL A0 A2 */
			A2 = A0;
			break;
		case 030003:
			/* CAL A0 A3 */
			A3 = A0;
			break;
		case 030004:
			/* CAL A0 A4 */
			A4 = A0;
			break;
		case 030005:
			/* CAL A0 A5 */
			A5 = A0;
			break;
		case 030006:
			/* CAL A0 A6 */
			A6 = A0;
			break;
		case 030007:
			/* CAL A0 A7 */
			A7 = A0;
			break;
		case 030102:
			/* CAL A1 A2 */
			A2 = A1;
			break;
		case 030103:
			/* CAL A1 A3 */
			A3 = A1;
			break;
		case 030104:
			/* CAL A1 A4 */
			A4 = A1;
			break;
		case 030105:
			/* CAL A1 A5 */
			A5 = A1;
			break;
		case 030106:
			/* CAL A1 A6 */
			A6 = A1;
			break;
		case 030107:
			/* CAL A1 A7 */
			A7 = A1;
			break;
		case 030201:
			/* CAL A2 A1 */
			A1 = A2;
			break;
		case 030203:
			/* CAL A2 A3 */
			A3 = A2;
			break;
		case 030204:
			/* CAL A2 A4 */
			A4 = A2;
			break;
		case 030205:
			/* CAL A2 A5 */
			A5 = A2;
			break;
		case 030206:
			/* CAL A2 A6 */
			A6 = A2;
			break;
		case 030207:
			/* CAL A2 A7 */
			A7 = A2;
			break;
		case 030301:
			/* CAl A3 A1 */
			A1 = A3;
			break;
		case 030302:
			/* CAL A3 A2 */
			A2 = A3;
			break;
		case 030304:
			/* CAL A3 A4 */
			A4 = A3;
			break;
		case 030305:
			/* CAL A3 A5 */
			A5 = A3;
			break;
		case 030306:
			/* CAL A3 A6 */
			A6 = A3;
			break;
		case 030307:
			/* CAL A3 A7 */
			A7 = A3;
			break;
		case 030401:
			/* CAL A4 A1 */
			A1 = A4;
			break;
		case 030402:
			/* CAL A4 A2 */
			A2 = A4;
			break;
		case 030403:
			/* CAL A4 A3 */
			A3 = A4;
			break;
		case 030405:
			/* CAL A4 A5 */
			A5 = A4;
			break;
		case 030406:
			/* CAL A4 A6 */
			A6 = A4;
			break;
		case 030407:
			/* CAL A4 A7 */
			A7 = A4;
			break;
		case 030501:
			/* CAL A5 A1 */
			A1 = A5;
			break;
		case 030502:
			/* CAL A5 A2 */
			A2 = A5;
			break;
		case 030503:
			/* CAL A5 A3 */
			A3 = A5;
			break;
		case 030504:
			/* CAL A5 A4 */
			A4 = A5;
			break;
		case 030506:
			/* CAL A5 A6 */
			A6 = A5;
			break;
		case 030507:
			/* CAL A5 A7 */
			A7 = A5;
			break;
		case 030601:
			/* CAL A6 A1 */
			A1 = A6;
			break;
		case 030602:
			/* CAL A6 A2 */
			A2 = A6;
			break;
		case 030603:
			/* CAL A6 A3 */
			A3 = A6;
			break;
		case 030604:
			/* CAL A6 A4 */
			A4 = A6;
			break;
		case 030605:
			/* CAL A6 A5 */
			A5 = A6;
			break;
		case 030607:
			/* CAL A6 A7 */
			A7 = A6;
			break;
		case 030701:
			/* CAL A7 A1 */
			A1 = A7;
			break;
		case 030702:
			/* CAL A7 A2 */
			A2 = A7;
			break;
		case 030703:
			/* CAL A7 A3 */
			A3 = A7;
			break;
		case 030704:
			/* CAL A7 A4 */
			A4 = A7;
			break;
		case 030705:
			/* CAL A7 A5 */
			A5 = A7;
			break;
		case 030706:
			/* CAL A7 A6 */
			A6 = A7;
			break;
		/* case 031001: SUSPECT */
			/* CAL Ai Aj-Ak */
			/* CAL A0 A0-A1 */
			/* A0 = A0 - A1;
			break; */
		/* case 031002: SUSPECT
			A0 = A0 - A2;
			break;
		case 031003:
			A0 = A0 - A3;
			break;
		case 031004:
			A0 = A0 - A4;
			break;
		case 031005:
			A0 = A0 - A5;
			break;
		case 031006:
			A0 = A0 - A6;
			break;
		case 031007:
			A0 = A0 - A7;
			break; */
		case 031011:
			A0 = A1 - A1;
			break;
		case 031012:
			A0 = A1 - A2;
			break;
		case 031013:
			A0 = A1 - A3;
			break;
		case 031014:
			A0 = A1 - A4;
			break;
		case 031015:
			A0 = A1 - A5;
			break;
		case 031016:
			A0 = A1 - A6;
			break;
		case 031017:
			A0 = A1 - A7;
			break;
		case 031021:
			A0 = A2 - A1;
			break;
		case 031022:
			A0 = A2 - A2;
			break;
		case 031023:
			A0 = A2 - A3;
			break;
		case 031024:
			A0 = A2 - A4;
			break;
		case 031025:
			A0 = A2 - A5;
			break;
		case 031026:
			A0 = A2 - A6;
			break;
		case 031027:
			A0 = A2 - A7;
			break;
		case 031031:
			A0 = A3 - A1;
			break;
		case 031032:
			A0 = A3 - A2;
			break;
		case 031033:
			A0 = A3 - A3;
			break;
		case 031034:
			A0 = A3 - A4;
			break;
		case 031035:
			A0 = A3 - A5;
			break;
		case 031036:
			A0 = A3 - A6;
			break;
		case 031037:
			A0 = A3 - A7;
			break;
		case 031041:
			A0 = A4 - A1;
			break;
		case 031042:
			A0 = A4 - A2;
			break;
		case 031043:
			A0 = A4 - A3;
			break;
		case 031044:
			A0 = A4 - A4;
			break;
		case 031045:
			A0 = A4 - A5;
			break;
		case 031046:
			A0 = A4 - A6;
			break;
		case 031047:
			A0 = A4 - A7;
			break;
		case 031051:
			A0 = A5 - A1;
			break;
		case 031052:
			A0 = A5 - A2;
			break;
		case 031053:
			A0 = A5 - A3;
			break;
		case 031054:
			A0 = A5 - A4;
			break;
		case 031055:
			A0 = A5 - A5;
			break;
		case 031056:
			A0 = A5 - A6;
			break;
		case 031057:
			A0 = A5 - A7;
			break;
		case 031061:
			A0 = A6 - A1;
			break;
		case 031062:
			A0 = A6 - A2;
			break;
		case 031063:
			A0 = A6 - A3;
			break;
		case 031064:
			A0 = A6 - A4;
			break;
		case 031065:
			A0 = A6 - A5;
			break;
		case 031066:
			A0 = A6 - A6;
			break;
		case 031067:
			A0 = A6 - A7;
			break;
		case 031071:
			A0 = A7 - A1;
			break;
		case 031072:
			A0 = A7 - A2;
			break;
		case 031073:
			A0 = A7 - A3;
			break;
		case 031074:
			A0 = A7 - A4;
			break;
		case 031075:
			A0 = A7 - A5;
			break;
		case 031076:
			A0 = A7 - A6;
			break;
		case 031077:
			A0 = A7 - A7;
			break;
		/* case 031101: SUSPECT
			A1 = A0 - A1;
			break;
		case 031102:
			A1 = A0 - A2;
			break;
		case 031103:
			A1 = A0 - A3;
			break;
		case 031104:
			A1 = A0 - A4;
			break;
		case 031105:
			A1 = A0 - A5;
			break;
		case 031106:
			A1 = A0 - A6;
			break;
		case 031107:
			A1 = A0 - A7;
			break; */
		case 031111:
			A1 = A1 - A1;
			break;
		case 031112:
			A1 = A1 - A2;
			break;
		case 031113:
			A1 = A1 - A3;
			break;
		case 031114:
			A1 = A1 - A4;
			break;
		case 031115:
			A1 = A1 - A5;
			break;
		case 031116:
			A1 = A1 - A6;
			break;
		case 031117:
			A1 = A1 - A7;
			break;
		case 031121:
			A1 = A2 - A1;
			break;
		case 031122:
			A1 = A2 - A2;
			break;
		case 031123:
			A1 = A2 - A3;
			break;
		case 031124:
			A1 = A2 - A3;
			break;
		case 031125:
			A1 = A2 - A5;
			break;
		case 031126:
			A1 = A2 - A6;
			break;
		case 031127:
			A1 = A2 - A7;
			break;
		case 031131:
			A1 = A3 - A1;
			break;
		case 031132:
			A1 = A3 - A2;
			break;
		case 031133:
			A1 = A3 - A3;
			break;
		case 031134:
			A1 = A3 - A4;
			break;
		case 031135:
			A1 = A3 - A5;
			break;
		case 031136:
			A1 = A3 - A6;
			break;
		case 031137:
			A1 = A3 - A7;
			break;
		case 031141:
			A1 = A4 - A1;
			break;
		case 031142:
			A1 = A4 - A2;
			break;
		case 031143:
			A1 = A4 - A3;
			break;
		case 031144:
			A1 = A4 - A4;
			break;
		case 031145:
			A1 = A4 - A5;
			break;
		case 031146:
			A1 = A4 - A6;
			break;
		case 031147:
			A1 = A4 - A7;
			break;
		case 031151:
			A1 = A5 - A1;
			break;
		case 031152:
			A1 = A5 - A2;
			break;
		case 031153:
			A1 = A5 - A3;
			break;
		case 031154:
			A1 = A5 - A4;
			break;
		case 031155:
			A1 = A5 - A5;
			break;
		case 031156:
			A1 = A5 - A6;
			break;
		case 031157:
			A1 = A5 - A7;
			break;
		case 031161:
			A1 = A6 - A1;
			break;
		case 031162:
			A1 = A6 - A2;
			break;
		case 031163:
			A1 = A6 - A3;
			break;
		case 031164:
			A1 = A6 - A4;
			break;
		case 031165:
			A1 = A6 - A5;
			break;
		case 031166:
			A1 = A6 - A6;
			break;
		case 031167:
			A1 = A6 - A7;
			break;
		case 031171:
			A1 = A7 - A1;
			break;
		case 031172:
			A1 = A7 - A2;
			break;
		case 031173:
			A1 = A7 - A3;
			break;
		case 031174:
			A1 = A7 - A4;
			break;
		case 031175:
			A1 = A7 - A5;
			break;
		case 031176:
			A1 = A7 - A6;
			break;
		case 031177:
			A1 = A7 - A7;
			break;
		/* case 031201:
			A2 = A0 - A1;
			break;
		case 031202:
			A2 = A0 - A2;
			break;
		case 031203:
			A2 = A0 - A3;
			break;
		case 031204:
			A2 = A0 - A4;
			break;
		case 031205:
			A2 = A0 - A5;
			break;
		case 031206:
			A2 = A0 - A6;
			break;
		case 031207:
			A2 = A0 - A7;
			break; */
		case 031211:
			A2 = A1 - A1;
			break;
		case 031212:
			A2 = A1 - A2;
			break;
		case 031213:
			A2 = A1 - A3;
			break;
		case 031214:
			A2 = A1 - A4;
			break;
		case 031215:
			A2 = A1 - A5;
			break;
		case 031216:
			A2 = A1 - A6;
			break;
		case 031217:
			A2 = A1 - A7;
			break;
		case 031221:
			A2 = A2 - A1;
			break;
		case 031222:
			A2 = A2 - A2;
			break;
		case 031223:
			A2 = A2 - A3;
			break;
		case 031224:
			A2 = A2 - A4;
			break;
		case 031225:
			A2 = A2 - A5;
			break;
		case 031226:
			A2 = A2 - A6;
			break;
		case 031227:
			A2 = A2 - A7;
			break;
		case 031231:
			A2 = A3 - A1;
			break;
		case 031232:
			A2 = A3 - A2;
			break;
		case 031233:
			A2 = A3 - A3;
			break;
		case 031234:
			A2 = A3 - A4;
			break;
		case 031235:
			A2 = A3 - A5;
			break;
		case 031236:
			A2 = A3 - A6;
			break;
		case 031237:
			A2 = A3 - A7;
			break;
		case 031241:
			A2 = A4 - A1;
			break;
		case 031242:
			A2 = A4 - A2;
			break;
		case 031243:
			A2 = A4 - A3;
			break;
		case 031244:
			A2 = A4 - A4;
			break;
		case 031245:
			A2 = A4 - A5;
			break;
		case 031246:
			A2 = A4 - A6;
			break;
		case 031247:
			A2 = A4 - A7;
			break;
		case 031251:
			A2 = A5 - A1;
			break;
		case 031252:
			A2 = A5 - A2;
			break;
		case 031253:
			A2 = A5 - A3;
			break;
		case 031254:
			A2 = A5 - A4;
			break;
		case 031255:
			A2 = A5 - A5;
			break;
		case 031256:
			A2 = A5 - A6;
			break;
		case 031257:
			A2 = A5 - A7;
			break;
		case 031261:
			A2 = A6 - A1;
			break;
		case 031262:
			A2 = A6 - A2;
			break;
		case 031263:
			A2 = A6 - A3;
			break;
		case 031264:
			A2 = A6 - A4;
			break;
		case 031265:
			A2 = A6 - A5;
			break;
		case 031266:
			A2 = A6 - A6;
			break;
		case 031267:
			A2 = A6 - A7;
			break;
		case 031271:
			A2 = A7 - A1;
			break;
		case 031272:
			A2 = A7 - A2;
			break;
		case 031273:
			A2 = A7 - A3;
			break;
		case 031274:
			A2 = A7 - A4;
			break;
		case 031275:
			A2 = A7 - A5;
			break;
		case 031276:
			A2 = A7 - A6;
			break;
		case 031277:
			A2 = A7 - A7;
			break;
		/* case 031301: SUSPECT
			A3 = A0 - A1;
			break;
		case 031302:
			A3 = A0 - A2;
			break;
		case 031303:
			A3 = A0 - A3;
			break;
		case 031304:
			A3 = A0 - A4;
			break;
		case 031305:
			A3 = A0 - A5;
			break;
		case 031306:
			A3 = A0 - A6;
			break;
		case 031307:
			A3 = A0 - A7;
			break; */
		case 031311:
			A3 = A1 - A1;
			break;
		case 031312:
			A3 = A1 - A2;
			break;
		case 031313:
			A3 = A1 - A3;
			break;
		case 031314:
			A3 = A1 - A4;
			break;
		case 031315:
			A3 = A1 - A5;
			break;
		case 031316:
			A3 = A1 - A6;
			break;
		case 031317:
			A3 = A1 - A7;
			break;
		case 031321:
			A3 = A2 - A1;
			break;
		case 031322:
			A3 = A2 - A2;
			break;
		case 031323:
			A3 = A2 - A3;
			break;
		case 031324:
			A3 = A2 - A4;
			break;
		case 031325:
			A3 = A2 - A5;
			break;
		case 031326:
			A3 = A2 - A6;
			break;
		case 031327:
			A3 = A2 - A7;
			break;
		case 031331:
			A3 = A3 - A1;
			break;
		case 031332:
			A3 = A3 - A2;
			break;
		case 031333:
			A3 = A3 - A3;
			break;
		case 031334:
			A3 = A3 - A4;
			break;
		case 031335:
			A3 = A3 - A5;
			break;
		case 031336:
			A3 = A3 - A6;
			break;
		case 031337:
			A3 = A3 - A7;
			break;
		case 031341:
			A3 = A4 - A1;
			break;
		case 031342:
			A3 = A4 - A2;
			break;
		case 031343:
			A3 = A4 - A3;
			break;
		case 031344:
			A3 = A4 - A4;
			break;
		case 031345:
			A3 = A4 - A5;
			break;
		case 031346:
			A3 = A4 - A6;
			break;
		case 031347:
			A3 = A4 - A7;
			break;
		case 031351:
			A3 = A5 - A1;
			break;
		case 031352:
			A3 = A5 - A2;
			break;
		case 031353:
			A3 = A5 - A3;
			break;
		case 031354:
			A3 = A5 - A4;
			break;
		case 031355:
			A3 = A5 - A5;
			break;
		case 031356:
			A3 = A5 - A6;
			break;
		case 031357:
			A3 = A5 - A7;
			break;
		case 031361:
			A3 = A6 - A1;
			break;
		case 031362:
			A3 = A6 - A2;
			break;
		case 031363:
			A3 = A6 - A3;
			break;
		case 031364:
			A3 = A6 - A4;
			break;
		case 031365:
			A3 = A6 - A5;
			break;
		case 031366:
			A3 = A6 - A6;
			break;
		case 031367:
			A3 = A6 - A7;
			break;
		case 031371:
			A3 = A7 - A1;
			break;
		case 031372:
			A3 = A7 - A2;
			break;
		case 031373:
			A3 = A7 - A3;
			break;
		case 031374:
			A3 = A7 - A4;
			break;
		case 031375:
			A3 = A7 - A5;
			break;
		case 031376:
			A3 = A7 - A6;
			break;
		case 031377:
			A3 = A7 - A7;
			break;
		/* case 031401: SUSPECT
			A4 = A0 - A1;
			break;
		case 031402:
			A4 = A0 - A2;
			break;
		case 031403:
			A4 = A0 - A3;
			break;
		case 031404:
			A4 = A0 - A4;
			break;
		case 031405:
			A4 = A0 - A5;
			break;
		case 031406:
			A4 = A0 - A6;
			break;
		case 031407:
			A4 = A0 - A7;
			break; */
		case 031411:
			A4 = A1 - A1;
			break;
		case 031412:
			A4 = A1 - A2;
			break;
		case 031413:
			A4 = A1 - A3;
			break;
		case 031414:
			A4 = A1 - A4;
			break;
		case 031415:
			A4 = A1 - A5;
			break;
		case 031416:
			A4 = A1 - A6;
			break;
		case 031417:
			A4 = A1 - A7;
			break;
		case 031421:
			A4 = A2 - A1;
			break;
		case 031422:
			A4 = A2 - A2;
			break;
		case 031423:
			A4 = A2 - A3;
			break;
		case 031424:
			A4 = A2 - A4;
			break;
		case 031425:
			A4 = A2 - A5;
			break;
		case 031426:
			A4 = A2 - A6;
			break;
		case 031427:
			A4 = A2 - A7;
			break;
		case 031431:
			A4 = A3 - A1;
			break;
		case 031432:
			A4 = A3 - A2;
			break;
		case 031433:
			A4 = A3 - A3;
			break;
		case 031434:
			A4 = A3 - A4;
			break;
		case 031435:
			A4 = A3 - A5;
			break;
		case 031436:
			A4 = A3 - A6;
			break;
		case 031437:
			A4 = A3 - A7;
			break;
		case 031441:
			A4 = A4 - A1;
			break;
		case 031442:
			A4 = A4 - A2;
			break;
		case 031443:
			A4 = A4 - A3;
			break;
		case 031444:
			A4 = A4 - A4;
			break;
		case 031445:
			A4 = A4 - A5;
			break;
		case 031446:
			A4 = A4 - A6;
			break;
		case 031447:
			A4 = A4 - A7;
			break;
		case 031451:
			A4 = A5 - A1;
			break;
		case 031452:
			A4 = A5 - A2;
			break;
		case 031453:
			A4 = A5 - A3;
			break;
		case 031454:
			A4 = A5 - A4;
			break;
		case 031455:
			A4 = A5 - A5;
			break;
		case 031456:
			A4 = A5 - A6;
			break;
		case 031457:
			A4 = A5 - A7;
			break;
		case 031461:
			A4 = A6 - A1;
			break;
		case 031462:
			A4 = A6 - A2;
			break;
		case 031463:
			A4 = A6 - A3;
			break;
		case 031464:
			A4 = A6 - A4;
			break;
		case 031465:
			A4 = A6 - A5;
			break;
		case 031466:
			A4 = A6 - A6;
			break;
		case 031467:
			A4 = A6 - A7;
			break;
		case 031471:
			A4 = A7 - A1;
			break;
		case 031472:
			A4 = A7 - A2;
			break;
		case 031473:
			A4 = A7 - A3;
			break;
		case 031474:
			A4 = A7 - A4;
			break;
		case 031475:
			A4 = A7 - A5;
			break;
		case 031476:
			A4 = A7 - A6;
			break;
		case 031477:
			A4 = A7 - A7;
			break;
		/* case 031501: SUSPECT
			A5 = A0 - A1;
			break;
		case 031502:
			A5 = A0 - A2;
			break;
		case 031503:
			A5 = A0 - A3;
			break;
		case 031504:
			A5 = A0 - A4;
			break;
		case 031505:
			A5 = A0 - A5;
			break;
		case 031506:
			A5 = A0 - A6;
			break;
		case 031507:
			A5 = A0 - A7;
			break; */
		case 031511:
			A5 = A1 - A1;
			break;
		case 031512:
			A5 = A1 - A2;
			break;
		case 031513:
			A5 = A1 - A3;
			break;
		case 031514:
			A5 = A1 - A4;
			break;
		case 031515:
			A5 = A1 - A5;
			break;
		case 031516:
			A5 = A1 - A6;
			break;
		case 031517:
			A5 = A1 - A7;
			break;
		case 031521:
			A5 = A2 - A1;
			break;
		case 031522:
			A5 = A2 - A2;
			break;
		case 031523:
			A5 = A2 - A3;
			break;
		case 031524:
			A5 = A2 - A4;
			break;
		case 031525:
			A5 = A2 - A5;
			break;
		case 031526:
			A5 = A2 - A6;
			break;
		case 031527:
			A5 = A2 - A7;
			break;
		case 031531:
			A5 = A3 - A1;
			break;
		case 031532:
			A5 = A3 - A2;
			break;
		case 031533:
			A5 = A3 - A3;
			break;
		case 031534:
			A5 = A3 - A4;
			break;
		case 031535:
			A5 = A3 - A5;
			break;
		case 031536:
			A5 = A3 - A6;
			break;
		case 031537:
			A5 = A3 - A7;
			break;
		case 031541:
			A5 = A4 - A1;
			break;
		case 031542:
			A5 = A4 - A2;
			break;
		case 031543:
			A5 = A4 - A3;
			break;
		case 031544:
			A5 = A4 - A4;
			break;
		case 031545:
			A5 = A4 - A5;
			break;
		case 031546:
			A5 = A4 - A6;
			break;
		case 031547:
			A5 = A4 - A7;
			break;
		case 031551:
			A5 = A5 - A1;
			break;
		case 031552:
			A5 = A5 - A2;
			break;
		case 031553:
			A5 = A5 - A3;
			break;
		case 031554:
			A5 = A5 - A4;
			break;
		case 031555:
			A5 = A5 - A5;
			break;
		case 031556:
			A5 = A5 - A6;
			break;
		case 031557:
			A5 = A5 - A7;
			break;
		case 031561:
			A5 = A6 - A1;
			break;
		case 031562:
			A5 = A6 - A2;
			break;
		case 031563:
			A5 = A6 - A3;
			break;
		case 031564:
			A5 = A6 - A4;
			break;
		case 031565:
			A5 = A6 - A5;
			break;
		case 031566:
			A5 = A6 - A6;
			break;
		case 031567:
			A5 = A6 - A7;
			break;
		case 031571:
			A5 = A7 - A1;
			break;
		case 031572:
			A5 = A7 - A2;
			break;
		case 031573:
			A5 = A7 - A3;
			break;
		case 031574:
			A5 = A7 - A4;
			break;
		case 031575:
			A5 = A7 - A5;
			break;
		case 031576:
			A5 = A7 - A6;
			break;
		case 031577:
			A5 = A7 - A7;
			break;
		/* case 031601: SUSPECT
			A6 = A0 - A1;
			break;
		case 031602:
			A6 = A0 - A2;
			break;
		case 031603:
			A6 = A0 - A3;
			break;
		case 031604:
			A6 = A0 - A4;
			break;
		case 031605:
			A6 = A0 - A5;
			break;
		case 031606:
			A6 = A0 - A6;
			break;
		case 031607:
			A6 = A0 - A7;
			break; */
		case 031611:
			A6 = A1 - A1;
			break;
		case 031612:
			A6 = A1 - A2;
			break;
		case 031613:
			A6 = A1 - A3;
			break;
		case 031614:
			A6 = A1 - A4;
			break;
		case 031615:
			A6 = A1 - A5;
			break;
		case 031616:
			A6 = A1 - A6;
			break;
		case 031617:
			A6 = A1 - A7;
			break;
		case 031621:
			A6 = A2 - A1;
			break;
		case 031622:
			A6 = A2 - A2;
			break;
		case 031623:
			A6 = A2 - A3;
			break;
		case 031624:
			A6 = A2 - A4;
			break;
		case 031625:
			A6 = A2 - A5;
			break;
		case 031626:
			A6 = A2 - A6;
			break;
		case 031627:
			A6 = A2 - A7;
			break;
		case 031631:
			A6 = A3 - A1;
			break;
		case 031632:
			A6 = A3 - A2;
			break;
		case 031633:
			A6 = A3 - A3;
			break;
		case 031634:
			A6 = A3 - A4;
			break;
		case 031635:
			A6 = A3 - A5;
			break;
		case 031636:
			A6 = A3 - A6;
			break;
		case 031637:
			A6 = A3 - A7;
			break;
		case 031641:
			A6 = A4 - A1;
			break;
		case 031642:
			A6 = A4 - A2;
			break;
		case 031643:
			A6 = A4 - A3;
			break;
		case 031644:
			A6 = A4 - A4;
			break;
		case 031645:
			A6 = A4 - A5;
			break;
		case 031646:
			A6 = A4 - A6;
			break;
		case 031647:
			A6 = A4 - A7;
			break;
		case 031651:
			A6 = A5 - A1;
			break;
		case 031652:
			A6 = A5 - A2;
			break;
		case 031653:
			A6 = A5 - A3;
			break;
		case 031654:
			A6 = A5 - A4;
			break;
		case 031655:
			A6 = A5 - A5;
			break;
		case 031656:
			A6 = A5 - A6;
			break;
		case 031657:
			A6 = A5 - A7;
			break;
		case 031661:
			A6 = A6 - A1;
			break;
		case 031662:
			A6 = A6 - A2;
			break;
		case 031663:
			A6 = A6 - A3;
			break;
		case 031664:
			A6 = A6 - A4;
			break;
		case 031665:
			A6 = A6 - A5;
			break;
		case 031666:
			A6 = A6 - A6;
			break;
		case 031667:
			A6 = A6 - A7;
			break;
		case 031671:
			A6 = A7 - A1;
			break;
		case 031672:
			A6 = A7 - A2;
			break;
		case 031673:
			A6 = A7 - A3;
			break;
		case 031674:
			A6 = A7 - A4;
			break;
		case 031675:
			A6 = A7 - A5;
			break;
		case 031676:
			A6 = A7 - A6;
			break;
		case 031677:
			A6 = A7 - A7;
			break;
		/* case 031701: SUSPECT
			A7 = A0 - A1;
			break;
		case 031702:
			A7 = A0 - A2;
			break;
		case 031703:
			A7 = A0 - A3;
			break;
		case 031704:
			A7 = A0 - A4;
			break;
		case 031705:
			A7 = A0 - A5;
			break;
		case 031706:
			A7 = A0 - A6;
			break;
		case 031707:
			A7 = A0 - A7;
			break; */
		case 031711:
			A7 = A1 - A1;
			break;
		case 031712:
			A7 = A1 - A2;
			break;
		case 031713:
			A7 = A1 - A3;
			break;
		case 031714:
			A7 = A1 - A4;
			break;
		case 031715:
			A7 = A1 - A5;
			break;
		case 031716:
			A7 = A1 - A6;
			break;
		case 031717:
			A7 = A1 - A7;
			break;
		case 031721:
			A7 = A2 - A1;
			break;
		case 031722:
			A7 = A2 - A2;
			break;
		case 031723:
			A7 = A2 - A3;
			break;
		case 031724:
			A7 = A2 - A4;
			break;
		case 031725:
			A7 = A2 - A5;
			break;
		case 031726:
			A7 = A2 - A6;
			break;
		case 031727:
			A7 = A2 - A7;
			break;
		case 031731:
			A7 = A3 - A1;
			break;
		case 031732:
			A7 = A3 - A2;
			break;
		case 031733:
			A7 = A3 - A3;
			break;
		case 031734:
			A7 = A3 - A4;
			break;
		case 031735:
			A7 = A3 - A5;
			break;
		case 031736:
			A7 = A3 - A6;
			break;
		case 031737:
			A7 = A3 - A7;
			break;
		case 031741:
			A7 = A4 - A1;
			break;
		case 031742:
			A7 = A4 - A2;
			break;
		case 031743:
			A7 = A4 - A3;
			break;
		case 031744:
			A7 = A4 - A4;
			break;
		case 031745:
			A7 = A4 - A5;
			break;
		case 031746:
			A7 = A4 - A6;
			break;
		case 031747:
			A7 = A4 - A7;
			break;
		case 031751:
			A7 = A5 - A1;
			break;
		case 031752:
			A7 = A5 - A2;
			break;
		case 031753:
			A7 = A5 - A3;
			break;
		case 031754:
			A7 = A5 - A4;
			break;
		case 031755:
			A7 = A5 - A5;
			break;
		case 031756:
			A7 = A5 - A6;
			break;
		case 031757:
			A7 = A5 - A7;
			break;
		case 031761:
			A7 = A6 - A1;
			break;
		case 031762:
			A7 = A6 - A2;
			break;
		case 031763:
			A7 = A6 - A3;
			break;
		case 031764:
			A7 = A6 - A4;
			break;
		case 031765:
			A7 = A6 - A5;
			break;
		case 031766:
			A7 = A6 - A6;
			break;
		case 031767:
			A7 = A6 - A7;
			break;
		case 031771:
			A7 = A7 - A1;
			break;
		case 031772:
			A7 = A7 - A2;
			break;
		case 031773:
			A7 = A7 - A3;
			break;
		case 031774:
			A7 = A7 - A4;
			break;
		case 031775:
			A7 = A7 - A5;
			break;
		case 031776:
			A7 = A7 - A6;
			break;
		case 031777:
			A7 = A7 - A7;
			break;
		case 031000:
			/* CAL A0 -1 */
			A0 = -1;
			break;
		case 031100:
			/* CAL A1 -1 */
			A1 = -1;
			break;
		case 031200:
			/* CAL A2 -1 */
			A2 = -1;
			break;
		case 031300:
			/* CAL A3 -1 */
			A3 = -1;
			break;
		case 031400:
			/* CAL A4 -1 */
			A4 = -1;
			break;
		case 031500:
			/* CAL A5 -1 */
			A5 = -1;
			break;
		case 031600:
			/* CAL A6 -1 */
			A6 = -1;
			break;
		case 031700:
			/* CAL A7 -1 */
			A7 = -1;
			break;
		case 031001:
			/* CAL Ai -Ak */
			/* CAL A0 -A1 */
			/* Transmits the negative of Ak to Ai */
			/* Have a few, though not very eficcient ideas on how to do this */
			break;
		case 031002:
			break;
		case 031003:
			break;
		case 031004:
			break;
		case 031005:
			break;
		case 031006:
			break;
		case 031007:
			break;
		case 031101:
			break;
		case 031102:
			break;
		case 031103:
			break;
		case 031104:
			break;
		case 031105:
			break;
		case 031106:
			break;
		case 031107:
			break;
		case 031201:
			break;
		case 031202:
			break;
		case 031203:
			break;
		case 031204:
			break;
		case 031205:
			break;
		case 031206:
			break;
		case 031207:
			break;
		case 031301:
			break;
		case 031302:
			break;
		case 031303:
			break;
		case 031304:
			break;
		case 031305:
			break;
		case 031306:
			break;
		case 031307:
			break;
		case 031401:
			break;
		case 031402:
			break;
		case 031403:
			break;
		case 031404:
			break;
		case 031405:
			break;
		case 031406:
			break;
		case 031407:
			break;
		case 031501:
			break;
		case 031502:
			break;
		case 031503:
			break;
		case 031504:
			break;
		case 031505:
			break;
		case 031506:
			break;
		case 031507:
			break;
		case 031601:
			break;
		case 031602:
			break;
		case 031603:
			break;
		case 031604:
			break;
		case 031605:
			break;
		case 031606:
			break;
		case 031607:
			break;
		case 031701:
			break;
		case 031702:
			break;
		case 031703:
			break;
		case 031704:
			break;
		case 031705:
			break;
		case 031706:
			break;
		case 031707:
			break;
		case 032000:
			/* CAL A0 A0*A0 */
			/* CAL Ai Aj*Ak */
			/* Integer product of Aj and Ak into Ai */
			/* Not sure if k=0 is acceptable here, looks like it, though could be wrong */
			/* pretty sure that this is implemented correctly, but could be wrong */
			A0 = A0 * A0;
			break;
		case 032001:
			A0 = A0 * A1;
			break;
		case 032002:
			A0 = A0 * A2;
			break;
		case 032003:
			A0 = A0 * A3;
			break;
		case 032004:
			A0 = A0 * A4;
			break;
		case 032005:
			A0 = A0 * A5;
			break;
		case 032006:
			A0 = A0 * A6;
			break;
		case 032007:
			A0 = A0 * A7;
			break;
		case 032010:
			A0 = A1 * A0;
			break;
		case 032011:
			A0 = A1 * A1;
			break;
		case 032012:
			A0 = A1 * A2;
			break;
		case 032013:
			A0 = A1 * A3;
			break;
		case 032014:
			A0 = A1 * A4;
			break;
		case 032015:
			A0 = A1 * A5;
			break;
		case 032016:
			A0 = A1 * A6;
			break;
		case 032017:
			A0 = A1 * A7;
			break;
		case 032020:
			A0 = A2 * A0;
			break;
		case 032021:
			A0 = A2 * A1;
			break;
		case 032022:
			A0 = A2 * A2;
			break;
		case 032023:
			A0 = A2 * A3;
			break;
		case 032024:
			A0 = A2 * A4;
			break;
		case 032025:
			A0 = A2 * A5;
			break;
		case 032026:
			A0 = A2 * A6;
			break;
		case 032027:
			A0 = A2 * A7;
			break;
		case 032030:
			A0 = A3 * A0;
			break;
		case 032031:
			A0 = A3 * A1;
			break;
		case 032032:
			A0 = A3 * A2;
			break;
		case 032033:
			A0 = A3 * A3;
			break;
		case 032034:
			A0 = A3 * A4;
			break;
		case 032035:
			A0 = A3 * A5;
			break;
		case 032036:
			A0 = A3 * A6;
			break;
		case 032037:
			A0 = A3 * A7;
			break;
		case 032040:
			A0 = A4 * A0;
			break;
		case 032041:
			A0 = A4 * A1;
			break;
		case 032042:
			A0 = A4 * A2;
			break;
		case 032043:
			A0 = A4 * A3;
			break;
		case 032044:
			A0 = A4 * A4;
			break;
		case 032045:
			A0 = A4 * A5;
			break;
		case 032046:
			A0 = A4 * A6;
			break;
		case 032047:
			A0 = A4 * A7;
			break;
		case 032050:
			A0 = A5 * A0;
			break;
		case 032051:
			A0 = A5 * A1;
			break;
		case 032052:
			A0 = A5 * A2;
			break;
		case 032053:
			A0 = A5 * A3;
			break;
		case 032054:
			A0 = A5 * A4;
			break;
		case 032055:
			A0 = A5 * A5;
			break;
		case 032056:
			A0 = A5 * A6;
			break;
		case 032057:
			A0 = A5 * A7;
			break;
		case 032060:
			A0 = A6 * A0;
			break;
		case 032061:
			A0 = A6 * A1;
			break;
		case 032062:
			A0 = A6 * A2;
			break;
		case 032063:
			A0 = A6 * A3;
			break;
		case 032064:
			A0 = A6 * A4;
			break;
		case 032065:
			A0 = A6 * A5;
			break;
		case 032066:
			A0 = A6 * A6;
			break;
		case 032067:
			A0 = A6 * A7;
			break;
		case 032070:
			A0 = A7 * A0;
			break;
		case 032071:
			A0 = A7 * A1;
			break;
		case 032072:
			A0 = A7 * A2;
			break;
		case 032073:
			A0 = A7 * A3;
			break;
		case 032074:
			A0 = A7 * A4;
			break;
		case 032075:
			A0 = A7 * A5;
			break;
		case 032076:
			A0 = A7 * A6;
			break;
		case 032077:
			A0 = A7 * A7;
			break;
		case 032100:
			A1 = A0 * A0;
			break;
		case 032101:
			A1 = A0 * A1;
			break;
		case 032102:
			A1 = A0 * A2;
			break;
		case 032103:
			A1 = A0 * A3;
			break;
		case 032104:
			A1 = A0 * A4;
			break;
		case 032105:
			A1 = A0 * A5;
			break;
		case 032106:
			A1 = A0 * A6;
			break;
		case 032107:
			A1 = A0 * A7;
			break;
		case 032110:
			A1 = A1 * A0;
			break;
		case 032111:
			A1 = A1 * A1;
			break;
		case 032112:
			A1 = A1 * A2;
			break;
		case 032113:
			A1 = A1 * A3;
			break;
		case 032114:
			A1 = A1 * A4;
			break;
		case 032115:
			A1 = A1 * A5;
			break;
		case 032116:
			A1 = A1 * A6;
			break;
		case 032117:
			A1 = A1 * A7;
			break;
		case 032120:
			A1 = A2 * A0;
			break;
		case 032121:
			A1 = A2 * A1;
			break;
		case 032122:
			A1 = A2 * A2;
			break;
		case 032123:
			A1 = A2 * A3;
			break;
		case 032124:
			A1 = A2 * A4;
			break;
		case 032125:
			A1 = A2 * A5;
			break;
		case 032126:
			A1 = A2 * A6;
			break;
		case 032127:
			A1 = A2 * A7;
			break;
		case 032130:
			A1 = A3 * A0;
			break;
		case 032131:
			A1 = A3 * A1;
			break;
		case 032132:
			A1 = A3 * A2;
			break;
		case 032133:
			A1 = A3 * A3;
			break;
		case 032134:
			A1 = A3 * A4;
			break;
		case 032135:
			A1 = A3 * A5;
			break;
		case 032136:
			A1 = A3 * A6;
			break;
		case 032137:
			A1 = A3 * A7;
			break;
		case 032140:
			A1 = A4 * A0;
			break;
		case 032141:
			A1 = A4 * A1;
			break;
		case 032142:
			A1 = A4 * A2;
			break;
		case 032143:
			A1 = A4 * A3;
			break;
		case 032144:
			A1 = A4 * A4;
			break;
		case 032145:
			A1 = A4 * A5;
			break;
		case 032146:
			A1 = A4 * A6;
			break;
		case 032147:
			A1 = A4 * A7;
			break;
		case 032150:
			A1 = A5 * A0;
			break;
		case 032151:
			A1 = A5 * A1;
			break;
		case 032152:
			A1 = A5 * A2;
			break;
		case 032153:
			A1 = A5 * A3;
			break;
		case 032154:
			A1 = A5 * A4;
			break;
		case 032155:
			A1 = A5 * A5;
			break;
		case 032156:
			A1 = A5 * A6;
			break;
		case 032157:
			A1 = A5 * A7;
			break;
		case 032160:
			A1 = A6 * A0;
			break;
		case 032161:
			A1 = A6 * A1;
			break;
		case 032162:
			A1 = A6 * A2;
			break;
		case 032163:
			A1 = A6 * A3;
			break;
		case 032164:
			A1 = A6 * A4;
			break;
		case 032165:
			A1 = A6 * A5;
			break;
		case 032166:
			A1 = A6 * A6;
			break;
		case 032167:
			A1 = A6 * A7;
			break;
		case 032170:
			A1 = A7 * A0;
			break;
		case 032171:
			A1 = A7 * A1;
			break;
		case 032172:
			A1 = A7 * A2;
			break;
		case 032173:
			A1 = A7 * A3;
			break;
		case 032174:
			A1 = A7 * A4;
			break;
		case 032175:
			A1 = A7 * A5;
			break;
		case 032176:
			A1 = A7 * A6;
			break;
		case 032177:
			A1 = A7 * A7;
			break;
		case 032200:
			A2 = A0 * A0;
			break;
		case 032201:
			A2 = A0 * A1;
			break;
		case 032202:
			A2 = A0 * A2;
			break;
		case 032203:
			A2 = A0 * A3;
			break;
		case 032204:
			A2 = A0 * A4;
			break;
		case 032205:
			A2 = A0 * A5;
			break;
		case 032206:
			A2 = A0 * A6;
			break;
		case 032207:
			A2 = A0 * A7;
			break;
		case 032210:
			A2 = A1 * A0;
			break;
		case 032211:
			A2 = A1 * A1;
			break;
		case 032212:
			A2 = A1 * A2;
			break;
		case 032213:
			A2 = A1 * A3;
			break;
		case 032214:
			A2 = A1 * A4;
			break;
		case 032215:
			A2 = A1 * A5;
			break;
		case 032216:
			A2 = A1 * A6;
			break;
		case 032217:
			A2 = A1 * A7;
			break;
		case 032220:
			A2 = A2 * A0;
			break;
		case 032221:
			A2 = A2 * A1;
			break;
		case 032222:
			A2 = A2 * A2;
			break;
		case 032223:
			A2 = A2 * A3;
			break;
		case 032224:
			A2 = A2 * A4;
			break;
		case 032225:
			A2 = A2 * A5;
			break;
		case 032226:
			A2 = A2 * A6;
			break;
		case 032227:
			A2 = A2 * A7;
			break;
		case 032230:
			A2 = A3 * A0;
			break;
		case 032231:
			A2 = A3 * A1;
			break;
		case 032232:
			A2 = A3 * A2;
			break;
		case 032233:
			A2 = A3 * A3;
			break;
		case 032234:
			A2 = A3 * A4;
			break;
		case 032235:
			A2 = A3 * A5;
			break;
		case 032236:
			A2 = A3 * A6;
			break;
		case 032237:
			A2 = A3 * A7;
			break;
		case 032240:
			A2 = A4 * A0;
			break;
		case 032241:
			A2 = A4 * A1;
			break;
		case 032242:
			A2 = A4 * A2;
			break;
		case 032243:
			A2 = A4 * A3;
			break;
		case 032244:
			A2 = A4 * A4;
			break;
		case 032245:
			A2 = A4 * A5;
			break;
		case 032246:
			A2 = A4 * A6;
			break;
		case 032247:
			A2 = A4 * A7;
			break;
		case 032250:
			A2 = A5 * A0;
			break;
		case 032251:
			A2 = A5 * A1;
			break;
		case 032252:
			A2 = A5 * A2;
			break;
		case 032253:
			A2 = A5 * A3;
			break;
		case 032254:
			A2 = A5 * A4;
			break;
		case 032255:
			A2 = A5 * A5;
			break;
		case 032256:
			A2 = A5 * A6;
			break;
		case 032257:
			A2 = A5 * A7;
			break;
		case 032260:
			A2 = A6 * A0;
			break;
		case 032261:
			A2 = A6 * A1;
			break;
		case 032262:
			A2 = A6 * A2;
			break;
		case 032263:
			A2 = A6 * A3;
			break;
		case 032264:
			A2 = A6 * A4;
			break;
		case 032265:
			A2 = A6 * A5;
			break;
		case 032266:
			A2 = A6 * A6;
			break;
		case 032267:
			A2 = A6 * A7;
			break;
		case 032270:
			A2 = A7 * A0;
			break;
		case 032271:
			A2 = A7 * A1;
			break;
		case 032272:
			A2 = A7 * A2;
			break;
		case 032273:
			A2 = A7 * A3;
			break;
		case 032274:
			A2 = A7 * A4;
			break;
		case 032275:
			A2 = A7 * A5;
			break;
		case 032276:
			A2 = A7 * A6;
			break;
		case 032277:
			A2 = A7 * A7;
			break;
		case 032300:
			A3 = A0 * A0;
			break;
		case 032301:
			A3 = A0 * A1;
			break;
		case 032302:
			A3 = A0 * A2;
			break;
		case 032303:
			A3 = A0 * A3;
			break;
		case 032304:
			A3 = A0 * A4;
			break;
		case 032305:
			A3 = A0 * A5;
			break;
		case 032306:
			A3 = A0 * A6;
			break;
		case 032307:
			A3 = A0 * A7;
			break;
		case 032310:
			A3 = A1 * A0;
			break;
		case 032311:
			A3 = A1 * A1;
			break;
		case 032312:
			A3 = A1 * A2;
			break;
		case 032313:
			A3 = A1 * A3;
			break;
		case 032314:
			A3 = A1 * A4;
			break;
		case 032315:
			A3 = A1 * A5;
			break;
		case 032316:
			A3 = A1 * A6;
			break;
		case 032317:
			A3 = A1 * A7;
			break;
		case 032320:
			A3 = A2 * A0;
			break;
		case 032321:
			A3 = A2 * A1;
			break;
		case 032322:
			A3 = A2 * A2;
			break;
		case 032323:
			A3 = A2 * A3;
			break;
		case 032324:
			A3 = A2 * A4;
			break;
		case 032325:
			A3 = A2 * A5;
			break;
		case 032326:
			A3 = A2 * A6;
			break;
		case 032327:
			A3 = A2 * A7;
			break;
		case 032330:
			A3 = A3 * A0;
			break;
		case 032331:
			A3 = A3 * A1;
			break;
		case 032332:
			A3 = A3 * A2;
			break;
		case 032333:
			A3 = A3 * A3;
			break;
		case 032334:
			A3 = A3 * A4;
			break;
		case 032335:
			A3 = A3 * A5;
			break;
		case 032336:
			A3 = A3 * A6;
			break;
		case 032337:
			A3 = A3 * A7;
			break;
		case 032340:
			A3 = A4 * A0;
			break;
		case 032341:
			A3 = A4 * A1;
			break;
		case 032342:
			A3 = A4 * A2;
			break;
		case 032343:
			A3 = A4 * A3;
			break;
		case 032344:
			A3 = A4 * A4;
			break;
		case 032345:
			A3 = A4 * A5;
			break;
		case 032346:
			A3 = A4 * A6;
			break;
		case 032347:
			A3 = A4 * A7;
			break;
		case 032350:
			A3 = A5 * A0;
			break;
		case 032351:
			A3 = A5 * A1;
			break;
		case 032352:
			A3 = A5 * A2;
			break;
		case 032353:
			A3 = A5 * A3;
			break;
		case 032354:
			A3 = A5 * A4;
			break;
		case 032355:
			A3 = A5 * A5;
			break;
		case 032356:
			A3 = A5 * A6;
			break;
		case 032357:
			A3 = A5 * A7;
			break;
		case 032360:
			A3 = A6 * A0;
			break;
		case 032361:
			A3 = A6 * A1;
			break;
		case 032362:
			A3 = A6 * A2;
			break;
		case 032363:
			A3 = A6 * A3;
			break;
		case 032364:
			A3 = A6 * A4;
			break;
		case 032365:
			A3 = A6 * A5;
			break;
		case 032366:
			A3 = A6 * A6;
			break;
		case 032367:
			A3 = A6 * A7;
			break;
		case 032370:
			A3 = A7 * A0;
			break;
		case 032371:
			A3 = A7 * A1;
			break;
		case 032372:
			A3 = A7 * A2;
			break;
		case 032373:
			A3 = A7 * A3;
			break;
		case 032374:
			A3 = A7 * A4;
			break;
		case 032375:
			A3 = A7 * A5;
			break;
		case 032376:
			A3 = A7 * A6;
			break;
		case 032377:
			A3 = A7 * A7;
			break;
		case 032400:
			A4 = A0 * A0;
			break;
		case 032401:
			A4 = A0 * A1;
			break;
		case 032402:
			A4 = A0 * A2;
			break;
		case 032403:
			A4 = A0 * A3;
			break;
		case 032404:
			A4 = A0 * A4;
			break;
		case 032405:
			A4 = A0 * A5;
			break;
		case 032406:
			A4 = A0 * A6;
			break;
		case 032407:
			A4 = A0 * A7;
			break;
		case 032410:
			A4 = A1 * A0;
			break;
		case 032411:
			A4 = A1 * A1;
			break;
		case 032412:
			A4 = A1 * A2;
			break;
		case 032413:
			A4 = A1 * A3;
			break;
		case 032414:
			A4 = A1 * A4;
			break;
		case 032415:
			A4 = A1 * A5;
			break;
		case 032416:
			A4 = A1 * A6;
			break;
		case 032417:
			A4 = A1 * A7;
			break;
		case 032420:
			A4 = A2 * A0;
			break;
		case 032421:
			A4 = A2 * A1;
			break;
		case 032422:
			A4 = A2 * A2;
			break;
		case 032423:
			A4 = A2 * A3;
			break;
		case 032424:
			A4 = A2 * A4;
			break;
		case 032425:
			A4 = A2 * A5;
			break;
		case 032426:
			A4 = A2 * A6;
			break;
		case 032427:
			A4 = A2 * A7;
			break;
		case 032430:
			A4 = A3 * A0;
			break;
		case 032431:
			A4 = A3 * A1;
			break;
		case 032432:
			A4 = A3 * A2;
			break;
		case 032433:
			A4 = A3 * A3;
			break;
		case 032434:
			A4 = A3 * A4;
			break;
		case 032435:
			A4 = A3 * A5;
			break;
		case 032436:
			A4 = A3 * A6;
			break;
		case 032437:
			A4 = A3 * A7;
			break;
		case 032440:
			A4 = A4 * A0;
			break;
		case 032441:
			A4 = A4 * A1;
			break;
		case 032442:
			A4 = A4 * A2;
			break;
		case 032443:
			A4 = A4 * A3;
			break;
		case 032444:
			A4 = A4 * A4;
			break;
		case 032445:
			A4 = A4 * A5;
			break;
		case 032446:
			A4 = A4 * A6;
			break;
		case 032447:
			A4 = A4 * A7;
			break;
		case 032450:
			A4 = A5 * A0;
			break;
		case 032451:
			A4 = A5 * A1;
			break;
		case 032452:
			A4 = A5 * A2;
			break;
		case 032453:
			A4 = A5 * A3;
			break;
		case 032454:
			A4 = A5 * A4;
			break;
		case 032455:
			A4 = A5 * A5;
			break;
		case 032456:
			A4 = A5 * A6;
			break;
		case 032457:
			A4 = A5 * A7;
			break;
		case 032460:
			A4 = A6 * A0;
			break;
		case 032461:
			A4 = A6 * A1;
			break;
		case 032462:
			A4 = A6 * A2;
			break;
		case 032463:
			A4 = A6 * A3;
			break;
		case 032464:
			A4 = A6 * A4;
			break;
		case 032465:
			A4 = A6 * A5;
			break;
		case 032466:
			A4 = A6 * A6;
			break;
		case 032467:
			A4 = A6 * A7;
			break;
		case 032470:
			A4 = A7 * A0;
			break;
		case 032471:
			A4 = A7 * A1;
			break;
		case 032472:
			A4 = A7 * A2;
			break;
		case 032473:
			A4 = A7 * A3;
			break;
		case 032474:
			A4 = A7 * A4;
			break;
		case 032475:
			A4 = A7 * A5;
			break;
		case 032476:
			A4 = A7 * A6;
			break;
		case 032477:
			A4 = A7 * A7;
			break;
		case 032500:
			A5 = A0 * A0;
			break;
		case 032501:
			A5 = A0 * A1;
			break;
		case 032502:
			A5 = A0 * A2;
			break;
		case 032503:
			A5 = A0 * A3;
			break;
		case 032504:
			A5 = A0 * A4;
			break;
		case 032505:
			A5 = A0 * A5;
			break;
		case 032506:
			A5 = A0 * A6;
			break;
		case 032507:
			A5 = A0 * A7;
			break;
		case 032510:
			A5 = A1 * A0;
			break;
		case 032511:
			A5 = A1 * A1;
			break;
		case 032512:
			A5 = A1 * A2;
			break;
		case 032513:
			A5 = A1 * A3;
			break;
		case 032514:
			A5 = A1 * A4;
			break;
		case 032515:
			A5 = A1 * A5;
			break;
		case 032516:
			A5 = A1 * A6;
			break;
		case 032517:
			A5 = A1 * A7;
			break;
		case 032520:
			A5 = A2 * A0;
			break;
		case 032521:
			A5 = A2 * A1;
			break;
		case 032522:
			A5 = A2 * A2;
			break;
		case 032523:
			A5 = A2 * A3;
			break;
		case 032524:
			A5 = A2 * A4;
			break;
		case 032525:
			A5 = A2 * A5;
			break;
		case 032526:
			A5 = A2 * A6;
			break;
		case 032527:
			A5 = A2 * A7;
			break;
		case 032530:
			A5 = A3 * A0;
			break;
		case 032531:
			A5 = A3 * A1;
			break;
		case 032532:
			A5 = A3 * A2;
			break;
		case 032533:
			A5 = A3 * A3;
			break;
		case 032534:
			A5 = A3 * A4;
			break;
		case 032535:
			A5 = A3 * A5;
			break;
		case 032536:
			A5 = A3 * A6;
			break;
		case 032537:
			A5 = A3 * A7;
			break;
		case 032540:
			A5 = A4 * A0;
			break;
		case 032541:
			A5 = A4 * A1;
			break;
		case 032542:
			A5 = A4 * A2;
			break;
		case 032543:
			A5 = A4 * A3;
			break;
		case 032544:
			A5 = A4 * A4;
			break;
		case 032545:
			A5 = A4 * A5;
			break;
		case 032546:
			A5 = A4 * A6;
			break;
		case 032547:
			A5 = A4 * A7;
			break;
		case 032550:
			A5 = A5 * A0;
			break;
		case 032551:
			A5 = A5 * A1;
			break;
		case 032552:
			A5 = A5 * A2;
			break;
		case 032553:
			A5 = A5 * A3;
			break;
		case 032554:
			A5 = A5 * A4;
			break;
		case 032555:
			A5 = A5 * A5;
			break;
		case 032556:
			A5 = A5 * A6;
			break;
		case 032557:
			A5 = A5 * A7;
			break;
		case 032560:
			A5 = A6 * A0;
			break;
		case 032561:
			A5 = A6 * A1;
			break;
		case 032562:
			A5 = A6 * A2;
			break;
		case 032563:
			A5 = A6 * A3;
			break;
		case 032564:
			A5 = A6 * A4;
			break;
		case 032565:
			A5 = A6 * A5;
			break;
		case 032566:
			A5 = A6 * A6;
			break;
		case 032567:
			A5 = A6 * A7;
			break;
		case 032570:
			A5 = A7 * A0;
			break;
		case 032571:
			A5 = A7 * A1;
			break;
		case 032572:
			A5 = A7 * A2;
			break;
		case 032573:
			A5 = A7 * A3;
			break;
		case 032574:
			A5 = A7 * A4;
			break;
		case 032575:
			A5 = A7 * A5;
			break;
		case 032576:
			A5 = A7 * A6;
			break;
		case 032577:
			A5 = A7 * A7;
			break;
		case 032600:
			A6 = A0 * A0;
			break;
		case 032601:
			A6 = A0 * A1;
			break;
		case 032602:
			A6 = A0 * A2;
			break;
		case 032603:
			A6 = A0 * A3;
			break;
		case 032604:
			A6 = A0 * A4;
			break;
		case 032605:
			A6 = A0 * A5;
			break;
		case 032606:
			A6 = A0 * A6;
			break;
		case 032607:
			A6 = A0 * A7;
			break;
		case 032610:
			A6 = A1 * A0;
			break;
		case 032611:
			A6 = A1 * A1;
			break;
		case 032612:
			A6 = A1 * A2;
			break;
		case 032613:
			A6 = A1 * A3;
			break;
		case 032614:
			A6 = A1 * A4;
			break;
		case 032615:
			A6 = A1 * A5;
			break;
		case 032616:
			A6 = A1 * A6;
			break;
		case 032617:
			A6 = A1 * A7;
			break;
		case 032620:
			A6 = A2 * A0;
			break;
		case 032621:
			A6 = A2 * A1;
			break;
		case 032622:
			A6 = A2 * A2;
			break;
		case 032623:
			A6 = A2 * A3;
			break;
		case 032624:
			A6 = A2 * A4;
			break;
		case 032625:
			A6 = A2 * A5;
			break;
		case 032626:
			A6 = A2 * A6;
			break;
		case 032627:
			A6 = A2 * A7;
			break;
		case 032630:
			A6 = A3 * A0;
			break;
		case 032631:
			A6 = A3 * A1;
			break;
		case 032632:
			A6 = A3 * A2;
			break;
		case 032633:
			A6 = A3 * A3;
			break;
		case 032634:
			A6 = A3 * A4;
			break;
		case 032635:
			A6 = A3 * A5;
			break;
		case 032636:
			A6 = A3 * A6;
			break;
		case 032637:
			A6 = A3 * A7;
			break;
		case 032640:
			A6 = A4 * A0;
			break;
		case 032641:
			A6 = A4 * A1;
			break;
		case 032642:
			A6 = A4 * A2;
			break;
		case 032643:
			A6 = A4 * A3;
			break;
		case 032644:
			A6 = A4 * A4;
			break;
		case 032645:
			A6 = A4 * A5;
			break;
		case 032646:
			A6 = A4 * A6;
			break;
		case 032647:
			A6 = A4 * A7;
			break;
		case 032650:
			A6 = A5 * A0;
			break;
		case 032651:
			A6 = A5 * A1;
			break;
		case 032652:
			A6 = A5 * A2;
			break;
		case 032653:
			A6 = A5 * A3;
			break;
		case 032654:
			A6 = A5 * A4;
			break;
		case 032655:
			A6 = A5 * A5;
			break;
		case 032656:
			A6 = A5 * A6;
			break;
		case 032657:
			A6 = A5 * A7;
			break;
		case 032660:
			A6 = A6 * A0;
			break;
		case 032661:
			A6 = A6 * A1;
			break;
		case 032662:
			A6 = A6 * A2;
			break;
		case 032663:
			A6 = A6 * A3;
			break;
		case 032664:
			A6 = A6 * A4;
			break;
		case 032665:
			A6 = A6 * A5;
			break;
		case 032666:
			A6 = A6 * A6;
			break;
		case 032667:
			A6 = A6 * A7;
			break;
		case 032670:
			A6 = A7 * A0;
			break;
		case 032671:
			A6 = A7 * A1;
			break;
		case 032672:
			A6 = A7 * A2;
			break;
		case 032673:
			A6 = A7 * A3;
			break;
		case 032674:
			A6 = A7 * A4;
			break;
		case 032675:
			A6 = A7 * A5;
			break;
		case 032676:
			A6 = A7 * A6;
			break;
		case 032677:
			A6 = A7 * A7;
			break;
		case 032700:
			A7 = A0 * A0;
			break;
		case 032701:
			A7 = A0 * A1;
			break;
		case 032702:
			A7 = A0 * A2;
			break;
		case 032703:
			A7 = A0 * A3;
			break;
		case 032704:
			A7 = A0 * A4;
			break;
		case 032705:
			A7 = A0 * A5;
			break;
		case 032706:
			A7 = A0 * A6;
			break;
		case 032707:
			A7 = A0 * A7;
			break;
		case 032710:
			A7 = A1 * A0;
			break;
		case 032711:
			A7 = A1 * A1;
			break;
		case 032712:
			A7 = A1 * A2;
			break;
		case 032713:
			A7 = A1 * A3;
			break;
		case 032714:
			A7 = A1 * A4;
			break;
		case 032715:
			A7 = A1 * A5;
			break;
		case 032716:
			A7 = A1 * A6;
			break;
		case 032717:
			A7 = A1 * A7;
			break;
		case 032720:
			A7 = A2 * A0;
			break;
		case 032721:
			A7 = A2 * A1;
			break;
		case 032722:
			A7 = A2 * A2;
			break;
		case 032723:
			A7 = A2 * A3;
			break;
		case 032724:
			A7 = A2 * A4;
			break;
		case 032725:
			A7 = A2 * A5;
			break;
		case 032726:
			A7 = A2 * A6;
			break;
		case 032727:
			A7 = A2 * A7;
			break;
		case 032730:
			A7 = A3 * A0;
			break;
		case 032731:
			A7 = A3 * A1;
			break;
		case 032732:
			A7 = A3 * A2;
			break;
		case 032733:
			A7 = A3 * A3;
			break;
		case 032734:
			A7 = A3 * A4;
			break;
		case 032735:
			A7 = A3 * A5;
			break;
		case 032736:
			A7 = A3 * A6;
			break;
		case 032737:
			A7 = A3 * A7;
			break;
		case 032740:
			A7 = A4 * A0;
			break;
		case 032741:
			A7 = A4 * A1;
			break;
		case 032742:
			A7 = A4 * A2;
			break;
		case 032743:
			A7 = A4 * A3;
			break;
		case 032744:
			A7 = A4 * A4;
			break;
		case 032745:
			A7 = A4 * A5;
			break;
		case 032746:
			A7 = A4 * A6;
			break;
		case 032747:
			A7 = A4 * A7;
			break;
		case 032750:
			A7 = A5 * A0;
			break;
		case 032751:
			A7 = A5 * A1;
			break;
		case 032752:
			A7 = A5 * A2;
			break;
		case 032753:
			A7 = A5 * A3;
			break;
		case 032754:
			A7 = A5 * A4;
			break;
		case 032755:
			A7 = A5 * A5;
			break;
		case 032756:
			A7 = A5 * A6;
			break;
		case 032757:
			A7 = A5 * A7;
			break;
		case 032760:
			A7 = A6 * A0;
			break;
		case 032761:
			A7 = A6 * A1;
			break;
		case 032762:
			A7 = A6 * A2;
			break;
		case 032763:
			A7 = A6 * A3;
			break;
		case 032764:
			A7 = A6 * A4;
			break;
		case 032765:
			A7 = A6 * A5;
			break;
		case 032766:
			A7 = A6 * A6;
			break;
		case 032767:
			A7 = A6 * A7;
			break;
		case 032770:
			A7 = A7 * A0;
			break;
		case 032771:
			A7 = A7 * A1;
			break;
		case 032772:
			A7 = A7 * A2;
			break;
		case 032773:
			A7 = A7 * A3;
			break;
		case 032774:
			A7 = A7 * A4;
			break;
		case 032775:
			A7 = A7 * A5;
			break;
		case 032776:
			A7 = A7 * A6;
			break;
		case 032777:
			A7 = A7 * A7;
			break;
		case 042000:
			/* CAL S0 -1 */
			/* CAL Si -1 */
			/* Enters -1 into Si */
			S0 = -1;
			break;
		case 042100:
			/* CAL S1 -1 */
			S1 = -1;
			break;
		case 042200:
			/* CAL S2 -1 */
			S2 = -1;
			break;
		case 042300:
			/* CAL S3 -1 */
			S3 = -1;
			break;
		case 042400:
			/* CAL S4 -1 */
			S4 = -1;
			break;
		case 042500:
			/* CAL S5 -1 */
			S5 = -1;
			break;
		case 042600:
			/* CAL S6 -1 */
			S6 = -1;
			break;
		case 042700:
			/* CAL S7 -1 */
			S7 = -1;
			break;
		case 042077:
			/* CAL S0 1 */
			/* CAL Si 1 */
			/* Enter 1 into Si */
			S0 = 1;
			break;
		case 042177:
			/* CAL S1 1 */
			S1 = 1;
			break;
		case 042277:
			/* CAL S2 1 */
			S2 = 1;
			break;
		case 042377:
			/* CAL S3 1 */
			S3 = 1;
			break;
		case 042477:
			/* CAL S4 1 */
			S4 = 1;
			break;
		case 042577:
			/* CAL S5 1 */
			S5 = 1;
			break;
		case 042677:
			/* CAL S6 1 */
			S6 = 1;
			break;
		case 042777:
			/* CAL S7 1 */
			S7 = 1;
			break;
		case 043000:
			/* CAL S0 0 */
			/* CAL Si 0 */
			/* Sets Si to 0 */
			S0 = 0;
			break;
		case 043100:
			/* CAL S1 0 */
			S1 = 0;
			break;
		case 043200:
			/* CAL S2 0 */
			S2 = 0;
			break;
		case 043300:
			/* CAL S3 0 */
			S3 = 0;
			break;
		case 043400:
			/* CAL S4 0 */
			S4 = 0;
			break;
		case 043500:
			/* CAL S5 0 */
			S5 = 0;
			break;
		case 043600:
			/* CAL S6 0 */
			S6 = 0;
			break;
		case 043700:
			/* CAL S7 0 */
			S7 = 0;
			break;
		case 051001:
			/* CAL S0 S1 */
			/* CAL Si Sk */
			/* Transmits Sk to Si */
			S1 = S0;
			break;
		case 051002:
			/* CAL S0 S2 */
			S2 = S0;
			break;
		case 051003:
			/* CAL S0 S3 */
			S3 = S0;
			break;
		case 051004:
			/* CAL S0 S4 */
			S4 = S0;
			break;
		case 051005:
			/* CAL S0 S5 */
			S5 = S0;
			break;
		case 051006:
			/* CAL S0 S6 */
			S6 = S0;
			break;
		case 051007:
			/* CAL S0 S7 */
			S7 = S0;
			break;
		case 051102:
			/* CAL S1 S2 */
			S2 = S1;
			break;
		case 051103:
			/* CAL S1 S3 */
			S3 = S1;
			break;
		case 051104:
			/* CAL S1 S4 */
			S4 = S1;
			break;
		case 051105:
			/* CAL S1 S5 */
			S5 = S1;
			break;
		case 051106:
			/* CAL S1 S6 */
			S6 = S1;
			break;
		case 051107:
			/* CAL S1 S7 */
			S7 = S1;
			break;
		case 051201:
			/* CAL S2 S1 */
			S1 = S2;
			break;
		case 051203:
			/* CAL S2 S3 */
			S3 = S2;
			break;
		case 051204:
			/* CAL S2 S4 */
			S4 = S2;
			break;
		case 051205:
			/* CAL S2 S5 */
			S5 = S2;
			break;
		case 051206:
			/* CAL S2 S6 */
			S6 = S2;
			break;
		case 051207:
			/* CAL S2 S7 */
			S7 = S2;
			break;
		case 051301:
			/* CAL S3 S1 */
			S1 = S3;
			break;
		case 051302:
			/* CAL S3 S2 */
			S2 = S3;
			break;
		case 051304:
			/* CAL S3 S4 */
			S4 = S3;
			break;
		case 051305:
			/* CAL S3 S5 */
			S5 = S3;
			break;
		case 051306:
			/* CAL S3 S6 */
			S6 = S3;
			break;
		case 051307:
			/* CAL S3 S7 */
			S7 = S3;
			break;
		case 051401:
			/* CAL S4 S1 */
			S1 = S4;
			break;
		case 051402:
			/* CAL S4 S2 */
			S2 = S4;
			break;
		case 051403:
			/* CAL S4 S3 */
			S3 = S4;
			break;
		case 051405:
			/* CAL S4 S5 */
			S5 = S4;
			break;
		case 051406:
			/* CAL S4 S6 */
			S6 = S4;
			break;
		case 051407:
			/* CAL S4 S7 */
			S7 = S4;
			break;
		case 051501:
			/* CAL S5 S1 */
			S1 = S5;
			break;
		case 051502:
			/* CAL S5 S2 */
			S2 = S5;
			break;
		case 051503:
			/* CAL S5 S3 */
			S3 = S5;
			break;
		case 051504:
			/* CAL S5 S4 */
			S4 = S5;
			break;
		case 051506:
			/* CAL S5 S6 */
			S6 = S5;
			break;
		case 051507:
			/* CAL S5 S7 */
			S7 = S5;
			break;
		case 051601:
			/* CAL S6 S1 */
			S1 = S6;
			break;
		case 051602:
			/* CAL S6 S2 */
			S2 = S6;
			break;
		case 051603:
			/* CAL S6 S3 */
			S3 = S6;
			break;
		case 051604:
			/* CAL S6 S4 */
			S4 = S6;
			break;
		case 051605:
			/* CAL S6 S5 */
			S5 = S6;
			break;
		case 051607:
			/* CAL S6 S7 */
			S7 = S6;
			break;
		case 051701:
			/* CAL S7 S1 */
			S1 = S7;
			break;
		case 051702:
			/* CAL S7 S2 */
			S2 = S7;
			break;
		case 051703:
			/* CAL S7 S3 */
			S3 = S7;
			break;
		case 051704:
			/* CAL S7 S4 */
			S4 = S7;
			break;
		case 051705:
			/* CAL S7 S5 */
			S5 = S7;
			break;
		case 051706:
			/* CAL S7 S6 */
			S6 = S7;
			break;
		case 051000:
			/* CAL S0 SB */
			/* CAL Si SB */
			/* Enter sign bit into Si */
			break;
		case 051100:
			/* CAL S1 SB */
			break;
		case 051200:
			/* CAL S2 SB */
			break;
		case 051300:
			/* CAL S3 SB */
			break;
		case 051400:
			/* CAL S4 SB */
			break;
		case 051500:
			/* CAL S5 SB */
			break;
		case 051600:
			/* CAL S6 SB */
			break;
		case 051700:
			/* CAL S7 SB */
			break;
		case 060001:
			/* CAL S0 S0 + S1 */
			/* CAL Si Sj + Sk */
			/* Integer sum of Sj and Sk to Si.*/
			S0 = S0 + S1;
			break;
		case 060002:
			/* CAL S0 S0 + S2 */
			S0 = S0 + S2;
			break;
		case 060003:
			/* CAL S0 S0 + S3 */
			S0 = S0 + S3;
			break;
		case 060004:
			/* CAL S0 S0 + S4 */
			S0 = S0 + S4;
			break;
		case 060005:
			/* CAL S0 S0 + S5 */
			S0 = S0 + S5;
			break;
		case 060006:
			/* CAL S0 S0 + S6 */
			S0 = S0 + S6;
			break;
		case 060007:
			/* CAL S0 S0 + S7 */
			S0 = S0 + S7;
			break;
		case 060011:
			S0 = S1 + S1;
		case 060012:
			/* CAL S0 S1 + S2 */
			S0 = S1 + S2;
			break;
		case 060013:
			/* CAL S0 S1 + S3 */
			S0 = S1 + S3;
			break;
		case 060014:
			/* CAL S0 S1 + S4 */
			S0 = S1 + S4;
			break;
		case 060015:
			/* CAL S0 S1 + S5 */
			S0 = S1 + S5;
			break;
		case 060016:
			/* CAL S0 S1 + S6 */
			S0 = S1 + S6;
			break;
		case 060017:
			/* CAL S0 S1 + S7 */
			S0 = S1 + S7;
			break;
		case 060021:
			/* CAL S0 S2 + S1 */
			S0 = S2 + S1;
			break;
		case 060022:
			S0 = S2 + S2;
			break;
		case 060023:
			/* CAL S0 S2 + S3 */
			S0 = S2 + S3;
			break;
		case 060024:
			/* CAL S0 S2 + S4 */
			S0 = S2 + S4;
			break;
		case 060025:
			/* CAL S0 S2 + S5 */
			S0 = S2 + S5;
			break;
		case 060026:
			/* CAL S0 S2 + S6 */
			S0 = S2 + S6;
			break;
		case 060027:
			/* CAL S0 S2 + S7 */
			S0 = S2 + S7;
			break;
		case 060031:
			/* CAL S0 S3 + S1 */
			S0 = S3 + S1;
			break;
		case 060032:
			/* CAL S0 S3 + S2 */
			S0 = S3 + S2;
			break;
		case 060033:
			S0 = S3 + S3;
			break;
		case 060034:
			S0 = S3 + S4;
			break;
		case 060035:
			S0 = S3 + S5;
			break;
		case 060036:
			S0 = S3 + S6;
			break;
		case 060037:
			S0 = S3 + S7;
			break;
		case 060041:
			S0 = S4 + S1;
			break;
		case 060042:
			S0 = S4 + S2;
			break;
		case 060043:
			S0 = S4 + S3;
			break;
		case 060044:
			S0 = S4 + S4;
			break;
		case 060045:
			S0 = S4 + S5;
			break;
		case 060046:
			S0 = S4 + S6;
			break;
		case 060047:
			S0 = S4 + S7;
			break;
		case 060051:
			S0 = S5 + S1;
			break;
		case 060052:
			S0 = S5 + S2;
			break;
		case 060053:
			S0 = S5 + S3;
			break;
		case 060054:
			S0 = S5 + S4;
			break;
		case 060055:
			S0 = S5 + S5;
			break;
		case 060056:
			S0 = S5 + S6;
			break;
		case 060057:
			S0 = S5 + S7;
			break;
		case 060061:
			S0 = S6 + S1;
			break;
		case 060062:
			S0 = S6 + S2;
			break;
		case 060063:
			S0 = S6 + S3;
			break;
		case 060064:
			S0 = S6 + S4;
			break;
		case 060065:
			S0 = S6 + S5;
			break;
		case 060066:
			S0 = S6 + S6;
			break;
		case 060067:
			S0 = S6 + S7;
			break;
		case 060071:
			S0 = S7 + S1;
			break;
		case 060072:
			S0 = S7 + S2;
			break;
		case 060073:
			S0 = S7 + S3;
			break;
		case 060074:
			S0 = S7 + S4;
			break;
		case 060075:
			S0 = S7 + S5;
			break;
		case 060076:
			S0 = S7 + S6;
			break;
		case 060077:
			S0 = S7 + S7;
			break;
		case 060101:
			S1 = S0 + S1;
			break;
		case 060102:
			S1 = S0 + S2;
			break;
		case 060103:
			S1 = S0 + S3;
			break;
		case 060104:
			S1 = S0 + S4;
			break;
		case 060105:
			S1 = S0 + S5;
			break;
		case 060106:
			S1 = S0 + S6;
			break;
		case 060107:
			S1 = S0 + S7;
			break;
		case 060111:
			S1 = S1 + S1;
			break;
		case 060112:
			S1 = S1 + S2;
			break;
		case 060113:
			S1 = S1 + S3;
			break;
		case 060114:
			S1 = S1 + S4;
			break;
		case 060115:
			S1 = S1 + S5;
			break;
		case 060116:
			S1 = S1 + S6;
			break;
		case 060117:
			S1 = S1 + S7;
			break;
		case 060121:
			S1 = S2 + S1;
			break;
		case 060122:
			S1 = S2 + S2;
			break;
		case 060123:
			S1 = S2 + S3;
			break;
		case 060124:
			S1 = S2 + S4;
			break;
		case 060125:
			S1 = S2 + S5;
			break;
		case 060126:
			S1 = S2 + S6;
			break;
		case 060127:
			S1 = S2 + S7;
			break;
		case 060131:
			S1 = S3 + S1;
			break;
		case 060132:
			S1 = S3 + S2;
			break;
		case 060133:
			S1 = S3 + S3;
			break;
		case 060134:
			S1 = S3 + S4;
			break;
		case 060135:
			S1 = S3 + S5;
			break;
		case 060136:
			S1 = S3 + S6;
			break;
		case 060137:
			S1 = S3 + S7;
			break;
		case 060141:
			S1 = S4 + S1;
			break;
		case 060142:
			S1 = S4 + S2;
			break;
		case 060143:
			S1 = S4 + S3;
			break;
		case 060144:
			S1 = S4 + S4;
			break;
		case 060145:
			S1 = S4 + S5;
			break;
		case 060146:
			S1 = S4 + S6;
			break;
		case 060147:
			S1 = S4 + S7;
			break;
		case 060151:
			S1 = S5 + S1;
			break;
		case 060152:
			S1 = S5 + S2;
			break;
		case 060153:
			S1 = S5 + S3;
			break;
		case 060154:
			S1 = S5 + S4;
			break;
		case 060155:
			S1 = S5 + S5;
			break;
		case 060156:
			S1 = S5 + S6;
			break;
		case 060157:
			S1 = S5 + S7;
			break;
		case 060161:
			S1 = S6 + S1;
			break;
		case 060162:
			S1 = S6 + S2;
			break;
		case 060163:
			S1 = S6 + S3;
			break;
		case 060164:
			S1 = S6 + S4;
			break;
		case 060165:
			S1 = S6 + S5;
			break;
		case 060166:
			S1 = S6 + S6;
			break;
		case 060167:
			S1 = S6 + S7;
			break;
		case 060171:
			S1 = S7 + S1;
			break;
		case 060172:
			S1 = S7 + S2;
			break;
		case 060173:
			S1 = S7 + S3;
			break;
		case 060174:
			S1 = S7 + S4;
			break;
		case 060175:
			S1 = S7 + S5;
			break;
		case 060176:
			S1 = S7 + S6;
			break;
		case 060177:
			S1 = S7 + S7;
			break;
		case 060201:
			S2 = S0 + S1;
			break;
		case 060202:
			S2 = S0 + S2;
			break;
		case 060203:
			S2 = S0 + S3;
			break;
		case 060204:
			S2 = S0 + S4;
			break;
		case 060205:
			S2 = S0 + S5;
			break;
		case 060206:
			S2 = S0 + S6;
			break;
		case 060207:
			S2 = S0 + S7;
			break;
		case 060211:
			S2 = S1 + S1;
			break;
		case 060212:
			S2 = S1 + S2;
			break;
		case 060213:
			S2 = S1 + S3;
			break;
		case 060214:
			S2 = S1 + S4;
			break;
		case 060215:
			S2 = S1 + S5;
			break;
		case 060216:
			S2 = S1 + S6;
			break;
		case 060217:
			S2 = S1 + S7;
			break;
		case 060221:
			S2 = S2 + S1;
			break;
		case 060222:
			S2 = S2 + S2;
			break;
		case 060223:
			S2 = S2 + S3;
			break;
		case 060224:
			S2 = S2 + S4;
			break;
		case 060225:
			S2 = S2 + S5;
			break;
		case 060226:
			S2 = S2 + S6;
			break;
		case 060227:
			S2 = S2 + S7;
			break;
		case 060231:
			S2 = S3 + S1;
			break;
		case 060232:
			S2 = S3 + S2;
			break;
		case 060233:
			S2 = S3 + S3;
			break;
		case 060234:
			S2 = S3 + S4;
			break;
		case 060235:
			S2 = S3 + S5;
			break;
		case 060236:
			S2 = S3 + S6;
			break;
		case 060237:
			S2 = S3 + S7;
			break;
		case 060241:
			S2 = S4 + S1;
			break;
		case 060242:
			S2 = S4 + S2;
			break;
		case 060243:
			S2 = S4 + S3;
			break;
		case 060244:
			S2 = S4 + S4;
			break;
		case 060245:
			S2 = S4 + S5;
			break;
		case 060246:
			S2 = S4 + S6;
			break;
		case 060247:
			S2 = S4 + S7;
			break;
		case 060251:
			S2 = S5 + S1;
			break;
		case 060252:
			S2 = S5 + S2;
			break;
		case 060253:
			S2 = S5 + S3;
			break;
		case 060254:
			S2 = S5 + S4;
			break;
		case 060255:
			S2 = S5 + S5;
			break;
		case 060256:
			S2 = S5 + S6;
			break;
		case 060257:
			S2 = S5 + S7;
			break;
		case 060261:
			S2 = S6 + S1;
			break;
		case 060262:
			S2 = S6 + S2;
			break;
		case 060263:
			S2 = S6 + S3;
			break;
		case 060264:
			S2 = S6 + S4;
			break;
		case 060265:
			S2 = S6 + S5;
			break;
		case 060266:
			S2 = S6 + S6;
			break;
		case 060267:
			S2 = S6 + S7;
			break;
		case 060271:
			S2 = S7 + S1;
			break;
		case 060272:
			S2 = S7 + S2;
			break;
		case 060273:
			S2 = S7 + S3;
			break;
		case 060274:
			S2 = S7 + S4;
			break;
		case 060275:
			S2 = S7 + S5;
			break;
		case 060276:
			S2 = S7 + S6;
			break;
		case 060277:
			S2 = S7 + S7;
			break;
		case 060301:
			S3 = S0 + S1;
			break;
		case 060302:
			S3 = S0 + S2;
			break;
		case 060303:
			S3 = S0 + S3;
			break;
		case 060304:
			S3 = S0 + S4;
			break;
		case 060305:
			S3 = S0 + S5;
			break;
		case 060306:
			S3 = S0 + S6;
			break;
		case 060307:
			S3 = S0 + S7;
			break;
		case 060311:
			S3 = S1 + S1;
			break;
		case 060312:
			S3 = S1 + S2;
			break;
		case 060313:
			S3 = S1 + S3;
			break;
		case 060314:
			S3 = S1 + S4;
			break;
		case 060315:
			S3 = S1 + S5;
			break;
		case 060316:
			S3 = S1 + S6;
			break;
		case 060317:
			S3 = S1 + S7;
			break;
		case 060321:
			S3 = S2 + S1;
			break;
		case 060322:
			S3 = S2 + S2;
			break;
		case 060323:
			S3 = S2 + S3;
			break;
		case 060324:
			S3 = S2 + S4;
			break;
		case 060325:
			S3 = S2 + S5;
			break;
		case 060326:
			S3 = S2 + S6;
			break;
		case 060327:
			S3 = S2 + S7;
			break;
		case 060331:
			S3 = S3 + S1;
			break;
		case 060332:
			S3 = S3 + S2;
			break;
		case 060333:
			S3 = S3 + S3;
			break;
		case 060334:
			S3 = S3 + S4;
			break;
		case 060335:
			S3 = S3 + S5;
			break;
		case 060336:
			S3 = S3 + S6;
			break;
		case 060337:
			S3 = S3 + S7;
			break;
		case 060341:
			S3 = S4 + S1;
			break;
		case 060342:
			S3 = S4 + S2;
			break;
		case 060343:
			S3 = S4 + S3;
			break;
		case 060344:
			S3 = S4 + S4;
			break;
		case 060345:
			S3 = S4 + S5;
			break;
		case 060346:
			S3 = S4 + S6;
			break;
		case 060347:
			S3 = S4 + S7;
			break;
		case 060351:
			S3 = S5 + S1;
			break;
		case 060352:
			S3 = S5 + S2;
			break;
		case 060353:
			S3 = S5 + S3;
			break;
		case 060354:
			S3 = S5 + S4;
			break;
		case 060355:
			S3 = S5 + S5;
			break;
		case 060356:
			S3 = S5 + S6;
			break;
		case 060357:
			S3 = S5 + S7;
			break;
		case 060361:
			S3 = S6 + S1;
			break;
		case 060362:
			S3 = S6 + S2;
			break;
		case 060363:
			S3 = S6 + S3;
			break;
		case 060364:
			S3 = S6 + S4;
			break;
		case 060365:
			S3 = S6 + S5;
			break;
		case 060366:
			S3 = S6 + S6;
			break;
		case 060367:
			S3 = S6 + S7;
			break;
		case 060371:
			S3 = S7 + S1;
			break;
		case 060372:
			S3 = S7 + S2;
			break;
		case 060373:
			S3 = S7 + S3;
			break;
		case 060374:
			S3 = S7 + S4;
			break;
		case 060375:
			S3 = S7 + S5;
			break;
		case 060376:
			S3 = S7 + S6;
			break;
		case 060377:
			S3 = S7 + S7;
			break;
		case 060401:
			S4 = S0 + S1;
			break;
		case 060402:
			S4 = S0 + S2;
			break;
		case 060403:
			S4 = S0 + S3;
			break;
		case 060404:
			S4 = S0 + S4;
			break;
		case 060405:
			S4 = S0 + S5;
			break;
		case 060406:
			S4 = S0 + S6;
			break;
		case 060407:
			S4 = S0 + S7;
			break;
		case 060411:
			S4 = S1 + S1;
			break;
		case 060412:
			S4 = S1 + S2;
			break;
		case 060413:
			S4 = S1 + S3;
			break;
		case 060414:
			S4 = S1 + S4;
			break;
		case 060415:
			S4 = S1 + S5;
			break;
		case 060416:
			S4 = S1 + S6;
			break;
		case 060417:
			S4 = S1 + S7;
			break;
		case 060421:
			S4 = S2 + S1;
			break;
		case 060422:
			S4 = S2 + S2;
			break;
		case 060423:
			S4 = S2 + S3;
			break;
		case 060424:
			S4 = S2 + S4;
			break;
		case 060425:
			S4 = S2 + S5;
			break;
		case 060426:
			S4 = S2 + S6;
			break;
		case 060427:
			S4 = S2 + S7;
			break;
		case 060431:
			S4 = S3 + S1;
			break;
		case 060432:
			S4 = S3 + S2;
			break;
		case 060433:
			S4 = S3 + S3;
			break;
		case 060434:
			S4 = S3 + S4;
			break;
		case 060435:
			S4 = S3 + S5;
			break;
		case 060436:
			S4 = S3 + S6;
			break;
		case 060437:
			S4 = S3 + S7;
			break;
		case 060441:
			S4 = S4 + S1;
			break;
		case 060442:
			S4 = S4 + S2;
			break;
		case 060443:
			S4 = S4 + S3;
			break;
		case 060444:
			S4 = S4 + S4;
			break;
		case 060445:
			S4 = S4 + S5;
			break;
		case 060446:
			S4 = S4 + S6;
			break;
		case 060447:
			S4 = S4 + S7;
			break;
		case 060451:
			S4 = S5 + S1;
			break;
		case 060452:
			S4 = S5 + S2;
			break;
		case 060453:
			S4 = S5 + S3;
			break;
		case 060454:
			S4 = S5 + S4;
			break;
		case 060455:
			S4 = S5 + S5;
			break;
		case 060456:
			S4 = S5 + S6;
			break;
		case 060457:
			S4 = S5 + S7;
			break;
		case 060461:
			S4 = S6 + S1;
			break;
		case 060462:
			S4 = S6 + S2;
			break;
		case 060463:
			S4 = S6 + S3;
			break;
		case 060464:
			S4 = S6 + S4;
			break;
		case 060465:
			S4 = S6 + S5;
			break;
		case 060466:
			S4 = S6 + S6;
			break;
		case 060467:
			S4 = S6 + S7;
			break;
		case 060471:
			S4 = S7 + S1;
			break;
		case 060472:
			S4 = S7 + S2;
			break;
		case 060473:
			S4 = S7 + S3;
			break;
		case 060474:
			S4 = S7 + S4;
			break;
		case 060475:
			S4 = S7 + S5;
			break;
		case 060476:
			S4 = S7 + S6;
			break;
		case 060477:
			S4 = S7 + S7;
			break;
		case 060501:
			S5 = S0 + S1;
			break;
		case 060502:
			S5 = S0 + S2;
			break;
		case 060503:
			S5 = S0 + S3;
			break;
		case 060504:
			S5 = S0 + S4;
			break;
		case 060505:
			S5 = S0 + S5;
			break;
		case 060506:
			S5 = S0 + S6;
			break;
		case 060507:
			S5 = S0 + S7;
			break;
		case 060511:
			S5 = S1 + S1;
			break;
		case 060512:
			S5 = S1 + S2;
			break;
		case 060513:
			S5 = S1 + S3;
			break;
		case 060514:
			S5 = S1 + S4;
			break;
		case 060515:
			S5 = S1 + S5;
			break;
		case 060516:
			S5 = S1 + S6;
			break;
		case 060517:
			S5 = S1 + S7;
			break;
		case 060521:
			S5 = S2 + S1;
			break;
		case 060522:
			S5 = S2 + S2;
			break;
		case 060523:
			S5 = S2 + S3;
			break;
		case 060524:
			S5 = S2 + S4;
			break;
		case 060525:
			S5 = S2 + S5;
			break;
		case 060526:
			S5 = S2 + S6;
			break;
		case 060527:
			S5 = S2 + S7;
			break;
		case 060531:
			S5 = S3 + S1;
			break;
		case 060532:
			S5 = S3 + S2;
			break;
		case 060533:
			S5 = S3 + S3;
			break;
		case 060534:
			S5 = S3 + S4;
			break;
		case 060535:
			S5 = S3 + S5;
			break;
		case 060536:
			S5 = S3 + S6;
			break;
		case 060537:
			S5 = S3 + S7;
			break;
		case 060541:
			S5 = S4 + S1;
			break;
		case 060542:
			S5 = S4 + S2;
			break;
		case 060543:
			S5 = S4 + S3;
			break;
		case 060544:
			S5 = S4 + S4;
			break;
		case 060545:
			S5 = S4 + S5;
			break;
		case 060546:
			S5 = S4 + S6;
			break;
		case 060547:
			S5 = S4 + S7;
			break;
		case 060551:
			S5 = S5 + S1;
			break;
		case 060552:
			S5 = S5 + S2;
			break;
		case 060553:
			S5 = S5 + S3;
			break;
		case 060554:
			S5 = S5 + S4;
			break;
		case 060555:
			S5 = S5 + S5;
			break;
		case 060556:
			S5 = S5 + S6;
			break;
		case 060557:
			S5 = S5 + S7;
			break;
		case 060561:
			S5 = S6 + S1;
			break;
		case 060562:
			S5 = S6 + S2;
			break;
		case 060563:
			S5 = S6 + S3;
			break;
		case 060564:
			S5 = S6 + S4;
			break;
		case 060565:
			S5 = S6 + S5;
			break;
		case 060566:
			S5 = S6 + S6;
			break;
		case 060567:
			S5 = S6 + S7;
			break;
		case 060571:
			S5 = S7 + S1;
			break;
		case 060572:
			S5 = S7 + S2;
			break;
		case 060573:
			S5 = S7 + S3;
			break;
		case 060574:
			S5 = S7 + S4;
			break;
		case 060575:
			S5 = S7 + S5;
			break;
		case 060576:
			S5 = S7 + S6;
			break;
		case 060577:
			S5 = S7 + S7;
			break;
		case 060601:
			S6 = S0 + S1;
			break;
		case 060602:
			S6 = S0 + S2;
			break;
		case 060603:
			S6 = S0 + S3;
			break;
		case 060604:
			S6 = S0 + S4;
			break;
		case 060605:
			S6 = S0 + S5;
			break;
		case 060606:
			S6 = S0 + S6;
			break;
		case 060607:
			S6 = S0 + S7;
			break;
		case 060611:
			S6 = S1 + S1;
			break;
		case 060612:
			S6 = S1 + S2;
			break;
		case 060613:
			S6 = S1 + S3;
			break;
		case 060614:
			S6 = S1 + S4;
			break;
		case 060615:
			S6 = S1 + S5;
			break;
		case 060616:
			S6 = S1 + S6;
			break;
		case 060617:
			S6 = S1 + S7;
			break;
		case 060621:
			S6 = S2 + S1;
			break;
		case 060622:
			S6 = S2 + S2;
			break;
		case 060623:
			S6 = S2 + S3;
			break;
		case 060624:
			S6 = S2 + S4;
			break;
		case 060625:
			S6 = S2 + S5;
			break;
		case 060626:
			S6 = S2 + S6;
			break;
		case 060627:
			S6 = S2 + S7;
			break;
		case 060631:
			S6 = S3 + S1;
			break;
		case 060632:
			S6 = S3 + S2;
			break;
		case 060633:
			S6 = S3 + S3;
			break;
		case 060634:
			S6 = S3 + S4;
			break;
		case 060635:
			S6 = S3 + S5;
			break;
		case 060636:
			S6 = S3 + S6;
			break;
		case 060637:
			S6 = S3 + S7;
			break;
		case 060641:
			S6 = S4 + S1;
			break;
		case 060642:
			S6 = S4 + S2;
			break;
		case 060643:
			S6 = S4 + S3;
			break;
		case 060644:
			S6 = S4 + S4;
			break;
		case 060645:
			S6 = S4 + S5;
			break;
		case 060646:
			S6 = S4 + S6;
			break;
		case 060647:
			S6 = S4 + S7;
			break;
		case 060651:
			S6 = S5 + S1;
			break;
		case 060652:
			S6 = S5 + S2;
			break;
		case 060653:
			S6 = S5 + S3;
			break;
		case 060654:
			S6 = S5 + S4;
			break;
		case 060655:
			S6 = S5 + S5;
			break;
		case 060656:
			S6 = S5 + S6;
			break;
		case 060657:
			S6 = S5 + S7;
			break;
		case 060661:
			S6 = S6 + S1;
			break;
		case 060662:
			S6 = S6 + S2;
			break;
		case 060663:
			S6 = S6 + S3;
			break;
		case 060664:
			S6 = S6 + S4;
			break;
		case 060665:
			S6 = S6 + S5;
			break;
		case 060666:
			S6 = S6 + S6;
			break;
		case 060667:
			S6 = S6 + S7;
			break;
		case 060671:
			S6 = S7 + S1;
			break;
		case 060672:
			S6 = S7 + S2;
			break;
		case 060673:
			S6 = S7 + S3;
			break;
		case 060674:
			S6 = S7 + S4;
			break;
		case 060675:
			S6 = S7 + S5;
			break;
		case 060676:
			S6 = S7 + S6;
			break;
		case 060677:
			S6 = S7 + S7;
			break;
		case 060701:
			S7 = S0 + S1;
			break;
		case 060702:
			S7 = S0 + S2;
			break;
		case 060703:
			S7 = S0 + S3;
			break;
		case 060704:
			S7 = S0 + S4;
			break;
		case 060705:
			S7 = S0 + S5;
			break;
		case 060706:
			S7 = S0 + S6;
			break;
		case 060707:
			S7 = S0 + S7;
			break;
		case 060711:
			S7 = S1 + S1;
			break;
		case 060712:
			S7 = S1 + S2;
			break;
		case 060713:
			S7 = S1 + S3;
			break;
		case 060714:
			S7 = S1 + S4;
			break;
		case 060715:
			S7 = S1 + S5;
			break;
		case 060716:
			S7 = S1 + S6;
			break;
		case 060717:
			S7 = S1 + S7;
			break;
		case 060721:
			S7 = S2 + S1;
			break;
		case 060722:
			S7 = S2 + S2;
			break;
		case 060723:
			S7 = S2 + S3;
			break;
		case 060724:
			S7 = S2 + S4;
			break;
		case 060725:
			S7 = S2 + S5;
			break;
		case 060726:
			S7 = S2 + S6;
			break;
		case 060727:
			S7 = S2 + S7;
			break;
		case 060731:
			S7 = S3 + S1;
			break;
		case 060732:
			S7 = S3 + S2;
			break;
		case 060733:
			S7 = S3 + S3;
			break;
		case 060734:
			S7 = S3 + S4;
			break;
		case 060735:
			S7 = S3 + S5;
			break;
		case 060736:
			S7 = S3 + S6;
			break;
		case 060737:
			S7 = S3 + S7;
			break;
		case 060741:
			S7 = S4 + S1;
			break;
		case 060742:
			S7 = S4 + S2;
			break;
		case 060743:
			S7 = S4 + S3;
			break;
		case 060744:
			S7 = S4 + S4;
			break;
		case 060745:
			S7 = S4 + S5;
			break;
		case 060746:
			S7 = S4 + S6;
			break;
		case 060747:
			S7 = S4 + S7;
			break;
		case 060751:
			S7 = S5 + S1;
			break;
		case 060752:
			S7 = S5 + S2;
			break;
		case 060753:
			S7 = S5 + S3;
			break;
		case 060754:
			S7 = S5 + S4;
			break;
		case 060755:
			S7 = S5 + S5;
			break;
		case 060756:
			S7 = S5 + S6;
			break;
		case 060757:
			S7 = S5 + S7;
			break;
		case 060761:
			S7 = S6 + S1;
			break;
		case 060762:
			S7 = S6 + S2;
			break;
		case 060763:
			S7 = S6 + S3;
			break;
		case 060764:
			S7 = S6 + S4;
			break;
		case 060765:
			S7 = S6 + S5;
			break;
		case 060766:
			S7 = S6 + S6;
			break;
		case 060767:
			S7 = S6 + S7;
			break;
		case 060771:
			S7 = S7 + S1;
			break;
		case 060772:
			S7 = S7 + S2;
			break;
		case 060773:
			S7 = S7 + S3;
			break;
		case 060774:
			S7 = S7 + S4;
			break;
		case 060775:
			S7 = S7 + S5;
			break;
		case 060776:
			S7 = S7 + S6;
			break;
		case 060777:
			S7 = S7 + S7;
			break;
		case 061011:
			/* CAL S0 S1 - S1 */
			/* CAL Si Sj - Sk */
			S0 = S1 - S1;
			break;
		case 061012:
			S0 = S1 - S2;
			break;
		case 061013:
			S0 = S1 - S3;
			break;
		case 061014:
			S0 = S1 - S4;
			break;
		case 061015:
			S0 = S1 - S5;
			break;
		case 061016:
			S0 = S1 - S6;
			break;
		case 061017:
			S0 = S1 - S7;
			break;
		case 061021:
			S0 = S2 - S1;
			break;
		case 061022:
			S0 = S2 - S2;
			break;
		case 061023:
			S0 = S2 - S3;
			break;
		case 061024:
			S0 = S2 - S4;
			break;
		case 061025:
			S0 = S2 - S5;
			break;
		case 061026:
			S0 = S2 - S6;
			break;
		case 061027:
			S0 = S2 - S7;
			break;
		case 061031:
			S0 = S3 - S1;
			break;
		case 061032:
			S0 = S3 - S2;
			break;
		case 061033:
			S0 = S3 - S3;
			break;
		case 061034:
			S0 = S3 - S4;
			break;
		case 061035:
			S0 = S3 - S5;
			break;
		case 061036:
			S0 = S3 - S6;
			break;
		case 061037:
			S0 = S3 - S7;
			break;
		case 061041:
			S0 = S4 - S1;
			break;
		case 061042:
			S0 = S4 - S2;
			break;
		case 061043:
			S0 = S4 - S3;
			break;
		case 061044:
			S0 = S4 - S4;
			break;
		case 061045:
			S0 = S4 - S5;
			break;
		case 061046:
			S0 = S4 - S6;
			break;
		case 061047:
			S0 = S4 - S7;
			break;
		case 061051:
			S0 = S5 - S1;
			break;
		case 061052:
			S0 = S5 - S2;
			break;
		case 061053:
			S0 = S5 - S3;
			break;
		case 061054:
			S0 = S5 - S4;
			break;
		case 061055:
			S0 = S5 - S5;
			break;
		case 061056:
			S0 = S5 - S6;
			break;
		case 061057:
			S0 = S5 - S7;
			break;
		case 061061:
			S0 = S6 - S1;
			break;
		case 061062:
			S0 = S6 - S2;
			break;
		case 061063:
			S0 = S6 - S3;
			break;
		case 061064:
			S0 = S6 - S4;
			break;
		case 061065:
			S0 = S6 - S5;
			break;
		case 061066:
			S0 = S6 - S6;
			break;
		case 061067:
			S0 = S6 - S7;
			break;
		case 061071:
			S0 = S7 - S1;
			break;
		case 061072:
			S0 = S7 - S2;
			break;
		case 061073:
			S0 = S7 - S3;
			break;
		case 061074:
			S0 = S7 - S4;
			break;
		case 061075:
			S0 = S7 - S5;
			break;
		case 061076:
			S0 = S7 - S6;
			break;
		case 061077:
			S0 = S7 - S7;
			break;
		/*case 061101: SUSPECT
			S1 = S0 - S1;
			break;
		case 061102:
			S1 = S0 - S2;
			break;
		case 061103:
			S1 = S0 - S3;
			break;
		case 061104:
			S1 = S0 - S4;
			break;
		case 061105:
			S1 = S0 - S5;
			break;
		case 061106:
			S1 = S0 - S6;
			break;
		case 061107:
			S1 = S0 - S7;
			break; */
		case 061111:
			S1 = S1 - S1;
			break;
		case 061112:
			S1 = S1 - S2;
			break;
		case 061113:
			S1 = S1 - S3;
			break;
		case 061114:
			S1 = S1 - S4;
			break;
		case 061115:
			S1 = S1 - S5;
			break;
		case 061116:
			S1 = S1 - S6;
			break;
		case 061117:
			S1 = S1 - S7;
			break;
		case 061121:
			/* CAL S1 S2 - S1 */
			/* CAL Si Sj - Sk */
			/* Verified by CRAY docs */
			S1 = S2 - S1;
			break;
		case 061122:
			S1 = S2 - S2;
			break;
		case 061123:
			S1 = S2 - S3;
			break;
		case 061124:
			S1 = S2 - S4;
			break;
		case 061125:
			S1 = S2 - S5;
			break;
		case 061126:
			S1 = S2 - S6;
			break;
		case 061127:
			S1 = S2 - S7;
			break;
		case 061131:
			S1 = S3 - S1;
			break;
		case 061132:
			S1 = S3 - S2;
			break;
		case 061133:
			S1 = S3 - S3;
			break;
		case 061134:
			S1 = S3 - S4;
			break;
		case 061135:
			S1 = S3 - S5;
			break;
		case 061136:
			S1 = S3 - S6;
			break;
		case 061137:
			S1 = S3 - S7;
			break;
		case 061141:
			S1 = S4 - S1;
			break;
		case 061142:
			S1 = S4 - S2;
			break;
		case 061143:
			S1 = S4 - S3;
			break;
		case 061144:
			S1 = S4 - S4;
			break;
		case 061145:
			S1 = S4 - S5;
			break;
		case 061146:
			S1 = S4 - S6;
			break;
		case 061147:
			S1 = S4 - S7;
			break;
		case 061151:
			S1 = S5 - S1;
			break;
		case 061152:
			S1 = S5 - S2;
			break;
		case 061153:
			S1 = S5 - S3;
			break;
		case 061154:
			S1 = S5 - S4;
			break;
		case 061155:
			S1 = S5 - S5;
			break;
		case 061156:
			S1 = S5 - S6;
			break;
		case 061157:
			S1 = S5 - S7;
			break;
		case 061161:
			S1 = S6 - S1;
			break;
		case 061162:
			S1 = S6 - S2;
			break;
		case 061163:
			S1 = S6 - S3;
			break;
		case 061164:
			S1 = S6 - S4;
			break;
		case 061165:
			S1 = S6 - S5;
			break;
		case 061166:
			S1 = S6 - S6;
			break;
		case 061167:
			S1 = S6 - S7;
			break;
		case 061171:
			S1 = S7 - S1;
			break;
		case 061172:
			S1 = S7 - S2;
			break;
		case 061173:
			S1 = S7 - S3;
			break;
		case 061174:
			S1 = S7 - S4;
			break;
		case 061175:
			S1 = S7 - S5;
			break;
		case 061176:
			S1 = S7 - S6;
			break;
		case 061177:
			S1 = S7 - S7;
			break;
		/* case 061201: SUSPECT
			S2 = S0 - S1;
			break;
		case 061202:
			S2 = S0 - S2;
			break;
		case 061203:
			S2 = S0 - S3;
			break;
		case 061204:
			S2 = S0 - S4;
			break;
		case 061205:
			S2 = S0 - S5;
			break;
		case 061206:
			S2 = S0 - S6;
			break;
		case 061207:
			S2 = S0 - S7;
			break; */
		case 061211:
			S2 = S1 - S1;
			break;
		case 061212:
			S2 = S1 - S2;
			break;
		case 061213:
			S2 = S1 - S3;
			break;
		case 061214:
			S2 = S1 - S4;
			break;
		case 061215:
			S2 = S1 - S5;
			break;
		case 061216:
			S2 = S1 - S6;
			break;
		case 061217:
			S2 = S1 - S7;
			break;
		case 061221:
			S2 = S2 - S1;
			break;
		case 061222:
			S2 = S2 - S2;
			break;
		case 061223:
			S2 = S2 - S3;
			break;
		case 061224:
			S2 = S2 - S4;
			break;
		case 061225:
			S2 = S2 - S5;
			break;
		case 061226:
			S2 = S2 - S6;
			break;
		case 061227:
			S2 = S2 - S7;
			break;
		case 061231:
			S2 = S3 - S1;
			break;
		case 061232:
			S2 = S3 - S2;
			break;
		case 061233:
			S2 = S3 - S3;
			break;
		case 061234:
			S2 = S3 - S4;
			break;
		case 061235:
			S2 = S3 - S5;
			break;
		case 061236:
			S2 = S3 - S6;
			break;
		case 061237:
			S2 = S3 - S7;
			break;
		case 061241:
			S2 = S4 - S1;
			break;
		case 061242:
			S2 = S4 - S2;
			break;
		case 061243:
			S2 = S4 - S3;
			break;
		case 061244:
			S2 = S4 - S4;
			break;
		case 061245:
			S2 = S4 - S5;
			break;
		case 061246:
			S2 = S4 - S6;
			break;
		case 061247:
			S2 = S4 - S7;
			break;
		case 061251:
			S2 = S5 - S1;
			break;
		case 061252:
			S2 = S5 - S2;
			break;
		case 061253:
			S2 = S5 - S3;
			break;
		case 061254:
			S2 = S5 - S4;
			break;
		case 061255:
			S2 = S5 - S5;
			break;
		case 061256:
			S2 = S5 - S6;
			break;
		case 061257:
			S2 = S5 - S7;
			break;
		case 061261:
			S2 = S6 - S1;
			break;
		case 061262:
			S2 = S6 - S2;
			break;
		case 061263:
			S2 = S6 - S3;
			break;
		case 061264:
			S2 = S6 - S4;
			break;
		case 061265:
			S2 = S6 - S5;
			break;
		case 061266:
			S2 = S6 - S6;
			break;
		case 061267:
			S2 = S6 - S7;
			break;
		case 061271:
			S2 = S7 - S1;
			break;
		case 061272:
			S2 = S7 - S2;
			break;
		case 061273:
			S2 = S7 - S3;
			break;
		case 061274:
			S2 = S7 - S4;
			break;
		case 061275:
			S2 = S7 - S5;
			break;
		case 061276:
			S2 = S7 - S7;
			break;
		case 061277:
			S2 = S7 - S7;
			break;
		/* case 061301: SUSPECT
			S3 = S0 - S1;
			break;
		case 061302:
			S3 = S0 - S2;
			break;
		case 061303:
			S3 = S0 - S3;
			break;
		case 061304:
			S3 = S0 - S4;
			break;
		case 061305:
			S3 = S0 - S5;
			break;
		case 061306:
			S3 = S0 - S6;
			break;
		case 061307:
			S3 = S0 - S7;
			break; */
		case 061311:
			S3 = S1 - S1;
			break;
		case 061312:
			S3 = S1 - S2;
			break;
		case 061313:
			S3 = S1 - S3;
			break;
		case 061314:
			S3 = S1 - S4;
			break;
		case 061315:
			S3 = S1 - S5;
			break;
		case 061316:
			S3 = S1 - S6;
			break;
		case 061317:
			S3 = S1 - S7;
			break;
		case 061321:
			S3 = S2 - S1;
			break;
		case 061322:
			S3 = S2 - S2;
			break;
		case 061323:
			S3 = S2 - S3;
			break;
		case 061324:
			S3 = S2 - S4;
			break;
		case 061325:
			S3 = S2 - S5;
			break;
		case 061326:
			S3 = S2 - S6;
			break;
		case 061327:
			S3 = S2 - S7;
			break;
		case 061331:
			S3 = S3 - S1;
			break;
		case 061332:
			S3 = S3 - S2;
			break;
		case 061333:
			S3 = S3 - S3;
			break;
		case 061334:
			S3 = S3 - S4;
			break;
		case 061335:
			S3 = S3 - S5;
			break;
		case 061336:
			S3 = S3 - S6;
			break;
		case 061337:
			S3 = S3 - S7;
			break;
		case 061341:
			S3 = S4 - S1;
			break;
		case 061342:
			S3 = S4 - S2;
			break;
		case 061343:
			S3 = S4 - S3;
			break;
		case 061344:
			S3 = S4 - S4;
			break;
		case 061345:
			S3 = S4 - S5;
			break;
		case 061346:
			S3 = S4 - S6;
			break;
		case 061347:
			S3 = S4 - S7;
			break;
		case 061351:
			S3 = S5 - S1;
			break;
		case 061352:
			S3 = S5 - S2;
			break;
		case 061353:
			S3 = S5 - S3;
			break;
		case 061354:
			S3 = S5 - S4;
			break;
		case 061355:
			S3 = S5 - S5;
			break;
		case 061356:
			S3 = S5 - S6;
			break;
		case 061357:
			S3 = S5 - S7;
			break;
		case 061361:
			S3 = S6 - S1;
			break;
		case 061362:
			S3 = S6 - S2;
			break;
		case 061363:
			S3 = S6 - S3;
			break;
		case 061364:
			S3 = S6 - S4;
			break;
		case 061365:
			S3 = S6 - S5;
			break;
		case 061366:
			S3 = S6 - S6;
			break;
		case 061367:
			S3 = S6 - S7;
			break;
		case 061371:
			S3 = S7 - S1;
			break;
		case 061372:
			S3 = S7 - S2;
			break;
		case 061373:
			S3 = S7 - S3;
			break;
		case 061374:
			S3 = S7 - S4;
			break;
		case 061375:
			S3 = S7 - S5;
			break;
		case 061376:
			S3 = S7 - S6;
			break;
		case 061377:
			S3 = S7 - S7;
			break;
		/* case 061401: SUSPECT
			S4 = S0 - S1;
			break;
		case 061402:
			S4 = S0 - S2;
			break;
		case 061403:
			S4 = S0 - S3;
			break;
		case 061404:
			S4 = S0 - S4;
			break;
		case 061405:
			S4 = S0 - S5;
			break;
		case 061406:
			S4 = S0 - S6;
			break;
		case 061407:
			S4 = S0 - S7;
			break; */
		case 061411:
			S4 = S1 - S1;
			break;
		case 061412:
			S4 = S1 - S2;
			break;
		case 061413:
			S4 = S1 - S3;
			break;
		case 061414:
			S4 = S1 - S4;
			break;
		case 061415:
			S4 = S1 - S5;
			break;
		case 061416:
			S4 = S1 - S6;
			break;
		case 061417:
			S4 = S1 - S7;
			break;
		case 061421:
			S4 = S2 - S1;
			break;
		case 061422:
			S4 = S2 - S2;
			break;
		case 061423:
			S4 = S2 - S3;
			break;
		case 061424:
			S4 = S2 - S4;
			break;
		case 061425:
			S4 = S2 - S5;
			break;
		case 061426:
			S4 = S2 - S6;
			break;
		case 061427:
			S4 = S2 - S7;
			break;
		case 061431:
			S4 = S3 - S1;
			break;
		case 061432:
			S4 = S3 - S2;
			break;
		case 061433:
			S4 = S3 - S3;
			break;
		case 061434:
			S4 = S3 - S4;
			break;
		case 061435:
			S4 = S3 - S5;
			break;
		case 061436:
			S4 = S3 - S6;
			break;
		case 061437:
			S4 = S3 - S7;
			break;
		case 061441:
			S4 = S4 - S1;
			break;
		case 061442:
			S4 = S4 - S2;
			break;
		case 061443:
			S4 = S4 - S3;
			break;
		case 061444:
			S4 = S4 - S4;
			break;
		case 061445:
			S4 = S4 - S5;
			break;
		case 061446:
			S4 = S4 - S6;
			break;
		case 061447:
			S4 = S4 - S7;
			break;
		case 061451:
			S4 = S5 - S1;
			break;
		case 061452:
			S4 = S5 - S2;
			break;
		case 061453:
			S4 = S5 - S3;
			break;
		case 061454:
			S4 = S5 - S4;
			break;
		case 061455:
			S4 = S5 - S5;
			break;
		case 061456:
			S4 = S5 - S6;
			break;
		case 061457:
			S4 = S5 - S7;
			break;
		case 061461:
			S4 = S6 - S1;
			break;
		case 061462:
			S4 = S6 - S2;
			break;
		case 061463:
			S4 = S6 - S3;
			break;
		case 061464:
			S4 = S6 - S4;
			break;
		case 061465:
			S4 = S6 - S5;
			break;
		case 061466:
			S4 = S6 - S6;
			break;
		case 061467:
			S4 = S6 - S7;
			break;
		case 061471:
			S4 = S7 - S1;
			break;
		case 061472:
			S4 = S7 - S2;
			break;
		case 061473:
			S4 = S7 - S3;
			break;
		case 061474:
			S4 = S7 - S4;
			break;
		case 061475:
			S4 = S7 - S5;
			break;
		case 061476:
			S4 = S7 - S6;
			break;
		case 061477:
			S4 = S7 - S7;
			break;
		/* case 061501: SUSPECT
			S5 = S0 - S1;
			break;
		case 061502:
			S5 = S0 - S2;
			break;
		case 061503:
			S5 = S0 - S3;
			break;
		case 061504:
			S5 = S0 - S4;
			break;
		case 061505:
			S5 = S0 - S5;
			break;
		case 061506:
			S5 = S0 - S6;
			break;
		case 061507:
			S5 = S0 - S7;
			break; */
		case 061511:
			S5 = S1 - S1;
			break;
		case 061512:
			S5 = S1 - S2;
			break;
		case 061513:
			S5 = S1 - S3;
			break;
		case 061514:
			S5 = S1 - S4;
			break;
		case 061515:
			S5 = S1 - S5;
			break;
		case 061516:
			S5 = S1 - S6;
			break;
		case 061517:
			S5 = S1 - S7;
			break;
		case 061521:
			S5 = S2 - S1;
			break;
		case 061522:
			S5 = S2 - S2;
			break;
		case 061523:
			S5 = S2 - S3;
			break;
		case 061524:
			S5 = S2 - S4;
			break;
		case 061525:
			S5 = S2 - S5;
			break;
		case 061526:
			S5 = S2 - S6;
			break;
		case 061527:
			S5 = S2 - S7;
			break;
		case 061531:
			S5 = S3 - S1;
			break;
		case 061532:
			S5 = S3 - S2;
			break;
		case 061533:
			S5 = S3 - S3;
			break;
		case 061534:
			S5 = S3 - S4;
			break;
		case 061535:
			S5 = S3 - S5;
			break;
		case 061536:
			S5 = S3 - S6;
			break;
		case 061537:
			S5 = S3 - S7;
			break;
		case 061541:
			S5 = S4 - S1;
			break;
		case 061542:
			S5 = S4 - S2;
			break;
		case 061543:
			S5 = S4 - S3;
			break;
		case 061544:
			S5 = S4 - S4;
			break;
		case 061545:
			S5 = S4 - S5;
			break;
		case 061546:
			S5 = S4 - S6;
			break;
		case 061547:
			S5 = S4 - S7;
			break;
		case 061551:
			S5 = S5 - S1;
			break;
		case 061552:
			S5 = S5 - S2;
			break;
		case 061553:
			S5 = S5 - S3;
			break;
		case 061554:
			S5 = S5 - S4;
			break;
		case 061555:
			S5 = S5 - S5;
			break;
		case 061556:
			S5 = S5 - S6;
			break;
		case 061557:
			S5 = S5 - S7;
			break;
		case 061561:
			S5 = S6 - S1;
			break;
		case 061562:
			S5 = S6 - S2;
			break;
		case 061563:
			S5 = S6 - S3;
			break;
		case 061564:
			S5 = S6 - S4;
			break;
		case 061565:
			S5 = S6 - S5;
			break;
		case 061566:
			S5 = S6 - S6;
			break;
		case 061567:
			S5 = S6 - S7;
			break;
		case 061571:
			S5 = S7 - S1;
			break;
		case 061572:
			S5 = S7 - S2;
			break;
		case 061573:
			S5 = S7 - S3;
			break;
		case 061574:
			S5 = S7 - S4;
			break;
		case 061575:
			S5 = S7 - S5;
			break;
		case 061576:
			S5 = S7 - S6;
			break;
		case 061577:
			S5 = S7 - S7;
			break;
		/* case 061601: SUSPECT
			S6 = S0 - S1;
			break;
		case 061602:
			S6 = S0 - S2;
			break;
		case 061603:
			S6 = S0 - S3;
			break;
		case 061604:
			S6 = S0 - S4;
			break;
		case 061605:
			S6 = S0 - S5;
			break;
		case 061606:
			S6 = S0 - S6;
			break;
		case 061607:
			S6 = S0 - S7;
			break; */
		case 061611:
			S6 = S1 - S1;
			break;
		case 061612:
			S6 = S1 - S2;
			break;
		case 061613:
			S6 = S1 - S3;
			break;
		case 061614:
			S6 = S1 - S4;
			break;
		case 061615:
			S6 = S1 - S5;
			break;
		case 061616:
			S6 = S1 - S6;
			break;
		case 061617:
			S6 = S1 - S7;
			break;
		case 061621:
			S6 = S2 - S1;
			break;
		case 061622:
			S6 = S2 - S2;
			break;
		case 061623:
			S6 = S2 - S3;
			break;
		case 061624:
			S6 = S2 - S4;
			break;
		case 061625:
			S6 = S2 - S5;
			break;
		case 061626:
			S6 = S2 - S6;
			break;
		case 061627:
			S6 = S2 - S7;
			break;
		case 061631:
			S6 = S3 - S1;
			break;
		case 061632:
			S6 = S3 - S2;
			break;
		case 061633:
			S6 = S3 - S3;
			break;
		case 061634:
			S6 = S3 - S4;
			break;
		case 061635:
			S6 = S3 - S5;
			break;
		case 061636:
			S6 = S3 - S6;
			break;
		case 061637:
			S6 = S3 - S7;
			break;
		case 061641:
			S6 = S4 - S1;
			break;
		case 061642:
			S6 = S4 - S2;
			break;
		case 061643:
			S6 = S4 - S3;
			break;
		case 061644:
			S6 = S4 - S4;
			break;
		case 061645:
			S6 = S4 - S5;
			break;
		case 061646:
			S6 = S4 - S6;
			break;
		case 061647:
			S6 = S4 - S7;
			break;
		case 061651:
			S6 = S5 - S1;
			break;
		case 061652:
			S6 = S5 - S2;
			break;
		case 061653:
			S6 = S5 - S3;
			break;
		case 061654:
			S6 = S5 - S4;
			break;
		case 061655:
			S6 = S5 - S5;
			break;
		case 061656:
			S6 = S5 - S6;
			break;
		case 061657:
			S6 = S5 - S7;
			break;
		case 061661:
			S6 = S6 - S1;
			break;
		case 061662:
			S6 = S6 - S2;
			break;
		case 061663:
			S6 = S6 - S3;
			break;
		case 061664:
			S6 = S6 - S4;
			break;
		case 061665:
			S6 = S6 - S5;
			break;
		case 061666:
			S6 = S6 - S6;
			break;
		case 061667:
			S6 = S6 - S7;
			break;
		case 061671:
			S6 = S7 - S1;
			break;
		case 061672:
			S6 = S7 - S2;
			break;
		case 061673:
			S6 = S7 - S3;
			break;
		case 061674:
			S6 = S7 - S4;
			break;
		case 061675:
			S6 = S7 - S5;
			break;
		case 061676:
			S6 = S7 - S6;
			break;
		case 061677:
			S6 = S7 - S7;
			break;
		/* case 061701: SUSPECT
			S7 = S0 - S1;
			break;
		case 061702:
			S7 = S0 - S2;
			break;
		case 061703:
			S7 = S0 - S3;
			break;
		case 061704:
			S7 = S0 - S4;
			break;
		case 061705:
			S7 = S0 - S5;
			break;
		case 061706:
			S7 = S0 - S6;
			break;
		case 061707:
			S7 = S0 - S7;
			break; */
		case 061711:
			S7 = S1 - S1;
			break;
		case 061712:
			S7 = S1 - S2;
			break;
		case 061713:
			S7 = S1 - S3;
			break;
		case 061714:
			S7 = S1 - S4;
			break;
		case 061715:
			S7 = S1 - S5;
			break;
		case 061716:
			S7 = S1 - S6;
			break;
		case 061717:
			S7 = S1 - S7;
			break;
		case 061721:
			S7 = S2 - S1;
			break;
		case 061722:
			S7 = S2 - S2;
			break;
		case 061723:
			S7 = S2 - S3;
			break;
		case 061724:
			S7 = S2 - S4;
			break;
		case 061725:
			S7 = S2 - S5;
			break;
		case 061726:
			S7 = S2 - S6;
			break;
		case 061727:
			S7 = S2 - S7;
			break;
		case 061731:
			S7 = S3 - S1;
			break;
		case 061732:
			S7 = S3 - S2;
			break;
		case 061733:
			S7 = S3 - S3;
			break;
		case 061734:
			S7 = S3 - S4;
			break;
		case 061735:
			S7 = S3 - S5;
			break;
		case 061736:
			S7 = S3 - S6;
			break;
		case 061737:
			S7 = S3 - S7;
			break;
		case 061741:
			S7 = S4 - S1;
			break;
		case 061742:
			S7 = S4 - S2;
			break;
		case 061743:
			S7 = S4 - S3;
			break;
		case 061744:
			S7 = S4 - S4;
			break;
		case 061745:
			S7 = S4 - S5;
			break;
		case 061746:
			S7 = S4 - S6;
			break;
		case 061747:
			S7 = S4 - S7;
			break;
		case 061751:
			S7 = S5 - S1;
			break;
		case 061752:
			S7 = S5 - S2;
			break;
		case 061753:
			S7 = S5 - S3;
			break;
		case 061754:
			S7 = S5 - S4;
			break;
		case 061755:
			S7 = S5 - S5;
			break;
		case 061756:
			S7 = S5 - S6;
			break;
		case 061757:
			S7 = S5 - S7;
			break;
		case 061761:
			S7 = S6 - S1;
			break;
		case 061762:
			S7 = S6 - S2;
			break;
		case 061763:
			S7 = S6 - S3;
			break;
		case 061764:
			S7 = S6 - S4;
			break;
		case 061765:
			S7 = S6 - S5;
			break;
		case 061766:
			S7 = S6 - S6;
			break;
		case 061767:
			S7 = S6 - S7;
			break;
		case 061771:
			S7 = S7 - S1;
			break;
		case 061772:
			S7 = S7 - S2;
			break;
		case 061773:
			S7 = S7 - S3;
			break;
		case 061774:
			S7 = S7 - S4;
			break;
		case 061775:
			S7 = S7 - S5;
			break;
		case 061776:
			S7 = S7 - S6;
			break;
		case 061777:
			S7 = S7 - S7;
			break;
		case 061000:
			/* CAL Si Sj-S0 */
			/* CAL S0 S0 - S0 */
			/* Integer difference of Sj less the sign bit to Si */
			break;
		case 061010:
			break;
		case 061020:
			break;
		case 061030:
			break;
		case 061040:
			break;
		case 061050:
			break;
		case 061060:
			break;
		case 061070:
			break;
		case 061100:
			break;
		case 061110:
			break;
		case 061120:
			break;
		case 061130:
			break;
		case 061140:
			break;
		case 061150:
			break;
		case 061160:
			break;
		case 061170:
			break;
		case 061200:
			break;
		case 061210:
			break;
		case 061220:
			break;
		case 061230:
			break;
		case 061240:
			break;
		case 061250:
			break;
		case 061260:
			break;
		case 061270:
			break;
		case 061300:
			break;
		case 061310:
			break;
		case 061320:
			break;
		case 061330:
			break;
		case 061340:
			break;
		case 061350:
			break;
		case 061360:
			break;
		case 061370:
			break;
		case 061400:
			break;
		case 061410:
			break;
		case 061420:
			break;
		case 061430:
			break;
		case 061440:
			break;
		case 061450:
			break;
		case 061460:
			break;
		case 061470:
			break;
		case 061500:
			break;
		case 061510:
			break;
		case 061520:
			break;
		case 061530:
			break;
		case 061540:
			break;
		case 061550:
			break;
		case 061560:
			break;
		case 061570:
			break;
		case 061600:
			break;
		case 061610:
			break;
		case 061620:
			break;
		case 061630:
			break;
		case 061640:
			break;
		case 061650:
			break;
		case 061660:
			break;
		case 061670:
			break;
		case 061700:
			break;
		case 061710:
			break;
		case 061720:
			break;
		case 061730:
			break;
		case 061740:
			break;
		case 061750:
			break;
		case 061760:
			break;
		case 061770:
			break;
		case 061001:
			/* CAL Si -Sk */
			/* CAL S0 -S1 */
			/* S0 = negative of S1 */
			break;
		case 061002:
			/* CAL S0 -S2 */
			break;
		case 061003:
			break;
		case 061004:
			break;
		case 061005:
			break;
		case 061006:
			break;
		case 061007:
			break;
		case 061101:
			/* CAL S1 -S1 */
			break;
		case 061102:
			break;
		case 061103:
			break;
		case 061104:
			break;
		case 061105:
			break;
		case 061106:
			break;
		case 061107:
			break;
		case 061201:
			break;
		case 061202:
			break;
		case 061203:
			break;
		case 061204:
			break;
		case 061205:
			break;
		case 061206:
			break;
		case 061207:
			break;
		case 061301:
			break;
		case 061302:
			break;
		case 061303:
			break;
		case 061304:
			break;
		case 061305:
			break;
		case 061306:
			break;
		case 061307:
			break;
		case 061401:
			break;
		case 061402:
			break;
		case 061403:
			break;
		case 061404:
			break;
		case 061405:
			break;
		case 061406:
			break;
		case 061407:
			break;
		case 061501:
			break;
		case 061502:
			break;
		case 061503:
			break;
		case 061504:
			break;
		case 061505:
			break;
		case 061506:
			break;
		case 061507:
			break;
		case 061601:
			break;
		case 061602:
			break;
		case 061603:
			break;
		case 061604:
			break;
		case 061605:
			break;
		case 061606:
			break;
		case 061607:
			break;
		case 061701:
			break;
		case 061702:
			break;
		case 061703:
			break;
		case 061704:
			break;
		case 061705:
			break;
		case 061706:
			break;
		case 061707:
			break;
		case 071040:
			/* CAL Si .4 */
			break;
		case 071140:
			break;
		case 071240:
			break;
		case 071340:
			break;
		case 071440:
			break;
		case 071540:
			break;
		case 071640:
			break;
		case 071740:
			break;
		case 071050:
			/* CAL Si 1. */
			/* Sends 1.0 as a floating point number to Si */
			S0 = 1.0;
			break;
		case 071150:
			S1 = 1.0;
			break;
		case 071250:
			S2 = 1.0;
			break;
		case 071350:
			S3 = 1.0;
			break;
		case 071450:
			S4 = 1.0;
			break;
		case 071550:
			S5 = 1.0;
			break;
		case 071650:
			S6 = 1.0;
			break;
		case 071750:
			S7 = 1.0;
			break;
		case 071060:
			/* CAL Si 2. */
			/* Transmits 2.0 to Si as normalized floating point constant */
			S0 = 2.0;
			break;
		case 071160:
			S1 = 2.0;
			break;
		case 071260:
			S2 = 2.0;
			break;
		case 071360:
			S3 = 2.0;
			break;
		case 071460:
			S4 = 2.0;
			break;
		case 071560:
			S5 = 2.0;
			break;
		case 071660:
			S6 = 2.0;
			break;
		case 071760:
			S7 = 2.0;
			break;
		case 071070:
			S0 = 4.0;
			break;
		case 071170:
			S1 = 4.0;
			break;
		case 071270:
			S2 = 4.0;
			break;
		case 071370:
			S3 = 4.0;
			break;
		case 071470:
			S4 = 4.0;
			break;
		case 071570:
			S5 = 4.0;
			break;
		case 071670:
			S6 = 4.0;
			break;
		case 071770:
			S7 = 4.0;
			break;
		case 072000:
			/* CAL S0 RT */
			/* CAL Si RT */
			/* Transmits RTC to Si */
			S0 = RT;
			break;
		case 072100:
			/* CAL S1 RT */
			/* Verified by Cray docs */
			S1 = RT;
			break;
		case 072200:
			/* CAL S2 RT */
			/* Verified by Cray docs */
			S2 = RT;
			break;
		case 072300:
			/* CAL S3 RT */
			S3 = RT;
			break;
		case 072400:
			/* CAL S4 RT */
			S4 = RT;
			break;
		case 072500:
			/* CAL S5 RT */
			S5 = RT;
			break;
		case 072600:
			/* CAL S6 RT */
			S6 = RT;
			break;
		case 072700:
			/* CAL S7 RT */
			S7 = RT;
			break;
		case 072003:
			/* CAL Si STj */
			/* Transmits STj to Si */
			S0 = ST0;
			break;
		case 072013:
			S0 = ST1;
			break;
		case 072023:
			S0 = ST2;
			break;
		case 072033:
			S0 = ST3;
			break;
		case 072043:
			S0 = ST4;
			break;
		case 072053:
			S0 = ST5;
			break;
		case 072063:
			S0 = ST6;
			break;
		case 072073:
			S0 = ST7;
			break;
		case 072103:
			S1 = ST0;
			break;
		case 072113:
			S1 = ST1;
			break;
		case 072123:
			S1 = ST2;
			break;
		case 072133:
			S1 = ST3;
			break;
		case 072143:
			S1 = ST4;
			break;
		case 072153:
			S1 = ST5;
			break;
		case 072163:
			S1 = ST6;
			break;
		case 072173:
			S1 = ST7;
			break;
		case 072203:
			S2 = ST0;
			break;
		case 072213:
			S2 = ST1;
			break;
		case 072223:
			S2 = ST2;
			break;
		case 072233:
			S2 = ST3;
			break;
		case 072243:
			S2 = ST4;
			break;
		case 072253:
			S2 = ST5;
			break;
		case 072263:
			S2 = ST6;
			break;
		case 072273:
			S2 = ST7;
			break;
		case 072303:
			S3 = ST0;
			break;
		case 072313:
			S3 = ST1;
			break;
		case 072323:
			S3 = ST2;
			break;
		case 072333:
			S3 = ST3;
			break;
		case 072343:
			S3 = ST4;
			break;
		case 072353:
			S3 = ST5;
			break;
		case 072363:
			S3 = ST6;
			break;
		case 072373:
			S3 = ST7;
			break;
		case 072403:
			S4 = ST0;
			break;
		case 072413:
			S4 = ST1;
			break;
		case 072423:
			S4 = ST2;
			break;
		case 072433:
			S4 = ST3;
			break;
		case 072443:
			S4 = ST4;
			break;
		case 072453:
			S4 = ST5;
			break;
		case 072463:
			S4 = ST6;
			break;
		case 072473:
			S4 = ST7;
			break;
		case 072503:
			S5 = ST0;
			break;
		case 072513:
			S5 = ST1;
			break;
		case 072523:
			S5 = ST2;
			break;
		case 072533:
			S5 = ST3;
			break;
		case 072543:
			S5 = ST4;
			break;
		case 072553:
			S5 = ST5;
			break;
		case 072563:
			S5 = ST6;
			break;
		case 072573:
			S5 = ST7;
			break;
		case 072603:
			S6 = ST0;
			break;
		case 072613:
			S6 = ST1;
			break;
		case 072623:
			S6 = ST2;
			break;
		case 072633:
			S6 = ST3;
			break;
		case 072643:
			S6 = ST4;
			break;
		case 072653:
			S6 = ST5;
			break;
		case 072663:
			S6 = ST6;
			break;
		case 072673:
			S6 = ST7;
			break;
		case 072703:
			S7 = ST0;
			break;
		case 072713:
			S7 = ST1;
			break;
		case 072723:
			S7 = ST2;
			break;
		case 072733:
			S7 = ST3;
			break;
		case 072743:
			S7 = ST4;
			break;
		case 072753:
			S7 = ST5;
			break;
		case 072763:
			S7 = ST6;
			break;
		case 072773:
			S7 = ST7;
			break;
		case 073000:
			/* CAL S0 VM */
			/* CAL Si VM */
			/* Transmits VM to Si */
			S0 = VM;
			break;
		case 073100:
			/* CAL S1 VM */
			S1 = VM;
			break;
		case 073200:
			/* CAL S2 VM */
			S2 = VM;
			break;
		case 073300:
			/* CAL S3 VM */
			S3 = VM;
			break;
		case 073400:
			/* CAL S4 VM  */
			S4 = VM;
			break;
		case 073500:
			/* CAL S5 VM */
			S5 = VM;
			break;
		case 073600:
			/* CAL S6 VM */
			S6 = VM;
			break;
		case 073700:
			/* CAL S7 VM */
			S7 = VM;
			break;
		case 073001:
			/* CAL Si SR0 */
			/* Transmits SR(0) to Si (there is no SR1 or SR2 on a YMP) */
			S0 = SR;
			break;
		case 073101:
			S1 = SR;
			break;
		case 073201:
			S2 = SR;
			break;
		case 073301:
			S3 = SR;
			break;
		case 073401:
			S4 = SR;
			break;
		case 073501:
			S5 = SR;
			break;
		case 073601:
			S6 = SR;
			break;
		case 073701:
			S7 = SR;
			break;
		case 073005:
			/* CAL SR0 Si */
			/* CAL SR0 S0 */
			/* Transmits Si bits 2^(48) through 2^(52) to SR0 */
			break;
		case 073105:
			break;
		case 073205:
			break;
		case 073305:
			break;
		case 073405:
			break;
		case 073505:
			break;
		case 073605:
			break;
		case 073705:
			break;
		case 074000:
			/* CAL Si Tjk */
			/* Transmits Tjk to Si */
			S0 = T0;
			break;
		case 074001:
			S0 = T1;
			break;
		case 074002:
			S0 = T2;
			break;
		case 074003:
			S0 = T3;
			break;
		case 074004:
			S0 = T4;
			break;
		case 074005:
			S0 = T5;
			break;
		case 074006:
			S0 = T6;
			break;
		case 074007:
			S0 = T7;
			break;
		case 074010:
			S0 = T8;
			break;
		case 074011:
			S0 = T9;
			break;
		case 074012:
			S0 = T10;
			break;
		case 074013:
			S0 = T11;
			break;
		case 074014:
			S0 = T12;
			break;
		case 074015:
			S0 = T13;
			break;
		case 074016:
			S0 = T14;
			break;
		case 074017:
			S0 = T15;
			break;
		case 074020:
			S0 = T16;
			break;
		case 074021:
			S0 = T17;
			break;
		case 074022:
			S0 = T18;
			break;
		case 074023:
			S0 = T19;
			break;
		case 074024:
			S0 = T20;
			break;
		case 074025:
			S0 = T21;
			break;
		case 074026:
			S0 = T22;
			break;
		case 074027:
			S0 = T23;
			break;
		case 074030:
			S0 = T24;
			break;
		case 074031:
			S0 = T25;
			break;
		case 074032:
			S0 = T26;
			break;
		case 074033:
			S0 = T27;
			break;
		case 074034:
			S0 = T28;
			break;
		case 074035:
			S0 = T29;
			break;
		case 074036:
			S0 = T30;
			break;
		case 074037:
			S0 = T31;
			break;
		case 074040:
			S0 = T32;
			break;
		case 074041:
			S0 = T33;
			break;
		case 074042:
			S0 = T34;
			break;
		case 074043:
			S0 = T35;
			break;
		case 074044:
			S0 = T36;
			break;
		case 074045:
			S0 = T37;
			break;
		case 074046:
			S0 = T38;
			break;
		case 074047:
			S0 = T39;
			break;
		case 074050:
			S0 = T40;
			break;
		case 074051:
			S0 = T41;
			break;
		case 074052:
			S0 = T42;
			break;
		case 074053:
			S0 = T43;
			break;
		case 074054:
			S0 = T44;
			break;
		case 074055:
			S0 = T45;
			break;
		case 074056:
			S0 = T46;
			break;
		case 074057:
			S0 = T47;
			break;
		case 074060:
			S0 = T48;
			break;
		case 074061:
			S0 = T49;
			break;
		case 074062:
			S0 = T50;
			break;
		case 074063:
			S0 = T51;
			break;
		case 074064:
			S0 = T52;
			break;
		case 074065:
			S0 = T53;
			break;
		case 074066:
			S0 = T54;
			break;
		case 074067:
			S0 = T55;
			break;
		case 074070:
			S0 = T56;
			break;
		case 074071:
			S0 = T57;
			break;
		case 074072:
			S0 = T58;
			break;
		case 074073:
			S0 = T59;
			break;
		case 074074:
			S0 = T60;
			break;
		case 074075:
			S0 = T61;
			break;
		case 074076:
			S0 = T62;
			break;
		case 074077:
			S0 = T63;
			break;
		case 074100:
			/* CAL Si Tjk */
			/* Transmits Tjk to Si */
			S1 = T0;
			break;
		case 074101:
			S1 = T1;
			break;
		case 074102:
			S1 = T2;
			break;
		case 074103:
			S1 = T3;
			break;
		case 074104:
			S1 = T4;
			break;
		case 074105:
			S1 = T5;
			break;
		case 074106:
			S1 = T6;
			break;
		case 074107:
			S1 = T7;
			break;
		case 074110:
			S1 = T8;
			break;
		case 074111:
			S1 = T9;
			break;
		case 074112:
			S1 = T10;
			break;
		case 074113:
			S1 = T11;
			break;
		case 074114:
			S1 = T12;
			break;
		case 074115:
			S1 = T13;
			break;
		case 074116:
			S1 = T14;
			break;
		case 074117:
			S1 = T15;
			break;
		case 074120:
			S1 = T16;
			break;
		case 074121:
			S1 = T17;
			break;
		case 074122:
			S1 = T18;
			break;
		case 074123:
			S1 = T19;
			break;
		case 074124:
			S1 = T20;
			break;
		case 074125:
			S1 = T21;
			break;
		case 074126:
			S1 = T22;
			break;
		case 074127:
			S1 = T23;
			break;
		case 074130:
			S1 = T24;
			break;
		case 074131:
			S1 = T25;
			break;
		case 074132:
			S1 = T26;
			break;
		case 074133:
			S1 = T27;
			break;
		case 074134:
			S1 = T28;
			break;
		case 074135:
			S1 = T29;
			break;
		case 074136:
			S1 = T30;
			break;
		case 074137:
			S1 = T31;
			break;
		case 074140:
			S1 = T32;
			break;
		case 074141:
			S1 = T33;
			break;
		case 074142:
			S1 = T34;
			break;
		case 074143:
			S1 = T35;
			break;
		case 074144:
			S1 = T36;
			break;
		case 074145:
			S1 = T37;
			break;
		case 074146:
			S1 = T38;
			break;
		case 074147:
			S1 = T39;
			break;
		case 074150:
			S1 = T40;
			break;
		case 074151:
			S1 = T41;
			break;
		case 074152:
			S1 = T42;
			break;
		case 074153:
			S1 = T43;
			break;
		case 074154:
			S1 = T44;
			break;
		case 074155:
			S1 = T45;
			break;
		case 074156:
			S1 = T46;
			break;
		case 074157:
			S1 = T47;
			break;
		case 074160:
			S1 = T48;
			break;
		case 074161:
			S1 = T49;
			break;
		case 074162:
			S1 = T50;
			break;
		case 074163:
			S1 = T51;
			break;
		case 074164:
			S1 = T52;
			break;
		case 074165:
			S1 = T53;
			break;
		case 074166:
			S1 = T54;
			break;
		case 074167:
			S1 = T55;
			break;
		case 074170:
			S1 = T56;
			break;
		case 074171:
			S1 = T57;
			break;
		case 074172:
			S1 = T58;
			break;
		case 074173:
			S1 = T59;
			break;
		case 074174:
			S1 = T60;
			break;
		case 074175:
			S1 = T61;
			break;
		case 074176:
			S1 = T62;
			break;
		case 074177:
			S1 = T63;
			break;
		case 074200:
			/* CAL S2 T00 */
			S2 = T0;
			break;
		case 074201:
			S2 = T1;
			break;
		case 074202:
			S2 = T2;
			break;
		case 074203:
			S2 = T3;
			break;
		case 074204:
			S2 = T4;
			break;
		case 074205:
			S2 = T5;
			break;
		case 074206:
			S2 = T6;
			break;
		case 074207:
			S2 = T7;
			break;
		case 074210:
			S2 = T8;
			break;
		case 074211:
			S2 = T9;
			break;
		case 074212:
			S2 = T10;
			break;
		case 074213:
			S2 = T11;
			break;
		case 074214:
			S2 = T12;
			break;
		case 074215:
			S2 = T13;
			break;
		case 074216:
			S2 = T14;
			break;
		case 074217:
			S2 = T15;
			break;
		case 074220:
			S2 = T16;
			break;
		case 074221:
			S2 = T17;
			break;
		case 074222:
			S2 = T18;
			break;
		case 074223:
			S2 = T19;
			break;
		case 074224:
			S2 = T20;
			break;
		case 074225:
			S2 = T21;
			break;
		case 074226:
			S2 = T22;
			break;
		case 074227:
			S2 = T23;
			break;
		case 074230:
			S2 = T24;
			break;
		case 074231:
			S2 = T25;
			break;
		case 074232:
			S2 = T26;
			break;
		case 074233:
			S2 = T27;
			break;
		case 074234:
			S2 = T28;
			break;
		case 074235:
			S2 = T29;
			break;
		case 074236:
			S2 = T30;
			break;
		case 074237:
			S2 = T31;
			break;
		case 074240:
			S2 = T32;
			break;
		case 074241:
			S2 = T33;
			break;
		case 074242:
			S2 = T34;
			break;
		case 074243:
			S2 = T35;
			break;
		case 074244:
			S2 = T36;
			break;
		case 074245:
			S2 = T37;
			break;
		case 074246:
			S2 = T38;
			break;
		case 074247:
			S2 = T39;
			break;
		case 074250:
			S2 = T40;
			break;
		case 074251:
			S2 = T41;
			break;
		case 074252:
			S2 = T42;
			break;
		case 074253:
			S2 = T43;
			break;
		case 074254:
			S2 = T44;
			break;
		case 074255:
			S2 = T45;
			break;
		case 074256:
			S2 = T46;
			break;
		case 074257:
			S2 = T47;
			break;
		case 074260:
			S2 = T48;
			break;
		case 074261:
			S2 = T49;
			break;
		case 074262:
			S2 = T50;
			break;
		case 074263:
			S2 = T51;
			break;
		case 074264:
			S2 = T52;
			break;
		case 074265:
			S2 = T53;
			break;
		case 074266:
			S2 = T54;
			break;
		case 074267:
			S2 = T55;
			break;
		case 074270:
			S2 = T56;
			break;
		case 074271:
			S2 = T57;
			break;
		case 074272:
			S2 = T58;
			break;
		case 074273:
			S2 = T59;
			break;
		case 074274:
			S2 = T60;
			break;
		case 074275:
			S2 = T61;
			break;
		case 074276:
			S2 = T62;
			break;
		case 074277:
			S2 = T63;
			break;
		case 074300:
			/* CAL S3 T00 */
			S3 = T0;
			break;
		case 074301:
			S3 = T1;
			break;
		case 074302:
			S3 = T2;
			break;
		case 074303:
			S3 = T3;
			break;
		case 074304:
			S3 = T4;
			break;
		case 074305:
			S3 = T5;
			break;
		case 074306:
			S3 = T6;
			break;
		case 074307:
			S3 = T7;
			break;
		case 074310:
			S3 = T8;
			break;
		case 074311:
			S3 = T9;
			break;
		case 074312:
			S3 = T10;
			break;
		case 074313:
			S3 = T11;
			break;
		case 074314:
			S3 = T12;
			break;
		case 074315:
			S3 = T13;
			break;
		case 074316:
			S3 = T14;
			break;
		case 074317:
			S3 = T15;
			break;
		case 074320:
			S3 = T16;
			break;
		case 074321:
			S3 = T17;
			break;
		case 074322:
			S3 = T18;
			break;
		case 074323:
			S3 = T19;
			break;
		case 074324:
			S3 = T20;
			break;
		case 074325:
			S3 = T21;
			break;
		case 074326:
			S3 = T22;
			break;
		case 074327:
			S3 = T23;
			break;
		case 074330:
			S3 = T24;
			break;
		case 074331:
			S3 = T25;
			break;
		case 074332:
			S3 = T26;
			break;
		case 074333:
			S3 = T27;
			break;
		case 074334:
			S3 = T28;
			break;
		case 074335:
			S3 = T29;
			break;
		case 074336:
			S3 = T30;
			break;
		case 074337:
			S3 = T31;
			break;
		case 074340:
			S3 = T32;
			break;
		case 074341:
			S3 = T33;
			break;
		case 074342:
			S3 = T34;
			break;
		case 074343:
			S3 = T35;
			break;
		case 074344:
			S3 = T36;
			break;
		case 074345:
			S3 = T37;
			break;
		case 074346:
			S3 = T38;
			break;
		case 074347:
			S3 = T39;
			break;
		case 074350:
			S3 = T40;
			break;
		case 074351:
			S3 = T41;
			break;
		case 074352:
			S3 = T42;
			break;
		case 074353:
			S3 = T43;
			break;
		case 074354:
			S3 = T44;
			break;
		case 074355:
			S3 = T45;
			break;
		case 074356:
			S3 = T46;
			break;
		case 074357:
			S3 = T47;
			break;
		case 074360:
			S3 = T48;
			break;
		case 074361:
			S3 = T49;
			break;
		case 074362:
			S3 = T50;
			break;
		case 074363:
			S3 = T51;
			break;
		case 074364:
			S3 = T52;
			break;
		case 074365:
			S3 = T53;
			break;
		case 074366:
			S3 = T54;
			break;
		case 074367:
			S3 = T55;
			break;
		case 074370:
			S3 = T56;
			break;
		case 074371:
			S3 = T57;
			break;
		case 074372:
			S3 = T58;
			break;
		case 074373:
			S3 = T59;
			break;
		case 074374:
			S3 = T60;
			break;
		case 074375:
			S3 = T61;
			break;
		case 074376:
			S3 = T62;
			break;
		case 074377:
			S3 = T63;
			break;
		case 074400:
			/* CAL S4 T00 */
			S4 = T0;
			break;
		case 074401:
			S4 = T1;
			break;
		case 074402:
			S4 = T2;
			break;
		case 074403:
			S4 = T3;
			break;
		case 074404:
			S4 = T4;
			break;
		case 074405:
			S4 = T5;
			break;
		case 074406:
			S4 = T6;
			break;
		case 074407:
			S4 = T7;
			break;
		case 074410:
			S4 = T8;
			break;
		case 074411:
			S4 = T9;
			break;
		case 074412:
			S4 = T10;
			break;
		case 074413:
			S4 = T11;
			break;
		case 074414:
			S4 = T12;
			break;
		case 074415:
			S4 = T13;
			break;
		case 074416:
			S4 = T14;
			break;
		case 074417:
			S4 = T15;
			break;
		case 074420:
			S4 = T16;
			break;
		case 074421:
			S4 = T17;
			break;
		case 074422:
			S4 = T18;
			break;
		case 074423:
			S4 = T19;
			break;
		case 074424:
			S4 = T20;
			break;
		case 074425:
			S4 = T21;
			break;
		case 074426:
			S4 = T22;
			break;
		case 074427:
			S4 = T23;
			break;
		case 074430:
			S4 = T24;
			break;
		case 074431:
			S4 = T25;
			break;
		case 074432:
			S4 = T26;
			break;
		case 074433:
			S4 = T27;
			break;
		case 074434:
			S4 = T28;
			break;
		case 074435:
			S4 = T29;
			break;
		case 074436:
			S4 = T30;
			break;
		case 074437:
			S4 = T31;
			break;
		case 074440:
			S4 = T32;
			break;
		case 074441:
			S4 = T33;
			break;
		case 074442:
			S4 = T34;
			break;
		case 074443:
			S4 = T35;
			break;
		case 074444:
			S4 = T36;
			break;
		case 074445:
			S4 = T37;
			break;
		case 074446:
			S4 = T38;
			break;
		case 074447:
			S4 = T39;
			break;
		case 074450:
			S4 = T40;
			break;
		case 074451:
			S4 = T41;
			break;
		case 074452:
			S4 = T42;
			break;
		case 074453:
			S4 = T43;
			break;
		case 074454:
			S4 = T44;
			break;
		case 074455:
			S4 = T45;
			break;
		case 074456:
			S4 = T46;
			break;
		case 074457:
			S4 = T47;
			break;
		case 074460:
			S4 = T48;
			break;
		case 074461:
			S4 = T49;
			break;
		case 074462:
			S4 = T50;
			break;
		case 074463:
			S4 = T51;
			break;
		case 074464:
			S4 = T52;
			break;
		case 074465:
			S4 = T53;
			break;
		case 074466:
			S4 = T54;
			break;
		case 074467:
			S4 = T55;
			break;
		case 074470:
			S4 = T56;
			break;
		case 074471:
			S4 = T57;
			break;
		case 074472:
			S4 = T58;
			break;
		case 074473:
			S4 = T59;
			break;
		case 074474:
			S4 = T60;
			break;
		case 074475:
			S4 = T61;
			break;
		case 074476:
			S4 = T62;
			break;
		case 074477:
			S4 = T63;
			break;
		case 074500:
			/* CAL S5 T00 */
			S5 = T0;
			break;
		case 074501:
			S5 = T1;
			break;
		case 074502:
			S5 = T2;
			break;
		case 074503:
			S5 = T3;
			break;
		case 074504:
			S5 = T4;
			break;
		case 074505:
			S5 = T5;
			break;
		case 074506:
			S5 = T6;
			break;
		case 074507:
			S5 = T7;
			break;
		case 074510:
			S5 = T8;
			break;
		case 074511:
			S5 = T9;
			break;
		case 074512:
			S5 = T10;
			break;
		case 074513:
			S5 = T11;
			break;
		case 074514:
			S5 = T12;
			break;
		case 074515:
			S5 = T13;
			break;
		case 074516:
			S5 = T14;
			break;
		case 074517:
			S5 = T15;
			break;
		case 074520:
			S5 = T16;
			break;
		case 074521:
			S5 = T17;
			break;
		case 074522:
			S5 = T18;
			break;
		case 074523:
			S5 = T19;
			break;
		case 074524:
			S5 = T20;
			break;
		case 074525:
			S5 = T21;
			break;
		case 074526:
			S5 = T22;
			break;
		case 074527:
			S5 = T23;
			break;
		case 074530:
			S5 = T24;
			break;
		case 074531:
			S5 = T25;
			break;
		case 074532:
			S5 = T26;
			break;
		case 074533:
			S5 = T27;
			break;
		case 074534:
			S5 = T28;
			break;
		case 074535:
			S5 = T29;
			break;
		case 074536:
			S5 = T30;
			break;
		case 074537:
			S5 = T31;
			break;
		case 074540:
			S5 = T32;
			break;
		case 074541:
			S5 = T33;
			break;
		case 074542:
			S5 = T34;
			break;
		case 074543:
			S5 = T35;
			break;
		case 074544:
			S5 = T36;
			break;
		case 074545:
			S5 = T37;
			break;
		case 074546:
			S5 = T38;
			break;
		case 074547:
			S5 = T39;
			break;
		case 074550:
			S5 = T40;
			break;
		case 074551:
			S5 = T41;
			break;
		case 074552:
			S5 = T42;
			break;
		case 074553:
			S5 = T43;
			break;
		case 074554:
			S5 = T44;
			break;
		case 074555:
			S5 = T45;
			break;
		case 074556:
			S5 = T46;
			break;
		case 074557:
			S5 = T47;
			break;
		case 074560:
			S5 = T48;
			break;
		case 074561:
			S5 = T49;
			break;
		case 074562:
			S5 = T50;
			break;
		case 074563:
			S5 = T51;
			break;
		case 074564:
			S5 = T52;
			break;
		case 074565:
			S5 = T53;
			break;
		case 074566:
			S5 = T54;
			break;
		case 074567:
			S5 = T55;
			break;
		case 074570:
			S5 = T56;
			break;
		case 074571:
			S5 = T57;
			break;
		case 074572:
			S5 = T58;
			break;
		case 074573:
			S5 = T59;
			break;
		case 074574:
			S5 = T60;
			break;
		case 074575:
			S5 = T61;
			break;
		case 074576:
			S5 = T62;
			break;
		case 074577:
			S5 = T63;
			break;
		case 074600:
			/* CAL S6 T00 */
			S6 = T0;
			break;
		case 074601:
			S6 = T1;
			break;
		case 074602:
			S6 = T2;
			break;
		case 074603:
			S6 = T3;
			break;
		case 074604:
			S6 = T4;
			break;
		case 074605:
			S6 = T5;
			break;
		case 074606:
			S6 = T6;
			break;
		case 074607:
			S6 = T7;
			break;
		case 074610:
			S6 = T8;
			break;
		case 074611:
			S6 = T9;
			break;
		case 074612:
			S6 = T10;
			break;
		case 074613:
			S6 = T11;
			break;
		case 074614:
			S6 = T12;
			break;
		case 074615:
			S6 = T13;
			break;
		case 074616:
			S6 = T14;
			break;
		case 074617:
			S6 = T15;
			break;
		case 074620:
			S6 = T16;
			break;
		case 074621:
			S6 = T17;
			break;
		case 074622:
			S6 = T18;
			break;
		case 074623:
			S6 = T19;
			break;
		case 074624:
			S6 = T20;
			break;
		case 074625:
			S6 = T21;
			break;
		case 074626:
			S6 = T22;
			break;
		case 074627:
			S6 = T23;
			break;
		case 074630:
			S6 = T24;
			break;
		case 074631:
			S6 = T25;
			break;
		case 074632:
			S6 = T26;
			break;
		case 074633:
			S6 = T27;
			break;
		case 074634:
			S6 = T28;
			break;
		case 074635:
			S6 = T29;
			break;
		case 074636:
			S6 = T30;
			break;
		case 074637:
			S6 = T31;
			break;
		case 074640:
			S6 = T32;
			break;
		case 074641:
			S6 = T33;
			break;
		case 074642:
			S6 = T34;
			break;
		case 074643:
			S6 = T35;
			break;
		case 074644:
			S6 = T36;
			break;
		case 074645:
			S6 = T37;
			break;
		case 074646:
			S6 = T38;
			break;
		case 074647:
			S6 = T39;
			break;
		case 074650:
			S6 = T40;
			break;
		case 074651:
			S6 = T41;
			break;
		case 074652:
			S6 = T42;
			break;
		case 074653:
			S6 = T43;
			break;
		case 074654:
			S6 = T44;
			break;
		case 074655:
			S6 = T45;
			break;
		case 074656:
			S6 = T46;
			break;
		case 074657:
			S6 = T47;
			break;
		case 074660:
			S6 = T48;
			break;
		case 074661:
			S6 = T49;
			break;
		case 074662:
			S6 = T50;
			break;
		case 074663:
			S6 = T51;
			break;
		case 074664:
			S6 = T52;
			break;
		case 074665:
			S6 = T53;
			break;
		case 074666:
			S6 = T54;
			break;
		case 074667:
			S6 = T55;
			break;
		case 074670:
			S6 = T56;
			break;
		case 074671:
			S6 = T57;
			break;
		case 074672:
			S6 = T58;
			break;
		case 074673:
			S6 = T59;
			break;
		case 074674:
			S6 = T60;
			break;
		case 074675:
			S6 = T61;
			break;
		case 074676:
			S6 = T62;
			break;
		case 074677:
			S6 = T63;
			break;
		case 074700:
			/* CAL S7 T00 */
			S7 = T0;
			break;
		case 074701:
			S7 = T1;
			break;
		case 074702:
			S7 = T2;
			break;
		case 074703:
			S7 = T3;
			break;
		case 074704:
			S7 = T4;
			break;
		case 074705:
			S7 = T5;
			break;
		case 074706:
			S7 = T6;
			break;
		case 074707:
			S7 = T7;
			break;
		case 074710:
			S7 = T8;
			break;
		case 074711:
			S7 = T9;
			break;
		case 074712:
			S7 = T10;
			break;
		case 074713:
			S7 = T11;
			break;
		case 074714:
			S7 = T12;
			break;
		case 074715:
			S7 = T13;
			break;
		case 074716:
			S7 = T14;
			break;
		case 074717:
			S7 = T15;
			break;
		case 074720:
			S7 = T16;
			break;
		case 074721:
			S7 = T17;
			break;
		case 074722:
			S7 = T18;
			break;
		case 074723:
			S7 = T19;
			break;
		case 074724:
			S7 = T20;
			break;
		case 074725:
			S7 = T21;
			break;
		case 074726:
			S7 = T22;
			break;
		case 074727:
			S7 = T23;
			break;
		case 074730:
			S7 = T24;
			break;
		case 074731:
			S7 = T25;
			break;
		case 074732:
			S7 = T26;
			break;
		case 074733:
			S7 = T27;
			break;
		case 074734:
			S7 = T28;
			break;
		case 074735:
			S7 = T29;
			break;
		case 074736:
			S7 = T30;
			break;
		case 074737:
			S7 = T31;
			break;
		case 074740:
			S7 = T32;
			break;
		case 074741:
			S7 = T33;
			break;
		case 074742:
			S7 = T34;
			break;
		case 074743:
			S7 = T35;
			break;
		case 074744:
			S7 = T36;
			break;
		case 074745:
			S7 = T37;
			break;
		case 074746:
			S7 = T38;
			break;
		case 074747:
			S7 = T39;
			break;
		case 074750:
			S7 = T40;
			break;
		case 074751:
			S7 = T41;
			break;
		case 074752:
			S7 = T42;
			break;
		case 074753:
			S7 = T43;
			break;
		case 074754:
			S7 = T44;
			break;
		case 074755:
			S7 = T45;
			break;
		case 074756:
			S7 = T46;
			break;
		case 074757:
			S7 = T47;
			break;
		case 074760:
			S7 = T48;
			break;
		case 074761:
			S7 = T49;
			break;
		case 074762:
			S7 = T50;
			break;
		case 074763:
			S7 = T51;
			break;
		case 074764:
			S7 = T52;
			break;
		case 074765:
			S7 = T53;
			break;
		case 074766:
			S7 = T54;
			break;
		case 074767:
			S7 = T55;
			break;
		case 074770:
			S7 = T56;
			break;
		case 074771:
			S7 = T57;
			break;
		case 074772:
			S7 = T58;
			break;
		case 074773:
			S7 = T59;
			break;
		case 074774:
			S7 = T60;
			break;
		case 074775:
			S7 = T61;
			break;
		case 074776:
			S7 = T62;
			break;
		case 074777:
			S7 = T63;
			break;
		case 075000:
			/* CAL Tjk Si */
			/* Transmits Si to Tjk */
			T0 = S0;
			break;
		case 075001:
			T1 = S0;
			break;
		case 075002:
			T2 = S0;
			break;
		case 075003:
			T3 = S0;
			break;
		case 075004:
			T4 = S0;
			break;
		case 075005:
			T5 = S0;
			break;
		case 075006:
			T6 = S0;
			break;
		case 075007:
			T7 = S0;
			break;
		case 075010:
			T8 = S0;
			break;
		case 075011:
			T9 = S0;
			break;
		case 075012:
			T10 = S0;
			break;
		case 075013:
			T11 = S0;
			break;
		case 075014:
			T12 = S0;
			break;
		case 075015:
			T13 = S0;
			break;
		case 075016:
			T14 = S0;
			break;
		case 075017:
			T15 = S0;
			break;
		case 075020:
			T16 = S0;
			break;
		case 075021:
			T17 = S0;
			break;
		case 075022:
			T18 = S0;
			break;
		case 075023:
			T19 = S0;
			break;
		case 075024:
			T20 = S0;
			break;
		case 075025:
			T21 = S0;
			break;
		case 075026:
			T22 = S0;
			break;
		case 075027:
			T23 = S0;
			break;
		case 075030:
			T24 = S0;
			break;
		case 075031:
			T25 = S0;
			break;
		case 075032:
			T26 = S0;
			break;
		case 075033:
			T27 = S0;
			break;
		case 075034:
			T28 = S0;
			break;
		case 075035:
			T29 = S0;
			break;
		case 075036:
			T30 = S0;
			break;
		case 075037:
			T31 = S0;
			break;
		case 075040:
			T32 = S0;
			break;
		case 075041:
			T33 = S0;
			break;
		case 075042:
			T34 = S0;
			break;
		case 075043:
			T35 = S0;
			break;
		case 075044:
			T36 = S0;
			break;
		case 075045:
			T37 = S0;
			break;
		case 075046:
			T38 = S0;
			break;
		case 075047:
			T39 = S0;
			break;
		case 075050:
			T40 = S0;
			break;
		case 075051:
			T41 = S0;
			break;
		case 075052:
			T42 = S0;
			break;
		case 075053:
			T43 = S0;
			break;
		case 075054:
			T44 = S0;
			break;
		case 075055:
			T45 = S0;
			break;
		case 075056:
			T46 = S0;
			break;
		case 075057:
			T47 = S0;
			break;
		case 075060:
			T48 = S0;
			break;
		case 075061:
			T49 = S0;
			break;
		case 075062:
			T50 = S0;
			break;
		case 075063:
			T51 = S0;
			break;
		case 075064:
			T52 = S0;
			break;
		case 075065:
			T53 = S0;
			break;
		case 075066:
			T54 = S0;
			break;
		case 075067:
			T55 = S0;
			break;
		case 075070:
			T56 = S0;
			break;
		case 075071:
			T57 = S0;
			break;
		case 075072:
			T58 = S0;
			break;
		case 075073:
			T59 = S0;
			break;
		case 075074:
			T60 = S0;
			break;
		case 075075:
			T61 = S0;
			break;
		case 075076:
			T62 = S0;
			break;
		case 075077:
			T63 = S0;
			break;
		case 075100:
			T0 = S1;
			break;
		case 075101:
			T1 = S1;
			break;
		case 075102:
			T2 = S1;
			break;
		case 075103:
			T3 = S1;
			break;
		case 075104:
			T4 = S1;
			break;
		case 075105:
			T5 = S1;
			break;
		case 075106:
			T6 = S1;
			break;
		case 075107:
			T7 = S1;
			break;
		case 075110:
			T8 = S1;
			break;
		case 075111:
			T9 = S1;
			break;
		case 075112:
			T10 = S1;
			break;
		case 075113:
			T11 = S1;
			break;
		case 075114:
			T12 = S1;
			break;
		case 075115:
			T13 = S1;
			break;
		case 075116:
			T14 = S2;
			break;
		case 075117:
			T15 = S1;
			break;
		case 075120:
			T16 = S1;
			break;
		case 075121:
			T17 = S1;
			break;
		case 075122:
			T18 = S1;
			break;
		case 075123:
			T19 = S1;
			break;
		case 075124:
			T20 = S1;
			break;
		case 075125:
			T21 = S1;
			break;
		case 075126:
			T22 = S1;
			break;
		case 075127:
			T23 = S1;
			break;
		case 075130:
			T24 = S1;
			break;
		case 075131:
			T25 = S1;
			break;
		case 075132:
			T26 = S1;
			break;
		case 075133:
			T27 = S1;
			break;
		case 075134:
			T28 = S1;
			break;
		case 075135:
			T29 = S1;
			break;
		case 075136:
			T30 = S1;
			break;
		case 075137:
			T31 = S1;
			break;
		case 075140:
			T32 = S1;
			break;
		case 075141:
			T33 = S1;
			break;
		case 075142:
			T34 = S1;
			break;
		case 075143:
			T35 = S1;
			break;
		case 075144:
			T36 = S1;
			break;
		case 075145:
			T37 = S1;
			break;
		case 075146:
			T38 = S1;
			break;
		case 075147:
			T39 = S1;
			break;
		case 075150:
			T40 = S1;
			break;
		case 075151:
			T41 = S1;
			break;
		case 075152:
			T42 = S1;
			break;
		case 075153:
			T43 = S1;
			break;
		case 075154:
			T44 = S1;
			break;
		case 075155:
			T45 = S1;
			break;
		case 075156:
			T46 = S1;
			break;
		case 075157:
			T47 = S1;
			break;
		case 075160:
			T48 = S1;
			break;
		case 075161:
			T49 = S1;
			break;
		case 075162:
			T50 = S1;
			break;
		case 075163:
			T51 = S1;
			break;
		case 075164:
			T52 = S1;
			break;
		case 075165:
			T53 = S1;
			break;
		case 075166:
			T54 = S1;
			break;
		case 075167:
			T55 = S1;
			break;
		case 075170:
			T56 = S1;
			break;
		case 075171:
			T57 = S1;
			break;
		case 075172:
			T58 = S1;
			break;
		case 075173:
			T59 = S1;
			break;
		case 075174:
			T60 = S1;
			break;
		case 075175:
			T61 = S1;
			break;
		case 075176:
			T62 = S1;
			break;
		case 075177:
			T63 = S1;
			break;
		case 075200:
			T0 = S2;
			break;
		case 075201:
			T1 = S2;
			break;
		case 075202:
			T2 = S2;
			break;
		case 075203:
			T3 = S2;
			break;
		case 075204:
			T4 = S2;
			break;
		case 075205:
			T5 = S2;
			break;
		case 075206:
			T6 = S2;
			break;
		case 075207:
			T7 = S2;
			break;
		case 075210:
			T8 = S2;
			break;
		case 075211:
			T9 = S2;
			break;
		case 075212:
			T10 = S2;
			break;
		case 075213:
			T11 = S2;
			break;
		case 075214:
			T12 = S2;
			break;
		case 075215:
			T13 = S2;
			break;
		case 075216:
			T14 = S2;
			break;
		case 075217:
			T15 = S2;
			break;
		case 075220:
			T16 = S2;
			break;
		case 075221:
			T17 = S2;
			break;
		case 075222:
			T18 = S2;
			break;
		case 075223:
			T19 = S2;
			break;
		case 075224:
			T20 = S2;
			break;
		case 075225:
			T21 = S2;
			break;
		case 075226:
			T22 = S2;
			break;
		case 075227:
			T23 = S2;
			break;
		case 075230:
			T24 = S2;
			break;
		case 075231:
			T25 = S2;
			break;
		case 075232:
			T26 = S2;
			break;
		case 075233:
			T27 = S2;
			break;
		case 075234:
			T28 = S2;
			break;
		case 075235:
			T29 = S2;
			break;
		case 075236:
			T30 = S2;
			break;
		case 075237:
			T31 = S2;
			break;
		case 075240:
			T32 = S2;
			break;
		case 075241:
			T33 = S2;
			break;
		case 075242:
			T34 = S2;
			break;
		case 075243:
			T35 = S2;
			break;
		case 075244:
			T36 = S2;
			break;
		case 075245:
			T37 = S2;
			break;
		case 075246:
			T38 = S2;
			break;
		case 075247:
			T39 = S2;
			break;
		case 075250:
			T40 = S2;
			break;
		case 075251:
			T41 = S2;
			break;
		case 075252:
			T42 = S2;
			break;
		case 075253:
			T43 = S2;
			break;
		case 075254:
			T44 = S2;
			break;
		case 075255:
			T45 = S2;
			break;
		case 075256:
			T46 = S2;
			break;
		case 075257:
			T47 = S2;
			break;
		case 075260:
			T48 = S2;
			break;
		case 075261:
			T49 = S2;
			break;
		case 075262:
			T50 = S2;
			break;
		case 075263:
			T51 = S2;
			break;
		case 075264:
			T52 = S2;
			break;
		case 075265:
			T53 = S2;
			break;
		case 075266:
			T54 = S2;
			break;
		case 075267:
			T55 = S2;
			break;
		case 075270:
			T56 = S2;
			break;
		case 075271:
			T57 = S2;
			break;
		case 075272:
			T58 = S2;
			break;
		case 075273:
			T59 = S2;
			break;
		case 075274:
			T60 = S2;
			break;
		case 075275:
			T61 = S2;
			break;
		case 075276:
			T62 = S2;
			break;
		case 075277:
			T63 = S2;
			break;
		case 075300:
			T0 = S3;
			break;
		case 075301:
			T1 = S3;
			break;
		case 075302:
			T2 = S3;
			break;
		case 075303:
			T3 = S3;
			break;
		case 075304:
			T4 = S3;
			break;
		case 075305:
			T5 = S3;
			break;
		case 075306:
			T6 = S3;
			break;
		case 075307:
			T7 = S3;
			break;
		case 075310:
			T8 = S3;
			break;
		case 075311:
			T9 = S3;
			break;
		case 075312:
			T10 = S3;
			break;
		case 075313:
			T11 = S3;
			break;
		case 075314:
			T12 = S3;
			break;
		case 075315:
			T13 = S3;
			break;
		case 075316:
			T14 = S3;
			break;
		case 075317:
			T15 = S3;
			break;
		case 075320:
			T16 = S3;
			break;
		case 075321:
			T17 = S3;
			break;
		case 075322:
			T18 = S3;
			break;
		case 075323:
			T19 = S3;
			break;
		case 075324:
			T20 = S3;
			break;
		case 075325:
			T21 = S3;
			break;
		case 075326:
			T22 = S3;
			break;
		case 075327:
			T23 = S3;
			break;
		case 075330:
			T24 = S3;
			break;
		case 075331:
			T25 = S3;
			break;
		case 075332:
			T26 = S3;
			break;
		case 075333:
			T27 = S3;
			break;
		case 075334:
			T28 = S3;
			break;
		case 075335:
			T29 = S3;
			break;
		case 075336:
			T30 = S3;
			break;
		case 075337:
			T31 = S3;
			break;
		case 075340:
			T32 = S3;
			break;
		case 075341:
			T33 = S3;
			break;
		case 075342:
			T34 = S3;
			break;
		case 075343:
			T35 = S3;
			break;
		case 075344:
			T36 = S3;
			break;
		case 075345:
			T37 = S3;
			break;
		case 075346:
			T38 = S3;
			break;
		case 075347:
			T39 = S3;
			break;
		case 075350:
			T40 = S3;
			break;
		case 075351:
			T41 = S3;
			break;
		case 075352:
			T42 = S3;
			break;
		case 075353:
			T43 = S3;
			break;
		case 075354:
			T44 = S3;
			break;
		case 075355:
			T45 = S3;
			break;
		case 075356:
			T46 = S3;
			break;
		case 075357:
			T47 = S3;
			break;
		case 075360:
			T48 = S3;
			break;
		case 075361:
			T49 = S3;
			break;
		case 075362:
			T50 = S3;
			break;
		case 075363:
			T51 = S3;
			break;
		case 075364:
			T52 = S3;
			break;
		case 075365:
			T53 = S3;
			break;
		case 075366:
			T54 = S3;
			break;
		case 075367:
			T55 = S3;
			break;
		case 075370:
			T56 = S3;
			break;
		case 075371:
			T57 = S3;
			break;
		case 075372:
			T58 = S3;
			break;
		case 075373:
			T59 = S3;
			break;
		case 075374:
			T60 = S3;
			break;
		case 075375:
			T61 = S3;
			break;
		case 075376:
			T62 = S3;
			break;
		case 075377:
			T63 = S3;
			break;
		case 075400:
			T0 = S4;
			break;
		case 075401:
			T1 = S4;
			break;
		case 075402:
			T2 = S4;
			break;
		case 075403:
			T3 = S4;
			break;
		case 075404:
			T4 = S4;
			break;
		case 075405:
			T5 = S4;
			break;
		case 075406:
			T6 = S4;
			break;
		case 075407:
			T7 = S4;
			break;
		case 075410:
			T8 = S4;
			break;
		case 075411:
			T9 = S4;
			break;
		case 075412:
			T10 = S4;
			break;
		case 075413:
			T11 = S4;
			break;
		case 075414:
			T12 = S4;
			break;
		case 075415:
			T13 = S4;
			break;
		case 075416:
			T14 = S4;
			break;
		case 075417:
			T15 = S4;
			break;
		case 075420:
			T16 = S4;
			break;
		case 075421:
			T17 = S4;
			break;
		case 075422:
			T18 = S4;
			break;
		case 075423:
			T19 = S4;
			break;
		case 075424:
			T20 = S4;
			break;
		case 075425:
			T21 = S4;
			break;
		case 075426:
			T22 = S4;
			break;
		case 075427:
			T23 = S4;
			break;
		case 075430:
			T24 = S4;
			break;
		case 075431:
			T25 = S4;
			break;
		case 075432:
			T26 = S4;
			break;
		case 075433:
			T27 = S4;
			break;
		case 075434:
			T28 = S4;
			break;
		case 075435:
			T29 = S4;
			break;
		case 075436:
			T30 = S4;
			break;
		case 075437:
			T31 = S4;
			break;
		case 075440:
			T32 = S4;
			break;
		case 075441:
			T33 = S4;
			break;
		case 075442:
			T34 = S4;
			break;
		case 075443:
			T35 = S4;
			break;
		case 075444:
			T36 = S4;
			break;
		case 075445:
			T37 = S4;
			break;
		case 075446:
			T38 = S4;
			break;
		case 075447:
			T39 = S4;
			break;
		case 075450:
			T40 = S4;
			break;
		case 075451:
			T41 = S4;
			break;
		case 075452:
			T42 = S4;
			break;
		case 075453:
			T43 = S4;
			break;
		case 075454:
			T44 = S4;
			break;
		case 075455:
			T45 = S4;
			break;
		case 075456:
			T46 = S4;
			break;
		case 075457:
			T47 = S4;
			break;
		case 075460:
			T48 = S4;
			break;
		case 075461:
			T49 = S4;
			break;
		case 075462:
			T50 = S4;
			break;
		case 075463:
			T51 = S4;
			break;
		case 075464:
			T52 = S4;
			break;
		case 075465:
			T53 = S4;
			break;
		case 075466:
			T54 = S4;
			break;
		case 075467:
			T55 = S4;
			break;
		case 075470:
			T56 = S4;
			break;
		case 075471:
			T57 = S4;
			break;
		case 075472:
			T58 = S4;
			break;
		case 075473:
			T59 = S4;
			break;
		case 075474:
			T60 = S4;
			break;
		case 075475:
			T61 = S4;
			break;
		case 075476:
			T62 = S4;
			break;
		case 075477:
			T63 = S4;
			break;
		case 075500:
			T0 = S5;
			break;
		case 075501:
			T1 = S5;
			break;
		case 075502:
			T2 = S5;
			break;
		case 075503:
			T3 = S5;
			break;
		case 075504:
			T4 = S5;
			break;
		case 075505:
			T5 = S5;
			break;
		case 075506:
			T6 = S5;
			break;
		case 075507:
			T7 = S5;
			break;
		case 075510:
			T8 = S5;
			break;
		case 075511:
			T9 = S5;
			break;
		case 075512:
			T10 = S5;
			break;
		case 075513:
			T11 = S5;
			break;
		case 075514:
			T12 = S5;
			break;
		case 075515:
			T13 = S5;
			break;
		case 075516:
			T14 = S5;
			break;
		case 075517:
			T15 = S5;
			break;
		case 075520:
			T16 = S5;
			break;
		case 075521:
			T17 = S5;
			break;
		case 075522:
			T18 = S5;
			break;
		case 075523:
			T19 = S5;
			break;
		case 075524:
			T20 = S5;
			break;
		case 075525:
			T21 = S5;
			break;
		case 075526:
			T22 = S5;
			break;
		case 075527:
			T23 = S5;
			break;
		case 075530:
			T24 = S5;
			break;
		case 075531:
			T25 = S5;
			break;
		case 075532:
			T26 = S5;
			break;
		case 075533:
			T27 = S5;
			break;
		case 075534:
			T28 = S5;
			break;
		case 075535:
			T29 = S5;
			break;
		case 075536:
			T30 = S5;
			break;
		case 075537:
			T31 = S5;
			break;
		case 075540:
			T32 = S5;
			break;
		case 075541:
			T33 = S5;
			break;
		case 075542:
			T34 = S5;
			break;
		case 075543:
			T35 = S5;
			break;
		case 075544:
			T36 = S5;
			break;
		case 075545:
			T37 = S5;
			break;
		case 075546:
			T38 = S5;
			break;
		case 075547:
			T39 = S5;
			break;
		case 075550:
			T40 = S5;
			break;
		case 075551:
			T41 = S5;
			break;
		case 075552:
			T42 = S5;
			break;
		case 075553:
			T43 = S5;
			break;
		case 075554:
			T44 = S5;
			break;
		case 075555:
			T45 = S5;
			break;
		case 075556:
			T46 = S5;
			break;
		case 075557:
			T47 = S5;
			break;
		case 075560:
			T48 = S5;
			break;
		case 075561:
			T49 = S5;
			break;
		case 075562:
			T50 = S5;
			break;
		case 075563:
			T51 = S5;
			break;
		case 075564:
			T52 = S5;
			break;
		case 075565:
			T53 = S5;
			break;
		case 075566:
			T54 = S5;
			break;
		case 075567:
			T55 = S5;
			break;
		case 075570:
			T56 = S5;
			break;
		case 075571:
			T57 = S5;
			break;
		case 075572:
			T58 = S5;
			break;
		case 075573:
			T59 = S5;
			break;
		case 075574:
			T60 = S5;
			break;
		case 075575:
			T61 = S5;
			break;
		case 075576:
			T62 = S5;
			break;
		case 075577:
			T63 = S5;
			break;
		case 075600:
			T0 = S6;
			break;
		case 075601:
			T1 = S6;
			break;
		case 075602:
			T2 = S6;
			break;
		case 075603:
			T3 = S6;
			break;
		case 075604:
			T4 = S6;
			break;
		case 075605:
			T5 = S6;
			break;
		case 075606:
			T6 = S6;
			break;
		case 075607:
			T7 = S6;
			break;
		case 075610:
			T8 = S6;
			break;
		case 075611:
			T9 = S6;
			break;
		case 075612:
			T10 = S6;
			break;
		case 075613:
			T11 = S6;
			break;
		case 075614:
			T12 = S6;
			break;
		case 075615:
			T13 = S6;
			break;
		case 075616:
			T14 = S6;
			break;
		case 075617:
			T15 = S6;
			break;
		case 075620:
			T16 = S6;
			break;
		case 075621:
			T17 = S6;
			break;
		case 075622:
			T18 = S6;
			break;
		case 075623:
			T19 = S6;
			break;
		case 075624:
			T20 = S6;
			break;
		case 075625:
			T21 = S6;
			break;
		case 075626:
			T22 = S6;
			break;
		case 075627:
			T23 = S6;
			break;
		case 075630:
			T24 = S6;
			break;
		case 075631:
			T25 = S6;
			break;
		case 075632:
			T26 = S6;
			break;
		case 075633:
			T27 = S6;
			break;
		case 075634:
			T28 = S6;
			break;
		case 075635:
			T29 = S6;
			break;
		case 075636:
			T30 = S6;
			break;
		case 075637:
			T31 = S6;
			break;
		case 075640:
			T32 = S6;
			break;
		case 075641:
			T33 = S6;
			break;
		case 075642:
			T34 = S6;
			break;
		case 075643:
			T35 = S6;
			break;
		case 075644:
			T36 = S6;
			break;
		case 075645:
			T37 = S6;
			break;
		case 075646:
			T38 = S6;
			break;
		case 075647:
			T39 = S6;
			break;
		case 075650:
			T40 = S6;
			break;
		case 075651:
			T41 = S6;
			break;
		case 075652:
			T42 = S6;
			break;
		case 075653:
			T43 = S6;
			break;
		case 075654:
			T44 = S6;
			break;
		case 075655:
			T45 = S6;
			break;
		case 075656:
			T46 = S6;
			break;
		case 075657:
			T47 = S6;
			break;
		case 075660:
			T48 = S6;
			break;
		case 075661:
			T49 = S6;
			break;
		case 075662:
			T50 = S6;
			break;
		case 075663:
			T51 = S6;
			break;
		case 075664:
			T52 = S6;
			break;
		case 075665:
			T53 = S6;
			break;
		case 075666:
			T54 = S6;
			break;
		case 075667:
			T55 = S6;
			break;
		case 075670:
			T56 = S6;
			break;
		case 075671:
			T57 = S6;
			break;
		case 075672:
			T58 = S6;
			break;
		case 075673:
			T59 = S6;
			break;
		case 075674:
			T60 = S6;
			break;
		case 075675:
			T61 = S6;
			break;
		case 075676:
			T62 = S6;
			break;
		case 075677:
			T63 = S6;
			break;
		case 075700:
			T0 = S7;
			break;
		case 075701:
			T1 = S7;
			break;
		case 075702:
			T2 = S7;
			break;
		case 075703:
			T3 = S7;
			break;
		case 075704:
			T4 = S7;
			break;
		case 075705:
			T5 = S7;
			break;
		case 075706:
			T6 = S7;
			break;
		case 075707:
			T7 = S7;
			break;
		case 075710:
			T8 = S7;
			break;
		case 075711:
			T9 = S7;
			break;
		case 075712:
			T10 = S7;
			break;
		case 075713:
			T11 = S7;
			break;
		case 075714:
			T12 = S7;
			break;
		case 075715:
			T13 = S7;
			break;
		case 075716:
			T14 = S7;
			break;
		case 075717:
			T15 = S7;
			break;
		case 075720:
			T16 = S7;
			break;
		case 075721:
			T17 = S7;
			break;
		case 075722:
			T18 = S7;
			break;
		case 075723:
			T19 = S7;
			break;
		case 075724:
			T20 = S7;
			break;
		case 075725:
			T21 = S7;
			break;
		case 075726:
			T22 = S7;
			break;
		case 075727:
			T23 = S7;
			break;
		case 075730:
			T24 = S7;
			break;
		case 075731:
			T25 = S7;
			break;
		case 075732:
			T26 = S7;
			break;
		case 075733:
			T27 = S7;
			break;
		case 075734:
			T28 = S7;
			break;
		case 075735:
			T29 = S7;
			break;
		case 075736:
			T30 = S7;
			break;
		case 075737:
			T31 = S7;
			break;
		case 075740:
			T32 = S7;
			break;
		case 075741:
			T33 = S7;
			break;
		case 075742:
			T34 = S7;
			break;
		case 075743:
			T35 = S7;
			break;
		case 075744:
			T36 = S7;
			break;
		case 075745:
			T37 = S7;
			break;
		case 075746:
			T38 = S7;
			break;
		case 075747:
			T39 = S7;
			break;
		case 075750:
			T40 = S7;
			break;
		case 075751:
			T41 = S7;
			break;
		case 075752:
			T42 = S7;
			break;
		case 075753:
			T43 = S7;
			break;
		case 075754:
			T44 = S7;
			break;
		case 075755:
			T45 = S7;
			break;
		case 075756:
			T46 = S7;
			break;
		case 075757:
			T47 = S7;
			break;
		case 075760:
			T48 = S7;
			break;
		case 075761:
			T49 = S7;
			break;
		case 075762:
			T50 = S7;
			break;
		case 075763:
			T51 = S7;
			break;
		case 075764:
			T52 = S7;
			break;
		case 075765:
			T53 = S7;
			break;
		case 075766:
			T54 = S7;
			break;
		case 075767:
			T55 = S7;
			break;
		case 075770:
			T56 = S7;
			break;
		case 075771:
			T57 = S7;
			break;
		case 075772:
			T58 = S7;
			break;
		case 075773:
			T59 = S7;
			break;
		case 075774:
			T60 = S7;
			break;
		case 075775:
			T61 = S7;
			break;
		case 075776:
			T62 = S7;
			break;
		case 075777:
			T63 = S7;
			break;
		default:
			printf("\nUnknown Opcode: %o\n", opcode);
			break;
		}
	}
	/* return cycles - cycle_count; */
}
