; ----------------- assembly instructions ---------------------------- 
;
; this is a subroutine library only
; it must be included in an executable source file
;
; Local Non-Zero Page Variables used
;
; ChrInVect      holds Character Input Address (3 bytes - low, high, high EOR A5)
; ScanInVect     holds Character Scan Input address (3 bytes)
; ChrOutVect     holds Character Output Address (3 bytes)
;
;*** I/O Locations *******************************
; define the i/o address of the terminal
KBData         =     $8000
KBStrobe       =     $8001
OutputPort     =     $8010
;
;***********************************************************************
; Terminal I/O Support Routines
;
term_init      LDX   #<Term_Input      ; set up RAM vectors for
               LDA   #>Term_Input      ; Input, Output, and Scan
               TAY                     ; Routines
               EOR   #$A5              ;
               sta   ChrInVect+2       ;
               sty   ChrInVect+1       ;
               stx   ChrInVect         ;
               LDX   #<Term_Scan       ;
               LDA   #>Term_Scan       ;
               TAY                     ;
               EOR   #$A5              ;
               sta   ScanInVect+2      ;
               sty   ScanInVect+1      ;
               stx   ScanInVect        ;
               LDX   #<Term_Output     ;
               LDA   #>Term_Output     ;
               TAY                     ;
               EOR   #$A5              ;
               sta   ChrOutVect+2      ;
               sty   ChrOutVect+1      ;
               stx   ChrOutVect        ;
               rts                     ; done
;
;
; input chr from terminal
Term_Input     LDA   Kbdata
               BPL   Term_Input
               STA   KBstrobe
               AND   #$7F
               RTS                     ;
;
; see if input requested without waiting
Term_Scan      clc			   ; clear carry - no key
		   lda   KBdata            ; return 0 if input requested
		   bpl   Term_scan1        ; no key
               sta   KBstrobe          ;
               and   #$7F
               sec			   ; key received
Term_scan1     rts                     ;
;
; output to Terminal
Term_Output    pha                     ; save registers
Term_out1      lda   Outputport        ;
               beq   Term_out1         ; wait until ready  
               pla                     ;
               sta   Outputport        ;
               RTS                     ; done
	
;end of file
