/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

public class AddressRegion
implements Cloneable {
    private int start;
    private int end;
    private String comment;

    public AddressRegion(int start, int end, String comment) {
        this.start = start;
        this.end = end;
        this.comment = comment;
    }

    public AddressRegion(int start, int end) {
        this(start, end, "");
    }

    public int getStartAddress() {
        return this.start;
    }

    public void setStartAddress(int start) {
        this.start = start;
    }

    public int getEndAddress() {
        return this.end;
    }

    public void setEndAddress(int end) {
        this.end = end;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public AddressRegion clone() {
        AddressRegion r;
        try {
            r = (AddressRegion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"AddressRegion\u306e\u30af\u30ed\u30fc\u30f3\u306b\u5931\u6557\u3057\u305f\u3002");
        }
        return r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(String.format("0x%04X", this.start));
        sb.append(",");
        sb.append(String.format("0x%04X", this.end));
        sb.append(",");
        sb.append(this.comment);
        sb.append(")");
        return sb.toString();
    }
}

