/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import jp.asamomiji.emulator.Addressable;
import jp.asamomiji.emulator.UnmappedMemory;

public final class MemorySystem {
    private Addressable[] instance;
    private HashMap<Class<? extends Addressable>, Addressable> map = new HashMap();
    private boolean debug = false;

    public void allocateSpace(int capacity) {
        if (capacity < 0 || capacity > 65536) {
            throw new RuntimeException("\u5bb9\u91cf(" + capacity + ")\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002");
        }
        this.instance = new Addressable[capacity];
        UnmappedMemory um = new UnmappedMemory(0, capacity);
        Arrays.fill(this.instance, um);
    }

    public void registMemory(Addressable m) {
        Arrays.fill(this.instance, m.getStartAddress(), m.getEndAddress() + 1, m);
        this.map.put(m.getClass(), m);
    }

    public Addressable getMemory(Class<? extends Addressable> clazz) {
        return this.map.get(clazz);
    }

    public Collection<Addressable> getMemories() {
        return this.map.values();
    }

    public int getStartAddress(Class<? extends Addressable> c) {
        return this.map.get(c).getStartAddress();
    }

    public int getEndAddress(Class<? extends Addressable> c) {
        return this.map.get(c).getEndAddress();
    }

    public byte load8(int address) {
        byte v = this.instance[address &= 0xFFFF].load8(address);
        if (this.debug) {
            System.out.printf("load8: addr=%04x val=%02x\n", address, v);
        }
        return v;
    }

    public void store8(int address, byte value) {
        address &= 0xFFFF;
        if (this.debug) {
            System.out.printf("store8: addr=%04x val=%02x\n", address, value & 0xFF);
        }
        this.instance[address].store8(address, value);
    }

    public short load16(int address) {
        int a1 = address & 0xFFFF;
        int a2 = address + 1 & 0xFFFF;
        short v = (short)(((this.instance[a1].load8(a1) & 0xFF) << 8) + (this.instance[a2].load8(a2) & 0xFF));
        if (this.debug) {
            System.out.printf("load16: addr=%04x val=%04x\n", a1, v & 0xFFFF);
        }
        return v;
    }

    public void store16(int address, short value) {
        int a1 = address & 0xFFFF;
        int a2 = address + 1 & 0xFFFF;
        if (this.debug) {
            System.out.printf("store16: addr=%04x val=%04x\n", a1, value & 0xFFFF);
        }
        this.instance[a1].store8(a1, (byte)((value & 0xFF00) >> 8));
        this.instance[a2].store8(a2, (byte)(value & 0xFF));
    }
}

