/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeManager {
    private ArrayList<Event> eventList = new ArrayList();

    private static <T extends Comparable<? super T>> void insert(List<T> list, T element) {
        int index = Collections.binarySearch(list, element);
        if (index < 0) {
            index = -index - 1;
        }
        if (list.size() <= index) {
            list.add(element);
        } else {
            list.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event) {
        ArrayList<Event> arrayList = this.eventList;
        synchronized (arrayList) {
            TimeManager.insert(this.eventList, event);
        }
    }

    public void addEvent(long timeOffset, EventCommand command) {
        this.addEvent(new Event(timeOffset, command));
    }

    public void start() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeManager.this.dispatcher();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 0L, 100L, TimeUnit.MICROSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatcher() {
        long time_offset = System.nanoTime();
        ArrayList<Event> arrayList = this.eventList;
        synchronized (arrayList) {
            Iterator<Event> itr = this.eventList.iterator();
            while (itr.hasNext()) {
                Event event = itr.next();
                if (event.timeOffset >= time_offset) continue;
                event.command.execute();
                itr.remove();
            }
        }
    }

    class Event
    implements Comparable<Event> {
        protected long timeOffset;
        protected EventCommand command;

        public Event(long timeOffset, EventCommand command) {
            this.timeOffset = timeOffset;
            this.command = command;
        }

        @Override
        public int compareTo(Event e) {
            return Long.compare(this.timeOffset, e.timeOffset);
        }

        public String toString() {
            return String.format("timeOffset = %d %s", this.timeOffset, this.command.toString());
        }
    }

    static interface EventCommand {
        public void execute();
    }
}

