/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.device;

import jp.asamomiji.emulator.AbstractSoundProcessor;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.StateSet;

public class Beep
extends AbstractSoundProcessor {
    private static final int MAX_RANK = 30;
    private static final int TABLE_LENGTH = 8192;
    private double time;
    private volatile double delta;
    private static volatile float[][] table2 = new float[31][8192];
    private volatile float[] t = table2[0];

    public Beep(Computer computer, double sampling_rate) {
        super(computer, sampling_rate);
        int rank = 1;
        while (rank <= 30) {
            int i = 0;
            while (i < 8192) {
                Beep.table2[rank][i] = this.value(rank, (double)i / 8192.0);
                ++i;
            }
            ++rank;
        }
        int i = 0;
        while (i < 8192) {
            Beep.table2[0][i] = 0.0f;
            ++i;
        }
        this.time = 0.0;
    }

    private float value(int n, double phase) {
        double x = Math.PI * 2 * phase;
        double temp = 0.0;
        int k = 1;
        while (k <= n) {
            temp += Math.sin((double)(2 * k - 1) * x) / (double)(2 * k - 1);
            ++k;
        }
        return (float)(4.0 * temp / Math.PI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeFrequency(double frequency) {
        int n = (int)Math.floor((this.samplingRate / (2.0 * frequency) + 1.0) / 2.0);
        if (n >= 30) {
            n = 30;
        }
        Beep beep = this;
        synchronized (beep) {
            this.frequency = frequency;
            this.t = table2[n];
            this.delta = 8192.0 * frequency / this.samplingRate;
        }
    }

    @Override
    public synchronized float tick() {
        while ((int)this.time >= 8192) {
            this.time -= 8192.0;
        }
        int index = (int)this.time;
        this.time += this.delta;
        return this.t[index];
    }

    @Override
    public void saveState(StateSet ss) {
        ss.set("AbstractSoundProcessor.frequency", this.frequency);
        ss.set("AbstractSoundProcessor.beep.time", this.time);
        ss.set("AbstractSoundProcessor.beep.delta", this.delta);
        ss.set("AbstractSoundProcessor.beep.current_table", this.t);
    }

    @Override
    public void loadState(StateSet ss) {
        this.frequency = (Double)ss.get("AbstractSoundProcessor.frequency");
        this.time = (Double)ss.get("AbstractSoundProcessor.beep.time");
        this.delta = (Double)ss.get("AbstractSoundProcessor.beep.delta");
        this.t = (float[])ss.get("AbstractSoundProcessor.beep.current_table");
    }
}

