/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.device;

import jp.asamomiji.emulator.CPU;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.StateSet;

public final class MB8861
extends CPU {
    public static final short VECTOR_IRQ = -8;
    public static final short VECTOR_SWI = -6;
    public static final short VECTOR_NMI = -4;
    public static final short VECTOR_RESTART = -2;
    public static final byte OP_ABA_IMP = 27;
    public static final byte OP_ADDA_IMM = -117;
    public static final byte OP_ADDA_DIR = -101;
    public static final byte OP_ADDA_IND = -85;
    public static final byte OP_ADDA_EXT = -69;
    public static final byte OP_ADDB_IMM = -53;
    public static final byte OP_ADDB_DIR = -37;
    public static final byte OP_ADDB_IND = -21;
    public static final byte OP_ADDB_EXT = -5;
    public static final byte OP_ADCA_IMM = -119;
    public static final byte OP_ADCA_DIR = -103;
    public static final byte OP_ADCA_IND = -87;
    public static final byte OP_ADCA_EXT = -71;
    public static final byte OP_ADCB_IMM = -55;
    public static final byte OP_ADCB_DIR = -39;
    public static final byte OP_ADCB_IND = -23;
    public static final byte OP_ADCB_EXT = -7;
    public static final byte OP_ANDA_IMM = -124;
    public static final byte OP_ANDA_DIR = -108;
    public static final byte OP_ANDA_IND = -92;
    public static final byte OP_ANDA_EXT = -76;
    public static final byte OP_ANDB_IMM = -60;
    public static final byte OP_ANDB_DIR = -44;
    public static final byte OP_ANDB_IND = -28;
    public static final byte OP_ANDB_EXT = -12;
    public static final byte OP_ASLA_IMP = 72;
    public static final byte OP_ASLB_IMP = 88;
    public static final byte OP_ASRA_IMP = 71;
    public static final byte OP_ASRB_IMP = 87;
    public static final byte OP_BITA_IMM = -123;
    public static final byte OP_BITA_DIR = -107;
    public static final byte OP_BITA_IND = -91;
    public static final byte OP_BITA_EXT = -75;
    public static final byte OP_BITB_IMM = -59;
    public static final byte OP_BITB_DIR = -43;
    public static final byte OP_BITB_IND = -27;
    public static final byte OP_BITB_EXT = -11;
    public static final byte OP_CBA_IMP = 17;
    public static final byte OP_CLRA_IMP = 79;
    public static final byte OP_CLRB_IMP = 95;
    public static final byte OP_CMPA_IMM = -127;
    public static final byte OP_CMPA_DIR = -111;
    public static final byte OP_CMPA_IND = -95;
    public static final byte OP_CMPA_EXT = -79;
    public static final byte OP_CMPB_IMM = -63;
    public static final byte OP_CMPB_DIR = -47;
    public static final byte OP_CMPB_IND = -31;
    public static final byte OP_CMPB_EXT = -15;
    public static final byte OP_COMA_IMP = 67;
    public static final byte OP_COMB_IMP = 83;
    public static final byte OP_DAA_IMP = 25;
    public static final byte OP_DECA_IMP = 74;
    public static final byte OP_DECB_IMP = 90;
    public static final byte OP_EORA_IMM = -120;
    public static final byte OP_EORA_DIR = -104;
    public static final byte OP_EORA_IND = -88;
    public static final byte OP_EORA_EXT = -72;
    public static final byte OP_EORB_IMM = -56;
    public static final byte OP_EORB_DIR = -40;
    public static final byte OP_EORB_IND = -24;
    public static final byte OP_EORB_EXT = -8;
    public static final byte OP_INCA_IMP = 76;
    public static final byte OP_INCB_IMP = 92;
    public static final byte OP_LDAA_IMM = -122;
    public static final byte OP_LDAA_DIR = -106;
    public static final byte OP_LDAA_IND = -90;
    public static final byte OP_LDAA_EXT = -74;
    public static final byte OP_LDAB_IMM = -58;
    public static final byte OP_LDAB_DIR = -42;
    public static final byte OP_LDAB_IND = -26;
    public static final byte OP_LDAB_EXT = -10;
    public static final byte OP_LSRA_IMP = 68;
    public static final byte OP_LSRB_IMP = 84;
    public static final byte OP_NEGA_IMP = 64;
    public static final byte OP_NEGB_IMP = 80;
    public static final byte OP_ORAA_IMM = -118;
    public static final byte OP_ORAA_DIR = -102;
    public static final byte OP_ORAA_IND = -86;
    public static final byte OP_ORAA_EXT = -70;
    public static final byte OP_ORAB_IMM = -54;
    public static final byte OP_ORAB_DIR = -38;
    public static final byte OP_ORAB_IND = -22;
    public static final byte OP_ORAB_EXT = -6;
    public static final byte OP_PSHA_IMP = 54;
    public static final byte OP_PSHB_IMP = 55;
    public static final byte OP_PULA_IMP = 50;
    public static final byte OP_PULB_IMP = 51;
    public static final byte OP_ROLA_IMP = 73;
    public static final byte OP_ROLB_IMP = 89;
    public static final byte OP_RORA_IMP = 70;
    public static final byte OP_RORB_IMP = 86;
    public static final byte OP_STAA_DIR = -105;
    public static final byte OP_STAA_IND = -89;
    public static final byte OP_STAA_EXT = -73;
    public static final byte OP_STAB_DIR = -41;
    public static final byte OP_STAB_IND = -25;
    public static final byte OP_STAB_EXT = -9;
    public static final byte OP_SBA_IMP = 16;
    public static final byte OP_SUBA_IMM = -128;
    public static final byte OP_SUBA_DIR = -112;
    public static final byte OP_SUBA_IND = -96;
    public static final byte OP_SUBA_EXT = -80;
    public static final byte OP_SUBB_IMM = -64;
    public static final byte OP_SUBB_DIR = -48;
    public static final byte OP_SUBB_IND = -32;
    public static final byte OP_SUBB_EXT = -16;
    public static final byte OP_SBCA_IMM = -126;
    public static final byte OP_SBCA_DIR = -110;
    public static final byte OP_SBCA_IND = -94;
    public static final byte OP_SBCA_EXT = -78;
    public static final byte OP_SBCB_IMM = -62;
    public static final byte OP_SBCB_DIR = -46;
    public static final byte OP_SBCB_IND = -30;
    public static final byte OP_SBCB_EXT = -14;
    public static final byte OP_TAB_IMP = 22;
    public static final byte OP_TBA_IMP = 23;
    public static final byte OP_TSTA_IMP = 77;
    public static final byte OP_TSTB_IMP = 93;
    public static final byte OP_CPX_IMM = -116;
    public static final byte OP_CPX_DIR = -100;
    public static final byte OP_CPX_IND = -84;
    public static final byte OP_CPX_EXT = -68;
    public static final byte OP_DEX_IMP = 9;
    public static final byte OP_DES_IMP = 52;
    public static final byte OP_INX_IMP = 8;
    public static final byte OP_INS_IMP = 49;
    public static final byte OP_LDX_IMM = -50;
    public static final byte OP_LDX_DIR = -34;
    public static final byte OP_LDX_IND = -18;
    public static final byte OP_LDX_EXT = -2;
    public static final byte OP_LDS_IMM = -114;
    public static final byte OP_LDS_DIR = -98;
    public static final byte OP_LDS_IND = -82;
    public static final byte OP_LDS_EXT = -66;
    public static final byte OP_STX_DIR = -33;
    public static final byte OP_STX_IND = -17;
    public static final byte OP_STX_EXT = -1;
    public static final byte OP_STS_DIR = -97;
    public static final byte OP_STS_IND = -81;
    public static final byte OP_STS_EXT = -65;
    public static final byte OP_TXS_IMP = 53;
    public static final byte OP_TSX_IMP = 48;
    public static final byte OP_ASL_IND = 104;
    public static final byte OP_ASL_EXT = 120;
    public static final byte OP_ASR_IND = 103;
    public static final byte OP_ASR_EXT = 119;
    public static final byte OP_CLR_IND = 111;
    public static final byte OP_CLR_EXT = 127;
    public static final byte OP_COM_IND = 99;
    public static final byte OP_COM_EXT = 115;
    public static final byte OP_DEC_IND = 106;
    public static final byte OP_DEC_EXT = 122;
    public static final byte OP_INC_IND = 108;
    public static final byte OP_INC_EXT = 124;
    public static final byte OP_LSR_IND = 100;
    public static final byte OP_LSR_EXT = 116;
    public static final byte OP_NEG_IND = 96;
    public static final byte OP_NEG_EXT = 112;
    public static final byte OP_ROL_IND = 105;
    public static final byte OP_ROL_EXT = 121;
    public static final byte OP_ROR_IND = 102;
    public static final byte OP_ROR_EXT = 118;
    public static final byte OP_TST_IND = 109;
    public static final byte OP_TST_EXT = 125;
    public static final byte OP_BRA_REL = 32;
    public static final byte OP_BCC_REL = 36;
    public static final byte OP_BCS_REL = 37;
    public static final byte OP_BEQ_REL = 39;
    public static final byte OP_BGE_REL = 44;
    public static final byte OP_BGT_REL = 46;
    public static final byte OP_BHI_REL = 34;
    public static final byte OP_BLE_REL = 47;
    public static final byte OP_BLS_REL = 35;
    public static final byte OP_BLT_REL = 45;
    public static final byte OP_BMI_REL = 43;
    public static final byte OP_BNE_REL = 38;
    public static final byte OP_BVC_REL = 40;
    public static final byte OP_BVS_REL = 41;
    public static final byte OP_BPL_REL = 42;
    public static final byte OP_BSR_REL = -115;
    public static final byte OP_JMP_IND = 110;
    public static final byte OP_JMP_EXT = 126;
    public static final byte OP_JSR_IND = -83;
    public static final byte OP_JSR_EXT = -67;
    public static final byte OP_NOP_IMP = 1;
    public static final byte OP_RTI_IMP = 59;
    public static final byte OP_RTS_IMP = 57;
    public static final byte OP_SWI_IMP = 63;
    public static final byte OP_WAI_IMP = 62;
    public static final byte OP_CLC_IMP = 12;
    public static final byte OP_CLI_IMP = 14;
    public static final byte OP_CLV_IMP = 10;
    public static final byte OP_SEC_IMP = 13;
    public static final byte OP_SEI_IMP = 15;
    public static final byte OP_SEV_IMP = 11;
    public static final byte OP_TAP_IMP = 6;
    public static final byte OP_TPA_IMP = 7;
    public static final byte OP_NIM_IND = 113;
    public static final byte OP_OIM_IND = 114;
    public static final byte OP_XIM_IND = 117;
    public static final byte OP_TMM_IND = 123;
    public static final byte OP_ADX_IMM = -20;
    public static final byte OP_ADX_EXT = -4;
    public byte A;
    public byte B;
    public short IX;
    public short SP;
    public short PC;
    public boolean CH = false;
    public boolean CI = false;
    public boolean CN = false;
    public boolean CZ = false;
    public boolean CV = false;
    public boolean CC = false;
    private boolean resetStatus = false;
    private boolean nmiStatus = false;
    private boolean irqStatus = false;
    private boolean haltStatus = false;
    private boolean haltProcessed = false;
    private boolean fetchWai = false;
    private MemorySystem m;

    public MB8861(Computer computer) {
        super(computer);
        this.m = computer.getHardware().getMemory();
    }

    @Override
    public void reset() {
        this.resetStatus = true;
    }

    @Override
    public void halt() {
        this.haltStatus = true;
    }

    @Override
    public void nmi() {
        this.nmiStatus = true;
    }

    @Override
    public void irq() {
        this.irqStatus = true;
    }

    private byte load8_dir(byte address) {
        return this.m.load8(address & 0xFF);
    }

    private byte load8_ext(short address) {
        return this.m.load8(address & 0xFFFF);
    }

    private byte load8_ind(byte offset) {
        return this.m.load8((this.IX & 0xFFFF) + (offset & 0xFF));
    }

    private void store8_ind(byte offset, byte value) {
        this.m.store8((this.IX & 0xFFFF) + (offset & 0xFF), value);
    }

    private void store8_ext(short address, byte value) {
        this.m.store8(address & 0xFFFF, value);
    }

    private short load16_dir(byte address) {
        return this.m.load16(address & 0xFF);
    }

    private short load16_ext(short address) {
        return this.m.load16(address & 0xFFFF);
    }

    private short load16_ind(byte offset) {
        return this.m.load16((this.IX & 0xFFFF) + (offset & 0xFF));
    }

    private void store16_ext(short address, short value) {
        this.m.store16(address & 0xFFFF, value);
    }

    private byte add(byte x, byte y) {
        int t = (x & 0xFF) + (y & 0xFF);
        byte tt = (byte)t;
        this.CH = (x & 0xF) + (y & 0xF) > 15;
        this.CN = tt < 0;
        this.CZ = tt == 0;
        this.CV = x > 0 & y > 0 & this.CN || x < 0 & y < 0 & !this.CN;
        this.CC = (t & 0x100) != 0;
        return tt;
    }

    private short add16(short x, short y) {
        int t = (x & 0xFFFF) + (y & 0xFFFF);
        short tt = (short)t;
        this.CN = tt < 0;
        this.CZ = tt == 0;
        this.CV = x > 0 & y > 0 & this.CN || x < 0 & y < 0 & !this.CN;
        this.CC = (t & 0x10000) != 0;
        return tt;
    }

    private byte adc(byte x, byte y) {
        int t = (x & 0xFF) + (y & 0xFF) + (this.CC ? 1 : 0);
        byte tt = (byte)t;
        this.CH = (x & 0xF) + (y & 0xF) > 15;
        this.CN = tt < 0;
        this.CZ = tt == 0;
        this.CV = x > 0 & y > 0 & this.CN || x < 0 & y < 0 & !this.CN;
        this.CC = (t & 0x100) != 0;
        return tt;
    }

    private byte and(byte x, byte y) {
        int t = x & y;
        this.CN = (t & 0x80) != 0;
        this.CZ = t == 0;
        this.CV = false;
        return (byte)(t & 0xFF);
    }

    public byte nim(byte x, byte y) {
        int t = x & y;
        this.CZ = t == 0;
        this.CN = !this.CZ;
        this.CV = false;
        return (byte)(t & 0xFF);
    }

    private byte asl(byte x) {
        int t = (x & 0xFF) << 1;
        this.CN = (byte)t < 0;
        this.CZ = (byte)t == 0;
        this.CC = t > 255;
        this.CV = this.CN ^ this.CC;
        return (byte)(t & 0xFF);
    }

    private byte asr(byte x) {
        int t = (x & 0xFF) >> 1 | x & 0x80;
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CC = (x & 1) != 0;
        this.CV = this.CN ^ this.CC;
        return (byte)(t & 0xFF);
    }

    private void bit(byte x, byte y) {
        int t = x & y;
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CV = false;
    }

    private void tmm(byte x, byte y) {
        if (x == 0 | y == 0) {
            this.CN = false;
            this.CZ = true;
            this.CV = false;
        } else if (y == -1) {
            this.CN = false;
            this.CZ = false;
            this.CV = true;
        } else {
            this.CN = true;
            this.CZ = false;
            this.CV = false;
        }
    }

    private void cmp(byte x, byte y) {
        int t = (x & 0xFF) - (y & 0xFF);
        byte tt = (byte)t;
        this.CN = tt < 0;
        this.CZ = tt == 0;
        this.CV = x > 0 & y < 0 & this.CN || x < 0 & y > 0 & !this.CN;
        this.CC = (t & 0x100) != 0;
    }

    private byte clr() {
        this.CN = false;
        this.CZ = true;
        this.CV = false;
        this.CC = false;
        return 0;
    }

    private byte com(byte x) {
        byte t = (byte)(255 - (x & 0xFF));
        this.CN = t < 0;
        this.CZ = t == 0;
        this.CV = false;
        this.CC = true;
        return t;
    }

    private void daa() {
        byte tt;
        int t = this.A & 0xFF;
        if ((t & 0xF) >= 10 || this.CH) {
            t += 6;
        }
        if ((t & 0xF0) >= 160) {
            t += 96;
        }
        this.CN = (tt = (byte)t) < 0;
        this.CZ = tt == 0;
        this.CV = this.A > 0 & this.CN || this.A < 0 & !this.CN;
        this.CC = (this.A & 0xF0) >= 160 || this.CC;
        this.A = tt;
    }

    private byte dec(byte x) {
        int t = x - 1 & 0xFF;
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CV = x == -128;
        return (byte)t;
    }

    private byte eor(byte x, byte y) {
        int t = x & 0xFF ^ y & 0xFF;
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CV = false;
        return (byte)t;
    }

    public byte xim(byte x, byte y) {
        int t = x ^ y;
        this.CZ = t == 0;
        this.CN = !this.CZ;
        return (byte)(t & 0xFF);
    }

    private byte inc(byte x) {
        int t = x + 1 & 0xFF;
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CV = x == 127;
        return (byte)t;
    }

    private byte lda(byte x) {
        this.CN = x < 0;
        this.CZ = x == 0;
        this.CV = false;
        return x;
    }

    private byte lsr(byte x) {
        int t = (x & 0xFF) >> 1;
        this.CN = false;
        this.CZ = t == 0;
        this.CC = (x & 1) != 0;
        this.CV = this.CN ^ this.CC;
        return (byte)t;
    }

    private byte neg(byte x) {
        int t = 0 - (x & 0xFF);
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CV = (byte)t == 128;
        this.CC = (byte)t == 0;
        return (byte)t;
    }

    private byte ora(byte x, byte y) {
        int t = x | y;
        this.CN = (byte)t < 0;
        this.CZ = t == 0;
        this.CV = false;
        return (byte)t;
    }

    public byte oim(byte x, byte y) {
        int t = x | y;
        this.CZ = t == 0;
        this.CN = !this.CZ;
        this.CV = false;
        return (byte)(t & 0xFF);
    }

    private void psh(byte x) {
        this.store8_ext(this.SP, x);
        this.SP = (short)(this.SP - 1);
    }

    private byte pul() {
        this.SP = (short)(this.SP + 1);
        return this.load8_ext(this.SP);
    }

    private byte rol(byte x) {
        int t = (x & 0xFF) << 1;
        this.CN = (byte)(t |= this.CC ? 1 : 0) < 0;
        this.CZ = t == 0;
        this.CC = t > 255;
        this.CV = this.CN ^ this.CC;
        return (byte)t;
    }

    private byte ror(byte x) {
        int t = (x & 0xFF) >> 1;
        this.CN = (byte)(t |= this.CC ? 128 : 0) < 0;
        this.CZ = (byte)t == 0;
        this.CC = (x & 1) != 0;
        this.CV = this.CN ^ this.CC;
        return (byte)t;
    }

    private void sta(short a, byte x) {
        this.CN = x < 0;
        this.CZ = x == 0;
        this.CV = false;
        this.store8_ext(a, x);
    }

    private byte sub(byte x, byte y) {
        int t = (x & 0xFF) - (y & 0xFF);
        byte tt = (byte)t;
        this.CN = tt < 0;
        this.CZ = tt == 0;
        this.CV = x > 0 & y < 0 & this.CN || x < 0 & y > 0 & !this.CN;
        this.CC = (t & 0x100) != 0;
        return tt;
    }

    private byte sbc(byte x, byte y) {
        int t = (x & 0xFF) - (y & 0xFF) - (this.CC ? 1 : 0);
        byte tt = (byte)t;
        this.CN = tt < 0;
        this.CZ = tt == 0;
        this.CV = x > 0 & y < 0 & this.CN || x < 0 & y > 0 & !this.CN;
        this.CC = (t & 0x100) != 0;
        return tt;
    }

    private void tab() {
        this.B = this.A;
        this.CN = this.B < 0;
        this.CZ = this.B == 0;
        this.CV = false;
    }

    private void tba() {
        this.A = this.B;
        this.CN = this.A < 0;
        this.CZ = this.A == 0;
        this.CV = false;
    }

    private void tst(byte x) {
        this.CN = x < 0;
        this.CZ = x == 0;
        this.CV = false;
        this.CC = false;
    }

    private void cpx(short x) {
        int t = (this.IX & 0xFFFF) - (x & 0xFFFF);
        this.CN = (short)t < 0;
        this.CZ = (short)t == 0;
        this.CV = this.IX > 0 & x < 0 & this.CN || this.IX < 0 & x > 0 & !this.CN;
    }

    private void dex() {
        this.IX = (short)(this.IX - 1);
        this.CZ = this.IX == 0;
    }

    private void des() {
        this.SP = (short)(this.SP - 1);
    }

    private void inx() {
        this.IX = (short)(this.IX + 1);
        this.CZ = this.IX == 0;
    }

    private void ins() {
        this.SP = (short)(this.SP + 1);
    }

    private void ldx(short a) {
        this.IX = a;
        this.CN = this.IX < 0;
        this.CZ = this.IX == 0;
        this.CV = false;
    }

    private void lds(short a) {
        this.SP = a;
        this.CN = this.SP < 0;
        this.CZ = this.SP == 0;
        this.CV = false;
    }

    private void stx(short a) {
        this.store16_ext(a, this.IX);
        this.CN = this.IX < 0;
        this.CZ = this.IX == 0;
        this.CV = false;
    }

    private void sts(short a) {
        this.store16_ext(a, this.SP);
        this.CN = this.IX < 0;
        this.CZ = this.IX == 0;
        this.CV = false;
    }

    private void txs() {
        this.SP = (short)(this.IX - 1);
    }

    private void tsx() {
        this.IX = (short)(this.SP + 1);
    }

    private void branch(byte offset, boolean condition) {
        if (condition) {
            this.PC = (short)(this.PC + offset);
        }
    }

    private void bsr(byte offset) {
        this.SP = (short)(this.SP - 2);
        this.store16_ext((short)(this.SP + 1), this.PC);
        this.PC = (short)(this.PC + offset);
    }

    private void jump(short a) {
        this.PC = a;
    }

    private void jsr(short a) {
        this.SP = (short)(this.SP - 2);
        this.store16_ext((short)(this.SP + 1), this.PC);
        this.PC = a;
    }

    private void nop() {
    }

    private void pushAllRegisters() {
        int ccr = 192;
        if (this.CH) {
            ccr |= 0x20;
        }
        if (this.CI) {
            ccr |= 0x10;
        }
        if (this.CN) {
            ccr |= 8;
        }
        if (this.CZ) {
            ccr |= 4;
        }
        if (this.CV) {
            ccr |= 2;
        }
        if (this.CC) {
            ccr |= 1;
        }
        this.store16_ext((short)(this.SP - 1), this.PC);
        this.store16_ext((short)(this.SP - 3), this.IX);
        this.store8_ext((short)(this.SP - 4), this.A);
        this.store8_ext((short)(this.SP - 5), this.B);
        this.store8_ext((short)(this.SP - 6), (byte)ccr);
        this.SP = (short)(this.SP - 7);
    }

    private void popAllRegisters() {
        this.SP = (short)(this.SP + 7);
        byte ccr = this.load8_ext((short)(this.SP - 6));
        this.CH = (ccr & 0x20) != 0;
        this.CI = (ccr & 0x10) != 0;
        this.CN = (ccr & 8) != 0;
        this.CZ = (ccr & 4) != 0;
        this.CV = (ccr & 2) != 0;
        this.CC = (ccr & 1) != 0;
        this.B = this.load8_ext((short)(this.SP - 5));
        this.A = this.load8_ext((short)(this.SP - 4));
        this.IX = this.load16_ext((short)(this.SP - 3));
        this.PC = this.load16_ext((short)(this.SP - 1));
    }

    private void rti() {
        this.popAllRegisters();
    }

    private void rts() {
        this.SP = (short)(this.SP + 2);
        this.PC = this.load16_ext((short)(this.SP - 1));
    }

    private void swi() {
        this.PC = (short)(this.PC + 1);
        this.pushAllRegisters();
        this.CI = true;
        this.PC = this.load16_ext((short)-6);
    }

    private void wai() {
        this.fetchWai = true;
    }

    private void clc() {
        this.CC = false;
    }

    private void cli() {
        this.CI = false;
    }

    private void clv() {
        this.CV = false;
    }

    private void sec() {
        this.CC = true;
    }

    private void sei() {
        this.CI = true;
    }

    private void sev() {
        this.CV = true;
    }

    private void tap() {
        this.CH = (this.A & 0x20) != 0;
        this.CI = (this.A & 0x10) != 0;
        this.CN = (this.A & 8) != 0;
        this.CZ = (this.A & 4) != 0;
        this.CV = (this.A & 2) != 0;
        this.CC = (this.A & 1) != 0;
    }

    private void tpa() {
        this.A = (byte)-64;
        if (this.CH) {
            this.A = (byte)(this.A | 0x20);
        }
        if (this.CI) {
            this.A = (byte)(this.A | 0x10);
        }
        if (this.CN) {
            this.A = (byte)(this.A | 8);
        }
        if (this.CZ) {
            this.A = (byte)(this.A | 4);
        }
        if (this.CV) {
            this.A = (byte)(this.A | 2);
        }
        if (this.CC) {
            this.A = (byte)(this.A | 1);
        }
    }

    private byte fetchOp() {
        short s = this.PC;
        this.PC = (short)(s + 1);
        return this.load8_ext(s);
    }

    private byte fetchOperand1() {
        short s = this.PC;
        this.PC = (short)(s + 1);
        return this.load8_ext(s);
    }

    private short fetchOperand2() {
        int op1 = this.fetchOperand1() & 0xFF;
        int op2 = this.fetchOperand1() & 0xFF;
        return (short)((op1 << 8) + op2);
    }

    @Override
    public long execute(long clocks) {
        long initial_clock = this.computer.clockCount;
        while (this.computer.clockCount < initial_clock + clocks) {
            if (this.resetStatus) {
                this.resetStatus = false;
                this.fetchWai = false;
                this.PC = this.load16_ext((short)-2);
                this.computer.clockCount = 0L;
                return 0L;
            }
            if (this.haltStatus) {
                this.haltProcessed = true;
                continue;
            }
            if (this.haltProcessed) {
                this.haltProcessed = false;
            } else {
                if (this.fetchWai) {
                    if (this.nmiStatus) {
                        this.nmiStatus = false;
                        this.fetchWai = false;
                        this.pushAllRegisters();
                        this.PC = this.m.load16(-4);
                        this.computer.clockCount += 12L;
                    }
                    if (this.irqStatus && !this.CI) {
                        this.irqStatus = false;
                        this.fetchWai = false;
                        this.pushAllRegisters();
                        this.PC = this.m.load16(-8);
                        this.computer.clockCount += 12L;
                    }
                    ++this.computer.clockCount;
                    continue;
                }
                if (this.nmiStatus) {
                    this.nmiStatus = false;
                    this.pushAllRegisters();
                    this.PC = this.m.load16(-4);
                    this.computer.clockCount += 12L;
                    continue;
                }
                if (this.irqStatus && !this.CI) {
                    this.irqStatus = false;
                    this.pushAllRegisters();
                    this.PC = this.m.load16(-8);
                    this.computer.clockCount += 12L;
                    continue;
                }
            }
            switch (this.fetchOp()) {
                case 27: {
                    this.A = this.add(this.A, this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -117: {
                    this.A = this.add(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -101: {
                    this.A = this.add(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -85: {
                    this.A = this.add(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -69: {
                    this.A = this.add(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -53: {
                    this.B = this.add(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -37: {
                    this.B = this.add(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -21: {
                    this.B = this.add(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -5: {
                    this.B = this.add(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -119: {
                    this.A = this.adc(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -103: {
                    this.A = this.adc(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -87: {
                    this.A = this.adc(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -71: {
                    this.A = this.adc(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -55: {
                    this.B = this.adc(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -39: {
                    this.B = this.adc(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -23: {
                    this.B = this.adc(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -7: {
                    this.B = this.adc(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -124: {
                    this.A = this.and(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -108: {
                    this.A = this.and(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -92: {
                    this.A = this.and(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -76: {
                    this.A = this.and(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -60: {
                    this.B = this.and(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -44: {
                    this.B = this.and(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -28: {
                    this.B = this.and(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -12: {
                    this.B = this.and(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 72: {
                    this.A = this.asl(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 88: {
                    this.B = this.asl(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 71: {
                    this.A = this.asr(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 87: {
                    this.B = this.asr(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -123: {
                    this.bit(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -107: {
                    this.bit(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -91: {
                    this.bit(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -75: {
                    this.bit(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -59: {
                    this.bit(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -43: {
                    this.bit(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -27: {
                    this.bit(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -11: {
                    this.bit(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 17: {
                    this.cmp(this.A, this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 79: {
                    this.A = this.clr();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 95: {
                    this.B = this.clr();
                    this.computer.clockCount += 2L;
                    break;
                }
                case -127: {
                    this.cmp(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -111: {
                    this.cmp(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -95: {
                    this.cmp(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -79: {
                    this.cmp(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -63: {
                    this.cmp(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -47: {
                    this.cmp(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -31: {
                    this.cmp(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -15: {
                    this.cmp(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 67: {
                    this.A = this.com(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 83: {
                    this.B = this.com(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 25: {
                    this.daa();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 74: {
                    this.A = this.dec(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 90: {
                    this.B = this.dec(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -120: {
                    this.A = this.eor(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -104: {
                    this.A = this.eor(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -88: {
                    this.A = this.eor(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -72: {
                    this.A = this.eor(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -56: {
                    this.B = this.eor(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -40: {
                    this.B = this.eor(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -24: {
                    this.B = this.eor(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -8: {
                    this.B = this.eor(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 76: {
                    this.A = this.inc(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 92: {
                    this.B = this.inc(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -122: {
                    this.A = this.lda(this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -106: {
                    this.A = this.lda(this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -90: {
                    this.A = this.lda(this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -74: {
                    this.A = this.lda(this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -58: {
                    this.B = this.lda(this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -42: {
                    this.B = this.lda(this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -26: {
                    this.B = this.lda(this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -10: {
                    this.B = this.lda(this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 68: {
                    this.A = this.lsr(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 84: {
                    this.B = this.lsr(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 64: {
                    this.A = this.neg(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 80: {
                    this.B = this.neg(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -118: {
                    this.A = this.ora(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -102: {
                    this.A = this.ora(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -86: {
                    this.A = this.ora(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -70: {
                    this.A = this.ora(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -54: {
                    this.B = this.ora(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -38: {
                    this.B = this.ora(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -22: {
                    this.B = this.ora(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -6: {
                    this.B = this.add(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 54: {
                    this.psh(this.A);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 55: {
                    this.psh(this.B);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 50: {
                    this.A = this.pul();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 51: {
                    this.B = this.pul();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 73: {
                    this.A = this.rol(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 89: {
                    this.B = this.rol(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 70: {
                    this.A = this.ror(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 86: {
                    this.B = this.ror(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -105: {
                    this.sta((short)(this.fetchOperand1() & 0xFF), this.A);
                    this.computer.clockCount += 4L;
                    break;
                }
                case -89: {
                    this.sta((short)((this.IX & 0xFFFF) + (this.fetchOperand1() & 0xFF)), this.A);
                    this.computer.clockCount += 6L;
                    break;
                }
                case -73: {
                    this.sta(this.fetchOperand2(), this.A);
                    this.computer.clockCount += 5L;
                    break;
                }
                case -41: {
                    this.sta((short)(this.fetchOperand1() & 0xFF), this.B);
                    this.computer.clockCount += 4L;
                    break;
                }
                case -25: {
                    this.sta((short)((this.IX & 0xFFFF) + (this.fetchOperand1() & 0xFF)), this.B);
                    this.computer.clockCount += 6L;
                    break;
                }
                case -9: {
                    this.sta(this.fetchOperand2(), this.B);
                    this.computer.clockCount += 5L;
                    break;
                }
                case 16: {
                    this.A = this.sub(this.A, this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -128: {
                    this.A = this.sub(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -112: {
                    this.A = this.sub(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -96: {
                    this.A = this.sub(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -80: {
                    this.A = this.sub(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -64: {
                    this.B = this.sub(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -48: {
                    this.B = this.sub(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -32: {
                    this.B = this.sub(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -16: {
                    this.B = this.sub(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -126: {
                    this.A = this.sbc(this.A, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -110: {
                    this.A = this.sbc(this.A, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -94: {
                    this.A = this.sbc(this.A, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -78: {
                    this.A = this.sbc(this.A, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -62: {
                    this.B = this.sbc(this.B, this.fetchOperand1());
                    this.computer.clockCount += 2L;
                    break;
                }
                case -46: {
                    this.B = this.sbc(this.B, this.load8_dir(this.fetchOperand1()));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -30: {
                    this.B = this.sbc(this.B, this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -14: {
                    this.B = this.sbc(this.B, this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 22: {
                    this.tab();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 23: {
                    this.tba();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 77: {
                    this.tst(this.A);
                    this.computer.clockCount += 2L;
                    break;
                }
                case 93: {
                    this.tst(this.B);
                    this.computer.clockCount += 2L;
                    break;
                }
                case -116: {
                    this.cpx(this.fetchOperand2());
                    this.computer.clockCount += 3L;
                    break;
                }
                case -100: {
                    this.cpx(this.load16_dir(this.fetchOperand1()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -84: {
                    this.cpx(this.load16_ind(this.fetchOperand1()));
                    this.computer.clockCount += 6L;
                    break;
                }
                case -68: {
                    this.cpx(this.load16_ext(this.fetchOperand2()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case 9: {
                    this.dex();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 52: {
                    this.des();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 8: {
                    this.inx();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 49: {
                    this.ins();
                    this.computer.clockCount += 4L;
                    break;
                }
                case -50: {
                    this.ldx(this.fetchOperand2());
                    this.computer.clockCount += 3L;
                    break;
                }
                case -34: {
                    this.ldx(this.load16_dir(this.fetchOperand1()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -18: {
                    this.ldx(this.load16_ind(this.fetchOperand1()));
                    this.computer.clockCount += 6L;
                    break;
                }
                case -2: {
                    this.ldx(this.load16_ext(this.fetchOperand2()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -114: {
                    this.lds(this.fetchOperand2());
                    this.computer.clockCount += 3L;
                    break;
                }
                case -98: {
                    this.lds(this.load16_dir(this.fetchOperand1()));
                    this.computer.clockCount += 4L;
                    break;
                }
                case -82: {
                    this.lds(this.load16_ind(this.fetchOperand1()));
                    this.computer.clockCount += 6L;
                    break;
                }
                case -66: {
                    this.lds(this.load16_ext(this.fetchOperand2()));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -33: {
                    this.stx((short)(this.fetchOperand1() & 0xFF));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -17: {
                    this.stx((short)((this.IX & 0xFFFF) + (this.fetchOperand1() & 0xFF)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case -1: {
                    this.stx(this.fetchOperand2());
                    this.computer.clockCount += 6L;
                    break;
                }
                case -97: {
                    this.sts((short)(this.fetchOperand1() & 0xFF));
                    this.computer.clockCount += 5L;
                    break;
                }
                case -81: {
                    this.sts((short)((this.IX & 0xFFFF) + (this.fetchOperand1() & 0xFF)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case -65: {
                    this.sts(this.fetchOperand2());
                    this.computer.clockCount += 6L;
                    break;
                }
                case 53: {
                    this.txs();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 48: {
                    this.tsx();
                    this.computer.clockCount += 4L;
                    break;
                }
                case 104: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.asl(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 120: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.asl(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 103: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.asr(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 119: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.asr(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 111: {
                    this.store8_ind(this.fetchOperand1(), this.clr());
                    this.computer.clockCount += 7L;
                    break;
                }
                case 127: {
                    this.store8_ext(this.fetchOperand2(), this.clr());
                    this.computer.clockCount += 6L;
                    break;
                }
                case 99: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.com(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 115: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.com(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 106: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.dec(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 122: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.dec(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 108: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.inc(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 124: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.inc(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 100: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.lsr(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 116: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.lsr(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 96: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.neg(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 112: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.neg(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 105: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.rol(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 121: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.rol(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 102: {
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.ror(this.load8_ind(offset)));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 118: {
                    short addr = this.fetchOperand2();
                    this.store8_ext(addr, this.ror(this.load8_ext(addr)));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 109: {
                    this.tst(this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 7L;
                    break;
                }
                case 125: {
                    this.tst(this.load8_ext(this.fetchOperand2()));
                    this.computer.clockCount += 6L;
                    break;
                }
                case 32: {
                    this.branch(this.fetchOperand1(), true);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 36: {
                    this.branch(this.fetchOperand1(), !this.CC);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 37: {
                    this.branch(this.fetchOperand1(), this.CC);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 39: {
                    this.branch(this.fetchOperand1(), this.CZ);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 44: {
                    this.branch(this.fetchOperand1(), !(this.CN ^ this.CV));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 46: {
                    this.branch(this.fetchOperand1(), !(this.CZ | this.CN ^ this.CV));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 34: {
                    this.branch(this.fetchOperand1(), !(this.CC | this.CZ));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 47: {
                    this.branch(this.fetchOperand1(), this.CZ | this.CN ^ this.CV);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 35: {
                    this.branch(this.fetchOperand1(), this.CC | this.CZ);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 45: {
                    this.branch(this.fetchOperand1(), this.CN ^ this.CV);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 43: {
                    this.branch(this.fetchOperand1(), this.CN);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 38: {
                    this.branch(this.fetchOperand1(), !this.CZ);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 40: {
                    this.branch(this.fetchOperand1(), !this.CV);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 41: {
                    this.branch(this.fetchOperand1(), this.CV);
                    this.computer.clockCount += 4L;
                    break;
                }
                case 42: {
                    this.branch(this.fetchOperand1(), !this.CN);
                    this.computer.clockCount += 4L;
                    break;
                }
                case -115: {
                    this.bsr(this.fetchOperand1());
                    this.computer.clockCount += 8L;
                    break;
                }
                case 110: {
                    this.jump((short)((this.IX & 0xFFFF) + (this.fetchOperand1() & 0xFF)));
                    this.computer.clockCount += 4L;
                    break;
                }
                case 126: {
                    this.jump(this.fetchOperand2());
                    this.computer.clockCount += 3L;
                    break;
                }
                case -83: {
                    this.jsr((short)((this.IX & 0xFFFF) + (this.fetchOperand1() & 0xFF)));
                    this.computer.clockCount += 8L;
                    break;
                }
                case -67: {
                    this.jsr(this.fetchOperand2());
                    this.computer.clockCount += 9L;
                    break;
                }
                case 1: {
                    this.computer.clockCount += 2L;
                    break;
                }
                case 59: {
                    this.rti();
                    this.computer.clockCount += 10L;
                    break;
                }
                case 57: {
                    this.rts();
                    this.computer.clockCount += 5L;
                    break;
                }
                case 63: {
                    this.swi();
                    this.computer.clockCount += 12L;
                    break;
                }
                case 62: {
                    this.wai();
                    this.computer.clockCount += 9L;
                    break;
                }
                case 12: {
                    this.clc();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 14: {
                    this.cli();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 10: {
                    this.clv();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 13: {
                    this.sec();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 15: {
                    this.sei();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 11: {
                    this.sev();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 6: {
                    this.tap();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 7: {
                    this.tpa();
                    this.computer.clockCount += 2L;
                    break;
                }
                case 113: {
                    byte value = this.fetchOperand1();
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.nim(value, this.load8_ind(offset)));
                    this.computer.clockCount += 8L;
                    break;
                }
                case 114: {
                    byte value = this.fetchOperand1();
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.oim(value, this.load8_ind(offset)));
                    this.computer.clockCount += 8L;
                    break;
                }
                case 117: {
                    byte value = this.fetchOperand1();
                    byte offset = this.fetchOperand1();
                    this.store8_ind(offset, this.xim(value, this.load8_ind(offset)));
                    this.computer.clockCount += 8L;
                    break;
                }
                case 123: {
                    this.tmm(this.fetchOperand1(), this.load8_ind(this.fetchOperand1()));
                    this.computer.clockCount += 7L;
                    break;
                }
                case -20: {
                    this.IX = this.add16(this.IX, (short)(this.fetchOperand1() & 0xFF));
                    this.computer.clockCount += 3L;
                    break;
                }
                case -4: {
                    this.IX = this.add16(this.IX, this.load16_ext(this.fetchOperand2()));
                    this.computer.clockCount += 7L;
                    break;
                }
                default: {
                    this.nop();
                    ++this.computer.clockCount;
                }
            }
        }
        return this.computer.clockCount - (initial_clock + clocks);
    }

    @Override
    public void saveState(StateSet ss) {
        ss.set("MB8861.A", this.A);
        ss.set("MB8861.B", this.B);
        ss.set("MB8861.IX", this.IX);
        ss.set("MB8861.SP", this.SP);
        ss.set("MB8861.PC", this.PC);
        ss.set("MB8861.CH", this.CH);
        ss.set("MB8861.CI", this.CI);
        ss.set("MB8861.CN", this.CN);
        ss.set("MB8861.CZ", this.CZ);
        ss.set("MB8861.CV", this.CV);
        ss.set("MB8861.CC", this.CC);
        ss.set("MB8861.resetStatus", this.resetStatus);
        ss.set("MB8861.nmiStatus", this.nmiStatus);
        ss.set("MB8861.irqStatus", this.irqStatus);
        ss.set("MB8861.haltStatus", this.haltStatus);
        ss.set("MB8861.haltProcessed", this.haltProcessed);
        ss.set("MB8861.fetchWai", this.fetchWai);
    }

    @Override
    public void loadState(StateSet ss) {
        this.A = (Byte)ss.get("MB8861.A");
        this.B = (Byte)ss.get("MB8861.B");
        this.IX = (Short)ss.get("MB8861.IX");
        this.SP = (Short)ss.get("MB8861.SP");
        this.PC = (Short)ss.get("MB8861.PC");
        this.CH = (Boolean)ss.get("MB8861.CH");
        this.CI = (Boolean)ss.get("MB8861.CI");
        this.CN = (Boolean)ss.get("MB8861.CN");
        this.CZ = (Boolean)ss.get("MB8861.CZ");
        this.CV = (Boolean)ss.get("MB8861.CV");
        this.CC = (Boolean)ss.get("MB8861.CC");
        this.resetStatus = (Boolean)ss.get("MB8861.resetStatus");
        this.nmiStatus = (Boolean)ss.get("MB8861.nmiStatus");
        this.irqStatus = (Boolean)ss.get("MB8861.irqStatus");
        this.haltStatus = (Boolean)ss.get("MB8861.haltStatus");
        this.haltProcessed = (Boolean)ss.get("MB8861.haltProcessed");
        this.fetchWai = (Boolean)ss.get("MB8861.fetchWai");
    }
}

