/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.Program;
import jp.asamomiji.emulator.file.TextFormatFile;
import jp.asamomiji.emulator.jr100.MainRam;

public class BasicTextFormatFile
extends TextFormatFile {
    public BasicTextFormatFile(File file) {
        super(file);
    }

    private int getLineNumber(StringBuffer buf) {
        int number;
        this.skipWhiteSpace(buf);
        if (buf.length() == 0) {
            return -1;
        }
        int index = 0;
        while (Character.isDigit(buf.charAt(index))) {
            ++index;
        }
        if (index == 0) {
            return -1;
        }
        try {
            number = Integer.parseInt(buf.substring(0, index));
        }
        catch (NumberFormatException e) {
            return -1;
        }
        buf.delete(0, index);
        return number;
    }

    /*
     * Unable to fully structure code
     */
    private void canonicalizeLine(StringBuffer buf) {
        index = 0;
        if (buf.length() != 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            ++index;
lbl5:
            // 2 sources

            ** while (index < buf.length() && Character.isWhitespace((char)buf.charAt((int)index)))
        }
lbl6:
        // 1 sources

        if (index > 0) {
            buf.delete(0, index);
        }
        index = buf.length() - 1;
        while (index >= 0 && Character.isWhitespace(buf.charAt(index))) {
            --index;
        }
        if (buf.length() - 1 - index > 0) {
            buf.delete(index + 1, buf.length());
        }
        i = 0;
        while (i < buf.length()) {
            buf.setCharAt(i, Character.toUpperCase(buf.charAt(i)));
            ++i;
        }
    }

    private void skipWhiteSpace(StringBuffer buf) {
        int index = 0;
        while (index < buf.length() && Character.isWhitespace(buf.charAt(index))) {
            ++index;
        }
        if (index > 0) {
            buf.delete(0, index);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Program load_jr100(MemorySystem ms) {
        Program p = new Program(ms);
        p.setName("");
        p.setBasicArea(true);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                BufferedReader r = new BufferedReader(new FileReader(this.file));
                try {
                    String line;
                    StringBuffer buf = new StringBuffer();
                    int addr = 582;
                    int end_addr = Short.MAX_VALUE;
                    while ((line = r.readLine()) != null) {
                        buf.replace(0, buf.length(), line);
                        this.canonicalizeLine(buf);
                        if (buf.length() == 0) continue;
                        int line_length = 0;
                        int line_number = this.getLineNumber(buf);
                        if (line_number == -1) {
                            this.setErrorStatus(3, "\u884c\u756a\u53f7\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                            return p;
                        }
                        if (line_number < 1 || line_number > Short.MAX_VALUE) {
                            this.setErrorStatus(3, "\u884c\u756a\u53f7(" + line_number + ")\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                            return p;
                        }
                        this.skipWhiteSpace(buf);
                        ms.store16(addr, (short)(line_number & 0xFFFF));
                        line_length += 2;
                        addr += 2;
                        int i = 0;
                        while (i < buf.length()) {
                            if (addr > end_addr) {
                                this.setErrorStatus(7, "\u30e1\u30e2\u30ea\u304c\u3044\u3063\u3071\u3044\u3067\u3059\u3002");
                                return p;
                            }
                            byte data = (byte)(buf.charAt(i) & 0xFF);
                            if (buf.charAt(i) == '\\') {
                                if (i + 2 >= buf.length()) {
                                    this.setErrorStatus(3, "\u884c\u672b\u306b\u9054\u3057\u307e\u3057\u305f\u3002\n" + line);
                                    return p;
                                }
                                try {
                                    data = (byte)(Integer.parseInt(buf.substring(i + 1, i + 3), 16) & 0xFF);
                                    i += 2;
                                }
                                catch (NumberFormatException e) {
                                    this.setErrorStatus(3, "\u4e0d\u6b63\u306a\u30a8\u30b9\u30b1\u30fc\u30d7\u6587\u5b57(\\" + buf.substring(i + 1, i + 3) + ")\u304c\u3042\u308a\u307e\u3059\u3002\n" + line);
                                    if (r == null) return p;
                                    r.close();
                                    return p;
                                }
                            }
                            ms.store8(addr++, data);
                            ++line_length;
                            ++i;
                        }
                        if (line_length > 72) {
                            this.setErrorStatus(3, "\u884c\u306e\u9577\u3055\u304c\u9577\u3059\u304e\u307e\u3059\u3002\n" + line);
                            return p;
                        }
                        ms.store8(addr++, (byte)0);
                    }
                    if (addr + 3 > end_addr) {
                        this.setErrorStatus(7, "\u30e1\u30e2\u30ea\u304c\u3044\u3063\u3071\u3044\u3067\u3059\u3002");
                        return p;
                    }
                    int end = addr + 1;
                    ms.store8(addr++, (byte)-33);
                    ms.store8(addr++, (byte)-33);
                    ms.store8(addr++, (byte)-33);
                    ms.store8(6, (byte)(end >> 8 & 0xFF));
                    ms.store8(7, (byte)(end & 0xFF));
                    ms.store8(8, (byte)(end + 1 >> 8 & 0xFF));
                    ms.store8(9, (byte)(end + 1 & 0xFF));
                    ms.store8(10, (byte)(end + 2 >> 8 & 0xFF));
                    ms.store8(11, (byte)(end + 2 & 0xFF));
                    ms.store8(12, (byte)(end + 3 >> 8 & 0xFF));
                    ms.store8(13, (byte)(end + 3 & 0xFF));
                }
                finally {
                    if (r == null) return p;
                    r.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.setErrorStatus(4, e.getMessage());
            return p;
        }
        catch (IOException e) {
            this.setErrorStatus(5, e.getMessage());
            return p;
        }
        this.setErrorStatus(0, null);
        return p;
    }

    @Override
    public void save_jr100(Program p, int version) {
        MemorySystem ms = p.getMemorySystem();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedWriter w = new BufferedWriter(new FileWriter(this.file));){
                int addr = 582;
                int end_addr = ms.getMemory(MainRam.class).getEndAddress();
                int line_number = ms.load16(addr) & 0xFFFF;
                while (addr < end_addr && line_number != 57311) {
                    int value;
                    w.write(Integer.toString(line_number));
                    w.write(32);
                    addr += 2;
                    while ((value = ms.load8(addr) & 0xFF) != 0) {
                        if (value >= 128) {
                            w.write(92);
                            String hex = Integer.toHexString(value).toUpperCase();
                            w.write(hex, hex.length() - 2, 2);
                        } else {
                            w.write((char)value);
                        }
                        ++addr;
                    }
                    w.write(System.getProperty("line.separator"));
                    line_number = ms.load16(++addr) & 0xFFFF;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.setErrorStatus(4, e.getMessage());
            return;
        }
        catch (IOException e) {
            this.setErrorStatus(5, e.getMessage());
            return;
        }
        this.setErrorStatus(0, null);
    }
}

