/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jp.asamomiji.emulator.AddressRegion;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.Program;
import jp.asamomiji.emulator.file.DataFile;
import jp.asamomiji.emulator.file.InvalidFormatException;

public class ProgFormatFile
extends DataFile {
    public static final int PROG_MAX_PROGRAM_NAME_LENGTH = 256;
    public static final int PROG_MAX_PROGRAM_LENGTH = 65536;
    public static final int PROG_MAX_COMMENT_LENGTH = 1024;
    public static final int PROG_MAX_BINARY_SECTIONS = 256;
    private static final int MIN_VERSION = 1;
    private static final int MAX_VERSION = 2;
    private static final int MAX_BUFFER_SIZE = 65536;
    private static final int MAGIC_NUMBER = 1196380752;
    private static final int SECTION_PNAM = 1296125520;
    private static final int SECTION_PBAS = 1396785744;
    private static final int SECTION_PBIN = 1313423952;
    private static final int SECTION_CMNT = 1414417731;

    public ProgFormatFile(File file) {
        super(file);
    }

    private void checkMagic(InputStream in, byte[] buffer) throws InvalidFormatException, EOFException, IOException {
        int buflen = in.read(buffer, 0, 4);
        if (buflen == -1) {
            throw new EOFException();
        }
        if (buflen < 4) {
            throw new InvalidFormatException("\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u9055\u3044\u307e\u3059\u3002");
        }
        int value = this.convertLEToInteger(buffer, 0, 4);
        if (value != 1196380752) {
            throw new InvalidFormatException("\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u9055\u3044\u307e\u3059\u3002");
        }
    }

    private void writeMagic(OutputStream out) throws IOException {
        out.write(80);
        out.write(82);
        out.write(79);
        out.write(71);
    }

    private int readInteger(InputStream in, byte[] buffer, int min, int max, String attr) throws InvalidFormatException, EOFException, IOException {
        int buflen = in.read(buffer, 0, 4);
        if (buflen == -1) {
            throw new EOFException();
        }
        if (buflen < 4) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u306e\u9577\u3055\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002(" + buflen + ")");
        }
        int value = this.convertLEToInteger(buffer, 0, 4);
        if (value < min) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u306e\u9577\u3055(" + value + ")\u304c\u6700\u5c0f\u5024(" + max + ")\u3088\u308a\u5c0f\u3055\u3044\u3067\u3059\u3002");
        }
        if (value > max) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u306e\u9577\u3055(" + value + ")\u304c\u6700\u5927\u5024(" + max + ")\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002");
        }
        return value;
    }

    private void writeInteger(OutputStream out, int value) throws IOException {
        out.write(value & 0xFF);
        out.write((value & 0xFF00) >> 8);
        out.write((value & 0xFF0000) >> 16);
        out.write((value & 0xFF000000) >> 24);
    }

    private byte[] readBytes(InputStream in, byte[] buffer, int length, String attr) throws InvalidFormatException, EOFException, IOException {
        int buflen = in.read(buffer, 0, length);
        if (buflen == -1) {
            throw new EOFException();
        }
        if (buflen < length) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002(" + buflen + ")");
        }
        return buffer;
    }

    private void writeBytes(OutputStream out, byte[] data) throws IOException {
        int i = 0;
        while (i < data.length) {
            out.write(data[i]);
            ++i;
        }
    }

    private String readUTF8String(InputStream in, byte[] buffer, int maxlen, String attr) throws InvalidFormatException, EOFException, IOException {
        int buflen = in.read(buffer, 0, 4);
        if (buflen == -1) {
            throw new EOFException();
        }
        if (buflen < 4) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u306e\u9577\u3055\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002(" + buflen + ")");
        }
        int len = this.convertLEToInteger(buffer, 0, 4);
        if (len > maxlen) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u306e\u9577\u3055\u304c\u9577\u3059\u304e\u307e\u3059\u3002(" + len + ")");
        }
        buflen = in.read(buffer, 0, len);
        if (buflen != len) {
            throw new InvalidFormatException(String.valueOf(attr) + "\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002(" + buflen + ")");
        }
        return new String(buffer, 0, len, "UTF-8");
    }

    private void writeUTF8String(OutputStream out, String str) throws IOException {
        if (str != null && !str.equals("")) {
            byte[] bytes = str.getBytes("UTF-8");
            this.writeInteger(out, bytes.length);
            this.writeBytes(out, bytes);
        } else {
            this.writeInteger(out, 0);
        }
    }

    private int convertLEToInteger(byte[] b, int off, int len) {
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 4) {
            return (b[off] & 0xFF) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
        }
        if (len == 0) {
            return 0;
        }
        if (len == 1) {
            return b[off];
        }
        if (len == 2) {
            return (b[off] & 0xFF) + ((b[off + 1] & 0xFF) << 8);
        }
        if (len == 3) {
            return (b[off] & 0xFF) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16);
        }
        return (b[off] & 0xFF) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
    }

    @Override
    public Program load_jr100(MemorySystem ms) {
        Program p;
        block15: {
            p = new Program(ms);
            byte[] buffer = new byte[4];
            try {
                Throwable throwable = null;
                Object var5_9 = null;
                try (FileInputStream in = new FileInputStream(this.file);){
                    this.checkMagic(in, buffer);
                    int version = this.readInteger(in, buffer, 1, 2, "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30d0\u30fc\u30b8\u30e7\u30f3");
                    if (version == 1) {
                        this.load1(in, p);
                        break block15;
                    }
                    if (version == 2) {
                        this.load2(in, p);
                        break block15;
                    }
                    throw new AssertionError((Object)"invalid version");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                this.setErrorStatus(4, e.getMessage());
                return p;
            }
            catch (InvalidFormatException e) {
                this.setErrorStatus(3, e.getMessage());
                return p;
            }
            catch (IOException e) {
                this.setErrorStatus(5, e.getMessage());
                return p;
            }
        }
        this.setErrorStatus(0, null);
        return p;
    }

    private void load1(InputStream in, Program p) throws InvalidFormatException, IOException {
        byte[] buffer = new byte[65536];
        MemorySystem ms = p.getMemorySystem();
        try {
            p.setName(this.readUTF8String(in, buffer, 256, "\u30d7\u30ed\u30b0\u30e9\u30e0\u540d"));
            int start_address = this.readInteger(in, buffer, 0, 65536, "\u958b\u59cb\u30a2\u30c9\u30ec\u30b9");
            int length = this.readInteger(in, buffer, 0, 65536, "\u30d7\u30ed\u30b0\u30e9\u30e0\u9577");
            if (start_address + length > 65536) {
                throw new InvalidFormatException("\u7d42\u4e86\u30a2\u30c9\u30ec\u30b9(" + (start_address + length) + ")\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002");
            }
            int flag = this.readInteger(in, buffer, Integer.MIN_VALUE, Integer.MAX_VALUE, "\u30d5\u30e9\u30b0");
            if (flag == 0) {
                p.setBasicArea(true);
            } else {
                p.addAddressRegion(start_address, start_address + length - 1);
                p.setBasicArea(false);
            }
            this.readBytes(in, buffer, length, "\u30d7\u30ed\u30b0\u30e9\u30e0");
            int end_address = start_address + length - 1;
            int i = start_address;
            while (i <= end_address) {
                ms.store8(i, buffer[i - start_address]);
                ++i;
            }
            if (flag == 0) {
                ms.store8(end_address + 1, (byte)-33);
                ms.store8(end_address + 2, (byte)-33);
                ms.store8(end_address + 3, (byte)-33);
                ms.store8(6, (byte)(end_address >> 8 & 0xFF));
                ms.store8(7, (byte)(end_address & 0xFF));
                ms.store8(8, (byte)(end_address + 1 >> 8 & 0xFF));
                ms.store8(9, (byte)(end_address + 1 & 0xFF));
                ms.store8(10, (byte)(end_address + 2 >> 8 & 0xFF));
                ms.store8(11, (byte)(end_address + 2 & 0xFF));
                ms.store8(12, (byte)(end_address + 3 >> 8 & 0xFF));
                ms.store8(13, (byte)(end_address + 3 & 0xFF));
                p.setBasicArea(true);
            }
        }
        catch (EOFException e) {
            throw new InvalidFormatException("\u30d5\u30a1\u30a4\u30eb\u304c\u4e0d\u5b8c\u5168\u3067\u3059\u3002");
        }
    }

    private void load2(InputStream in, Program p) throws InvalidFormatException, IOException {
        byte[] buffer = new byte[65536];
        MemorySystem ms = p.getMemorySystem();
        int count_pnam = 0;
        int count_cmnt = 0;
        int count_pbas = 0;
        int count_pbin = 0;
        while (true) {
            int section_id;
            try {
                section_id = this.readInteger(in, buffer, Integer.MIN_VALUE, Integer.MAX_VALUE, "\u30bb\u30af\u30b7\u30e7\u30f3\u540d");
            }
            catch (EOFException e) {
                break;
            }
            int section_length = this.readInteger(in, buffer, 0, Integer.MAX_VALUE, "\u30bb\u30af\u30b7\u30e7\u30f3\u9577");
            if (section_id == 1296125520) {
                if (count_pnam == 1) {
                    in.skip(section_length);
                    continue;
                }
                ++count_pnam;
                String name = this.readUTF8String(in, buffer, 256, "\u30d7\u30ed\u30b0\u30e9\u30e0\u540d");
                p.setName(name);
                if (section_length == name.getBytes("UTF-8").length + 4) continue;
                throw new InvalidFormatException("\u30bb\u30af\u30b7\u30e7\u30f3PNAM\u306e\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002(" + section_length + ")");
            }
            if (section_id == 1396785744) {
                if (count_pbas == 1) {
                    in.skip(section_length);
                    continue;
                }
                ++count_pbas;
                int start_address = 582;
                int program_length = this.readInteger(in, buffer, 0, 65536, "BASIC\u30d7\u30ed\u30b0\u30e9\u30e0\u9577");
                if (start_address + program_length > 65536) {
                    throw new InvalidFormatException("\u7d42\u4e86\u30a2\u30c9\u30ec\u30b9(" + (start_address + program_length) + ")\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002");
                }
                this.readBytes(in, buffer, program_length, "BASIC\u30d7\u30ed\u30b0\u30e9\u30e0");
                int end_address = start_address + program_length - 1;
                int addr = start_address;
                while (addr <= end_address) {
                    ms.store8(addr, buffer[addr - start_address]);
                    ++addr;
                }
                ms.store8(end_address + 1, (byte)-33);
                ms.store8(end_address + 2, (byte)-33);
                ms.store8(end_address + 3, (byte)-33);
                ms.store8(6, (byte)(end_address >> 8 & 0xFF));
                ms.store8(7, (byte)(end_address & 0xFF));
                ms.store8(8, (byte)(end_address + 1 >> 8 & 0xFF));
                ms.store8(9, (byte)(end_address + 1 & 0xFF));
                ms.store8(10, (byte)(end_address + 2 >> 8 & 0xFF));
                ms.store8(11, (byte)(end_address + 2 & 0xFF));
                ms.store8(12, (byte)(end_address + 3 >> 8 & 0xFF));
                ms.store8(13, (byte)(end_address + 3 & 0xFF));
                p.setBasicArea(true);
                if (section_length == program_length + 4) continue;
                throw new InvalidFormatException("\u30bb\u30af\u30b7\u30e7\u30f3PBAS\u306e\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002(" + section_length + ")");
            }
            if (section_id == 1313423952) {
                int data_length;
                if (count_pbin == 256) {
                    in.skip(section_length);
                    continue;
                }
                ++count_pbin;
                int start_addr = this.readInteger(in, buffer, 0, 65536, "\u958b\u59cb\u30a2\u30c9\u30ec\u30b9");
                if (start_addr + (data_length = this.readInteger(in, buffer, 0, 65536, "\u30c7\u30fc\u30bf\u9577")) > 65536) {
                    throw new InvalidFormatException("\u7d42\u4e86\u30a2\u30c9\u30ec\u30b9(" + (start_addr + data_length) + ")\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002");
                }
                this.readBytes(in, buffer, data_length, "\u30de\u30b7\u30f3\u8a9e\u30c7\u30fc\u30bf");
                int addr = start_addr;
                while (addr < start_addr + data_length) {
                    ms.store8(addr, buffer[addr - start_addr]);
                    ++addr;
                }
                String comment = this.readUTF8String(in, buffer, 1024, "\u30a2\u30c9\u30ec\u30b9\u7bc4\u56f2\u306e\u30b3\u30e1\u30f3\u30c8");
                p.addAddressRegion(start_addr, start_addr + data_length - 1, comment);
                if (section_length == data_length + 4 + comment.getBytes("UTF-8").length + 4) continue;
                throw new InvalidFormatException("\u30bb\u30af\u30b7\u30e7\u30f3PBIN\u306e\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002(" + section_length + ")");
            }
            if (section_id == 1414417731) {
                if (count_cmnt == 1) {
                    in.skip(section_length);
                    continue;
                }
                ++count_cmnt;
                String comment = this.readUTF8String(in, buffer, 1024, "\u30b3\u30e1\u30f3\u30c8");
                p.setComment(comment);
                if (section_length == comment.getBytes().length + 4) continue;
                throw new InvalidFormatException("\u30bb\u30af\u30b7\u30e7\u30f3CMNT\u306e\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002(" + section_length + ")");
            }
            in.skip(section_length);
        }
    }

    @Override
    public void save_jr100(Program p, int version) {
        block17: {
            if (p == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var4_8 = null;
                try (FileOutputStream out = new FileOutputStream(this.file);){
                    this.writeMagic(out);
                    this.writeInteger(out, version);
                    if (version == 1) {
                        this.save1(out, p);
                        break block17;
                    }
                    if (version == 2) {
                        this.save2(out, p);
                        break block17;
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                this.setErrorStatus(4, e.getMessage());
                return;
            }
            catch (InvalidFormatException e) {
                this.setErrorStatus(3, e.getMessage());
                return;
            }
            catch (IOException e) {
                this.setErrorStatus(5, e.getMessage());
                return;
            }
        }
        this.setErrorStatus(0, null);
    }

    private void save1(OutputStream out, Program p) throws InvalidFormatException, IOException {
        int flag;
        int end_addr;
        int start_addr;
        MemorySystem ms = p.getMemorySystem();
        ArrayList<AddressRegion> r = p.getAllAddressRegions();
        if (p.hasBasicArea() && r.size() != 0 || !p.hasBasicArea() && r.size() != 1) {
            throw new InvalidFormatException("\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u30d0\u30fc\u30b8\u30e7\u30f31\u5f62\u5f0f\u3067\u306f\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002BASIC\u9818\u57df\u304b\u30d0\u30a4\u30ca\u30ea\u9818\u57df\u306e\u3044\u305a\u308c\u304b1\u3064\u306e\u307f\u683c\u7d0d\u3067\u304d\u307e\u3059\u3002");
        }
        this.writeUTF8String(out, p.getName());
        if (p.hasBasicArea()) {
            start_addr = 582;
            end_addr = ms.load16(6);
            flag = 0;
        } else {
            start_addr = r.get(0).getStartAddress();
            end_addr = r.get(0).getEndAddress();
            flag = 1;
        }
        this.writeInteger(out, start_addr);
        this.writeInteger(out, end_addr - start_addr + 1);
        this.writeInteger(out, flag);
        byte[] data = new byte[end_addr - start_addr + 1];
        int addr = start_addr;
        while (addr <= end_addr) {
            data[addr - start_addr] = ms.load8(addr);
            ++addr;
        }
        this.writeBytes(out, data);
    }

    private void save2(OutputStream out, Program p) throws InvalidFormatException, IOException {
        String comment;
        MemorySystem ms = p.getMemorySystem();
        ArrayList<AddressRegion> regions = p.getAllAddressRegions();
        String name = p.getName();
        if (name != null && !name.equals("")) {
            this.writeInteger(out, 1296125520);
            this.writeInteger(out, 4 + name.getBytes("UTF-8").length);
            this.writeUTF8String(out, name);
        }
        if ((comment = p.getComment()) != null && !comment.equals("")) {
            byte[] bytes = comment.getBytes("UTF-8");
            this.writeInteger(out, 1414417731);
            this.writeInteger(out, 4 + bytes.length);
            this.writeInteger(out, bytes.length);
            this.writeBytes(out, bytes);
        }
        if (p.hasBasicArea()) {
            int start_addr = 582;
            int end_addr = ms.load16(6);
            this.writeInteger(out, 1396785744);
            this.writeInteger(out, 4 + (end_addr - start_addr + 1));
            this.writeInteger(out, end_addr - start_addr + 1);
            byte[] data = new byte[end_addr - start_addr + 1];
            int addr = start_addr;
            while (addr <= end_addr) {
                data[addr - start_addr] = ms.load8(addr);
                ++addr;
            }
            this.writeBytes(out, data);
        }
        int count = 0;
        for (AddressRegion r : regions) {
            int start_addr = r.getStartAddress();
            int end_addr = r.getEndAddress();
            String region_comment = r.getComment();
            this.writeInteger(out, 1313423952);
            this.writeInteger(out, 4 + (end_addr - start_addr + 1) + 4 + region_comment.getBytes("UTF-8").length);
            this.writeInteger(out, start_addr);
            this.writeInteger(out, end_addr - start_addr + 1);
            byte[] data = new byte[end_addr - start_addr + 1];
            int addr = start_addr;
            while (addr <= end_addr) {
                data[addr - start_addr] = ms.load8(addr);
                ++addr;
            }
            this.writeBytes(out, data);
            this.writeUTF8String(out, region_comment);
            if (++count == 256) break;
        }
    }
}

