/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jp.asamomiji.emulator.AddressRegion;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.Program;
import jp.asamomiji.emulator.file.BasicTextFormatFile;
import jp.asamomiji.emulator.file.BinaryTextFormatFile;
import jp.asamomiji.emulator.file.DataFile;
import jp.asamomiji.emulator.file.ProgFormatFile;

public class FileSaveDialog
extends JDialog {
    private Computer computer;
    private final JPanel contentPanel = new JPanel();
    private JTextField textField_programName;
    private JTextArea textArea_programComment;
    private JTable table_addressRegions;
    private JTextField textField_filename;
    private JTextField textField_pathname;
    private JCheckBox checkBox_saveBasicArea;
    private JComboBox<FileFormatEntry> comboBox_fileFormat;
    private JLabel label_message = new JLabel();
    private final Action action_cancel = new SwingAction();
    private final Action action_chooseFile = new SwingAction_1();
    private final Action action_ok = new SwingAction_2();
    private static final FileFormatEntry FORMAT_PROG = new FileFormatEntry("prg", "PROG\u5f62\u5f0f(*.prg)");
    private static final FileFormatEntry FORMAT_BASIC = new FileFormatEntry("bas", "BASIC\u30c6\u30ad\u30b9\u30c8(*.bas)");
    private static final FileFormatEntry FORMAT_DUMP = new FileFormatEntry("dat", "16\u9032\u30c0\u30f3\u30d7(*.dat)");
    private FileFormatEntry[] fileFormatList = new FileFormatEntry[]{FORMAT_PROG, FORMAT_BASIC, FORMAT_DUMP};
    private ComboBoxModel<FileFormatEntry> fileFormatModel = new DefaultComboBoxModel<FileFormatEntry>(this.fileFormatList);

    public FileSaveDialog(Computer computer, Frame owner) {
        super(owner);
        this.computer = computer;
        Program p = computer.getProgram();
        this.setTitle("\u4fdd\u5b58");
        this.setBounds(100, 100, 599, 546);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JLabel label_programName = new JLabel("\u30d7\u30ed\u30b0\u30e9\u30e0\u540d");
        this.textField_programName = new JTextField();
        this.textField_programName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!FileSaveDialog.this.checkText(FileSaveDialog.this.textField_programName.getText(), 256, "\u30d7\u30ed\u30b0\u30e9\u30e0\u540d")) {
                    FileSaveDialog.this.textField_programName.requestFocusInWindow();
                }
            }
        });
        this.textField_programName.setColumns(10);
        if (p != null && p.getName() != null) {
            this.textField_programName.setText(p.getName());
        }
        JLabel label_programComment = new JLabel("\u30b3\u30e1\u30f3\u30c8");
        JScrollPane scrollPane_programComment = new JScrollPane();
        JPanel panel_saveArea = new JPanel();
        panel_saveArea.setBorder(new TitledBorder(null, "\u4fdd\u5b58\u3059\u308b\u9818\u57df", 4, 2, null, null));
        JLabel label_filename = new JLabel("\u30d5\u30a1\u30a4\u30eb\u540d");
        JLabel label_pathname = new JLabel("\u30d1\u30b9\u540d");
        this.textField_filename = new JTextField();
        this.textField_filename.setColumns(10);
        this.textField_pathname = new JTextField();
        this.textField_pathname.setColumns(10);
        if (p != null && p.getFile() != null) {
            this.textField_filename.setText(p.getFile().getName());
            this.textField_pathname.setText(p.getFile().getParent());
        } else {
            this.textField_filename.setText("");
            this.textField_pathname.setText(Application.getCurrentDirectory());
        }
        JButton button_chooseFile = new JButton("\u30d5\u30a1\u30a4\u30eb\u9078\u629e");
        button_chooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        button_chooseFile.setAction(this.action_chooseFile);
        JLabel label_fileFormat = new JLabel("\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f");
        this.comboBox_fileFormat = new JComboBox<FileFormatEntry>(this.fileFormatModel);
        this.comboBox_fileFormat.setRenderer(new FileFormatRenderer());
        this.comboBox_fileFormat.setSelectedItem(FORMAT_PROG);
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label_programComment).addComponent(label_programName)).addGap(36).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(scrollPane_programComment, -1, 469, Short.MAX_VALUE).addComponent(this.textField_programName, -2, 226, -2))).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label_pathname).addComponent(label_filename).addComponent(label_fileFormat)).addGap(31).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textField_filename, -2, 197, -2).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addComponent(this.comboBox_fileFormat, 0, -1, Short.MAX_VALUE).addGap(52)).addGroup(gl_contentPanel.createSequentialGroup().addComponent(this.textField_pathname, -1, 351, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(button_chooseFile)))).addGroup(gl_contentPanel.createSequentialGroup().addComponent(panel_saveArea, -1, -1, Short.MAX_VALUE).addGap(3))).addContainerGap()));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textField_programName, -2, -1, -2).addComponent(label_programName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label_programComment).addComponent(scrollPane_programComment, -2, 72, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel_saveArea, -2, 243, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label_filename).addComponent(this.textField_filename, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label_fileFormat).addComponent(this.comboBox_fileFormat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label_pathname).addComponent(this.textField_pathname, -2, -1, -2).addComponent(button_chooseFile)).addContainerGap()));
        this.checkBox_saveBasicArea = new JCheckBox("BASIC\u30d7\u30ed\u30b0\u30e9\u30e0\u9818\u57df");
        if (p == null) {
            this.checkBox_saveBasicArea.setSelected(true);
        } else {
            this.checkBox_saveBasicArea.setSelected(p.hasBasicArea());
        }
        JButton button_addRegion = new JButton("\u8ffd\u52a0");
        button_addRegion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressRegionTableModel artm = (AddressRegionTableModel)FileSaveDialog.this.table_addressRegions.getModel();
                if (artm.getRowCount() >= 256) {
                    JOptionPane.showMessageDialog(FileSaveDialog.this, "\u3053\u308c\u4ee5\u4e0a\u30a2\u30c9\u30ec\u30b9\u9818\u57df\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 0);
                    return;
                }
                artm.addAddressRegion(0, 0, "");
                int new_row = FileSaveDialog.this.table_addressRegions.convertRowIndexToView(artm.getRowCount() - 1);
                artm.fireTableRowsInserted(0, new_row);
                FileSaveDialog.this.table_addressRegions.editCellAt(new_row, 0);
                FileSaveDialog.this.table_addressRegions.setRowSelectionInterval(new_row, new_row);
                FileSaveDialog.this.table_addressRegions.setColumnSelectionInterval(0, 0);
                AddressEditor editor = (AddressEditor)FileSaveDialog.this.table_addressRegions.getCellEditor(new_row, 0);
                editor.getComponent().requestFocusInWindow();
            }
        });
        JScrollPane scrollPane_addressRegions = new JScrollPane(22, 31);
        JLabel label_machineLanguageArea = new JLabel("\u30de\u30b7\u30f3\u8a9e\u9818\u57df");
        GroupLayout gl_panel_saveArea = new GroupLayout(panel_saveArea);
        gl_panel_saveArea.setHorizontalGroup(gl_panel_saveArea.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_panel_saveArea.createSequentialGroup().addGroup(gl_panel_saveArea.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBox_saveBasicArea).addGroup(gl_panel_saveArea.createSequentialGroup().addComponent(label_machineLanguageArea).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(button_addRegion)).addGroup(gl_panel_saveArea.createSequentialGroup().addContainerGap().addComponent(this.label_message, -1, 522, Short.MAX_VALUE)).addGroup(gl_panel_saveArea.createSequentialGroup().addContainerGap().addComponent(scrollPane_addressRegions, -1, 522, Short.MAX_VALUE))).addContainerGap()));
        gl_panel_saveArea.setVerticalGroup(gl_panel_saveArea.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_saveArea.createSequentialGroup().addContainerGap().addComponent(this.checkBox_saveBasicArea).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel_saveArea.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label_machineLanguageArea).addComponent(button_addRegion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane_addressRegions, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label_message).addContainerGap(35, Short.MAX_VALUE)));
        AddressRegionTableModel dm = new AddressRegionTableModel(new ArrayList<AddressRegion>());
        if (p != null) {
            p.getAllAddressRegions().forEach(r -> dm.addAddressRegion(r.clone()));
        }
        this.table_addressRegions = new JTable(dm){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                KeyEvent ke;
                char ch;
                boolean r = super.editCellAt(row, column, e);
                if (r && e instanceof KeyEvent && !Character.isISOControl(ch = (ke = (KeyEvent)e).getKeyChar()) && this.editorComp instanceof JTextField) {
                    JTextField tf = (JTextField)this.editorComp;
                    tf.selectAll();
                }
                return r;
            }
        };
        this.table_addressRegions.setFont(new Font("Monospaced", 0, 12));
        this.table_addressRegions.setAutoResizeMode(3);
        this.table_addressRegions.setAutoCreateRowSorter(true);
        this.table_addressRegions.setSelectionMode(0);
        this.table_addressRegions.getTableHeader().setReorderingAllowed(false);
        this.table_addressRegions.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table_addressRegions.setSurrendersFocusOnKeystroke(true);
        DefaultTableColumnModel column_model = (DefaultTableColumnModel)this.table_addressRegions.getColumnModel();
        AddressRenderer ar = new AddressRenderer();
        CommentRenderer cr = new CommentRenderer();
        DeleteButtonRenderer dr = new DeleteButtonRenderer();
        AddressEditor ae = new AddressEditor();
        CommentEditor ce = new CommentEditor();
        DeleteButtonEditor de = new DeleteButtonEditor();
        TableColumn column_start = column_model.getColumn(0);
        column_start.setPreferredWidth(120);
        column_start.setResizable(false);
        column_start.setCellRenderer(ar);
        column_start.setCellEditor(ae);
        TableColumn column_end = column_model.getColumn(1);
        column_end.setPreferredWidth(120);
        column_end.setResizable(false);
        column_end.setCellRenderer(ar);
        column_end.setCellEditor(ae);
        TableColumn column_comment = column_model.getColumn(2);
        column_comment.setPreferredWidth(500);
        column_comment.setResizable(true);
        column_comment.setCellRenderer(cr);
        column_comment.setCellEditor(ce);
        TableColumn column_button = column_model.getColumn(3);
        column_button.setCellRenderer(dr);
        column_button.setCellEditor(de);
        column_button.setMinWidth(20);
        column_button.setMaxWidth(20);
        scrollPane_addressRegions.setViewportView(this.table_addressRegions);
        panel_saveArea.setLayout(gl_panel_saveArea);
        this.textArea_programComment = new JTextArea();
        this.textArea_programComment.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!FileSaveDialog.this.checkText(FileSaveDialog.this.textArea_programComment.getText(), 1024, "\u30d7\u30ed\u30b0\u30e9\u30e0\u30b3\u30e1\u30f3\u30c8")) {
                    FileSaveDialog.this.textArea_programComment.requestFocusInWindow();
                }
            }
        });
        if (p != null && p.getComment() != null) {
            this.textArea_programComment.setText(p.getComment());
        }
        scrollPane_programComment.setViewportView(this.textArea_programComment);
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("\u4fdd\u5b58");
        okButton.setAction(this.action_ok);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        cancelButton.setAction(this.action_cancel);
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    private boolean checkText(String text, int maxlen, String name) {
        try {
            int len = text.getBytes("UTF-8").length;
            if (len > maxlen) {
                JOptionPane.showMessageDialog(this, String.valueOf(name) + "\u306e\u9577\u3055(" + len + "\u30d0\u30a4\u30c8)\u304c\u6700\u5927\u5024(" + maxlen + "\u30d0\u30a4\u30c8)\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002", "\u30a8\u30e9\u30fc", 0);
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(name) + "\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u4e0d\u6b63\u3067\u3059\u3002", "\u30a8\u30e9\u30fc", 0);
            return false;
        }
        return true;
    }

    private boolean checkParameters() {
        if (this.textField_filename.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "\u30a8\u30e9\u30fc", 0);
            return false;
        }
        AddressRegionTableModel dm = (AddressRegionTableModel)this.table_addressRegions.getModel();
        if (dm.getRowCount() > 0) {
            for (AddressRegion r : dm.getAllAddressRegions()) {
                if (r.getStartAddress() > r.getEndAddress()) {
                    JOptionPane.showMessageDialog(this, "\u30a2\u30c9\u30ec\u30b9\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059\u3002" + r.toString(), "\u30a8\u30e9\u30fc", 0);
                    return false;
                }
                if (this.checkText(r.getComment(), 1024, "\u30a2\u30c9\u30ec\u30b9\u7bc4\u56f2\u306e\u30b3\u30e1\u30f3\u30c8")) continue;
                return false;
            }
        }
        return true;
    }

    private class AddressEditor
    extends DefaultCellEditor {
        private int address;

        public AddressEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.BLUE));
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, String.format("%04X", value), isSelected, row, column);
            c.setHorizontalAlignment(0);
            c.setFont(table.getFont());
            return c;
        }

        @Override
        public boolean stopCellEditing() {
            int value;
            block4: {
                value = 0;
                String s = (String)super.getCellEditorValue();
                if (s != null && !s.isEmpty()) {
                    try {
                        value = Integer.parseInt(s, 16);
                        if (value < 0 || value > 65535) {
                            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.RED));
                            FileSaveDialog.this.label_message.setText("\u6570\u5024\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
                            return false;
                        }
                        break block4;
                    }
                    catch (NumberFormatException e) {
                        FileSaveDialog.this.label_message.setText("\u6570\u5024\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                        ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.RED));
                        return false;
                    }
                }
                FileSaveDialog.this.label_message.setText("\u6570\u5024\u304c\u7a7a\u3067\u3059\u3002");
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.RED));
                return false;
            }
            this.address = value;
            FileSaveDialog.this.label_message.setText("");
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.address;
        }
    }

    class AddressRegionTableModel
    extends AbstractTableModel {
        private ColumnContext[] column_array = new ColumnContext[]{new ColumnContext("\u958b\u59cb\u30a2\u30c9\u30ec\u30b9", Integer.class, true), new ColumnContext("\u7d42\u4e86\u30a2\u30c9\u30ec\u30b9", Integer.class, true), new ColumnContext("\u30b3\u30e1\u30f3\u30c8", String.class, true), new ColumnContext("", String.class, true)};
        private ArrayList<AddressRegion> regions;

        public AddressRegionTableModel(ArrayList<AddressRegion> regions) {
            this.regions = regions;
        }

        public ArrayList<AddressRegion> getAllAddressRegions() {
            return this.regions;
        }

        @Override
        public String getColumnName(int column) {
            return this.column_array[column].columnName;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.column_array[column].columnClass;
        }

        @Override
        public int getColumnCount() {
            return this.column_array.length;
        }

        @Override
        public int getRowCount() {
            return this.regions.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.column_array[columnIndex].isEditable;
        }

        public void removeRow(int row) {
            this.regions.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AddressRegion r = this.regions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return r.getStartAddress();
                }
                case 1: {
                    return r.getEndAddress();
                }
                case 2: {
                    return r.getComment();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int model_row, int model_column) {
            AddressRegion r = this.regions.get(model_row);
            if (model_column == 0) {
                r.setStartAddress((Integer)obj);
                this.fireTableCellUpdated(model_row, model_column);
            } else if (model_column == 1) {
                r.setEndAddress((Integer)obj);
                this.fireTableCellUpdated(model_row, model_column);
            } else {
                String value = (String)obj;
                if (value.length() > 1024) {
                    return;
                }
                r.setComment(value);
                this.fireTableCellUpdated(model_row, model_column);
            }
        }

        public void addAddressRegion(int start, int end, String comment) {
            this.regions.add(new AddressRegion(start, end, comment));
        }

        public void addAddressRegion(AddressRegion r) {
            this.regions.add(r);
        }

        private class ColumnContext {
            public final String columnName;
            public final Class<?> columnClass;
            public final boolean isEditable;

            protected ColumnContext(String columnName, Class<?> columnClass, boolean isEditable) {
                this.columnName = columnName;
                this.columnClass = columnClass;
                this.isEditable = isEditable;
            }
        }
    }

    class AddressRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer c = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, String.format("%04X", value), isSelected, hasFocus, row, column);
            c.setHorizontalAlignment(0);
            return c;
        }
    }

    class CommentEditor
    extends JTextArea
    implements TableCellEditor {
        private static final String KEY_STOP = "Stop-Cell-Editing";
        private static final String KEY_ENTER = "Insert-Enter";
        protected transient ChangeEvent changeEvent;
        private final JScrollPane scroll = new JScrollPane(this){

            @Override
            public boolean isValidateRoot() {
                return true;
            }
        };

        protected CommentEditor() {
            this.scroll.setBorder(BorderFactory.createEmptyBorder());
            this.setLineWrap(true);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            KeyStroke enter_shift = KeyStroke.getKeyStroke(10, 64);
            this.getInputMap(0).put(enter, KEY_STOP);
            this.getInputMap(0).put(enter_shift, KEY_ENTER);
            this.getActionMap().put(KEY_STOP, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommentEditor.this.stopCellEditing();
                }
            });
            this.getActionMap().put(KEY_ENTER, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommentEditor.this.insert("\n", CommentEditor.this.getCaretPosition());
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setFont(table.getFont());
            this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            this.setText(Objects.toString(value, ""));
            table.setRowHeight(row, Math.max(48, table.getCellRect((int)row, (int)column, (boolean)true).height));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommentEditor.this.setCaretPosition(CommentEditor.this.getText().length());
                    CommentEditor.this.requestFocusInWindow();
                }
            });
            return this.scroll;
        }

        @Override
        public boolean isCellEditable(final EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= 2;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KeyEvent ke;
                    char kc;
                    if (e instanceof KeyEvent && Character.isUnicodeIdentifierStart(kc = (ke = (KeyEvent)e).getKeyChar())) {
                        CommentEditor.this.setText(String.valueOf(CommentEditor.this.getText()) + kc);
                    }
                }
            });
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            try {
                if (this.getText().getBytes("UTF-8").length > 1024) {
                    FileSaveDialog.this.label_message.setText("\u6587\u5b57\u5217\u304c\u9577\u3059\u304e\u307e\u3059\u3002");
                    this.setBorder(BorderFactory.createLineBorder(Color.RED));
                    return false;
                }
            }
            catch (UnsupportedEncodingException e) {
                FileSaveDialog.this.label_message.setText("\u4e0d\u6b63\u306a\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002");
                this.setBorder(BorderFactory.createLineBorder(Color.RED));
                return false;
            }
            FileSaveDialog.this.label_message.setText("");
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        public CellEditorListener[] getCellEditorListeners() {
            return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == CellEditorListener.class) {
                    if (Objects.isNull(this.changeEvent)) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
                }
                i -= 2;
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == CellEditorListener.class) {
                    if (Objects.isNull(this.changeEvent)) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
                }
                i -= 2;
            }
        }
    }

    class CommentRenderer
    extends JTextArea
    implements TableCellRenderer {
        private final List<List<Integer>> rowAndCellHeights = new ArrayList<List<Integer>>();
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CommentRenderer() {
            this.setLineWrap(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            this.setText(Objects.toString(value, ""));
            this.adjustRowHeight(table, row, column);
            return this;
        }

        private void adjustRowHeight(JTable table, int row, int column) {
            this.setBounds(table.getCellRect(row, column, false));
            int preferredHeight = this.getPreferredSize().height;
            while (this.rowAndCellHeights.size() <= row) {
                this.rowAndCellHeights.add(new ArrayList(column));
            }
            List<Integer> list = this.rowAndCellHeights.get(row);
            while (list.size() <= column) {
                list.add(0);
            }
            list.set(column, preferredHeight);
            int max = (Integer)list.stream().max(Integer::compare).get();
            if (table.getRowHeight(row) != max) {
                table.setRowHeight(row, max);
            }
        }
    }

    class DeleteButton
    extends JButton {
        DeleteButton() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            this.setRolloverEnabled(false);
            this.setText("X");
        }
    }

    class DeleteButtonEditor
    extends DeleteButton
    implements TableCellEditor {
        private transient ActionListener listener;

        DeleteButtonEditor() {
        }

        @Override
        public void updateUI() {
            this.removeActionListener(this.listener);
            super.updateUI();
            this.listener = e -> {
                Container o = SwingUtilities.getAncestorOfClass(JTable.class, this);
                if (o instanceof JTable) {
                    Object[] options = new Object[]{"\u306f\u3044", "\u3044\u3044\u3048"};
                    int answer = JOptionPane.showOptionDialog(FileSaveDialog.this, "\u524a\u9664\u3057\u3066\u3082\u826f\u3044\u3067\u3059\u304b?", "\u524a\u9664\u78ba\u8a8d", -1, 3, null, options, options[1]);
                    if (answer == 1) {
                        return;
                    }
                    JTable table = (JTable)o;
                    int row = table.convertRowIndexToModel(table.getEditingRow());
                    this.fireEditingStopped();
                    AddressRegionTableModel artm = (AddressRegionTableModel)table.getModel();
                    artm.removeRow(row);
                }
            };
            this.addActionListener(this.listener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        public CellEditorListener[] getCellEditorListeners() {
            return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == CellEditorListener.class) {
                    if (Objects.isNull(this.changeEvent)) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
                }
                i -= 2;
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == CellEditorListener.class) {
                    if (Objects.isNull(this.changeEvent)) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
                }
                i -= 2;
            }
        }
    }

    class DeleteButtonRenderer
    extends DeleteButton
    implements TableCellRenderer {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (hasFocus) {
                this.setBackground(table.getSelectionBackground());
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBackground(table.getBackground());
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    static class FileFormatEntry
    implements Comparable<FileFormatEntry> {
        private String extension;
        private String description;

        public FileFormatEntry(String e, String d) {
            this.extension = e;
            this.description = d;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public int compareTo(FileFormatEntry e) {
            return this.extension.compareTo(e.getExtension());
        }
    }

    class FileFormatRenderer
    extends DefaultListCellRenderer {
        FileFormatRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setText(((FileFormatEntry)value).getDescription());
            }
            return label;
        }
    }

    private class SwingAction
    extends AbstractAction {
        public SwingAction() {
            this.putValue("Name", "\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u7121\u52b9\u306b\u3057\u3066\u9589\u3058\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileSaveDialog.this.dispose();
        }
    }

    private class SwingAction_1
    extends AbstractAction {
        public SwingAction_1() {
            this.putValue("Name", "\u4fdd\u5b58\u5834\u6240\u306e\u9078\u629e");
            this.putValue("ShortDescription", "\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u4fdd\u5b58\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u307e\u305f\u306f\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3059\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(Application.getCurrentDirectory());
            chooser.setFileSelectionMode(2);
            int selected = chooser.showDialog(FileSaveDialog.this, "\u9078\u629e");
            Application.setCurrentDirectory(chooser.getCurrentDirectory().getAbsolutePath());
            if (selected == 0) {
                File file = chooser.getSelectedFile();
                if (file.isDirectory()) {
                    FileSaveDialog.this.textField_pathname.setText(file.getAbsolutePath());
                } else {
                    FileSaveDialog.this.textField_filename.setText(file.getName());
                    FileSaveDialog.this.textField_pathname.setText(file.getParent());
                }
            }
        }
    }

    private class SwingAction_2
    extends AbstractAction {
        public SwingAction_2() {
            this.putValue("Name", "\u4fdd\u5b58");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3059\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String comment;
            String name;
            if (!FileSaveDialog.this.checkParameters()) {
                return;
            }
            Program p = FileSaveDialog.this.computer.getProgram();
            if (p == null) {
                p = new Program(FileSaveDialog.this.computer.getHardware().getMemory());
            }
            if ((name = FileSaveDialog.this.textField_programName.getText()) != null && !name.equals("")) {
                p.setName(FileSaveDialog.this.textField_programName.getText());
            }
            if ((comment = FileSaveDialog.this.textArea_programComment.getText()) != null && !comment.equals("")) {
                p.setComment(comment);
            }
            p.setBasicArea(FileSaveDialog.this.checkBox_saveBasicArea.isSelected());
            AddressRegionTableModel dm = (AddressRegionTableModel)FileSaveDialog.this.table_addressRegions.getModel();
            ArrayList<AddressRegion> regions = p.getAllAddressRegions();
            regions.clear();
            dm.getAllAddressRegions().forEach(r -> {
                boolean bl = regions.add(r.clone());
            });
            StringBuilder path_name = new StringBuilder();
            path_name.append(FileSaveDialog.this.textField_pathname.getText());
            path_name.append(File.separator);
            path_name.append(FileSaveDialog.this.textField_filename.getText());
            String ext = DataFile.getExtension(FileSaveDialog.this.textField_filename.getText());
            FileFormatEntry selected_format = (FileFormatEntry)FileSaveDialog.this.comboBox_fileFormat.getSelectedItem();
            if (ext == null) {
                path_name.append(".");
                path_name.append(selected_format.getExtension());
            } else if (!ext.equals(selected_format.getExtension())) {
                path_name.append(".");
                path_name.append(selected_format.getExtension());
            }
            File file = new File(path_name.toString());
            if (file.exists()) {
                int selected = JOptionPane.showConfirmDialog(FileSaveDialog.this, "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u3066\u3082\u3088\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0);
                if (selected == 1) {
                    return;
                }
                Path target_file = Paths.get(path_name.toString(), new String[0]);
                Path backup_file = Paths.get(String.valueOf(path_name.toString()) + "~", new String[0]);
                try {
                    Files.move(target_file, backup_file, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(FileSaveDialog.this, exc.getMessage(), "\u30a8\u30e9\u30fc", 0);
                    return;
                }
            }
            DataFile data_file = null;
            if (selected_format.compareTo(FORMAT_PROG) == 0) {
                data_file = new ProgFormatFile(file);
            } else if (selected_format.compareTo(FORMAT_BASIC) == 0) {
                data_file = new BasicTextFormatFile(file);
            } else if (selected_format.compareTo(FORMAT_DUMP) == 0) {
                data_file = new BinaryTextFormatFile(file);
            } else {
                throw new AssertionError((Object)"\u672a\u5b9a\u7fa9\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3067\u4fdd\u5b58\u3057\u3088\u3046\u3068\u3057\u305f\u3002");
            }
            data_file.save_jr100(p, 2);
            if (data_file.getErrorStatus() != 0) {
                JOptionPane.showMessageDialog(FileSaveDialog.this, data_file.getErrorMessage(), "\u30a8\u30e9\u30fc", 0);
                return;
            }
            p.setFile(file);
            FileSaveDialog.this.computer.setProgram(p);
            FileSaveDialog.this.dispose();
        }
    }
}

