/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import jp.asamomiji.emulator.AbstractDisplay;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.StateSet;
import jp.asamomiji.emulator.jr100.BasicRom;
import jp.asamomiji.emulator.jr100.UserDefinedCharacterRam;
import jp.asamomiji.emulator.jr100.VideoRam;

public class JR100Display
extends AbstractDisplay {
    public static final int FONT_NORMAL = 0;
    public static final int FONT_USER_DEFINED = 1;
    public static final int WIDTH_CHARS = 32;
    public static final int HEIGHT_CHARS = 24;
    public static final int PPC = 8;
    private int userDefinedRam;
    private int videoRam;
    private int characterRom;
    private BufferedImage[][] fonts = new BufferedImage[2][256];
    private BufferedImage[] currentFont;
    private int[][] defaultColorMap = new int[][]{new int[256], {0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF}};
    private int[][] colorMap = new int[2][256];
    private MemorySystem memory;

    public JR100Display(Computer computer) {
        super(computer, 32, 24, 8, 8);
        this.memory = computer.getHardware().getMemory();
        this.scaling = this.getPropertyOfDisplayScaling();
        this.userDefinedRam = this.memory.getMemory(UserDefinedCharacterRam.class).getStartAddress();
        this.videoRam = this.memory.getMemory(VideoRam.class).getStartAddress();
        this.characterRom = ((BasicRom)this.memory.getMemory(BasicRom.class)).getFontAddress();
        this.initializeColors();
        this.initializeFonts();
        this.currentFont = this.fonts[0];
        this.setPreferredSize(this.getPreferredSize());
        this.setFocusable(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean readColorMapFile(String file) {
        if (file == null) {
            Application.getLogger().log(Level.SEVERE, "\u30d5\u30a1\u30a4\u30eb \u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        try {
            int index = 0;
            BufferedReader r = new BufferedReader(new FileReader(new File(file)));
            block5: while (true) {
                String line;
                if ((line = r.readLine()) == null) {
                    r.close();
                    return true;
                }
                StringTokenizer st = new StringTokenizer(line);
                do {
                    int value;
                    if (!st.hasMoreTokens()) continue block5;
                    String s = st.nextToken();
                    try {
                        value = Integer.parseInt(s, 16);
                    }
                    catch (NumberFormatException ee) {
                        Application.getLogger().log(Level.WARNING, "\u4e0d\u6b63\u306a\u6570\u5024(" + s + ")\u304c\u3042\u308a\u307e\u3057\u305f\u30020xff0000(\u8d64)\u3068\u3057\u3066\u6271\u3044\u307e\u3059\u3002", ee);
                        value = 0xFF0000;
                    }
                    this.colorMap[index / 256][index % 256] = value;
                } while (++index != 512);
                break;
            }
            r.close();
            return true;
        }
        catch (FileNotFoundException e) {
            Application.getLogger().log(Level.SEVERE, "\u30d5\u30a1\u30a4\u30eb " + file + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", e);
            return false;
        }
        catch (IOException e) {
            Application.getLogger().log(Level.SEVERE, "\u30d5\u30a1\u30a4\u30eb " + file + " \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
    }

    @Override
    protected void applyDisplayColor() {
        double[][] rgb = new double[2][3];
        switch (this.getPropertyOfDisplayType()) {
            case 0: {
                rgb[0][0] = 31.0;
                rgb[0][1] = 31.0;
                rgb[0][2] = 31.0;
                rgb[1][0] = 255.0;
                rgb[1][1] = 255.0;
                rgb[1][2] = 255.0;
                break;
            }
            case 1: {
                rgb[0][0] = 0.0;
                rgb[0][1] = 31.0;
                rgb[0][2] = 0.0;
                rgb[1][0] = 0.0;
                rgb[1][1] = 223.0;
                rgb[1][2] = 31.0;
                break;
            }
            case 2: {
                rgb[0][0] = 31.0;
                rgb[0][1] = 0.0;
                rgb[0][2] = 0.0;
                rgb[1][0] = 255.0;
                rgb[1][1] = 127.0;
                rgb[1][2] = 0.0;
                break;
            }
            default: {
                rgb[0][0] = 31.0;
                rgb[0][1] = 31.0;
                rgb[0][2] = 31.0;
                rgb[1][0] = 255.0;
                rgb[1][1] = 255.0;
                rgb[1][2] = 255.0;
            }
        }
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 256) {
                if (this.getPropertyOfDisplayType() != 3) {
                    double r0 = (this.colorMap[i][j] & 0xFF0000) >> 16;
                    double g0 = (this.colorMap[i][j] & 0xFF00) >> 8;
                    double b0 = this.colorMap[i][j] & 0xFF;
                    double y = 0.299 * r0 + 0.587 * g0 + 0.114 * b0;
                    int r = (int)(y * rgb[1][0] / 255.0 + rgb[0][0]);
                    int g = (int)(y * rgb[1][1] / 255.0 + rgb[0][1]);
                    int b = (int)(y * rgb[1][2] / 255.0 + rgb[0][2]);
                    if (r > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    this.colorMap[i][j] = (r << 16) + (g << 8) + b;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void initializeColors() {
        int maptype = this.getPropertyOfDisplayColorMap();
        if (maptype == 0) {
            int i = 0;
            while (i < 2) {
                System.arraycopy(this.defaultColorMap[i], 0, this.colorMap[i], 0, this.defaultColorMap[i].length);
                ++i;
            }
        } else if (maptype == 1 && !this.readColorMapFile(this.getPropertyOfDisplayColorMapFile())) {
            Application.getLogger().log(Level.WARNING, "\u30ab\u30e9\u30fc\u30de\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u305f\u305f\u3081\u30c7\u30d5\u30a9\u30eb\u30c8\u30ab\u30e9\u30fc\u30de\u30c3\u30d7\u3092\u9069\u7528\u3057\u307e\u3059\u3002");
            int i = 0;
            while (i < 2) {
                System.arraycopy(this.defaultColorMap[i], 0, this.colorMap[i], 0, this.defaultColorMap[i].length);
                ++i;
            }
        }
        this.applyDisplayColor();
    }

    @Override
    protected void initializeFonts() {
        int[] bitmasks = new int[]{0xFF0000, 65280, 255};
        DirectColorModel cm = new DirectColorModel(24, bitmasks[0], bitmasks[1], bitmasks[2]);
        int i = 0;
        while (i < this.fonts.length) {
            int j = 0;
            while (j < this.fonts[i].length) {
                this.fonts[i][j] = new BufferedImage(cm, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, 8, 8, bitmasks), new Point()), false, null);
                ++j;
            }
            ++i;
        }
        int code = 0;
        while (code < 128) {
            DataBuffer db0a = this.fonts[0][code].getRaster().getDataBuffer();
            DataBuffer db0b = this.fonts[0][code + 128].getRaster().getDataBuffer();
            DataBuffer db1a = this.fonts[1][code].getRaster().getDataBuffer();
            int line = 0;
            while (line < 8) {
                int value = this.memory.load8(this.characterRom + code * 8 + line);
                int bit = 0;
                while (bit < 8) {
                    int index = line * 8 + (8 - bit - 1);
                    db0a.setElem(index, this.colorMap[value & 1][code]);
                    db1a.setElem(index, this.colorMap[value & 1][code]);
                    db0b.setElem(index, this.colorMap[1 - (value & 1)][code + 128]);
                    value >>= 1;
                    ++bit;
                }
                ++line;
            }
            ++code;
        }
        code = 128;
        while (code < 256) {
            DataBuffer db1b = this.fonts[1][code].getRaster().getDataBuffer();
            int line = 0;
            while (line < 8) {
                int value = this.memory.load8(this.userDefinedRam + (code - 128) * 8 + line);
                int bit = 0;
                while (bit < 8) {
                    db1b.setElem(line * 8 + (8 - bit - 1), this.colorMap[value & 1][code]);
                    value >>= 1;
                    ++bit;
                }
                ++line;
            }
            ++code;
        }
    }

    public void updateFont(int code, int line, int value) {
        DataBuffer db1b = this.fonts[1][code + 128].getRaster().getDataBuffer();
        int bit = 0;
        while (bit < 8) {
            db1b.setElem(line * 8 + 8 - bit - 1, this.colorMap[value & 1][code + 128]);
            value >>= 1;
            ++bit;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width * this.scaling, this.height * this.scaling);
    }

    public void setCurrentFont(int plane) {
        this.currentFont = this.fonts[plane];
    }

    @Override
    protected void renderDisplay(Graphics g) {
        int x = 0;
        while (x < this.cx) {
            int y = 0;
            while (y < this.cy) {
                int value = this.memory.load8(this.videoRam + x + y * this.cx) & 0xFF;
                g.drawImage(this.currentFont[value], x * this.px * this.scaling, y * this.py * this.scaling, (x + 1) * this.px * this.scaling, (y + 1) * this.py * this.scaling, 0, 0, this.px, this.py, null);
                ++y;
            }
            ++x;
        }
    }

    public BufferedImage[][] getFonts() {
        return this.fonts;
    }

    @Override
    public void saveState(StateSet ss) {
        super.saveState(ss);
        int index = this.currentFont == this.fonts[0] ? 0 : 1;
        ss.set("JR100Display.currentFont", index);
    }

    @Override
    public void loadState(StateSet ss) {
        super.loadState(ss);
        this.initializeFonts();
        int index = (Integer)ss.get("JR100Display.currentFont");
        this.currentFont = this.fonts[index];
    }
}

