/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import jp.asamomiji.emulator.AbstractKeyboard;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.StateSet;

public final class JR100Keyboard
extends AbstractKeyboard {
    private int[] keyMatrix = new int[9];

    public JR100Keyboard(Computer computer) {
        super(computer);
    }

    public int[] getKeyMatrix() {
        return this.keyMatrix;
    }

    @Override
    public void keyPressed(int keycode) {
        super.keyPressed(keycode);
        switch (keycode) {
            case 45: {
                this.keyMatrix[8] = this.keyMatrix[8] | 0x10;
                break;
            }
            case 10: {
                this.keyMatrix[8] = this.keyMatrix[8] | 8;
                break;
            }
            case 513: {
                this.keyMatrix[8] = this.keyMatrix[8] | 4;
                break;
            }
            case 32: {
                this.keyMatrix[8] = this.keyMatrix[8] | 2;
                break;
            }
            case 46: {
                this.keyMatrix[8] = this.keyMatrix[8] | 1;
                break;
            }
            case 44: {
                this.keyMatrix[7] = this.keyMatrix[7] | 0x10;
                break;
            }
            case 77: {
                this.keyMatrix[7] = this.keyMatrix[7] | 8;
                break;
            }
            case 78: {
                this.keyMatrix[7] = this.keyMatrix[7] | 4;
                break;
            }
            case 66: {
                this.keyMatrix[7] = this.keyMatrix[7] | 2;
                break;
            }
            case 86: {
                this.keyMatrix[7] = this.keyMatrix[7] | 1;
                break;
            }
            case 59: {
                this.keyMatrix[6] = this.keyMatrix[6] | 0x10;
                break;
            }
            case 76: {
                this.keyMatrix[6] = this.keyMatrix[6] | 8;
                break;
            }
            case 75: {
                this.keyMatrix[6] = this.keyMatrix[6] | 4;
                break;
            }
            case 74: {
                this.keyMatrix[6] = this.keyMatrix[6] | 2;
                break;
            }
            case 72: {
                this.keyMatrix[6] = this.keyMatrix[6] | 1;
                break;
            }
            case 80: {
                this.keyMatrix[5] = this.keyMatrix[5] | 0x10;
                break;
            }
            case 79: {
                this.keyMatrix[5] = this.keyMatrix[5] | 8;
                break;
            }
            case 73: {
                this.keyMatrix[5] = this.keyMatrix[5] | 4;
                break;
            }
            case 85: {
                this.keyMatrix[5] = this.keyMatrix[5] | 2;
                break;
            }
            case 89: {
                this.keyMatrix[5] = this.keyMatrix[5] | 1;
                break;
            }
            case 48: {
                this.keyMatrix[4] = this.keyMatrix[4] | 0x10;
                break;
            }
            case 57: {
                this.keyMatrix[4] = this.keyMatrix[4] | 8;
                break;
            }
            case 56: {
                this.keyMatrix[4] = this.keyMatrix[4] | 4;
                break;
            }
            case 55: {
                this.keyMatrix[4] = this.keyMatrix[4] | 2;
                break;
            }
            case 54: {
                this.keyMatrix[4] = this.keyMatrix[4] | 1;
                break;
            }
            case 67: {
                this.keyMatrix[0] = this.keyMatrix[0] | 0x10;
                break;
            }
            case 88: {
                this.keyMatrix[0] = this.keyMatrix[0] | 8;
                break;
            }
            case 90: {
                this.keyMatrix[0] = this.keyMatrix[0] | 4;
                break;
            }
            case 16: {
                this.keyMatrix[0] = this.keyMatrix[0] | 2;
                break;
            }
            case 17: {
                this.keyMatrix[0] = this.keyMatrix[0] | 1;
                break;
            }
            case 71: {
                this.keyMatrix[1] = this.keyMatrix[1] | 0x10;
                break;
            }
            case 70: {
                this.keyMatrix[1] = this.keyMatrix[1] | 8;
                break;
            }
            case 68: {
                this.keyMatrix[1] = this.keyMatrix[1] | 4;
                break;
            }
            case 83: {
                this.keyMatrix[1] = this.keyMatrix[1] | 2;
                break;
            }
            case 65: {
                this.keyMatrix[1] = this.keyMatrix[1] | 1;
                break;
            }
            case 84: {
                this.keyMatrix[2] = this.keyMatrix[2] | 0x10;
                break;
            }
            case 82: {
                this.keyMatrix[2] = this.keyMatrix[2] | 8;
                break;
            }
            case 69: {
                this.keyMatrix[2] = this.keyMatrix[2] | 4;
                break;
            }
            case 87: {
                this.keyMatrix[2] = this.keyMatrix[2] | 2;
                break;
            }
            case 81: {
                this.keyMatrix[2] = this.keyMatrix[2] | 1;
                break;
            }
            case 53: {
                this.keyMatrix[3] = this.keyMatrix[3] | 0x10;
                break;
            }
            case 52: {
                this.keyMatrix[3] = this.keyMatrix[3] | 8;
                break;
            }
            case 51: {
                this.keyMatrix[3] = this.keyMatrix[3] | 4;
                break;
            }
            case 50: {
                this.keyMatrix[3] = this.keyMatrix[3] | 2;
                break;
            }
            case 49: {
                this.keyMatrix[3] = this.keyMatrix[3] | 1;
                break;
            }
        }
    }

    @Override
    public void keyReleased(int keycode) {
        super.keyReleased(keycode);
        switch (keycode) {
            case 45: {
                this.keyMatrix[8] = this.keyMatrix[8] & 0xEF;
                break;
            }
            case 10: {
                this.keyMatrix[8] = this.keyMatrix[8] & 0xF7;
                break;
            }
            case 513: {
                this.keyMatrix[8] = this.keyMatrix[8] & 0xFB;
                break;
            }
            case 32: {
                this.keyMatrix[8] = this.keyMatrix[8] & 0xFD;
                break;
            }
            case 46: {
                this.keyMatrix[8] = this.keyMatrix[8] & 0xFE;
                break;
            }
            case 44: {
                this.keyMatrix[7] = this.keyMatrix[7] & 0xEF;
                break;
            }
            case 77: {
                this.keyMatrix[7] = this.keyMatrix[7] & 0xF7;
                break;
            }
            case 78: {
                this.keyMatrix[7] = this.keyMatrix[7] & 0xFB;
                break;
            }
            case 66: {
                this.keyMatrix[7] = this.keyMatrix[7] & 0xFD;
                break;
            }
            case 86: {
                this.keyMatrix[7] = this.keyMatrix[7] & 0xFE;
                break;
            }
            case 59: {
                this.keyMatrix[6] = this.keyMatrix[6] & 0xEF;
                break;
            }
            case 76: {
                this.keyMatrix[6] = this.keyMatrix[6] & 0xF7;
                break;
            }
            case 75: {
                this.keyMatrix[6] = this.keyMatrix[6] & 0xFB;
                break;
            }
            case 74: {
                this.keyMatrix[6] = this.keyMatrix[6] & 0xFD;
                break;
            }
            case 72: {
                this.keyMatrix[6] = this.keyMatrix[6] & 0xFE;
                break;
            }
            case 80: {
                this.keyMatrix[5] = this.keyMatrix[5] & 0xEF;
                break;
            }
            case 79: {
                this.keyMatrix[5] = this.keyMatrix[5] & 0xF7;
                break;
            }
            case 73: {
                this.keyMatrix[5] = this.keyMatrix[5] & 0xFB;
                break;
            }
            case 85: {
                this.keyMatrix[5] = this.keyMatrix[5] & 0xFD;
                break;
            }
            case 89: {
                this.keyMatrix[5] = this.keyMatrix[5] & 0xFE;
                break;
            }
            case 48: {
                this.keyMatrix[4] = this.keyMatrix[4] & 0xEF;
                break;
            }
            case 57: {
                this.keyMatrix[4] = this.keyMatrix[4] & 0xF7;
                break;
            }
            case 56: {
                this.keyMatrix[4] = this.keyMatrix[4] & 0xFB;
                break;
            }
            case 55: {
                this.keyMatrix[4] = this.keyMatrix[4] & 0xFD;
                break;
            }
            case 54: {
                this.keyMatrix[4] = this.keyMatrix[4] & 0xFE;
                break;
            }
            case 67: {
                this.keyMatrix[0] = this.keyMatrix[0] & 0xEF;
                break;
            }
            case 88: {
                this.keyMatrix[0] = this.keyMatrix[0] & 0xF7;
                break;
            }
            case 90: {
                this.keyMatrix[0] = this.keyMatrix[0] & 0xFB;
                break;
            }
            case 16: {
                this.keyMatrix[0] = this.keyMatrix[0] & 0xFD;
                break;
            }
            case 17: {
                this.keyMatrix[0] = this.keyMatrix[0] & 0xFE;
                break;
            }
            case 71: {
                this.keyMatrix[1] = this.keyMatrix[1] & 0xEF;
                break;
            }
            case 70: {
                this.keyMatrix[1] = this.keyMatrix[1] & 0xF7;
                break;
            }
            case 68: {
                this.keyMatrix[1] = this.keyMatrix[1] & 0xFB;
                break;
            }
            case 83: {
                this.keyMatrix[1] = this.keyMatrix[1] & 0xFD;
                break;
            }
            case 65: {
                this.keyMatrix[1] = this.keyMatrix[1] & 0xFE;
                break;
            }
            case 84: {
                this.keyMatrix[2] = this.keyMatrix[2] & 0xEF;
                break;
            }
            case 82: {
                this.keyMatrix[2] = this.keyMatrix[2] & 0xF7;
                break;
            }
            case 69: {
                this.keyMatrix[2] = this.keyMatrix[2] & 0xFB;
                break;
            }
            case 87: {
                this.keyMatrix[2] = this.keyMatrix[2] & 0xFD;
                break;
            }
            case 81: {
                this.keyMatrix[2] = this.keyMatrix[2] & 0xFE;
                break;
            }
            case 53: {
                this.keyMatrix[3] = this.keyMatrix[3] & 0xEF;
                break;
            }
            case 52: {
                this.keyMatrix[3] = this.keyMatrix[3] & 0xF7;
                break;
            }
            case 51: {
                this.keyMatrix[3] = this.keyMatrix[3] & 0xFB;
                break;
            }
            case 50: {
                this.keyMatrix[3] = this.keyMatrix[3] & 0xFD;
                break;
            }
            case 49: {
                this.keyMatrix[3] = this.keyMatrix[3] & 0xFE;
                break;
            }
        }
    }

    @Override
    public void saveState(StateSet ss) {
        super.saveState(ss);
        ss.set("JR100Keyboard.keyMatrix", this.keyMatrix);
    }

    @Override
    public void loadState(StateSet ss) {
        super.loadState(ss);
        this.keyMatrix = (int[])ss.get("JR100Keyboard.keyMatrix");
    }

    @Override
    public void execute() {
    }
}

