/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jp.asamomiji.emulator.Computer;

public class RevertSnapshotDialog
extends JDialog {
    private Computer computer = null;
    private SnapshotsTableModel tableModel = null;
    private Vector<Hashtable<String, Object>> snapshots;
    private int selectedIndex;
    private JPanel jContentPane = null;
    private JPanel P_main = null;
    private JPanel P_buttons = null;
    private JButton BT_revert = null;
    private JButton BT_cancel = null;
    private JPanel P_snapshots = null;
    private JScrollPane SP_snapshots = null;
    private JTable TBL_snapshots = null;
    private JTextArea TA_comment = null;
    private JScrollPane SP_comment = null;

    public RevertSnapshotDialog(Computer computer, Frame owner) {
        super(owner);
        this.computer = computer;
        this.initialize();
    }

    private void initialize() {
        this.setSize(384, 244);
        this.setTitle("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u306e\u5fa9\u5143");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getP_main(), null);
            this.jContentPane.add((Component)this.getP_buttons(), null);
        }
        return this.jContentPane;
    }

    private JPanel getP_main() {
        if (this.P_main == null) {
            this.P_main = new JPanel();
            this.P_main.setLayout(new BoxLayout(this.getP_main(), 1));
            this.P_main.add((Component)this.getP_snapshots(), null);
        }
        return this.P_main;
    }

    private JPanel getP_buttons() {
        if (this.P_buttons == null) {
            this.P_buttons = new JPanel();
            this.P_buttons.setLayout(new BoxLayout(this.getP_buttons(), 0));
            this.P_buttons.add(Box.createHorizontalGlue());
            this.P_buttons.add((Component)this.getBT_revert(), null);
            this.P_buttons.add((Component)this.getBT_cancel(), null);
        }
        return this.P_buttons;
    }

    private JButton getBT_revert() {
        if (this.BT_revert == null) {
            this.BT_revert = new JButton();
            this.BT_revert.setText("\u5fa9\u5143");
            this.BT_revert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = (File)((Hashtable)RevertSnapshotDialog.this.snapshots.get(RevertSnapshotDialog.this.selectedIndex)).get("file");
                    try {
                        RevertSnapshotDialog.this.computer.pause();
                        RevertSnapshotDialog.this.computer.getApplication().loadState(f.getAbsolutePath());
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
                        return;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
                        return;
                    }
                    RevertSnapshotDialog.this.computer.resume();
                    RevertSnapshotDialog.this.dispose();
                }
            });
        }
        return this.BT_revert;
    }

    private JButton getBT_cancel() {
        if (this.BT_cancel == null) {
            this.BT_cancel = new JButton();
            this.BT_cancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.BT_cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RevertSnapshotDialog.this.dispose();
                }
            });
        }
        return this.BT_cancel;
    }

    private JPanel getP_snapshots() {
        if (this.P_snapshots == null) {
            this.P_snapshots = new JPanel();
            this.P_snapshots.setLayout(new BoxLayout(this.getP_snapshots(), 1));
            this.P_snapshots.add((Component)this.getSP_snapshots(), null);
            this.P_snapshots.add((Component)this.getSP_comment(), null);
        }
        return this.P_snapshots;
    }

    private JScrollPane getSP_snapshots() {
        if (this.SP_snapshots == null) {
            this.SP_snapshots = new JScrollPane();
            this.SP_snapshots.setViewportView(this.getTBL_snapshots());
        }
        return this.SP_snapshots;
    }

    private JTable getTBL_snapshots() {
        if (this.TBL_snapshots == null) {
            String[] column_names = new String[]{"\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u540d", "\u4f5c\u6210\u65e5"};
            this.tableModel = new SnapshotsTableModel(column_names, 0);
            this.TBL_snapshots = new JTable(this.tableModel);
            this.TBL_snapshots.setSelectionMode(0);
            this.TBL_snapshots.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    RevertSnapshotDialog.this.selectedIndex = RevertSnapshotDialog.this.TBL_snapshots.getSelectedRow();
                    RevertSnapshotDialog.this.TA_comment.setText((String)((Hashtable)RevertSnapshotDialog.this.snapshots.get(RevertSnapshotDialog.this.selectedIndex)).get("comment"));
                    RevertSnapshotDialog.this.TA_comment.setCaretPosition(0);
                }
            });
        }
        this.snapshots = this.computer.getApplication().getSnapshotProperties();
        if (this.snapshots != null) {
            for (Hashtable<String, Object> d : this.snapshots) {
                this.tableModel.addRow(new Object[]{d.get("name"), DateFormat.getDateTimeInstance().format((Date)d.get("createdDate"))});
            }
        }
        return this.TBL_snapshots;
    }

    private JTextArea getTA_comment() {
        if (this.TA_comment == null) {
            this.TA_comment = new JTextArea();
            this.TA_comment.setEditable(false);
        }
        return this.TA_comment;
    }

    private JScrollPane getSP_comment() {
        if (this.SP_comment == null) {
            this.SP_comment = new JScrollPane();
            this.SP_comment.setPreferredSize(new Dimension(120, 180));
            this.SP_comment.setViewportView(this.getTA_comment());
        }
        return this.SP_comment;
    }

    class SnapshotsTableModel
    extends DefaultTableModel {
        public SnapshotsTableModel(String[] coumn_names, int row_count) {
            super(coumn_names, row_count);
        }

        public Class<? extends Object> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return JRadioButton.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

