/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.assembler;

import jp.asamomiji.assembler.Instruction;

public class BranchInstruction
extends Instruction {
    private Instruction target = null;

    public BranchInstruction(int address) {
        super(address);
    }

    public BranchInstruction(int address, int mode, int operand) {
        super(address, mode, operand);
    }

    public Instruction getTarget() {
        return this.target;
    }

    public void setTarget(Instruction target) {
        this.target = target;
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    public String getOperandString() {
        if (this.target != null && this.target.getLabel() != null) {
            return this.target.getLabel().toString();
        }
        switch (this.mode) {
            case 5: {
                return String.format("PC+0x%02X", (byte)this.operand);
            }
            case 2: {
                return String.format("X+0x%02X", (byte)this.operand);
            }
            case 3: {
                return String.format("0x%04X", (short)this.operand);
            }
        }
        return "???";
    }

    public int getTargetAddress() {
        switch (this.mode) {
            case 0: {
                return this.operand;
            }
            case 3: {
                return this.operand;
            }
            case 5: {
                return this.address + (byte)this.operand + 2;
            }
        }
        return -1;
    }
}

