/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.assembler;

import jp.asamomiji.assembler.Label;

public abstract class Instruction {
    public static final int MODE_IMMEDIATE = 0;
    public static final int MODE_DIRECT = 1;
    public static final int MODE_INDEXED = 2;
    public static final int MODE_EXTENDED = 3;
    public static final int MODE_IMPLIED = 4;
    public static final int MODE_RELATIVE = 5;
    protected int address = 0;
    protected int mode = 0;
    protected int operand = 0;
    protected String mnemonic = null;
    protected Label label = null;
    protected boolean isBranchTarget = false;

    protected Instruction(int address) {
        this.address = address;
        this.mode = 4;
        this.operand = 0;
    }

    protected Instruction(int address, int mode, int operand) {
        this.address = address;
        this.mode = mode;
        this.operand = operand;
    }

    public int getAddress() {
        return this.address;
    }

    public int getMode() {
        return this.mode;
    }

    public int getOperand() {
        return this.operand;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public abstract String getOperandString();

    public abstract boolean isBranch();

    public boolean isBranchTarget() {
        return this.isBranchTarget;
    }

    public void setBranchTarget() {
        this.isBranchTarget = true;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public int getLength() {
        switch (this.mode) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 1;
    }
}

