/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.assembler;

import jp.asamomiji.assembler.Instruction;

public abstract class NonBranchInstruction
extends Instruction {
    public NonBranchInstruction(int address) {
        super(address);
    }

    public NonBranchInstruction(int address, int mode, int operand) {
        super(address, mode, operand);
    }

    @Override
    public String getOperandString() {
        switch (this.mode) {
            case 0: {
                return String.format("0x%02X", (byte)this.operand);
            }
            case 1: {
                return String.format("[0x%02X]", (byte)this.operand);
            }
            case 2: {
                return String.format("[X+0x%02X]", (byte)this.operand);
            }
            case 3: {
                return String.format("[0x%04X]", (short)this.operand);
            }
            case 4: {
                return "";
            }
        }
        return "???";
    }

    @Override
    public boolean isBranch() {
        return false;
    }
}

