/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.StateSet;

public abstract class Application
extends JFrame {
    public static final String PROPERTY_DATA_FOLDER = "system.data_folder";
    public static final String PROPERTY_SNAPSHOT_FOLDER = "system.snapshot_folder";
    public static final String PROPERTY_SNAPSHOT_EXTENSION = "system.snapshot_extension";
    public static final String PROPERTY_LOG_LEVEL = "system.log_level";
    private static final String DEFAULT_SNAPSHOT_EXTENSION = "snapshot";
    private static Properties properties = new Properties();
    private static String currentDirectory = null;
    private static Logger logger;
    private Computer computer = null;
    protected static Application app;

    public static Properties getProperties() {
        return properties;
    }

    public static boolean loadProperties(String file_name) {
        File f = new File(file_name);
        try {
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                Application.getProperties().load(in);
                in.close();
            }
        }
        catch (IOException e) {
            Application.getLogger().log(Level.SEVERE, "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb " + file_name + " \u306e\u5165\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        return true;
    }

    public boolean saveProperties(String file_name) {
        File f = new File(file_name);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(f);
            Application.getProperties().store(out, null);
            out.close();
        }
        catch (IOException ex) {
            Application.getLogger().log(Level.SEVERE, "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb " + file_name + " \u306e\u5165\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        return true;
    }

    public static String getPropertyOfDataFolder() {
        return Application.getProperties().getProperty(PROPERTY_DATA_FOLDER, System.getProperty("user.home"));
    }

    public static void setPropertyOfDataFolder(String path) {
        Application.getProperties().setProperty(PROPERTY_DATA_FOLDER, path);
        currentDirectory = path;
    }

    public static String getPropertyOfSnapshotFolder() {
        return Application.getProperties().getProperty(PROPERTY_SNAPSHOT_FOLDER, Application.getPropertyOfDataFolder());
    }

    public static void setPropertyOfSnapshotFolder(String path) {
        Application.getProperties().setProperty(PROPERTY_SNAPSHOT_FOLDER, path);
    }

    public static String getPropertyOfSnapshotExtension() {
        return Application.getProperties().getProperty(PROPERTY_SNAPSHOT_EXTENSION, DEFAULT_SNAPSHOT_EXTENSION);
    }

    public static void setPropertyOfSnapshotExtension(String extension) {
        Application.getProperties().setProperty(PROPERTY_SNAPSHOT_EXTENSION, extension);
    }

    public static Level getLogLevel() {
        Level level;
        String m = Application.getProperties().getProperty(PROPERTY_LOG_LEVEL);
        if (m == null) {
            return Level.OFF;
        }
        try {
            level = Level.parse(Application.getProperties().getProperty(PROPERTY_LOG_LEVEL));
        }
        catch (IllegalArgumentException e) {
            level = Level.OFF;
        }
        return level;
    }

    public static void setLogLevel(Level level) {
        Application.getProperties().setProperty(PROPERTY_LOG_LEVEL, level.toString());
    }

    public static Logger getLogger() {
        return logger;
    }

    public static String getCurrentDirectory() {
        if (currentDirectory == null) {
            currentDirectory = Application.getPropertyOfDataFolder();
        }
        return currentDirectory;
    }

    public static void setCurrentDirectory(String path) {
        currentDirectory = path;
    }

    public static void initializeLogger(String log_name, String file_name) {
        try {
            logger = Logger.getLogger(log_name);
            logger.setLevel(Application.getLogLevel());
            if (Application.getLogLevel().equals(Level.OFF)) {
                logger.addHandler(new StreamHandler(new OutputStream(){

                    @Override
                    public void write(int b) {
                    }

                    @Override
                    public void write(byte[] b) {
                    }

                    @Override
                    public void write(byte[] b, int off, int len) {
                    }
                }, new SimpleFormatter()));
            } else {
                FileHandler fh = new FileHandler(file_name);
                fh.setFormatter(new SimpleFormatter());
                logger.addHandler(fh);
            }
        }
        catch (IOException e) {
            System.out.println("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
    }

    public void setComputer(Computer computer) {
        this.computer = computer;
    }

    public Computer getComputer() {
        return this.computer;
    }

    public abstract JMenuBar createMenuBar();

    public JComponent createMainPanel() {
        this.getComputer().getHardware().getDisplay().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Application.this.getComputer().getHardware().getKeyboard().keyPressed(e.getKeyCode());
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Application.this.getComputer().getHardware().getKeyboard().keyReleased(e.getKeyCode());
            }
        });
        this.getComputer().getHardware().getDisplay().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Application.this.getComputer().getHardware().getDisplay().requestFocusInWindow();
            }
        });
        return this.getComputer().getHardware().getDisplay();
    }

    public abstract JPanel createStatusBar();

    public void createGui(String title, Image icon) {
        app.setTitle(title);
        app.setIconImage(icon);
        app.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        app.setJMenuBar(app.createMenuBar());
        app.getContentPane().add((Component)app.createMainPanel(), "Center");
        app.getContentPane().add((Component)app.createStatusBar(), "South");
        app.getRootPane().setDoubleBuffered(true);
        app.pack();
        app.setVisible(true);
    }

    private void waitForStatus(int status) {
        try {
            int count = 0;
            while (this.computer.getRunningStatus() != status) {
                if (count > 10) {
                    throw new RuntimeException("\u30a8\u30df\u30e5\u30ec\u30fc\u30bf\u306e\u72b6\u614b\u304c\u4e00\u6642\u505c\u6b62\u306b\u306a\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                }
                Thread.sleep(1000L);
                ++count;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void saveState(String snapshot_name, String comment) throws FileNotFoundException, IOException {
        StringBuffer path = new StringBuffer();
        Date date = new Date();
        path.append(Application.getPropertyOfSnapshotFolder());
        path.append("\\");
        path.append(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(date));
        path.append(".");
        path.append(Application.getPropertyOfSnapshotExtension());
        this.waitForStatus(1);
        StateSet s = new StateSet(snapshot_name, date, comment);
        s.saveState(this.computer);
        s.writeFile(path.toString());
    }

    public void saveState() throws FileNotFoundException, IOException {
        this.saveState("quick snapshot", "This is a quick snapshot");
    }

    public Vector<Hashtable<String, Object>> getSnapshotProperties() {
        File d = new File(Application.getPropertyOfSnapshotFolder());
        File[] files = d.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int period_index = name.lastIndexOf(46);
                if (period_index < 0 || period_index > name.length() - 1) {
                    return false;
                }
                return name.substring(period_index + 1).compareToIgnoreCase(Application.getPropertyOfSnapshotExtension()) == 0;
            }
        });
        if (files == null) {
            return null;
        }
        Vector<Hashtable<String, Object>> v = new Vector<Hashtable<String, Object>>();
        int i = 0;
        while (i < files.length) {
            try {
                FileInputStream fis = new FileInputStream(files[i]);
                ObjectInputStream ois = new ObjectInputStream(fis);
                if (!((String)ois.readObject()).equals("SPST")) {
                    ois.close();
                    throw new IOException("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                }
                if (ois.readInt() != 1) {
                    ois.close();
                    throw new IOException("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                }
                Hashtable<String, Object> p = new Hashtable<String, Object>();
                p.put("file", files[i]);
                p.put("name", (String)ois.readObject());
                p.put("createdDate", (Date)ois.readObject());
                p.put("comment", (String)ois.readObject());
                v.add(p);
                ois.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return v;
    }

    public void loadState(String path_name) throws FileNotFoundException, IOException {
        this.waitForStatus(1);
        StateSet s = new StateSet();
        s.readFile(path_name);
        s.loadState(this.computer);
    }

    public void loadState() throws FileNotFoundException, IOException {
        File d = new File(Application.getPropertyOfSnapshotFolder());
        File[] files = d.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int period_index = name.lastIndexOf(46);
                if (period_index < 0 || period_index > name.length() - 1) {
                    return false;
                }
                return name.substring(period_index + 1).compareToIgnoreCase(Application.getPropertyOfSnapshotExtension()) == 0;
            }
        });
        if (files != null && files.length > 0) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    long mtime2;
                    long mtime1 = file1.lastModified();
                    if (mtime1 < (mtime2 = file2.lastModified())) {
                        return -1;
                    }
                    if (mtime1 > mtime2) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.loadState(files[files.length - 1].getAbsolutePath());
        } else {
            this.waitForStatus(1);
        }
    }
}

