/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import jp.asamomiji.emulator.Addressable;

public class Memory
implements Addressable {
    protected byte[] data = null;
    protected int start;
    protected int length;

    public Memory(int start, int length) {
        this.start = start;
        this.length = length;
        this.data = new byte[length];
    }

    @Override
    public int getStartAddress() {
        return this.start;
    }

    @Override
    public int getEndAddress() {
        return this.start + this.length - 1;
    }

    @Override
    public byte load8(int address) {
        return this.data[address - this.start];
    }

    @Override
    public short load16(int address) {
        byte val1 = this.data[address - this.start];
        byte val2 = this.data[address - this.start + 1];
        return (short)((val1 << 8) + val2);
    }

    @Override
    public void store8(int address, byte value) {
        this.data[address - this.start] = value;
    }

    @Override
    public void store16(int address, short value) {
        this.data[address - this.start] = (byte)(value >> 8);
        this.data[address - this.start + 1] = (byte)(value & 0xFF);
    }
}

