/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Hashtable;
import jp.asamomiji.emulator.Computer;

public class StateSet {
    public static final String SIGNATURE = "SPST";
    public static final int VERSION = 1;
    private String name;
    private Date createdDate;
    private String comment;
    private Hashtable<String, Object> valueTable = new Hashtable();

    public StateSet(String name, Date date, String comment) {
        this.name = name;
        this.createdDate = date;
        this.comment = comment;
    }

    public StateSet() {
        this(null, null, null);
    }

    public void set(String key, Object value) {
        this.valueTable.put(key, value);
    }

    public Object get(String key, Object default_value) {
        Object value = this.valueTable.get(key);
        return value == null ? default_value : value;
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public void saveState(Computer computer) {
        computer.saveState(this);
    }

    public void loadState(Computer computer) {
        computer.loadState(this);
    }

    public void writeFile(String file_name) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(new File(file_name));
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(SIGNATURE);
        oos.writeInt(1);
        oos.writeObject(this.name);
        oos.writeObject(this.createdDate);
        oos.writeObject(this.comment);
        oos.writeObject(this.valueTable);
        oos.close();
    }

    public void readFile(String file_name) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(new File(file_name));
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            if (!((String)ois.readObject()).equals(SIGNATURE)) {
                ois.close();
                throw new IOException("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            if (ois.readInt() != 1) {
                ois.close();
                throw new IOException("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
            this.name = (String)ois.readObject();
            this.createdDate = (Date)ois.readObject();
            this.comment = (String)ois.readObject();
            this.valueTable = (Hashtable)ois.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ois.close();
    }
}

