/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.asamomiji.emulator.ROM;

public final class BasicRom
extends ROM {
    private static final String PROG_FILE_ID = "PROG";

    public BasicRom(String fname, int start, int length) {
        super(start, length);
        this.readROM(fname);
    }

    public int getFontAddress() {
        return 57344;
    }

    private int readByLittleEndian(InputStream in) throws IOException {
        int value1 = in.read();
        int value2 = in.read();
        int value3 = in.read();
        int value4 = in.read();
        return value1 + (value2 << 8) + (value3 << 16) + (value4 << 24);
    }

    private boolean checkFile(FileInputStream in) throws IOException {
        byte[] id = new byte[4];
        in.read(id);
        if (!new String(id).equals(PROG_FILE_ID)) {
            return false;
        }
        in.skip(4L);
        return true;
    }

    public void readROM(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            if (!this.checkFile(in)) {
                throw new IOException("invalid file format");
            }
            int nlen = this.readByLittleEndian(in);
            byte[] pname_array = new byte[nlen];
            in.read(pname_array);
            int startAddress = this.readByLittleEndian(in);
            int length = this.readByLittleEndian(in);
            if (startAddress < 0 || startAddress > 65535) {
                throw new IOException("invalid address: " + startAddress);
            }
            if (length < 0 || startAddress + length > 65536) {
                throw new IOException("invalid length: " + length);
            }
            this.readByLittleEndian(in);
            int i = 0;
            while (i < length) {
                int v = in.read();
                this.data[i] = (byte)(v & 0xFF);
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            return;
        }
    }
}

