/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.jr100.AboutDialog;
import jp.asamomiji.emulator.jr100.CpuConfigurationDialog;
import jp.asamomiji.emulator.jr100.DisassembleDialog;
import jp.asamomiji.emulator.jr100.FileOpenHooker;
import jp.asamomiji.emulator.jr100.FileSaveDialog;
import jp.asamomiji.emulator.jr100.InputDeviceConfigurationDialog;
import jp.asamomiji.emulator.jr100.JR100;
import jp.asamomiji.emulator.jr100.PropertyDialog;
import jp.asamomiji.emulator.jr100.RevertSnapshotDialog;
import jp.asamomiji.emulator.jr100.TakeSnapshotDialog;
import jp.asamomiji.emulator.jr100.VolumeDialog;

public final class JR100Application
extends Application {
    public static final String REVISION_STRING = "2.4.0";
    public static final String COPYRIGHT_STRING = "Copyright (C) 2005-2017 Kenichi Miyata";
    public static final String DEFAULT_ROM_FILE_NAME = "jr100rom.prg";
    public static final String LOGFILE_NAME = "jr100v2.log";
    public static final String PROPERTIES_FILENAME = "jr100v2.ini";
    public static final String PROPERTY_USE_D3D = "system.use_d3d";
    private static String romfilename;
    private JMenuBar MB_menubar = null;
    private JMenu M_file = null;
    private JMenuItem MI_open = null;
    private JMenuItem MI_save = null;
    private JMenuItem MI_exit = null;
    private JMenu M_tool = null;
    private JMenuItem MI_disassemble = null;
    private JCheckBoxMenuItem MI_pause = null;
    private JMenuItem MI_reset = null;
    private JMenuItem MI_power = null;
    private JRadioButtonMenuItem MI_powerOff = null;
    private JRadioButtonMenuItem MI_powerOn = null;
    private JMenu M_snapshot = null;
    private JMenuItem MI_takeSnapshot = null;
    private JMenuItem MI_revertSnapshot = null;
    private JMenu M_configuration = null;
    private JMenuItem MI_cpu = null;
    private JMenu M_display = null;
    private JMenu M_displayColor = null;
    private JRadioButtonMenuItem MI_monochrome = null;
    private JRadioButtonMenuItem MI_green = null;
    private JRadioButtonMenuItem MI_orange = null;
    private JRadioButtonMenuItem MI_color8 = null;
    private JMenu M_displayScaling = null;
    private JRadioButtonMenuItem MI_x1 = null;
    private JRadioButtonMenuItem MI_x2 = null;
    private JMenuItem MI_sound = null;
    private JMenuItem MI_inputDevice = null;
    private JMenuItem MI_property = null;
    private JMenuItem MI_saveConfiguration = null;
    private JMenu M_help = null;
    private JMenuItem MI_helpTOC = null;
    private JMenuItem MI_about = null;
    private JPanel P_statusBar = null;
    private JButton BT_powerOff = null;
    private JButton BT_pause = null;
    private JButton BT_resume = null;
    private JButton BT_takeSnapshot = null;
    private JButton BT_revertSnapshot = null;

    public static boolean getPropertyOfD3dUsed() {
        String s = Application.getProperties().getProperty(PROPERTY_USE_D3D);
        if (s == null) {
            s = System.getProperty("sun.java2d.d3d");
        }
        if (s == null) {
            return false;
        }
        return Boolean.parseBoolean(s);
    }

    public static void setPropertyOfD3dUsed(boolean value) {
        Application.getProperties().setProperty(PROPERTY_USE_D3D, Boolean.toString(value));
    }

    public static void start() {
        try {
            app = new JR100Application();
            app.setComputer(new JR100(app, romfilename));
            app.createGui("JR-100\u30a8\u30df\u30e5\u30ec\u30fc\u30bf", Toolkit.getDefaultToolkit().getImage(app.getClass().getResource("/jr100emuicon.png")));
            new Thread(app.getComputer()).start();
        }
        catch (Throwable e) {
            JR100Application.getLogger().log(Level.SEVERE, "\u5b9f\u884c\u6642\u30a8\u30e9\u30fc", e);
            System.exit(0);
        }
    }

    @Override
    public JMenuBar createMenuBar() {
        if (this.MB_menubar == null) {
            this.MB_menubar = new JMenuBar();
            this.MB_menubar.add(this.getFileMenu());
            this.MB_menubar.add(this.getToolMenu());
            this.MB_menubar.add(this.getConfigurationMenu());
            this.MB_menubar.add(this.getHelpMenu());
        }
        return this.MB_menubar;
    }

    private JMenu getFileMenu() {
        if (this.M_file == null) {
            this.M_file = new JMenu("\u30d5\u30a1\u30a4\u30eb");
            this.M_file.add(this.getOpenMenuItem());
            this.M_file.add(this.getSaveMenuItem());
            this.M_file.add(this.getExitMenuItem());
        }
        return this.M_file;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.MI_open == null) {
            this.MI_open = new JMenuItem("\u958b\u304f");
            this.MI_open.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileOpenHooker f = new FileOpenHooker(JR100Application.this.getComputer(), JR100Application.this);
                    f.openDialog();
                }
            });
        }
        return this.MI_open;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.MI_save == null) {
            this.MI_save = new JMenuItem("\u4fdd\u5b58");
            this.MI_save.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileSaveDialog d = new FileSaveDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_save;
    }

    private JMenuItem getExitMenuItem() {
        if (this.MI_exit == null) {
            this.MI_exit = new JMenuItem("\u7d42\u4e86");
            this.MI_exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.MI_exit;
    }

    private JMenu getToolMenu() {
        if (this.M_tool == null) {
            this.M_tool = new JMenu("\u30c4\u30fc\u30eb");
            this.M_tool.add(this.getDisassembleMenuItem());
            this.M_tool.addSeparator();
            this.M_tool.add(this.getPauseMenuItem());
            this.M_tool.add(this.getResetMenuItem());
            this.M_tool.add(this.getPowerMenu());
            this.M_tool.add(this.getSnapshotMenu());
        }
        return this.M_tool;
    }

    private JMenuItem getDisassembleMenuItem() {
        if (this.MI_disassemble == null) {
            this.MI_disassemble = new JMenuItem("\u9006\u30a2\u30bb\u30f3\u30d6\u30eb");
            this.MI_disassemble.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DisassembleDialog d = new DisassembleDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_disassemble;
    }

    private void changePowerMenuComponents(int new_status) {
        if (new_status == 1) {
            this.MI_powerOn.setSelected(true);
            this.MI_powerOff.setSelected(false);
            this.MI_pause.setSelected(true);
            this.MI_pause.setEnabled(true);
            this.MI_reset.setEnabled(true);
            this.BT_powerOff.setEnabled(true);
            this.BT_pause.setEnabled(false);
            this.BT_resume.setEnabled(true);
        } else if (new_status == 2) {
            this.MI_powerOn.setSelected(false);
            this.MI_powerOff.setSelected(true);
            this.MI_pause.setSelected(false);
            this.MI_pause.setEnabled(false);
            this.MI_reset.setEnabled(false);
            this.BT_powerOff.setEnabled(false);
            this.BT_pause.setEnabled(false);
            this.BT_resume.setEnabled(true);
        } else if (new_status == 0) {
            this.MI_powerOn.setSelected(true);
            this.MI_powerOff.setSelected(false);
            this.MI_pause.setSelected(false);
            this.MI_pause.setEnabled(true);
            this.MI_reset.setEnabled(true);
            this.BT_powerOff.setEnabled(true);
            this.BT_pause.setEnabled(true);
            this.BT_resume.setEnabled(false);
        }
    }

    private JCheckBoxMenuItem getPauseMenuItem() {
        if (this.MI_pause == null) {
            this.MI_pause = new JCheckBoxMenuItem("\u4e00\u6642\u505c\u6b62");
            this.MI_pause.setSelected(this.getComputer().getRunningStatus() == 1);
            this.MI_pause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JR100Application.this.MI_pause.isSelected()) {
                        JR100Application.this.getComputer().pause();
                        JR100Application.this.changePowerMenuComponents(1);
                    } else {
                        JR100Application.this.getComputer().resume();
                        JR100Application.this.changePowerMenuComponents(0);
                    }
                }
            });
        }
        return this.MI_pause;
    }

    private JMenuItem getResetMenuItem() {
        if (this.MI_reset == null) {
            this.MI_reset = new JMenuItem("\u30ea\u30bb\u30c3\u30c8");
            this.MI_reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().reset();
                    JR100Application.this.changePowerMenuComponents(0);
                }
            });
        }
        return this.MI_reset;
    }

    private JMenuItem getPowerMenu() {
        if (this.MI_power == null) {
            this.MI_power = new JMenu("\u96fb\u6e90");
            ((JMenu)this.MI_power).add(this.getPowerOnMenuItem());
            ((JMenu)this.MI_power).add(this.getPowerOffMenuItem());
            ButtonGroup g = new ButtonGroup();
            g.add(this.MI_powerOn);
            g.add(this.MI_powerOff);
            if (this.getComputer().getRunningStatus() == 0 || this.getComputer().getRunningStatus() == 1) {
                this.MI_powerOn.setSelected(true);
            } else {
                this.MI_powerOff.setSelected(true);
            }
        }
        return this.MI_power;
    }

    private JRadioButtonMenuItem getPowerOnMenuItem() {
        if (this.MI_powerOn == null) {
            this.MI_powerOn = new JRadioButtonMenuItem("On");
            this.MI_powerOn.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JR100Application.this.getComputer().getRunningStatus() == 2) {
                        Computer computer = JR100Application.this.getComputer();
                        synchronized (computer) {
                            JR100Application.this.getComputer().notify();
                        }
                        JR100Application.this.changePowerMenuComponents(0);
                    }
                }
            });
        }
        return this.MI_powerOn;
    }

    private JRadioButtonMenuItem getPowerOffMenuItem() {
        if (this.MI_powerOff == null) {
            this.MI_powerOff = new JRadioButtonMenuItem("Off");
            this.MI_powerOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JR100Application.this.getComputer().getRunningStatus() != 2) {
                        JR100Application.this.getComputer().powerOff();
                    }
                    JR100Application.this.changePowerMenuComponents(2);
                }
            });
        }
        return this.MI_powerOff;
    }

    private JMenu getSnapshotMenu() {
        if (this.M_snapshot == null) {
            this.M_snapshot = new JMenu("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8");
            this.M_snapshot.add(this.getTakeSnapshotMenuItem());
            this.M_snapshot.add(this.getRevertSnapshotMenuItem());
        }
        return this.M_snapshot;
    }

    private JMenuItem getTakeSnapshotMenuItem() {
        if (this.MI_takeSnapshot == null) {
            this.MI_takeSnapshot = new JMenuItem("\u63a1\u53d6");
            this.MI_takeSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TakeSnapshotDialog d = new TakeSnapshotDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_takeSnapshot;
    }

    private JMenuItem getRevertSnapshotMenuItem() {
        if (this.MI_revertSnapshot == null) {
            this.MI_revertSnapshot = new JMenuItem("\u5fa9\u5143");
            this.MI_revertSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RevertSnapshotDialog d = new RevertSnapshotDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_revertSnapshot;
    }

    private JMenu getConfigurationMenu() {
        if (this.M_configuration == null) {
            this.M_configuration = new JMenu("\u8a2d\u5b9a");
            this.M_configuration.add(this.getCPUMenuItem());
            this.M_configuration.add(this.getDisplayMenu());
            this.M_configuration.add(this.getSoundMenuItem());
            this.M_configuration.add(this.setInputDeviceMenuItem());
            this.M_configuration.add(this.getPropertyMenuItem());
            this.M_configuration.add(this.getSaveConfigurationMenuItem());
        }
        return this.M_configuration;
    }

    private JMenuItem getCPUMenuItem() {
        if (this.MI_cpu == null) {
            this.MI_cpu = new JMenuItem("CPU...");
            this.MI_cpu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CpuConfigurationDialog d = new CpuConfigurationDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_cpu;
    }

    private JMenu getDisplayMenu() {
        if (this.M_display == null) {
            this.M_display = new JMenu("\u753b\u9762");
            this.M_display.add(this.getDisplayColorMenu());
            this.M_display.add(this.getDisplayScaling());
        }
        return this.M_display;
    }

    private JMenu getDisplayColorMenu() {
        if (this.M_displayColor == null) {
            this.M_displayColor = new JMenu("\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4");
            this.M_displayColor.add(this.getMonochromeMenuItem());
            this.M_displayColor.add(this.getGreenMenuItem());
            this.M_displayColor.add(this.getOrangeMenuItem());
            this.M_displayColor.add(this.getColor8MenuItem());
            ButtonGroup g = new ButtonGroup();
            g.add(this.getMonochromeMenuItem());
            g.add(this.getGreenMenuItem());
            g.add(this.getOrangeMenuItem());
            g.add(this.getColor8MenuItem());
            switch (this.getComputer().getHardware().getDisplay().getPropertyOfDisplayType()) {
                case 0: {
                    this.getMonochromeMenuItem().setSelected(true);
                    break;
                }
                case 1: {
                    this.getGreenMenuItem().setSelected(true);
                    break;
                }
                case 2: {
                    this.getOrangeMenuItem().setSelected(true);
                    break;
                }
                case 3: {
                    this.getColor8MenuItem().setSelected(true);
                    break;
                }
            }
        }
        return this.M_displayColor;
    }

    private JRadioButtonMenuItem getMonochromeMenuItem() {
        if (this.MI_monochrome == null) {
            this.MI_monochrome = new JRadioButtonMenuItem("\u767d\u9ed2");
            this.MI_monochrome.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().setPropertyOfDisplayType(0);
                }
            });
        }
        return this.MI_monochrome;
    }

    private JRadioButtonMenuItem getGreenMenuItem() {
        if (this.MI_green == null) {
            this.MI_green = new JRadioButtonMenuItem("\u30b0\u30ea\u30fc\u30f3");
            this.MI_green.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().setPropertyOfDisplayType(1);
                }
            });
        }
        return this.MI_green;
    }

    private JRadioButtonMenuItem getOrangeMenuItem() {
        if (this.MI_orange == null) {
            this.MI_orange = new JRadioButtonMenuItem("\u30a2\u30f3\u30d0\u30fc");
            this.MI_orange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().setPropertyOfDisplayType(2);
                }
            });
        }
        return this.MI_orange;
    }

    private JRadioButtonMenuItem getColor8MenuItem() {
        if (this.MI_color8 == null) {
            this.MI_color8 = new JRadioButtonMenuItem("\u30ab\u30e9\u30fc");
            this.MI_color8.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().setPropertyOfDisplayType(3);
                }
            });
        }
        return this.MI_color8;
    }

    private JMenu getDisplayScaling() {
        if (this.M_displayScaling == null) {
            this.M_displayScaling = new JMenu("\u62e1\u5927\u7387");
            this.M_displayScaling.add(this.getX1MenuItem());
            this.M_displayScaling.add(this.getX2MenuItem());
            switch (this.getComputer().getHardware().getDisplay().getPropertyOfDisplayScaling()) {
                case 1: {
                    this.getX1MenuItem().setSelected(true);
                    break;
                }
                case 2: {
                    this.getX2MenuItem().setSelected(true);
                    break;
                }
            }
            ButtonGroup g = new ButtonGroup();
            g.add(this.getX1MenuItem());
            g.add(this.getX2MenuItem());
        }
        return this.M_displayScaling;
    }

    private JRadioButtonMenuItem getX1MenuItem() {
        if (this.MI_x1 == null) {
            this.MI_x1 = new JRadioButtonMenuItem("x1");
            this.MI_x1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().setPropertyOfDisplayScaling(1);
                }
            });
        }
        return this.MI_x1;
    }

    private JRadioButtonMenuItem getX2MenuItem() {
        if (this.MI_x2 == null) {
            this.MI_x2 = new JRadioButtonMenuItem("x2");
            this.MI_x2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().setPropertyOfDisplayScaling(2);
                }
            });
        }
        return this.MI_x2;
    }

    private JMenuItem getSoundMenuItem() {
        if (this.MI_sound == null) {
            this.MI_sound = new JMenuItem("\u97f3...");
            this.MI_sound.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VolumeDialog d = new VolumeDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_sound;
    }

    private JMenuItem setInputDeviceMenuItem() {
        if (this.MI_inputDevice == null) {
            this.MI_inputDevice = new JMenuItem("\u5165\u529b\u30c7\u30d0\u30a4\u30b9...");
            this.MI_inputDevice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputDeviceConfigurationDialog d = new InputDeviceConfigurationDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_inputDevice;
    }

    private JMenuItem getPropertyMenuItem() {
        if (this.MI_property == null) {
            this.MI_property = new JMenuItem("\u30d7\u30ed\u30d1\u30c6\u30a3...");
            this.MI_property.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyDialog d = new PropertyDialog(JR100Application.this.getComputer(), JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_property;
    }

    private JMenuItem getSaveConfigurationMenuItem() {
        if (this.MI_saveConfiguration == null) {
            this.MI_saveConfiguration = new JMenuItem("\u8a2d\u5b9a\u306e\u4fdd\u5b58");
            this.MI_saveConfiguration.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.saveProperties(JR100Application.PROPERTIES_FILENAME);
                }
            });
        }
        return this.MI_saveConfiguration;
    }

    private JMenu getHelpMenu() {
        if (this.M_help == null) {
            this.M_help = new JMenu("\u30d8\u30eb\u30d7");
            this.M_help.add(this.getHelpTOC());
            this.M_help.add(this.getAboutMenuItem());
        }
        return this.M_help;
    }

    private JMenuItem getHelpTOC() {
        if (this.MI_helpTOC == null) {
            this.MI_helpTOC = new JMenuItem("\u30d8\u30eb\u30d7\u76ee\u6b21");
            HelpSet helpset = null;
            HelpBroker broker = null;
            ClassLoader cl = JR100Application.class.getClassLoader();
            try {
                URL url = HelpSet.findHelpSet(cl, "ug.hs");
                helpset = new HelpSet(null, url);
            }
            catch (Throwable e) {
                JR100Application.getLogger().log(Level.SEVERE, "\u30d8\u30eb\u30d7\u30bb\u30c3\u30c8\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                return this.MI_helpTOC;
            }
            CSH.setHelpIDString(this.MI_helpTOC, "top");
            broker = helpset.createHelpBroker();
            this.MI_helpTOC.addActionListener(new CSH.DisplayHelpFromSource(broker));
        }
        return this.MI_helpTOC;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.MI_about == null) {
            this.MI_about = new JMenuItem("JR-100\u30a8\u30df\u30e5\u30ec\u30fc\u30bf\u306b\u3064\u3044\u3066");
            this.MI_about.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog d = new AboutDialog(JR100Application.this);
                    d.setVisible(true);
                }
            });
        }
        return this.MI_about;
    }

    @Override
    public JPanel createStatusBar() {
        if (this.P_statusBar == null) {
            this.P_statusBar = new JPanel();
            this.P_statusBar.setLayout(new BoxLayout(this.P_statusBar, 2));
            this.P_statusBar.add(this.createPowerOffButton());
            this.P_statusBar.add(this.createPauseButton());
            this.P_statusBar.add(this.createResumeButton());
            this.P_statusBar.add(Box.createRigidArea(new Dimension(16, 16)));
            this.P_statusBar.add(this.createTakeSnapshotButton());
            this.P_statusBar.add(this.createRevertSnapshotButton());
            this.P_statusBar.add(Box.createHorizontalGlue());
        }
        return this.P_statusBar;
    }

    private JButton createPowerOffButton() {
        if (this.BT_powerOff == null) {
            this.BT_powerOff = new JButton();
            this.BT_powerOff.setPreferredSize(new Dimension(16, 16));
            this.BT_powerOff.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(app.getClass().getResource("/power.png"))));
            this.BT_powerOff.setToolTipText("\u96fb\u6e90OFF");
            if (this.getComputer().getRunningStatus() == 0 || this.getComputer().getRunningStatus() == 1) {
                this.BT_powerOff.setEnabled(true);
            } else {
                this.BT_powerOff.setEnabled(false);
            }
            this.BT_powerOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JR100Application.this.getComputer().getRunningStatus() != 2) {
                        JR100Application.this.getComputer().powerOff();
                    }
                    JR100Application.this.changePowerMenuComponents(2);
                }
            });
        }
        return this.BT_powerOff;
    }

    private JButton createPauseButton() {
        if (this.BT_pause == null) {
            this.BT_pause = new JButton();
            this.BT_pause.setPreferredSize(new Dimension(16, 16));
            this.BT_pause.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(app.getClass().getResource("/pause.png"))));
            this.BT_pause.setToolTipText("\u4e00\u6642\u505c\u6b62");
            this.BT_pause.setEnabled(true);
            this.BT_pause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().requestFocusInWindow();
                    JR100Application.this.getComputer().pause();
                    JR100Application.this.changePowerMenuComponents(1);
                }
            });
        }
        return this.BT_pause;
    }

    private JButton createResumeButton() {
        if (this.BT_resume == null) {
            this.BT_resume = new JButton();
            this.BT_resume.setPreferredSize(new Dimension(16, 16));
            this.BT_resume.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(app.getClass().getResource("/resume.png"))));
            this.BT_resume.setToolTipText("\u518d\u958b/\u96fb\u6e90ON");
            if (this.getComputer().getRunningStatus() == 0 || this.getComputer().getRunningStatus() == 1) {
                this.BT_resume.setEnabled(false);
            } else {
                this.BT_resume.setEnabled(true);
            }
            this.BT_resume.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().requestFocusInWindow();
                    if (JR100Application.this.getComputer().getRunningStatus() == 2) {
                        Computer computer = JR100Application.this.getComputer();
                        synchronized (computer) {
                            JR100Application.this.getComputer().notify();
                        }
                    } else if (JR100Application.this.getComputer().getRunningStatus() == 1) {
                        JR100Application.this.getComputer().resume();
                    }
                    JR100Application.this.changePowerMenuComponents(0);
                }
            });
        }
        return this.BT_resume;
    }

    private JButton createTakeSnapshotButton() {
        if (this.BT_takeSnapshot == null) {
            this.BT_takeSnapshot = new JButton();
            this.BT_takeSnapshot.setPreferredSize(new Dimension(16, 16));
            this.BT_takeSnapshot.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(app.getClass().getResource("/take_snapshot.png"))));
            this.BT_takeSnapshot.setToolTipText("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u63a1\u53d6");
            this.BT_takeSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().requestFocusInWindow();
                    try {
                        try {
                            JR100Application.this.getComputer().pause();
                            JR100Application.this.changePowerMenuComponents(1);
                            JR100Application.this.saveState();
                        }
                        catch (FileNotFoundException ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
                            JR100Application.this.getComputer().resume();
                            JR100Application.this.changePowerMenuComponents(0);
                            return;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
                            JR100Application.this.getComputer().resume();
                            JR100Application.this.changePowerMenuComponents(0);
                            return;
                        }
                    }
                    finally {
                        JR100Application.this.getComputer().resume();
                        JR100Application.this.changePowerMenuComponents(0);
                    }
                }
            });
        }
        return this.BT_takeSnapshot;
    }

    private JButton createRevertSnapshotButton() {
        if (this.BT_revertSnapshot == null) {
            this.BT_revertSnapshot = new JButton();
            this.BT_revertSnapshot.setPreferredSize(new Dimension(16, 16));
            this.BT_revertSnapshot.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(app.getClass().getResource("/revert_snapshot.png"))));
            this.BT_revertSnapshot.setToolTipText("\u30b9\u30ca\u30c3\u30d7\u30b7\u30e7\u30c3\u30c8\u5fa9\u5143");
            this.BT_revertSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JR100Application.this.getComputer().getHardware().getDisplay().requestFocusInWindow();
                    try {
                        try {
                            JR100Application.this.getComputer().pause();
                            JR100Application.this.changePowerMenuComponents(1);
                            JR100Application.this.loadState();
                        }
                        catch (FileNotFoundException ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
                            JR100Application.this.getComputer().resume();
                            JR100Application.this.changePowerMenuComponents(0);
                            return;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
                            JR100Application.this.getComputer().resume();
                            JR100Application.this.changePowerMenuComponents(0);
                            return;
                        }
                    }
                    finally {
                        JR100Application.this.getComputer().resume();
                        JR100Application.this.changePowerMenuComponents(0);
                    }
                }
            });
        }
        return this.BT_revertSnapshot;
    }

    public static void main(String[] args) {
        JR100Application.loadProperties(PROPERTIES_FILENAME);
        JR100Application.initializeLogger("JR-100 Emulator Logger", LOGFILE_NAME);
        System.setProperty("sun.java2d.d3d", Boolean.toString(JR100Application.getPropertyOfD3dUsed()));
        romfilename = args.length == 0 ? DEFAULT_ROM_FILE_NAME : args[0];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JR100Application.start();
            }
        });
    }
}

