/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.Device;
import jp.asamomiji.emulator.StateSavable;
import jp.asamomiji.emulator.TimeManager;

public abstract class AbstractSoundProcessor
extends Thread
implements Device,
StateSavable {
    public static final String PROPERTY_SOUND_VOLUME = "sound.volume";
    public static final byte DEFAULT_VOLUME = 30;
    private static final int SAMPLING_BIT_LENGTH = 8;
    private static final double COEFF = 19.36708871;
    protected Computer computer;
    protected volatile double frequency;
    protected double samplingRate;
    protected int volume;
    private double amplitude;
    private SourceDataLine line;
    private byte[] buffer = null;
    private double status = 0.0;

    public AbstractSoundProcessor(Computer computer, double sampling_rate) {
        this.computer = computer;
        this.samplingRate = sampling_rate;
        this.buffer = new byte[(int)sampling_rate];
        this.setVolume(this.getPropertyOfVolume());
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, (float)sampling_rate, 8, 1, 1, (float)sampling_rate, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(format, 1000);
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException("fail to initialize sound I/O");
        }
        this.line.start();
    }

    public int getPropertyOfVolume() {
        int value;
        String m = Application.getProperties().getProperty(PROPERTY_SOUND_VOLUME);
        if (m == null) {
            return 30;
        }
        try {
            value = Integer.parseInt(m);
        }
        catch (NumberFormatException e) {
            value = 30;
        }
        return value;
    }

    public void setPropertyOfVolume(int volume) {
        this.setVolume(volume);
        Application.getProperties().setProperty(PROPERTY_SOUND_VOLUME, Integer.toString(volume));
    }

    private void setVolume(int volume) {
        this.volume = volume;
        this.amplitude = this.calculateAmplitude(volume) * (Math.pow(2.0, 7.0) - 1.0);
    }

    public void setLineOn() {
        this.status = 1.0;
    }

    public void setLineOff() {
        this.status = 0.0;
    }

    private double calculateAmplitude(int volume) {
        if (volume == 0) {
            return 0.0;
        }
        double dB = 19.36708871 * (Math.log10(volume) - 2.0);
        double amplitude = Math.pow(10.0, Math.log10(2.0) / 3.0 * dB) * 0.8;
        return amplitude;
    }

    public void setFrequency(long time, double frequency) {
        this.computer.getTimeManager().addEvent(time, new ChangeFrequencyCommand(frequency));
    }

    public abstract void changeFrequency(double var1);

    public abstract float tick();

    @Override
    public void reset() {
        Thread.State state = this.getState();
        if (state == Thread.State.NEW || state == Thread.State.TERMINATED) {
            this.start();
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void run() {
        while (true) {
            int len = 20;
            int t = 0;
            while (t < len) {
                this.buffer[t] = (byte)(this.status * this.amplitude * (double)this.tick());
                ++t;
            }
            this.line.write(this.buffer, 0, len);
        }
    }

    class ChangeFrequencyCommand
    implements TimeManager.EventCommand {
        private double frequency;

        public ChangeFrequencyCommand(double frequency) {
            this.frequency = frequency;
        }

        @Override
        public void execute() {
            AbstractSoundProcessor.this.changeFrequency(this.frequency);
        }

        public String toString() {
            return String.format("change frequency to %d", (int)this.frequency);
        }
    }
}

