/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.file;

import java.io.File;
import java.io.FileInputStream;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.Program;

public abstract class DataFile {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_PROG = 1;
    public static final int FORMAT_BASIC_TEXT = 2;
    public static final int FORMAT_BINARY_TEXT = 3;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_NO_ADDRESS = 1;
    public static final int STATUS_CHECK_SUM_ERROR = 2;
    public static final int STATUS_INVALID_FORMAT = 3;
    public static final int STATUS_FILE_NOT_FOUND = 4;
    public static final int STATUS_IO_ERROR = 5;
    public static final int STATUS_UNEXPECTED_ERROR = 6;
    public static final int STATUS_MEMORY_FULL = 7;
    protected File file = null;
    protected int errorStatus = 0;
    protected String errorMessage = null;

    protected DataFile(File file) {
        this.file = file;
    }

    public abstract Program load_jr100(MemorySystem var1);

    public abstract void save_jr100(Program var1, int var2);

    public void setErrorStatus(int status, String message) {
        this.errorStatus = status;
        this.errorMessage = message;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected int withMessage(int status, String message) {
        this.errorMessage = message;
        return status;
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.lastIndexOf(".");
        if (index != -1) {
            return filename.substring(index + 1);
        }
        return null;
    }

    private static byte[] readMagic(String filename) {
        byte[] magic = new byte[4];
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(filename);){
                in.read(magic);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
        return magic;
    }

    public static boolean isProgFile(File f) {
        String ext = DataFile.getExtension(f.getName());
        if (ext != null && ext.equals("prg")) {
            return true;
        }
        byte[] magic = DataFile.readMagic(f.getName());
        if (magic == null) {
            return false;
        }
        return magic[0] == 80 && magic[1] == 82 && magic[2] == 79 && magic[3] == 71;
    }

    public static boolean isBasicTextFile(File f) {
        String ext = DataFile.getExtension(f.getName());
        return ext != null && (ext.equals("txt") || ext.equals("bas"));
    }
}

