/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.jr100.JR100;

public class CpuConfigurationDialog
extends JDialog {
    private Computer computer;
    private final JPanel contentPanel = new JPanel();
    private ButtonGroup btnGroup = new ButtonGroup();
    private JTextField txtCustomclock;
    private final Action action = new SwingAction();
    private final Action action_1 = new SwingAction_1();

    public CpuConfigurationDialog(Computer computer, Frame owner) {
        this.computer = computer;
        this.setTitle("CPU\u306e\u8a2d\u5b9a");
        this.setBounds(100, 100, 463, 330);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JLabel lblcpu = new JLabel("\u5b9f\u884c\u4e2d\u306eCPU\u901f\u5ea6");
        JLabel lblCurrentclock = new JLabel("current_clock");
        int clock = computer.getClockFrequency();
        if (clock < 1000) {
            lblCurrentclock.setText(String.valueOf(Integer.toString(computer.getClockFrequency())) + "Hz");
        } else if (clock < 1000000) {
            lblCurrentclock.setText(String.valueOf(String.format("%.3f", (double)computer.getClockFrequency() / 1000.0)) + "kHz");
        } else {
            lblCurrentclock.setText(String.valueOf(String.format("%.6f", (double)computer.getClockFrequency() / 1000000.0)) + "MHz");
        }
        JLabel lblCpu = new JLabel("CPU\u901f\u5ea6");
        JRadioButton rdbtn100khz = new JRadioButton("100kHz");
        rdbtn100khz.setActionCommand("100000");
        JRadioButton rdbtn500khz = new JRadioButton("500kHz");
        rdbtn500khz.setActionCommand("500000");
        JRadioButton rdbtn894khz = new JRadioButton("894kHz (\u30c7\u30d5\u30a9\u30eb\u30c8)");
        rdbtn894khz.setActionCommand("894000");
        JRadioButton rdbtn1mhz = new JRadioButton("1MHz");
        rdbtn1mhz.setActionCommand("1000000");
        JRadioButton rdbtn2mhz = new JRadioButton("2MHz");
        rdbtn2mhz.setActionCommand("2000000");
        JRadioButton rdbtn5mhz = new JRadioButton("5MHz");
        rdbtn5mhz.setActionCommand("5000000");
        JRadioButton rdbtn10mhz = new JRadioButton("10MHz");
        rdbtn10mhz.setActionCommand("10000000");
        JRadioButton rdbtncustom = new JRadioButton("\u30ab\u30b9\u30bf\u30e0...");
        rdbtncustom.setActionCommand("custom");
        this.btnGroup.add(rdbtn100khz);
        this.btnGroup.add(rdbtn500khz);
        this.btnGroup.add(rdbtn894khz);
        this.btnGroup.add(rdbtn1mhz);
        this.btnGroup.add(rdbtn2mhz);
        this.btnGroup.add(rdbtn5mhz);
        this.btnGroup.add(rdbtn10mhz);
        this.btnGroup.add(rdbtncustom);
        rdbtn894khz.setSelected(true);
        this.txtCustomclock = new JTextField();
        this.txtCustomclock.setText("894000");
        this.txtCustomclock.setColumns(10);
        JLabel lblHz_1 = new JLabel("Hz");
        JLabel lbljroffon = new JLabel("\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3059\u308b\u305f\u3081\u306bJR-100\u306e\u96fb\u6e90\u3092OFF\u306b\u3057\u3066\u304b\u3089ON\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        JLabel lblNewLabel = new JLabel("(100000(100kHz)\uff5e10000000(10MHz))");
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lblcpu).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblCurrentclock, -2, 97, -2)).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lblCpu).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(rdbtn500khz).addComponent(rdbtn100khz).addComponent(rdbtn894khz).addComponent(rdbtn1mhz).addComponent(rdbtn2mhz).addComponent(rdbtn5mhz).addComponent(rdbtn10mhz).addGroup(gl_contentPanel.createSequentialGroup().addComponent(rdbtncustom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblNewLabel).addGroup(gl_contentPanel.createSequentialGroup().addComponent(this.txtCustomclock, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblHz_1, -2, 138, Short.MAX_VALUE)))))).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addComponent(lbljroffon))).addGap(95)));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblcpu).addComponent(lblCurrentclock)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblCpu).addComponent(rdbtn100khz)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rdbtn500khz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rdbtn894khz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rdbtn1mhz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rdbtn2mhz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rdbtn5mhz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rdbtn10mhz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(rdbtncustom).addComponent(this.txtCustomclock, -2, -1, -2).addComponent(lblHz_1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblNewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lbljroffon).addContainerGap(44, Short.MAX_VALUE)));
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton();
        okButton.setAction(this.action_1);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton();
        cancelButton.setAction(this.action);
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    private class SwingAction
    extends AbstractAction {
        public SwingAction() {
            this.putValue("Name", "\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u7121\u52b9\u306b\u3057\u3066\u9589\u3058\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CpuConfigurationDialog.this.dispose();
        }
    }

    private class SwingAction_1
    extends AbstractAction {
        public SwingAction_1() {
            this.putValue("Name", "OK");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3057\u3066\u9589\u3058\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int new_clock;
            String s = CpuConfigurationDialog.this.btnGroup.getSelection().getActionCommand();
            if (s.equals("custom")) {
                s = CpuConfigurationDialog.this.txtCustomclock.getText();
            }
            try {
                new_clock = Integer.parseInt(s);
                if (new_clock <= 0 || new_clock > 10000000) {
                    JOptionPane.showMessageDialog(null, "100000(100kHz)\uff5e10000000(10MHz)\u306e\u9593\u306e\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044", "ERROR", 0);
                    return;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "\u4e0d\u6b63\u306a\u6570\u5024\u3067\u3059: " + s, "ERROR", 0);
                return;
            }
            JR100.setPropertyOfCpuClockFrequency(new_clock);
            CpuConfigurationDialog.this.dispose();
        }
    }
}

