/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.Frame;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.asamomiji.emulator.AddressRegion;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.Program;
import jp.asamomiji.emulator.file.BasicTextFormatFile;
import jp.asamomiji.emulator.file.BinaryTextFormatFile;
import jp.asamomiji.emulator.file.DataFile;
import jp.asamomiji.emulator.file.ProgFormatFile;

public class FileOpenHooker {
    private Computer computer;
    private Frame owner;
    private JFileChooser chooser;

    public FileOpenHooker(Computer computer, Frame owner) {
        this.computer = computer;
        this.owner = owner;
        this.chooser = new JFileChooser(Application.getCurrentDirectory());
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.addChoosableFileFilter(new FileNameExtensionFilter("\u6a19\u6e96\u30d7\u30ed\u30b0\u30e9\u30e0\u30d5\u30a1\u30a4\u30eb (*.prg, *.txt, *.bas, *.dat)", "prg", "txt", "bas", "dat"));
        this.chooser.addChoosableFileFilter(new FileNameExtensionFilter("PROG\u5f62\u5f0f(\u30d0\u30a4\u30ca\u30ea)\u30d5\u30a1\u30a4\u30eb (*.prg)", "prg"));
        this.chooser.setApproveButtonText("\u958b\u304f(\u8907\u6570\u9078\u629e\u53ef)");
    }

    public void openDialog() {
        int selected = this.chooser.showOpenDialog(this.owner);
        Application.setCurrentDirectory(this.chooser.getCurrentDirectory().getAbsolutePath());
        File[] files = this.chooser.getSelectedFiles();
        File f = null;
        Program merged_program = new Program(this.computer.getHardware().getMemory());
        StringBuilder sb = new StringBuilder();
        if (selected == 0) {
            int i = 0;
            while (i < files.length) {
                f = files[i];
                DataFile df = DataFile.isProgFile(f) ? new ProgFormatFile(f) : (DataFile.isBasicTextFile(f) ? new BasicTextFormatFile(f) : new BinaryTextFormatFile(f));
                Program p = df.load_jr100(this.computer.getHardware().getMemory());
                if (df.getErrorStatus() != 0) {
                    JOptionPane.showMessageDialog(this.chooser, df.getErrorMessage(), "\u30a8\u30e9\u30fc", 0);
                    return;
                }
                if (merged_program.getName().equals("") && !p.getName().equals("")) {
                    merged_program.setName(p.getName());
                }
                if (!p.getComment().equals("")) {
                    sb.delete(0, sb.length());
                    sb.append(merged_program.getComment());
                    if (!merged_program.getComment().equals("")) {
                        sb.append("\n");
                    }
                    sb.append(p.getComment());
                    merged_program.setComment(sb.toString());
                }
                if (merged_program.hasBasicArea() && p.hasBasicArea()) {
                    JOptionPane.showMessageDialog(this.chooser, "BASIC\u30d7\u30ed\u30b0\u30e9\u30e0\u9818\u57df\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002", "\u30a8\u30e9\u30fc", 0);
                    return;
                }
                if (!merged_program.hasBasicArea() && p.hasBasicArea()) {
                    merged_program.setBasicArea(true);
                }
                for (AddressRegion r : p.getAllAddressRegions()) {
                    if (merged_program.getAllAddressRegions().size() == 256) break;
                    merged_program.addAddressRegion(r.clone());
                }
                ++i;
            }
            if (files.length == 1) {
                merged_program.setFile(files[0]);
            }
            this.computer.setProgram(merged_program);
        } else if (selected != 1) {
            Application.getLogger().log(Level.SEVERE, "FileChooser\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }
}

